/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.core;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.zen.config.ui.core.ConfigTheme;
import xyz.meowing.zen.config.ui.elements.ButtonElement;
import xyz.meowing.zen.config.ui.elements.ColorPickerElement;
import xyz.meowing.zen.config.ui.elements.DropdownElement;
import xyz.meowing.zen.config.ui.elements.KeybindElement;
import xyz.meowing.zen.config.ui.elements.MCColorCode;
import xyz.meowing.zen.config.ui.elements.MCColorPickerElement;
import xyz.meowing.zen.config.ui.elements.MultiCheckboxElement;
import xyz.meowing.zen.config.ui.elements.SliderElement;
import xyz.meowing.zen.config.ui.elements.SwitchElement;
import xyz.meowing.zen.config.ui.elements.TextInputElement;
import xyz.meowing.zen.config.ui.elements.TextParagraphElement;
import xyz.meowing.zen.config.ui.types.ConfigElement;
import xyz.meowing.zen.config.ui.types.ElementType;
import xyz.meowing.zen.deps.gg.essential.elementa.UIComponent;
import xyz.meowing.zen.utils.Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJN\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ:\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J:\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fj\u0002`\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/meowing/zen/config/ui/core/ElementFactory;", "", "theme", "Lxyz/meowing/zen/config/ui/core/ConfigTheme;", "<init>", "(Lxyz/meowing/zen/config/ui/core/ConfigTheme;)V", "createButton", "Lxyz/meowing/zen/deps/gg/essential/elementa/UIComponent;", "element", "Lxyz/meowing/zen/config/ui/types/ConfigElement;", "createSwitch", "config", "", "", "Lxyz/meowing/zen/config/ui/ConfigData;", "roundness", "", "handleWidth", "onUpdate", "Lkotlin/Function1;", "", "createSlider", "createDropdown", "createTextInput", "createTextParagraph", "createColorPicker", "createKeybind", "createMultiCheckbox", "createMCColorPicker", "updateSwitchValue", "switchComponent", "newValue", "", "zen"})
@SourceDebugExtension(value={"SMAP\nElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementFactory.kt\nxyz/meowing/zen/config/ui/core/ElementFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,125:1\n1617#2,9:126\n1869#2:135\n1870#2:137\n1626#2:138\n1617#2,9:139\n1869#2:148\n1870#2:150\n1626#2:151\n1#3:136\n1#3:149\n1#3:162\n1#3:165\n11546#4,9:152\n13472#4:161\n13473#4:163\n11555#4:164\n*S KotlinDebug\n*F\n+ 1 ElementFactory.kt\nxyz/meowing/zen/config/ui/core/ElementFactory\n*L\n95#1:126,9\n95#1:135\n95#1:137\n95#1:138\n96#1:139,9\n96#1:148\n96#1:150\n96#1:151\n95#1:136\n96#1:149\n97#1:162\n97#1:152,9\n97#1:161\n97#1:163\n97#1:164\n*E\n"})
public final class ElementFactory {
    @NotNull
    private final ConfigTheme theme;

    public ElementFactory(@NotNull ConfigTheme theme2) {
        Intrinsics.checkNotNullParameter(theme2, "theme");
        this.theme = theme2;
    }

    @NotNull
    public final UIComponent createButton(@NotNull ConfigElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.Button");
        ElementType.Button type2 = (ElementType.Button)elementType;
        return new ButtonElement(type2.getText(), new Function0<Unit>(type2){
            final /* synthetic */ ElementType.Button $type;
            {
                this.$type = $type;
                super(0);
            }

            public final void invoke() {
                this.$type.getOnClick().invoke();
            }
        });
    }

    @NotNull
    public final UIComponent createSwitch(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, float roundness, float handleWidth, @NotNull Function1<Object, Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.Switch");
        ElementType.Switch type2 = (ElementType.Switch)elementType;
        Object object = config.get(element.getConfigKey());
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return new SwitchElement(bl != null ? bl.booleanValue() : type2.getDefault(), roundness, handleWidth, onUpdate);
    }

    public static /* synthetic */ UIComponent createSwitch$default(ElementFactory elementFactory, ConfigElement configElement, Map map2, float f, float f2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        if ((n & 8) != 0) {
            f2 = 25.0f;
        }
        return elementFactory.createSwitch(configElement, map2, f, f2, function1);
    }

    @NotNull
    public final UIComponent createSlider(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.Slider");
        ElementType.Slider type2 = (ElementType.Slider)elementType;
        Object object = config.get(element.getConfigKey());
        Double d = object instanceof Double ? (Double)object : null;
        double value = d != null ? d.doubleValue() : type2.getDefault();
        return new SliderElement(type2.getMin(), type2.getMax(), value, type2.getShowDouble(), onUpdate);
    }

    @NotNull
    public final UIComponent createDropdown(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.Dropdown");
        ElementType.Dropdown type2 = (ElementType.Dropdown)elementType;
        Object v = config.get(element.getConfigKey());
        int index = v instanceof Integer ? ((Number)v).intValue() : (v instanceof Double ? (int)((Number)v).doubleValue() : type2.getDefault());
        return new DropdownElement(type2.getOptions(), index, onUpdate);
    }

    @NotNull
    public final UIComponent createTextInput(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.TextInput");
        ElementType.TextInput type2 = (ElementType.TextInput)elementType;
        Object object = config.get(element.getConfigKey());
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = type2.getDefault();
        }
        return new TextInputElement(string, type2.getPlaceholder(), onUpdate);
    }

    @NotNull
    public final UIComponent createTextParagraph(@NotNull ConfigElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.TextParagraph");
        ElementType.TextParagraph type2 = (ElementType.TextParagraph)elementType;
        return new TextParagraphElement(type2.getText(), true, this.theme.getAccent());
    }

    @NotNull
    public final UIComponent createColorPicker(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Object object;
        block10: {
            ElementType.ColorPicker type2;
            block9: {
                Color color;
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(config, "config");
                Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
                ElementType elementType = element.getType();
                Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.ColorPicker");
                type2 = (ElementType.ColorPicker)elementType;
                object = config.get(element.getConfigKey());
                if (object == null) break block9;
                Object configValue = object;
                boolean bl = false;
                Object object2 = configValue;
                if (object2 instanceof Color) {
                    color = (Color)configValue;
                } else if (object2 instanceof Map) {
                    if (((Map)configValue).containsKey("r")) {
                        Object v = ((Map)configValue).get("r");
                        Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
                        int r = number != null ? number.intValue() : 255;
                        Object v2 = ((Map)configValue).get("g");
                        Number number2 = v2 instanceof Number ? (Number)((Number)v2) : (Number)null;
                        int g = number2 != null ? number2.intValue() : 255;
                        Object v3 = ((Map)configValue).get("b");
                        Number number3 = v3 instanceof Number ? (Number)((Number)v3) : (Number)null;
                        int b = number3 != null ? number3.intValue() : 255;
                        Object v4 = ((Map)configValue).get("a");
                        Number number4 = v4 instanceof Number ? (Number)((Number)v4) : (Number)null;
                        int a = number4 != null ? number4.intValue() : 255;
                        color = new Color(r, g, b, a);
                    } else {
                        color = Utils.INSTANCE.toColorFromMap((Map)configValue);
                    }
                } else {
                    color = object2 instanceof List ? Utils.INSTANCE.toColorFromList((List)configValue) : (object2 instanceof Number ? new Color(((Number)configValue).intValue(), true) : null);
                }
                object = color;
                if (color != null) break block10;
            }
            object = type2.getDefault();
        }
        Object value = object;
        return new ColorPickerElement((Color)value, (Function1<? super Color, Unit>)new Function1<Color, Unit>(onUpdate){
            final /* synthetic */ Function1<Object, Unit> $onUpdate;
            {
                this.$onUpdate = $onUpdate;
                super(1);
            }

            public final void invoke(Color color) {
                Intrinsics.checkNotNullParameter(color, "color");
                Pair[] pairArray = new Pair[]{TuplesKt.to("r", color.getRed()), TuplesKt.to("g", color.getGreen()), TuplesKt.to("b", color.getBlue()), TuplesKt.to("a", color.getAlpha())};
                this.$onUpdate.invoke(MapsKt.mapOf(pairArray));
            }
        });
    }

    @NotNull
    public final UIComponent createKeybind(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.Keybind");
        ElementType.Keybind type2 = (ElementType.Keybind)elementType;
        Object confKey = config.get(element.getConfigKey());
        int keyCode = confKey instanceof Integer ? ((Number)confKey).intValue() : (confKey instanceof Double ? (int)((Number)confKey).doubleValue() : type2.getDefault());
        return new KeybindElement(keyCode, onUpdate, this.theme);
    }

    @NotNull
    public final UIComponent createMultiCheckbox(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Set<Integer> set;
        Object element$iv$iv;
        boolean $i$f$forEach;
        Object[] $this$forEach$iv$iv$iv;
        Object[] $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        boolean $i$f$mapNotNull;
        Object[] $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        ElementType elementType = element.getType();
        Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.MultiCheckbox");
        ElementType.MultiCheckbox type2 = (ElementType.MultiCheckbox)elementType;
        Object configValue = config.get(element.getConfigKey());
        if (configValue instanceof List) {
            $this$mapNotNull$iv = (Object[])configValue;
            $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        } else if (configValue instanceof Set) {
            $this$mapNotNull$iv = (Iterable)configValue;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl4 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        } else if (configValue instanceof Object[]) {
            $this$mapNotNull$iv = (Object[])configValue;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int j = 0; j < n; ++j) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                Object it = element$iv$iv2;
                boolean bl6 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        } else {
            set = configValue == null ? type2.getDefault() : type2.getDefault();
        }
        Set<Integer> selectedIndices = set;
        return new MultiCheckboxElement(type2.getOptions(), selectedIndices, onUpdate);
    }

    @NotNull
    public final UIComponent createMCColorPicker(@NotNull ConfigElement element, @NotNull Map<String, ? extends Object> config, @NotNull Function1<Object, Unit> onUpdate) {
        Object object;
        block11: {
            ElementType.MCColorPicker type2;
            block10: {
                MCColorCode mCColorCode;
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(config, "config");
                Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
                ElementType elementType = element.getType();
                Intrinsics.checkNotNull(elementType, "null cannot be cast to non-null type xyz.meowing.zen.config.ui.types.ElementType.MCColorPicker");
                type2 = (ElementType.MCColorPicker)elementType;
                object = config.get(element.getConfigKey());
                if (object == null) break block10;
                Object configValue = object;
                boolean bl = false;
                Object object2 = configValue;
                if (object2 instanceof String) {
                    Object v2;
                    block9: {
                        Iterable iterable = MCColorCode.getEntries();
                        for (Object t : iterable) {
                            MCColorCode it = (MCColorCode)((Object)t);
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getCode(), configValue)) continue;
                            v2 = t;
                            break block9;
                        }
                        v2 = null;
                    }
                    if ((mCColorCode = (MCColorCode)v2) == null) {
                        mCColorCode = type2.getDefault();
                    }
                } else {
                    mCColorCode = object2 instanceof MCColorCode ? (MCColorCode)((Object)configValue) : type2.getDefault();
                }
                object = mCColorCode;
                if (mCColorCode != null) break block11;
            }
            object = type2.getDefault();
        }
        Object value = object;
        return new MCColorPickerElement((MCColorCode)((Object)value), (Function1<? super MCColorCode, Unit>)new Function1<MCColorCode, Unit>(onUpdate){
            final /* synthetic */ Function1<Object, Unit> $onUpdate;
            {
                this.$onUpdate = $onUpdate;
                super(1);
            }

            public final void invoke(MCColorCode colorCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)colorCode), "colorCode");
                this.$onUpdate.invoke(colorCode.getCode());
            }
        });
    }

    public final void updateSwitchValue(@NotNull UIComponent switchComponent, boolean newValue) {
        Intrinsics.checkNotNullParameter(switchComponent, "switchComponent");
        if (switchComponent instanceof SwitchElement) {
            SwitchElement.setValue$default((SwitchElement)switchComponent, newValue, false, 2, null);
        }
    }
}

