/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal;

import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.Block;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.BlockQuote;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class BlockQuoteParser
extends AbstractBlockParser {
    private final BlockQuote block = new BlockQuote();

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        return true;
    }

    @Override
    public BlockQuote getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        if (BlockQuoteParser.isMarker(state, nextNonSpace)) {
            int newColumn = state.getColumn() + state.getIndent() + 1;
            if (Parsing.isSpaceOrTab(state.getLine().getContent(), nextNonSpace + 1)) {
                ++newColumn;
            }
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    private static boolean isMarker(ParserState state, int index) {
        CharSequence line = state.getLine().getContent();
        return state.getIndent() < Parsing.CODE_BLOCK_INDENT && index < line.length() && line.charAt(index) == '>';
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            if (BlockQuoteParser.isMarker(state, nextNonSpace)) {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab(state.getLine().getContent(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new BlockQuoteParser()).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }
}

