/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.UtilitiesKt;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.DrawState;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.MarkdownComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables.Drawable;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables.DrawableList;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables.ParagraphDrawable;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables.TextDrawable;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.selection.Cursor;
import xyz.meowing.zen.deps.gg.essential.universal.UMatrixStack;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ,\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u000fH\u0014J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00061"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ListDrawable;", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable;", "md", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/MarkdownComponent;", "drawables", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/DrawableList;", "isOrdered", "", "isLoose", "(Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/drawables/DrawableList;ZZ)V", "children", "", "getChildren", "()Ljava/util/List;", "elementSpacing", "", "getElementSpacing", "()F", "indentLevel", "", "listItems", "", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ListDrawable$ListEntry;", "<set-?>", "maxTextLineWidth", "getMaxTextLineWidth", "cursorAt", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/selection/Cursor;", "mouseX", "mouseY", "dragged", "mouseButton", "cursorAtEnd", "cursorAtStart", "draw", "", "matrixStack", "Lxyz/meowing/zen/deps/gg/essential/universal/UMatrixStack;", "state", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/DrawState;", "layoutImpl", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "", "asMarkdown", "ListEntry", "Elementa"})
@SourceDebugExtension(value={"SMAP\nListDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDrawable.kt\ngg/essential/elementa/markdown/drawables/ListDrawable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n764#2:200\n855#2,2:201\n798#2,11:203\n1849#2,2:214\n*S KotlinDebug\n*F\n+ 1 ListDrawable.kt\ngg/essential/elementa/markdown/drawables/ListDrawable\n*L\n70#1:200\n70#1:201,2\n103#1:203,11\n123#1:214,2\n*E\n"})
public final class ListDrawable
extends Drawable {
    @NotNull
    private final DrawableList drawables;
    private final boolean isOrdered;
    private boolean isLoose;
    @NotNull
    private final List<ListEntry> listItems;
    private int indentLevel;
    private float maxTextLineWidth;

    public ListDrawable(@NotNull MarkdownComponent md, @NotNull DrawableList drawables, boolean isOrdered, boolean isLoose) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(drawables, "drawables");
        super(md);
        this.drawables = drawables;
        this.isOrdered = isOrdered;
        this.isLoose = isLoose;
        this.listItems = new ArrayList();
        Drawable.Companion.trim(this.drawables);
        this.drawables.setParent(this);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.listItems;
    }

    private final float getElementSpacing() {
        return this.isLoose ? this.getConfig().getListConfig().getElementSpacingLoose() : this.getConfig().getListConfig().getElementSpacingTight();
    }

    public final float getMaxTextLineWidth() {
        return this.maxTextLineWidth;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        Float f;
        float f2;
        this.listItems.clear();
        float marginTop = this.getInsertSpaceBefore() ? this.getConfig().getListConfig().getSpaceBeforeList() : 0.0f;
        float marginBottom = this.getInsertSpaceAfter() ? this.getConfig().getListConfig().getSpaceAfterList() : 0.0f;
        Ref.FloatRef currY = new Ref.FloatRef();
        currY.element = y + marginTop;
        float spaceAfterSymbol = this.getConfig().getListConfig().getSpaceBeforeText();
        float indentation = this.getConfig().getListConfig().getIndentation();
        Ref.IntRef orderedListShift = new Ref.IntRef();
        if (this.isOrdered) {
            void $this$filterTo$iv$iv;
            float dotWidth = UtilitiesKt.width$default('.', 0.0f, 1, null);
            Object $this$filter$iv = CollectionsKt.getIndices(this.drawables);
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(!(this.drawables.get(it) instanceof ListDrawable))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Iterator $i$f$filter22 = $this$filter$iv.iterator();
            if (!$i$f$filter22.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            int it = ((Number)$i$f$filter22.next()).intValue();
            boolean bl = false;
            float f3 = UtilitiesKt.width$default(String.valueOf(it), 0.0f, null, 3, null) + dotWidth;
            while ($i$f$filter22.hasNext()) {
                int it22 = ((Number)$i$f$filter22.next()).intValue();
                $i$a$-maxOf-ListDrawable$layoutImpl$symbolWidth$2 = false;
                float it22 = UtilitiesKt.width$default(String.valueOf(it22), 0.0f, null, 3, null) + dotWidth;
                f3 = Math.max(f3, it22);
            }
            f2 = f3;
        } else {
            String symbols = this.getConfig().getListConfig().getUnorderedSymbols();
            f2 = UtilitiesKt.width$default(symbols.charAt(this.indentLevel % symbols.length()), 0.0f, 1, null);
        }
        float symbolWidth = f2;
        Ref.IntRef index = new Ref.IntRef();
        for (Drawable drawable : this.drawables) {
            if (drawable instanceof ListDrawable) {
                ((ListDrawable)drawable).indentLevel = this.indentLevel + 1;
            }
            ListDrawable.layoutImpl$addItem(this, index, symbolWidth, spaceAfterSymbol, currY, x, indentation, width, orderedListShift, drawable);
            int n = index.element;
            index.element = n + 1;
        }
        Iterable iterable = this.drawables;
        ListDrawable listDrawable = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            Float f4;
            void $this$filterIsInstanceTo$iv$iv;
            Drawable drawable = (Drawable)iterator2.next();
            boolean bl = false;
            Iterable $this$filterIsInstance$iv = drawable.getChildren();
            boolean $i$f$filterIsInstance22 = false;
            Object it = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            Iterator $i$f$filterIsInstance22 = $this$filterIsInstance$iv.iterator();
            if (!$i$f$filterIsInstance22.hasNext()) {
                f4 = null;
            } else {
                it = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                boolean bl2 = false;
                float it2 = indentation + symbolWidth + spaceAfterSymbol + ((ParagraphDrawable)it).getMaxTextLineWidth();
                while ($i$f$filterIsInstance22.hasNext()) {
                    ParagraphDrawable it32 = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                    $i$a$-maxOfOrNull-ListDrawable$layoutImpl$1$1 = false;
                    float it32 = indentation + symbolWidth + spaceAfterSymbol + it32.getMaxTextLineWidth();
                    it2 = Math.max(it2, it32);
                }
                f4 = Float.valueOf(it2);
            }
            float f5 = f4 != null ? f4.floatValue() : 0.0f;
            while (iterator2.hasNext()) {
                Float f6;
                void $this$filterIsInstanceTo$iv$iv2;
                Drawable drawable2 = (Drawable)iterator2.next();
                $i$a$-maxOfOrNull-ListDrawable$layoutImpl$1 = false;
                Iterable $this$filterIsInstance$iv2 = drawable2.getChildren();
                boolean $i$f$filterIsInstance = false;
                Object it32 = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv2;
                Iterator iterator3 = iterable2.iterator();
                if (!iterator3.hasNext()) {
                    f6 = null;
                } else {
                    it32 = (ParagraphDrawable)iterator3.next();
                    boolean bl3 = false;
                    float f7 = indentation + symbolWidth + spaceAfterSymbol + ((ParagraphDrawable)it32).getMaxTextLineWidth();
                    while (iterator3.hasNext()) {
                        ParagraphDrawable it3 = (ParagraphDrawable)iterator3.next();
                        $i$a$-maxOfOrNull-ListDrawable$layoutImpl$1$1 = false;
                        float f8 = indentation + symbolWidth + spaceAfterSymbol + it3.getMaxTextLineWidth();
                        f7 = Math.max(f7, f8);
                    }
                    f6 = Float.valueOf(f7);
                }
                float f9 = f6 != null ? f6.floatValue() : 0.0f;
                f5 = Math.max(f5, f9);
            }
            f = Float.valueOf(f5);
        }
        listDrawable.maxTextLineWidth = f != null ? f.floatValue() : 0.0f;
        currY.element -= this.getElementSpacing();
        currY.element += marginBottom;
        float height = currY.element - y;
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, marginTop, 0.0f, marginBottom));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        Iterable $this$forEach$iv = this.listItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ListEntry it = (ListEntry)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.drawables.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.drawables.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.drawables.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        return CollectionsKt.joinToString$default(this.listItems, "\n", null, null, 0, null, new Function1<ListEntry, CharSequence>(asMarkdown){
            final /* synthetic */ boolean $asMarkdown;
            {
                this.$asMarkdown = $asMarkdown;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ListEntry it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.selectedText(this.$asMarkdown);
            }
        }, 30, null);
    }

    private static final String layoutImpl$symbol(ListDrawable this$0, Ref.IntRef orderedListShift, int index) {
        String string;
        if (this$0.isOrdered) {
            string = "" + (index + 1 - orderedListShift.element) + '.';
        } else {
            String symbols = this$0.getConfig().getListConfig().getUnorderedSymbols();
            string = String.valueOf(symbols.charAt(this$0.indentLevel % symbols.length()));
        }
        return string;
    }

    private static final void layoutImpl$addItem(ListDrawable this$0, Ref.IntRef index, float symbolWidth, float spaceAfterSymbol, Ref.FloatRef currY, float $x, float indentation, float $width, Ref.IntRef orderedListShift, Drawable drawable) {
        ListEntry item = this$0.new ListEntry(this$0.getMd(), ListDrawable.layoutImpl$symbol(this$0, orderedListShift, index.element), symbolWidth, spaceAfterSymbol, drawable);
        this$0.listItems.add(item);
        currY.element += item.layout($x + indentation, currY.element, $width - indentation).getHeight();
        currY.element += this$0.getElementSpacing();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\nJ,\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0014J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ListDrawable$ListEntry;", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable;", "md", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/MarkdownComponent;", "symbol", "", "symbolWidth", "", "symbolPaddingRight", "drawable", "(Lgg/essential/elementa/markdown/drawables/ListDrawable;Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/lang/String;FFLgg/essential/elementa/markdown/drawables/Drawable;)V", "actualSymbolWidth", "children", "", "getChildren", "()Ljava/util/List;", "getDrawable", "()Lgg/essential/elementa/markdown/drawables/Drawable;", "cursorAt", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/selection/Cursor;", "mouseX", "mouseY", "dragged", "", "mouseButton", "", "cursorAtEnd", "cursorAtStart", "draw", "", "matrixStack", "Lxyz/meowing/zen/deps/gg/essential/universal/UMatrixStack;", "state", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/DrawState;", "layoutImpl", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "asMarkdown", "Elementa"})
    public final class ListEntry
    extends Drawable {
        @NotNull
        private final String symbol;
        private final float symbolWidth;
        private final float symbolPaddingRight;
        @NotNull
        private final Drawable drawable;
        private final float actualSymbolWidth;

        public ListEntry(@NotNull MarkdownComponent md, String symbol, float symbolWidth, @NotNull float symbolPaddingRight, Drawable drawable) {
            Intrinsics.checkNotNullParameter(md, "md");
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(drawable, "drawable");
            super(md);
            this.symbol = symbol;
            this.symbolWidth = symbolWidth;
            this.symbolPaddingRight = symbolPaddingRight;
            this.drawable = drawable;
            this.actualSymbolWidth = UtilitiesKt.width$default(this.symbol, 0.0f, null, 3, null);
            Drawable.Companion.trim(this.drawable);
            if (this.drawable instanceof DrawableList) {
                Iterator<Drawable> iterator2 = ((DrawableList)this.drawable).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index = n++;
                    Drawable item = iterator2.next();
                    if (!(item instanceof ListDrawable)) continue;
                    if (index != 0) {
                        Drawable.Companion.trim(((DrawableList)this.drawable).get(index - 1));
                    }
                    if (index == CollectionsKt.getLastIndex((List)((Object)this.drawable))) continue;
                    Drawable.Companion.trim(((DrawableList)this.drawable).get(index + 1));
                }
            }
        }

        @NotNull
        public final Drawable getDrawable() {
            return this.drawable;
        }

        @Override
        @NotNull
        public List<Drawable> getChildren() {
            return CollectionsKt.listOf(this.drawable);
        }

        @Override
        @NotNull
        protected Drawable.Layout layoutImpl(float x, float y, float width) {
            float nonDrawableSpace = this.symbolWidth + this.symbolPaddingRight;
            this.drawable.layout(x + nonDrawableSpace, y, width - nonDrawableSpace);
            return new Drawable.Layout(x, y, width, this.drawable.getHeight(), null, 16, null);
        }

        @Override
        public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(state, "state");
            float newX = this.getX() + this.symbolWidth - this.actualSymbolWidth;
            if (!(this.drawable instanceof ListDrawable)) {
                TextDrawable.Companion.drawString$default(TextDrawable.Companion, matrixStack, this.getConfig(), this.getMd().getFontProvider(), this.symbol, newX + state.getXShift(), this.getY() + state.getYShift(), false, false, false, null, 960, null);
            }
            this.drawable.drawCompat(matrixStack, state);
        }

        @Override
        @NotNull
        public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
            return this.drawable.cursorAt(mouseX, mouseY, dragged, mouseButton);
        }

        @Override
        @NotNull
        public Cursor<?> cursorAtStart() {
            return this.drawable.cursorAtStart();
        }

        @Override
        @NotNull
        public Cursor<?> cursorAtEnd() {
            return this.drawable.cursorAtEnd();
        }

        @Override
        @NotNull
        public String selectedText(boolean asMarkdown) {
            StringBuilder stringBuilder;
            if (!this.hasSelectedText()) {
                return "";
            }
            String text = this.drawable.selectedText(asMarkdown);
            ListDrawable listDrawable = ListDrawable.this;
            StringBuilder $this$selectedText_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = listDrawable.indentLevel;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                $this$selectedText_u24lambda_u241.append("  ");
            }
            if (asMarkdown) {
                $this$selectedText_u24lambda_u241.append(this.symbol);
                $this$selectedText_u24lambda_u241.append(' ');
            }
            $this$selectedText_u24lambda_u241.append(text);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

