/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.universal.shader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.deps.gg.essential.universal.shader.UniformType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R#\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lxyz/meowing/zen/deps/gg/essential/universal/shader/ShaderTransformer;", "", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "vertexFormat", "", "targetVersion", "<init>", "(Lnet/minecraft/client/renderer/vertex/VertexFormat;I)V", "", "originalSource", "transform", "(Ljava/lang/String;)Ljava/lang/String;", "", "attributes", "Ljava/util/List;", "getAttributes", "()Ljava/util/List;", "", "samplers", "Ljava/util/Set;", "getSamplers", "()Ljava/util/Set;", "I", "", "Lxyz/meowing/zen/deps/gg/essential/universal/shader/UniformType;", "uniforms", "Ljava/util/Map;", "getUniforms", "()Ljava/util/Map;", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "UniversalCraft 1.8.9-forge"})
@SourceDebugExtension(value={"SMAP\nShaderTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderTransformer.kt\ngg/essential/universal/shader/ShaderTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1849#2,2:180\n1849#2,2:182\n1783#2,3:184\n*S KotlinDebug\n*F\n+ 1 ShaderTransformer.kt\ngg/essential/universal/shader/ShaderTransformer\n*L\n73#1:180,2\n79#1:182,2\n137#1:184,3\n*E\n"})
public final class ShaderTransformer {
    @Nullable
    private final VertexFormat vertexFormat;
    private final int targetVersion;
    @NotNull
    private final List<String> attributes;
    @NotNull
    private final Set<String> samplers;
    @NotNull
    private final Map<String, UniformType> uniforms;

    public ShaderTransformer(@Nullable VertexFormat vertexFormat, int targetVersion) {
        this.vertexFormat = vertexFormat;
        this.targetVersion = targetVersion;
        Integer[] integerArray = new Integer[]{110, 130, 150};
        if (!CollectionsKt.listOf(integerArray).contains(this.targetVersion)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.attributes = new ArrayList();
        this.samplers = new LinkedHashSet();
        this.uniforms = new LinkedHashMap();
    }

    @NotNull
    public final List<String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Set<String> getSamplers() {
        return this.samplers;
    }

    @NotNull
    public final Map<String, UniformType> getUniforms() {
        return this.uniforms;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String transform(@NotNull String originalSource) {
        Object object;
        String varyingOut;
        Intrinsics.checkNotNullParameter(originalSource, "originalSource");
        Ref.ObjectRef<String> source2 = new Ref.ObjectRef<String>();
        source2.element = originalSource;
        source2.element = StringsKt.replace$default((String)source2.element, "gl_ModelViewProjectionMatrix", "gl_ProjectionMatrix * gl_ModelViewMatrix", false, 4, null);
        if (this.targetVersion >= 130) {
            source2.element = StringsKt.replace$default((String)source2.element, "texture2D", "texture", false, 4, null);
        }
        Map replacements = new LinkedHashMap();
        List transformed = new ArrayList();
        transformed.add("#version " + this.targetVersion);
        boolean frag = StringsKt.contains$default((CharSequence)source2.element, "gl_FragColor", false, 2, null);
        boolean vert = !frag;
        String attributeIn = this.targetVersion >= 130 ? "in" : "attribute";
        String varyingIn = this.targetVersion >= 130 ? "in" : "varying";
        String string = varyingOut = this.targetVersion >= 130 ? "out" : "varying";
        if (frag && this.targetVersion >= 130) {
            transformed.add(varyingOut + " vec4 uc_FragColor;");
            replacements.put("gl_FragColor", "uc_FragColor");
        }
        if (vert && StringsKt.contains$default((CharSequence)source2.element, "gl_FrontColor", false, 2, null)) {
            transformed.add(varyingOut + " vec4 uc_FrontColor;");
            replacements.put("gl_FrontColor", "uc_FrontColor");
        }
        if (frag && StringsKt.contains$default((CharSequence)source2.element, "gl_Color", false, 2, null)) {
            transformed.add(varyingIn + " vec4 uc_FrontColor;");
            replacements.put("gl_Color", "uc_FrontColor");
        }
        if (vert) {
            Pair it;
            Object element$iv;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            List newAttributes = new ArrayList();
            ShaderTransformer.transform$replaceAttribute(source2, replacements, attributeIn, newAttributes, "gl_Vertex", "vec3", "uc_Position", "vec4(uc_Position, 1.0)");
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, attributeIn, newAttributes, "gl_Color", "vec4", null, null, 192, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, attributeIn, newAttributes, "gl_MultiTexCoord0.st", "vec2", "uc_UV0", null, 128, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, attributeIn, newAttributes, "gl_MultiTexCoord1.st", "vec2", "uc_UV1", null, 128, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, attributeIn, newAttributes, "gl_MultiTexCoord2.st", "vec2", "uc_UV2", null, 128, null);
            if (this.vertexFormat != null) {
                $this$forEach$iv = newAttributes;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    element$iv = object.next();
                    it = (Pair)element$iv;
                    boolean bl = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            } else {
                $this$forEach$iv = newAttributes;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    element$iv = object.next();
                    it = (Pair)element$iv;
                    boolean bl = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            }
        }
        ShaderTransformer.transform$replaceUniform$default(source2, replacements, this, transformed, "gl_ModelViewMatrix", UniformType.Mat4, "ModelViewMat", null, 128, null);
        ShaderTransformer.transform$replaceUniform$default(source2, replacements, this, transformed, "gl_ProjectionMatrix", UniformType.Mat4, "ProjMat", null, 128, null);
        for (String line : StringsKt.lines((CharSequence)source2.element)) {
            String string2;
            List list = transformed;
            if (StringsKt.startsWith$default(line, "#version", false, 2, null)) continue;
            if (StringsKt.startsWith$default(line, "varying ", false, 2, null) && this.targetVersion >= 130) {
                string2 = (frag ? "in " : "out ") + StringsKt.substringAfter$default(line, "varying ", null, 2, null);
            } else if (StringsKt.startsWith$default(line, "uniform ", false, 2, null)) {
                object = new char[]{';'};
                CharSequence charSequence = StringsKt.trimEnd(line, object);
                object = new String[]{" "};
                List $i$f$forEach = StringsKt.split$default(charSequence, (String[])object, false, 0, 6, null);
                String glslType = (String)$i$f$forEach.get(1);
                String name = (String)$i$f$forEach.get(2);
                if (Intrinsics.areEqual(glslType, "sampler2D")) {
                    this.samplers.add(name);
                    string2 = line;
                } else {
                    this.uniforms.put(name, UniformType.Companion.fromGlsl(glslType));
                    string2 = line;
                }
            } else {
                void $this$fold$iv;
                Iterable $i$f$forEach = replacements.entrySet();
                List list2 = list;
                boolean $i$f$fold = false;
                String accumulator$iv = line;
                for (Object element$iv : $this$fold$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    String acc = accumulator$iv;
                    boolean bl = false;
                    String needle = (String)entry.getKey();
                    String replacement = (String)entry.getValue();
                    accumulator$iv = StringsKt.replace$default(acc, needle, replacement, false, 4, null);
                }
                string2 = accumulator$iv;
                list = list2;
            }
            list.add(string2);
        }
        return CollectionsKt.joinToString$default(transformed, "\n", null, null, 0, null, null, 62, null);
    }

    private static final void transform$replaceAttribute(Ref.ObjectRef<String> source2, Map<String, String> replacements, String attributeIn, List<Pair<String, String>> newAttributes, String needle, String type2, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)source2.element, needle, false, 2, null)) {
            replacements.put(needle, replacement);
            newAttributes.add(TuplesKt.to(replacementName, attributeIn + ' ' + type2 + ' ' + replacementName + ';'));
        }
    }

    static /* synthetic */ void transform$replaceAttribute$default(Ref.ObjectRef objectRef, Map map2, String string, List list, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 0x40) != 0) {
            string4 = "uc_" + StringsKt.substringAfter$default(string2, "_", null, 2, null);
        }
        if ((n & 0x80) != 0) {
            string5 = string4;
        }
        ShaderTransformer.transform$replaceAttribute(objectRef, map2, string, list, string2, string3, string4, string5);
    }

    private static final void transform$replaceUniform(Ref.ObjectRef<String> source2, Map<String, String> replacements, ShaderTransformer this$0, List<String> transformed, String needle, UniformType type2, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)source2.element, needle, false, 2, null)) {
            replacements.put(needle, replacement);
            if (!this$0.uniforms.containsKey(replacementName)) {
                this$0.uniforms.put(replacementName, type2);
                transformed.add("uniform " + type2.getGlslName() + ' ' + replacementName + ';');
            }
        }
    }

    static /* synthetic */ void transform$replaceUniform$default(Ref.ObjectRef objectRef, Map map2, ShaderTransformer shaderTransformer, List list, String string, UniformType uniformType, String string2, String string3, int n, Object object) {
        if ((n & 0x80) != 0) {
            string3 = string2;
        }
        ShaderTransformer.transform$replaceUniform(objectRef, map2, shaderTransformer, list, string, uniformType, string2, string3);
    }
}

