/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.features.general;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.features.general.ChatFilterType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lxyz/meowing/zen/features/general/ChatPattern;", "", "pattern", "", "filterType", "Lxyz/meowing/zen/features/general/ChatFilterType;", "<init>", "(Ljava/lang/String;Lxyz/meowing/zen/features/general/ChatFilterType;)V", "getPattern", "()Ljava/lang/String;", "setPattern", "(Ljava/lang/String;)V", "getFilterType", "()Lxyz/meowing/zen/features/general/ChatFilterType;", "matches", "", "message", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "zen"})
public final class ChatPattern {
    @NotNull
    private String pattern;
    @NotNull
    private final ChatFilterType filterType;

    public ChatPattern(@NotNull String pattern, @NotNull ChatFilterType filterType) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter((Object)filterType, "filterType");
        this.pattern = pattern;
        this.filterType = filterType;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public final void setPattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.pattern = string;
    }

    @NotNull
    public final ChatFilterType getFilterType() {
        return this.filterType;
    }

    public final boolean matches(@NotNull String message) {
        boolean bl;
        Intrinsics.checkNotNullParameter(message, "message");
        switch (WhenMappings.$EnumSwitchMapping$0[this.filterType.ordinal()]) {
            case 1: {
                bl = StringsKt.contains$default((CharSequence)message, this.pattern, false, 2, null);
                break;
            }
            case 2: {
                bl = Intrinsics.areEqual(message, this.pattern);
                break;
            }
            case 3: {
                boolean bl2;
                try {
                    CharSequence charSequence = message;
                    bl2 = new Regex(this.pattern).matches(charSequence);
                }
                catch (Exception exception) {
                    bl2 = false;
                }
                bl = bl2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.pattern;
    }

    @NotNull
    public final ChatFilterType component2() {
        return this.filterType;
    }

    @NotNull
    public final ChatPattern copy(@NotNull String pattern, @NotNull ChatFilterType filterType) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter((Object)filterType, "filterType");
        return new ChatPattern(pattern, filterType);
    }

    public static /* synthetic */ ChatPattern copy$default(ChatPattern chatPattern, String string, ChatFilterType chatFilterType, int n, Object object) {
        if ((n & 1) != 0) {
            string = chatPattern.pattern;
        }
        if ((n & 2) != 0) {
            chatFilterType = chatPattern.filterType;
        }
        return chatPattern.copy(string, chatFilterType);
    }

    @NotNull
    public String toString() {
        return "ChatPattern(pattern=" + this.pattern + ", filterType=" + (Object)((Object)this.filterType) + ')';
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = result * 31 + this.filterType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatPattern)) {
            return false;
        }
        ChatPattern chatPattern = (ChatPattern)other;
        if (!Intrinsics.areEqual(this.pattern, chatPattern.pattern)) {
            return false;
        }
        return this.filterType == chatPattern.filterType;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatFilterType.values().length];
            try {
                nArray[ChatFilterType.CONTAINS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatFilterType.EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatFilterType.REGEX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

