/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.ui.components;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import xyz.meowing.zen.utils.FontUtils;
import xyz.meowing.zen.utils.Render2D;
import xyz.meowing.zen.utils.StencilUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u001c\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u0005J\u001e\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020'2\u0006\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020<J\u000e\u0010T\u001a\u00020M2\u0006\u0010S\u001a\u00020<J\u001e\u0010U\u001a\u00020M2\u0006\u0010\u0004\u001a\u00020'2\u0006\u0010Q\u001a\u00020'2\u0006\u0010S\u001a\u00020<J\u0016\u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020<J\b\u0010Z\u001a\u00020MH\u0002J\u0010\u0010[\u001a\u00020<2\u0006\u0010\\\u001a\u00020'H\u0002J\u0010\u0010]\u001a\u00020M2\u0006\u0010^\u001a\u00020<H\u0002J\u0010\u0010_\u001a\u00020M2\u0006\u0010`\u001a\u00020\u0003H\u0002J\u0010\u0010a\u001a\u00020M2\u0006\u0010b\u001a\u00020<H\u0002J\u0018\u0010c\u001a\u00020M2\u0006\u0010d\u001a\u00020<2\u0006\u0010e\u001a\u000200H\u0002J\u0018\u0010f\u001a\u00020M2\u0006\u0010g\u001a\u00020<2\u0006\u0010e\u001a\u000200H\u0002J\u0018\u0010h\u001a\u00020M2\u0006\u0010b\u001a\u00020<2\u0006\u0010e\u001a\u000200H\u0002J\u0018\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<2\u0006\u0010b\u001a\u00020<H\u0002J\b\u0010k\u001a\u00020MH\u0002J\b\u0010l\u001a\u00020MH\u0002J\b\u0010m\u001a\u00020MH\u0002J\b\u0010n\u001a\u00020\u0003H\u0002J\b\u0010o\u001a\u00020MH\u0002J\b\u0010p\u001a\u00020MH\u0002J\u000f\u0010q\u001a\u0004\u0018\u00010MH\u0002\u00a2\u0006\u0002\u0010rJ\b\u0010s\u001a\u00020MH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR$\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0010\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\u00020'X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010*R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000209X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010@R\u0014\u0010C\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u00102R\u001a\u0010E\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010*\"\u0004\bG\u0010HR\u000e\u0010I\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006t"}, d2={"Lxyz/meowing/zen/ui/components/TextInputComponent;", "", "placeholder", "", "x", "", "y", "width", "height", "radius", "accentColor", "Ljava/awt/Color;", "hoverColor", "<init>", "(Ljava/lang/String;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/awt/Color;Ljava/awt/Color;)V", "getPlaceholder", "()Ljava/lang/String;", "getX", "()Ljava/lang/Number;", "setX", "(Ljava/lang/Number;)V", "getY", "setY", "getWidth", "setWidth", "getHeight", "setHeight", "getRadius", "getAccentColor", "()Ljava/awt/Color;", "getHoverColor", "newVal", "value", "getValue", "setValue", "(Ljava/lang/String;)V", "fontObj", "Lnet/minecraft/client/gui/FontRenderer;", "padding", "", "textRenderAreaWidth", "getTextRenderAreaWidth", "()D", "fieldWidth", "getFieldWidth", "textPadding", "getTextPadding", "focused", "", "getFocused", "()Z", "setFocused", "(Z)V", "isDragging", "caretVisible", "isHovered", "lastBlink", "", "caretBlinkRate", "cursorIndex", "", "selectionAnchor", "selectionStart", "getSelectionStart", "()I", "selectionEnd", "getSelectionEnd", "hasSelection", "getHasSelection", "scrollOffset", "getScrollOffset", "setScrollOffset", "(D)V", "lastClickTime", "clickCount", "lastKeyProcessed", "draw", "", "mx", "my", "mouseClicked", "mouseX", "mouseY", "button", "mouseRelease", "mouseDragged", "keyTyped", "typedChar", "", "keyCode", "resetCaretBlink", "getCharIndexAtAbsX", "absClickX", "selectWordAt", "pos", "insertText", "text", "deleteChar", "direction", "moveCaret", "amount", "shiftHeld", "moveCaretTo", "position", "moveWord", "findWordBoundary", "startIndex", "deletePrevWord", "deleteNextWord", "selectAll", "getSelectedText", "copySelection", "cutSelection", "paste", "()Lkotlin/Unit;", "ensureCaretVisible", "zen"})
@SourceDebugExtension(value={"SMAP\nTextInputComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputComponent.kt\nxyz/meowing/zen/ui/components/TextInputComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,467:1\n1#2:468\n*E\n"})
public final class TextInputComponent {
    @NotNull
    private final String placeholder;
    @NotNull
    private Number x;
    @NotNull
    private Number y;
    @NotNull
    private Number width;
    @NotNull
    private Number height;
    @NotNull
    private final Number radius;
    @NotNull
    private final Color accentColor;
    @NotNull
    private final Color hoverColor;
    @NotNull
    private String value;
    @NotNull
    private final FontRenderer fontObj;
    private final double padding;
    private final double textPadding;
    private boolean focused;
    private boolean isDragging;
    private boolean caretVisible;
    private boolean isHovered;
    private long lastBlink;
    private final long caretBlinkRate;
    private int cursorIndex;
    private int selectionAnchor;
    private double scrollOffset;
    private long lastClickTime;
    private int clickCount;
    private boolean lastKeyProcessed;

    public TextInputComponent(@NotNull String placeholder, @NotNull Number x, @NotNull Number y, @NotNull Number width, @NotNull Number height, @NotNull Number radius, @NotNull Color accentColor, @NotNull Color hoverColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(width, "width");
        Intrinsics.checkNotNullParameter(height, "height");
        Intrinsics.checkNotNullParameter(radius, "radius");
        Intrinsics.checkNotNullParameter(accentColor, "accentColor");
        Intrinsics.checkNotNullParameter(hoverColor, "hoverColor");
        this.placeholder = placeholder;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.radius = radius;
        this.accentColor = accentColor;
        this.hoverColor = hoverColor;
        this.value = "";
        this.fontObj = FontUtils.INSTANCE.getFontRenderer();
        this.padding = 6.0;
        this.textPadding = 4.0;
        this.caretVisible = true;
        this.lastBlink = System.currentTimeMillis();
        this.caretBlinkRate = 500L;
        this.cursorIndex = this.value.length();
        this.selectionAnchor = this.value.length();
    }

    public /* synthetic */ TextInputComponent(String string, Number number, Number number2, Number number3, Number number4, Number number5, Color color, Color color2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string, number, number2, number3, number4, number5, color, color2);
    }

    @NotNull
    public final String getPlaceholder() {
        return this.placeholder;
    }

    @NotNull
    public final Number getX() {
        return this.x;
    }

    public final void setX(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "<set-?>");
        this.x = number;
    }

    @NotNull
    public final Number getY() {
        return this.y;
    }

    public final void setY(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "<set-?>");
        this.y = number;
    }

    @NotNull
    public final Number getWidth() {
        return this.width;
    }

    public final void setWidth(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "<set-?>");
        this.width = number;
    }

    @NotNull
    public final Number getHeight() {
        return this.height;
    }

    public final void setHeight(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "<set-?>");
        this.height = number;
    }

    @NotNull
    public final Number getRadius() {
        return this.radius;
    }

    @NotNull
    public final Color getAccentColor() {
        return this.accentColor;
    }

    @NotNull
    public final Color getHoverColor() {
        return this.hoverColor;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String newVal) {
        Intrinsics.checkNotNullParameter(newVal, "newVal");
        if (Intrinsics.areEqual(this.value, newVal)) {
            return;
        }
        this.value = newVal;
        this.cursorIndex = RangesKt.coerceIn(this.cursorIndex, 0, this.value.length());
        this.selectionAnchor = RangesKt.coerceIn(this.selectionAnchor, 0, this.value.length());
    }

    private final double getTextRenderAreaWidth() {
        return this.getFieldWidth() - this.textPadding * (double)2;
    }

    private final double getFieldWidth() {
        return this.width.doubleValue() - this.padding * (double)2;
    }

    public final double getTextPadding() {
        return this.textPadding;
    }

    public final boolean getFocused() {
        return this.focused;
    }

    public final void setFocused(boolean bl) {
        this.focused = bl;
    }

    private final int getSelectionStart() {
        return Math.min(this.cursorIndex, this.selectionAnchor);
    }

    private final int getSelectionEnd() {
        return Math.max(this.cursorIndex, this.selectionAnchor);
    }

    private final boolean getHasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public final double getScrollOffset() {
        return this.scrollOffset;
    }

    public final void setScrollOffset(double d) {
        this.scrollOffset = d;
    }

    /*
     * Unable to fully structure code
     */
    public final void draw(@NotNull Number mx, @NotNull Number my) {
        Intrinsics.checkNotNullParameter(mx, "mx");
        Intrinsics.checkNotNullParameter(my, "my");
        x = this.x.doubleValue();
        y = this.y.doubleValue();
        height = this.height.doubleValue();
        mouseX = mx.doubleValue();
        mouseY = my.doubleValue();
        fieldRectX = x;
        fieldRectY = y;
        v0 = fieldRectX <= mouseX ? mouseX <= fieldRectX + this.getFieldWidth() : false;
        if (!v0) ** GOTO lbl-1000
        v1 = fieldRectY <= mouseY ? mouseY <= fieldRectY + height : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        this.isHovered = v2;
        borderColor = this.focused != false ? this.accentColor : (this.isHovered != false ? this.hoverColor : new Color(60, 60, 60));
        Render2D.INSTANCE.drawRoundedRect(borderColor, x - (double)true, y - (double)true, this.getFieldWidth() + (double)2, height + (double)2, this.radius);
        Render2D.INSTANCE.drawRoundedRect(new Color(20, 20, 20), x, y, this.getFieldWidth(), height, this.radius);
        StencilUtils.INSTANCE.beginStencilClip(new Function0<Unit>(x, y, this, height){
            final /* synthetic */ double $x;
            final /* synthetic */ double $y;
            final /* synthetic */ TextInputComponent this$0;
            final /* synthetic */ double $height;
            {
                this.$x = $x;
                this.$y = $y;
                this.this$0 = $receiver;
                this.$height = $height;
                super(0);
            }

            public final void invoke() {
                Color color = Color.WHITE;
                Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                Render2D.INSTANCE.drawRect(color, this.$x, this.$y, TextInputComponent.access$getFieldWidth(this.this$0), this.$height);
            }
        });
        shouldShowPlaceholder = ((CharSequence)this.value).length() == 0 != false && this.focused == false;
        textToRender = shouldShowPlaceholder != false ? this.placeholder : this.value;
        textColor = shouldShowPlaceholder != false ? new Color(120, 120, 120) : Color.WHITE;
        textY = y + (height - (double)this.fontObj.field_78288_b) / (double)2;
        if (this.getHasSelection() && !shouldShowPlaceholder) {
            v3 = this.value.substring(0, this.getSelectionStart());
            Intrinsics.checkNotNullExpressionValue(v3, "substring(...)");
            selStartStr = v3;
            v4 = this.value.substring(0, this.getSelectionEnd());
            Intrinsics.checkNotNullExpressionValue(v4, "substring(...)");
            selEndStr = v4;
            x1 = x + this.textPadding - this.scrollOffset + (double)this.fontObj.func_78256_a(selStartStr);
            x2 = x + this.textPadding - this.scrollOffset + (double)this.fontObj.func_78256_a(selEndStr);
            selectionHeight = this.fontObj.field_78288_b;
            Render2D.INSTANCE.drawRect(this.accentColor, x1, textY, x2 - x1, selectionHeight);
        }
        Render2D.renderString$default(Render2D.INSTANCE, textToRender, (float)(x + this.textPadding - this.scrollOffset), (float)textY, 1.0f, textColor.getRGB(), null, 32, null);
        if (this.focused && this.caretVisible && !shouldShowPlaceholder && (caretXPos = x + this.textPadding - this.scrollOffset + (double)this.fontObj.func_78256_a(textBeforeCaret = StringsKt.take(this.value, this.cursorIndex))) >= x + this.textPadding - (double)true && caretXPos <= x + this.textPadding + this.getTextRenderAreaWidth()) {
            v5 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(v5, "WHITE");
            Render2D.INSTANCE.drawRect(v5, caretXPos, textY, 1.0, this.fontObj.field_78288_b);
        }
        StencilUtils.INSTANCE.endStencilClip();
        if (System.currentTimeMillis() - this.lastBlink > this.caretBlinkRate) {
            this.caretVisible = this.caretVisible == false;
            this.lastBlink = System.currentTimeMillis();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return;
        }
        fieldRectX = this.x.doubleValue();
        fieldRectY = this.y.doubleValue();
        fieldHeight = this.height.doubleValue();
        v0 = fieldRectX <= mouseX ? mouseX <= fieldRectX + this.getFieldWidth() : false;
        if (!v0) ** GOTO lbl-1000
        v1 = fieldRectY <= mouseY ? mouseY <= fieldRectY + fieldHeight : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = clickedOnField = false;
        }
        if (clickedOnField) {
            this.focused = true;
            this.isDragging = true;
            clickRelX = mouseX - (fieldRectX + this.textPadding - this.scrollOffset);
            newCursorIndex = this.getCharIndexAtAbsX(clickRelX);
            currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 250L) {
                var18_11 = this.clickCount;
                this.clickCount = var18_11 + 1;
            } else {
                this.clickCount = 1;
            }
            this.lastClickTime = currentTime;
            switch (this.clickCount) {
                case 1: {
                    this.cursorIndex = newCursorIndex;
                    if (GuiScreen.func_146272_n()) break;
                    this.selectionAnchor = this.cursorIndex;
                    break;
                }
                case 2: {
                    this.selectWordAt(newCursorIndex);
                    break;
                }
                default: {
                    this.selectAll();
                    this.clickCount = 0;
                }
            }
            this.resetCaretBlink();
        } else {
            this.focused = false;
            this.isDragging = false;
        }
    }

    public final void mouseRelease(int button2) {
        if (button2 == 0) {
            this.isDragging = false;
        }
    }

    public final void mouseDragged(double x, double mouseX, int button2) {
        if (this.focused && this.isDragging && button2 == 0) {
            double fieldRectX = x + this.padding;
            double clickRelX = mouseX - (fieldRectX + this.textPadding - this.scrollOffset);
            this.cursorIndex = this.getCharIndexAtAbsX(clickRelX);
            this.ensureCaretVisible();
            this.resetCaretBlink();
        }
    }

    public final boolean keyTyped(char typedChar, int keyCode) {
        if (!this.focused) {
            return false;
        }
        boolean isKeyPressed = Keyboard.getEventKeyState();
        if (!isKeyPressed && this.lastKeyProcessed) {
            this.lastKeyProcessed = false;
            return false;
        }
        if (isKeyPressed) {
            this.lastKeyProcessed = true;
        }
        boolean ctrlDown = GuiScreen.func_146271_m();
        boolean shiftDown = GuiScreen.func_146272_n();
        switch (keyCode) {
            case 1: {
                this.focused = false;
                return true;
            }
            case 28: {
                this.focused = false;
                return true;
            }
            case 14: {
                if (ctrlDown) {
                    this.deletePrevWord();
                } else {
                    this.deleteChar(-1);
                }
                return true;
            }
            case 211: {
                if (ctrlDown) {
                    this.deleteNextWord();
                } else {
                    this.deleteChar(1);
                }
                return true;
            }
            case 203: {
                if (ctrlDown) {
                    this.moveWord(-1, shiftDown);
                } else {
                    this.moveCaret(-1, shiftDown);
                }
                return true;
            }
            case 205: {
                if (ctrlDown) {
                    this.moveWord(1, shiftDown);
                } else {
                    this.moveCaret(1, shiftDown);
                }
                return true;
            }
            case 199: {
                this.moveCaretTo(0, shiftDown);
                return true;
            }
            case 207: {
                this.moveCaretTo(this.value.length(), shiftDown);
                return true;
            }
            case 30: {
                if (!ctrlDown) break;
                this.selectAll();
                return true;
            }
            case 46: {
                if (!ctrlDown) break;
                this.copySelection();
                return true;
            }
            case 47: {
                if (!ctrlDown) break;
                this.paste();
                return true;
            }
            case 45: {
                if (!ctrlDown) break;
                this.cutSelection();
                return true;
            }
            case 33: {
                if (!ctrlDown) break;
                this.focused = true;
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.insertText(String.valueOf(typedChar));
            return true;
        }
        return false;
    }

    private final void resetCaretBlink() {
        this.lastBlink = System.currentTimeMillis();
        this.caretVisible = true;
    }

    private final int getCharIndexAtAbsX(double absClickX) {
        if (absClickX <= 0.0) {
            return 0;
        }
        double currentWidth = 0.0;
        int n = ((CharSequence)this.value).length();
        for (int i2 = 0; i2 < n; ++i2) {
            int charWidth = this.fontObj.func_78256_a(String.valueOf(this.value.charAt(i2)));
            if (absClickX < currentWidth + (double)charWidth / 2.0) {
                return i2;
            }
            currentWidth += (double)charWidth;
        }
        return this.value.length();
    }

    private final void selectWordAt(int pos) {
        if (((CharSequence)this.value).length() == 0) {
            return;
        }
        int currentPos = RangesKt.coerceIn(pos, 0, this.value.length());
        if (currentPos < this.value.length() && !Character.isWhitespace(this.value.charAt(currentPos))) {
            int end;
            int start;
            for (start = currentPos; start > 0 && !Character.isWhitespace(this.value.charAt(start - 1)); --start) {
            }
            for (end = currentPos; end < this.value.length() && !Character.isWhitespace(this.value.charAt(end)); ++end) {
            }
            this.cursorIndex = end;
            this.selectionAnchor = start;
        } else {
            this.cursorIndex = currentPos;
            this.selectionAnchor = currentPos;
        }
        this.ensureCaretVisible();
    }

    private final void insertText(String text) {
        int n;
        StringBuilder builder = new StringBuilder(this.value);
        String textToInsert = ChatAllowedCharacters.func_71565_a((String)text);
        if (!this.getHasSelection()) {
            n = this.cursorIndex;
        } else {
            int currentSelectionStart = this.getSelectionStart();
            builder.delete(currentSelectionStart, this.getSelectionEnd());
            n = currentSelectionStart;
        }
        int newCursorPos = n;
        builder.insert(newCursorPos, textToInsert);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.setValue(string);
        this.selectionAnchor = this.cursorIndex = RangesKt.coerceIn(newCursorPos + textToInsert.length(), 0, this.value.length());
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    private final void deleteChar(int direction) {
        StringBuilder builder;
        boolean textChanged = false;
        String newText = this.value;
        int newCursor = this.cursorIndex;
        if (this.getHasSelection()) {
            builder = new StringBuilder(this.value);
            int selStart = this.getSelectionStart();
            builder.delete(selStart, this.getSelectionEnd());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            newCursor = selStart;
            textChanged = true;
        } else if (direction == -1 && this.cursorIndex > 0) {
            int originalCursor = this.cursorIndex;
            StringBuilder builder2 = new StringBuilder(this.value);
            builder2.deleteCharAt(originalCursor - 1);
            String string = builder2.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            newCursor = originalCursor - 1;
            textChanged = true;
        } else if (direction == 1 && this.cursorIndex < this.value.length()) {
            builder = new StringBuilder(this.value);
            builder.deleteCharAt(this.cursorIndex);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            textChanged = true;
        }
        if (!textChanged) {
            this.resetCaretBlink();
        } else {
            this.setValue(newText);
            this.selectionAnchor = this.cursorIndex = RangesKt.coerceIn(newCursor, 0, this.value.length());
            double maxScroll = Math.max(0.0, (double)this.fontObj.func_78256_a(this.value) - this.getTextRenderAreaWidth());
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
            this.ensureCaretVisible();
            this.resetCaretBlink();
        }
    }

    private final void moveCaret(int amount, boolean shiftHeld) {
        this.cursorIndex = RangesKt.coerceIn(this.cursorIndex + amount, 0, this.value.length());
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    private final void moveCaretTo(int position, boolean shiftHeld) {
        this.cursorIndex = RangesKt.coerceIn(position, 0, this.value.length());
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    private final void moveWord(int direction, boolean shiftHeld) {
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, direction);
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    private final int findWordBoundary(int startIndex, int direction) {
        int i2;
        int len = this.value.length();
        if (direction < 0) {
            if (i2 > 0) {
                --i2;
            }
            while (i2 > 0 && Character.isWhitespace(this.value.charAt(i2))) {
                --i2;
            }
            while (i2 > 0 && !Character.isWhitespace(this.value.charAt(i2 - 1))) {
                --i2;
            }
        } else {
            for (i2 = startIndex; i2 < len && !Character.isWhitespace(this.value.charAt(i2)); ++i2) {
            }
            while (i2 < len && Character.isWhitespace(this.value.charAt(i2))) {
                ++i2;
            }
        }
        return RangesKt.coerceIn(i2, 0, len);
    }

    private final void deletePrevWord() {
        if (this.getHasSelection()) {
            this.deleteChar(0);
            return;
        }
        if (this.cursorIndex == 0) {
            return;
        }
        int oldCursor = this.cursorIndex;
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, -1);
        this.selectionAnchor = oldCursor;
        this.deleteChar(0);
    }

    private final void deleteNextWord() {
        if (this.getHasSelection()) {
            this.deleteChar(0);
            return;
        }
        if (this.cursorIndex == this.value.length()) {
            return;
        }
        int oldCursor = this.cursorIndex;
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, 1);
        this.selectionAnchor = oldCursor;
        this.deleteChar(0);
    }

    private final void selectAll() {
        this.selectionAnchor = 0;
        this.cursorIndex = this.value.length();
        this.resetCaretBlink();
    }

    private final String getSelectedText() {
        String string;
        if (this.getHasSelection()) {
            String string2 = this.value.substring(this.getSelectionStart(), this.getSelectionEnd());
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final void copySelection() {
        if (!this.getHasSelection()) {
            return;
        }
        GuiScreen.func_146275_d((String)this.getSelectedText());
    }

    private final void cutSelection() {
        if (!this.getHasSelection()) {
            return;
        }
        this.copySelection();
        this.deleteChar(0);
    }

    private final Unit paste() {
        Unit unit;
        String string = GuiScreen.func_146277_j();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            this.insertText(p0);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void ensureCaretVisible() {
        String string = this.value.substring(0, RangesKt.coerceIn(this.cursorIndex, 0, this.value.length()));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        double caretXAbsolute = this.fontObj.func_78256_a(string);
        double visibleTextStart = this.scrollOffset;
        double visibleTextEnd = this.scrollOffset + this.getTextRenderAreaWidth();
        if (caretXAbsolute < visibleTextStart) {
            this.scrollOffset = caretXAbsolute;
        } else if (caretXAbsolute > visibleTextEnd - 1.0) {
            this.scrollOffset = caretXAbsolute - this.getTextRenderAreaWidth() + 1.0;
        }
        double maxScrollPossible = Math.max(0.0, (double)this.fontObj.func_78256_a(this.value) - this.getTextRenderAreaWidth());
        this.scrollOffset = RangesKt.coerceIn(this.scrollOffset, 0.0, maxScrollPossible);
        if ((double)this.fontObj.func_78256_a(this.value) <= this.getTextRenderAreaWidth()) {
            this.scrollOffset = 0.0;
        }
    }

    public static final /* synthetic */ double access$getFieldWidth(TextInputComponent $this) {
        return $this.getFieldWidth();
    }
}

