/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier;

import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CommandDispatcher<S> {
    public static final String ARGUMENT_SEPARATOR = " ";
    public static final char ARGUMENT_SEPARATOR_CHAR = ' ';
    private static final String USAGE_OPTIONAL_OPEN = "[";
    private static final String USAGE_OPTIONAL_CLOSE = "]";
    private static final String USAGE_REQUIRED_OPEN = "(";
    private static final String USAGE_REQUIRED_CLOSE = ")";
    private static final String USAGE_OR = "|";
    private final RootCommandNode<S> root;
    private final Predicate<CommandNode<S>> hasCommand = new Predicate<CommandNode<S>>(){

        @Override
        public boolean test(CommandNode<S> input) {
            return input != null && (input.getCommand() != null || input.getChildren().stream().anyMatch(CommandDispatcher.this.hasCommand));
        }
    };
    private ResultConsumer<S> consumer = (c, s, r) -> {};

    public CommandDispatcher(RootCommandNode<S> root) {
        this.root = root;
    }

    public CommandDispatcher() {
        this(new RootCommandNode());
    }

    public LiteralCommandNode<S> register(LiteralArgumentBuilder<S> command2) {
        CommandNode build = command2.build();
        this.root.addChild(build);
        return build;
    }

    public void setConsumer(ResultConsumer<S> consumer) {
        this.consumer = consumer;
    }

    public int execute(String input, S source2) throws CommandSyntaxException {
        return this.execute(new StringReader(input), source2);
    }

    public int execute(StringReader input, S source2) throws CommandSyntaxException {
        ParseResults<S> parse2 = this.parse(input, source2);
        return this.execute(parse2);
    }

    public int execute(ParseResults<S> parse2) throws CommandSyntaxException {
        if (parse2.getReader().canRead()) {
            if (parse2.getExceptions().size() == 1) {
                throw parse2.getExceptions().values().iterator().next();
            }
            if (parse2.getContext().getRange().isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse2.getReader());
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse2.getReader());
        }
        String command2 = parse2.getReader().getString();
        CommandContext<S> original = parse2.getContext().build(command2);
        Optional<ContextChain<S>> flatContext = ContextChain.tryFlatten(original);
        if (!flatContext.isPresent()) {
            this.consumer.onCommandComplete(original, false, 0);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse2.getReader());
        }
        return flatContext.get().executeAll(original.getSource(), this.consumer);
    }

    public ParseResults<S> parse(String command2, S source2) {
        return this.parse(new StringReader(command2), source2);
    }

    public ParseResults<S> parse(StringReader command2, S source2) {
        CommandContextBuilder<S> context = new CommandContextBuilder<S>(this, source2, this.root, command2.getCursor());
        return this.parseNodes(this.root, command2, context);
    }

    private ParseResults<S> parseNodes(CommandNode<S> node2, StringReader originalReader, CommandContextBuilder<S> contextSoFar) {
        S source2 = contextSoFar.getSource();
        LinkedHashMap<CommandNode<S>, CommandSyntaxException> errors = null;
        ArrayList<ParseResults<S>> potentials = null;
        int cursor = originalReader.getCursor();
        for (CommandNode<S> child : node2.getRelevantNodes(originalReader)) {
            if (!child.canUse(source2)) continue;
            CommandContextBuilder<S> context = contextSoFar.copy();
            StringReader reader = new StringReader(originalReader);
            try {
                try {
                    child.parse(reader, context);
                }
                catch (RuntimeException ex) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext(reader, ex.getMessage());
                }
                if (reader.canRead() && reader.peek() != ' ') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext(reader);
                }
            }
            catch (CommandSyntaxException ex) {
                if (errors == null) {
                    errors = new LinkedHashMap<CommandNode<S>, CommandSyntaxException>();
                }
                errors.put(child, ex);
                reader.setCursor(cursor);
                continue;
            }
            context.withCommand(child.getCommand());
            if (reader.canRead(child.getRedirect() == null ? 2 : 1)) {
                reader.skip();
                if (child.getRedirect() != null) {
                    CommandContextBuilder<S> childContext = new CommandContextBuilder<S>(this, source2, child.getRedirect(), reader.getCursor());
                    ParseResults<S> parse2 = this.parseNodes(child.getRedirect(), reader, childContext);
                    context.withChild(parse2.getContext());
                    return new ParseResults<S>(context, parse2.getReader(), parse2.getExceptions());
                }
                ParseResults<S> parse3 = this.parseNodes(child, reader, context);
                if (potentials == null) {
                    potentials = new ArrayList(1);
                }
                potentials.add(parse3);
                continue;
            }
            if (potentials == null) {
                potentials = new ArrayList<ParseResults<S>>(1);
            }
            potentials.add(new ParseResults<S>(context, reader, Collections.emptyMap()));
        }
        if (potentials != null) {
            if (potentials.size() > 1) {
                potentials.sort((a, b) -> {
                    if (!a.getReader().canRead() && b.getReader().canRead()) {
                        return -1;
                    }
                    if (a.getReader().canRead() && !b.getReader().canRead()) {
                        return 1;
                    }
                    if (a.getExceptions().isEmpty() && !b.getExceptions().isEmpty()) {
                        return -1;
                    }
                    if (!a.getExceptions().isEmpty() && b.getExceptions().isEmpty()) {
                        return 1;
                    }
                    return 0;
                });
            }
            return (ParseResults)potentials.get(0);
        }
        return new ParseResults<S>(contextSoFar, originalReader, errors == null ? Collections.emptyMap() : errors);
    }

    public String[] getAllUsage(CommandNode<S> node2, S source2, boolean restricted) {
        ArrayList<String> result = new ArrayList<String>();
        this.getAllUsage(node2, source2, result, "", restricted);
        return result.toArray(new String[result.size()]);
    }

    private void getAllUsage(CommandNode<S> node2, S source2, ArrayList<String> result, String prefix, boolean restricted) {
        if (restricted && !node2.canUse(source2)) {
            return;
        }
        if (node2.getCommand() != null) {
            result.add(prefix);
        }
        if (node2.getRedirect() != null) {
            String redirect = node2.getRedirect() == this.root ? "..." : "-> " + node2.getRedirect().getUsageText();
            result.add(prefix.isEmpty() ? node2.getUsageText() + ARGUMENT_SEPARATOR + redirect : prefix + ARGUMENT_SEPARATOR + redirect);
        } else if (!node2.getChildren().isEmpty()) {
            for (CommandNode<S> child : node2.getChildren()) {
                this.getAllUsage(child, source2, result, prefix.isEmpty() ? child.getUsageText() : prefix + ARGUMENT_SEPARATOR + child.getUsageText(), restricted);
            }
        }
    }

    public Map<CommandNode<S>, String> getSmartUsage(CommandNode<S> node2, S source2) {
        LinkedHashMap<CommandNode<S>, String> result = new LinkedHashMap<CommandNode<S>, String>();
        boolean optional = node2.getCommand() != null;
        for (CommandNode<S> child : node2.getChildren()) {
            String usage = this.getSmartUsage(child, source2, optional, false);
            if (usage == null) continue;
            result.put(child, usage);
        }
        return result;
    }

    private String getSmartUsage(CommandNode<S> node2, S source2, boolean optional, boolean deep) {
        String close2;
        if (!node2.canUse(source2)) {
            return null;
        }
        String self = optional ? USAGE_OPTIONAL_OPEN + node2.getUsageText() + USAGE_OPTIONAL_CLOSE : node2.getUsageText();
        boolean childOptional = node2.getCommand() != null;
        String open2 = childOptional ? USAGE_OPTIONAL_OPEN : USAGE_REQUIRED_OPEN;
        String string = close2 = childOptional ? USAGE_OPTIONAL_CLOSE : USAGE_REQUIRED_CLOSE;
        if (!deep) {
            if (node2.getRedirect() != null) {
                String redirect = node2.getRedirect() == this.root ? "..." : "-> " + node2.getRedirect().getUsageText();
                return self + ARGUMENT_SEPARATOR + redirect;
            }
            Collection children2 = node2.getChildren().stream().filter(c -> c.canUse(source2)).collect(Collectors.toList());
            if (children2.size() == 1) {
                String usage = this.getSmartUsage((CommandNode)children2.iterator().next(), source2, childOptional, childOptional);
                if (usage != null) {
                    return self + ARGUMENT_SEPARATOR + usage;
                }
            } else if (children2.size() > 1) {
                LinkedHashSet<String> childUsage = new LinkedHashSet<String>();
                for (CommandNode child : children2) {
                    String usage = this.getSmartUsage(child, source2, childOptional, true);
                    if (usage == null) continue;
                    childUsage.add(usage);
                }
                if (childUsage.size() == 1) {
                    String usage = (String)childUsage.iterator().next();
                    return self + ARGUMENT_SEPARATOR + (childOptional ? USAGE_OPTIONAL_OPEN + usage + USAGE_OPTIONAL_CLOSE : usage);
                }
                if (childUsage.size() > 1) {
                    StringBuilder builder = new StringBuilder(open2);
                    int count2 = 0;
                    for (CommandNode child : children2) {
                        if (count2 > 0) {
                            builder.append(USAGE_OR);
                        }
                        builder.append(child.getUsageText());
                        ++count2;
                    }
                    if (count2 > 0) {
                        builder.append(close2);
                        return self + ARGUMENT_SEPARATOR + builder.toString();
                    }
                }
            }
        }
        return self;
    }

    public CompletableFuture<Suggestions> getCompletionSuggestions(ParseResults<S> parse2) {
        return this.getCompletionSuggestions(parse2, parse2.getReader().getTotalLength());
    }

    public CompletableFuture<Suggestions> getCompletionSuggestions(ParseResults<S> parse2, int cursor) {
        CommandContextBuilder<S> context = parse2.getContext();
        SuggestionContext<S> nodeBeforeCursor = context.findSuggestionContext(cursor);
        CommandNode parent = nodeBeforeCursor.parent;
        int start = Math.min(nodeBeforeCursor.startPos, cursor);
        String fullInput = parse2.getReader().getString();
        String truncatedInput = fullInput.substring(0, cursor);
        String truncatedInputLowerCase = truncatedInput.toLowerCase(Locale.ROOT);
        CompletableFuture[] futures = new CompletableFuture[parent.getChildren().size()];
        int i2 = 0;
        for (CommandNode<S> node2 : parent.getChildren()) {
            CompletableFuture<Suggestions> future = Suggestions.empty();
            try {
                future = node2.listSuggestions(context.build(truncatedInput), new SuggestionsBuilder(truncatedInput, truncatedInputLowerCase, start));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            futures[i2++] = future;
        }
        CompletableFuture<Suggestions> result = new CompletableFuture<Suggestions>();
        CompletableFuture.allOf(futures).thenRun(() -> {
            ArrayList<Suggestions> suggestions = new ArrayList<Suggestions>();
            for (CompletableFuture future : futures) {
                suggestions.add((Suggestions)future.join());
            }
            result.complete(Suggestions.merge(fullInput, suggestions));
        });
        return result;
    }

    public RootCommandNode<S> getRoot() {
        return this.root;
    }

    public Collection<String> getPath(CommandNode<S> target) {
        ArrayList<List<CommandNode<S>>> nodes = new ArrayList<List<CommandNode<S>>>();
        this.addPaths(this.root, nodes, new ArrayList<CommandNode<S>>());
        for (List list : nodes) {
            if (list.get(list.size() - 1) != target) continue;
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (CommandNode node2 : list) {
                if (node2 == this.root) continue;
                result.add(node2.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public CommandNode<S> findNode(Collection<String> path) {
        CommandNode node2 = this.root;
        for (String name : path) {
            if ((node2 = node2.getChild(name)) != null) continue;
            return null;
        }
        return node2;
    }

    public void findAmbiguities(AmbiguityConsumer<S> consumer) {
        this.root.findAmbiguities(consumer);
    }

    private void addPaths(CommandNode<S> node2, List<List<CommandNode<S>>> result, List<CommandNode<S>> parents) {
        ArrayList<CommandNode<S>> current = new ArrayList<CommandNode<S>>(parents);
        current.add(node2);
        result.add(current);
        for (CommandNode<S> child : node2.getChildren()) {
            this.addPaths(child, result, current);
        }
    }
}

