/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream;

import dev.deftu.filestream.util.OperatingSystem;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;

public class FileStream {
    public static final String NAME = "filestream";
    public static final String VERSION = "0.4.1";
    public static final String USER_AGENT = String.format("%s/%s", "filestream", "0.4.1");
    public static final String GLOBAL_STORE_NAME = System.getProperty("polyio.globalStoreName", "Polyfrost");
    private static Path localStorage = null;

    private FileStream() {
    }

    public static Path getLocalStorage() {
        if (localStorage == null) {
            localStorage = FileStream.findSystemLocalStorage();
        }
        return localStorage;
    }

    private static Path findSystemLocalStorage() {
        Path storePath = null;
        OperatingSystem os = OperatingSystem.find();
        switch (os) {
            case WINDOWS: {
                storePath = Paths.get(System.getenv("APPDATA"), new String[0]);
                if (Files.exists(storePath, new LinkOption[0])) break;
                storePath = Paths.get(System.getProperty("user.home"), "AppData", "Roaming");
                break;
            }
            case MACOS: {
                storePath = Paths.get(System.getProperty("user.home"), "Library", "Application Support");
                break;
            }
            default: {
                if (!os.isUnixLike()) break;
                String baseDir = System.getenv().getOrDefault("XDG_DATA_HOME", System.getProperty("user.home") + File.separator + ".local" + File.separator + "share");
                storePath = Paths.get(baseDir, new String[0]);
            }
        }
        if (storePath == null || !Files.exists(storePath, new LinkOption[0])) {
            storePath = Paths.get(System.getProperty("java.io.tmpdir", Stream.of("TEMP", "TMP", "TMPDIR").map(System::getenv).filter(Objects::nonNull).filter(it -> Files.exists(Paths.get(it, new String[0]), new LinkOption[0])).findFirst().orElse("/tmp")), new String[0]);
        }
        if (!Files.exists(storePath, new LinkOption[0])) {
            throw new IllegalStateException("Could not find platform target local store: " + storePath);
        }
        return storePath;
    }
}

