/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.api;

import dev.deftu.filestream.api.Store;
import dev.deftu.filestream.download.DownloaderImpl;
import java.net.URL;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Downloader {
    public Download<URL> download(@NotNull URL var1, @Nullable Path var2, @Nullable HashProvider var3, @Nullable DownloadCallback var4);

    default public Download<URL> download(URL url, Path target, @Nullable HashProvider hashProvider) {
        return this.download(url, target, hashProvider, DownloadCallback.NOOP);
    }

    default public Download<URL> download(URL url, Path target, DownloadCallback callback2) {
        return this.download(url, target, null, callback2);
    }

    default public Download<URL> download(URL url, Path target) {
        return this.download(url, target, null, DownloadCallback.NOOP);
    }

    public Download<URL> download(@NotNull URL var1, @NotNull Store var2, @Nullable HashProvider var3, @Nullable DownloadCallback var4);

    default public Download<URL> download(URL url, Store store, @Nullable HashProvider hashProvider) {
        return this.download(url, store, hashProvider, DownloadCallback.NOOP);
    }

    default public Download<URL> download(URL url, Store store, DownloadCallback callback2) {
        return this.download(url, store, null, callback2);
    }

    default public Download<URL> download(URL url, Store store) {
        return this.download(url, store, null, DownloadCallback.NOOP);
    }

    default public Download<URL> download(URL url, HashProvider hashProvider, DownloadCallback callback2) {
        return this.download(url, (Path)null, hashProvider, callback2);
    }

    default public Download<URL> download(URL url, DownloadCallback callback2) {
        return this.download(url, (Path)null, null, callback2);
    }

    default public Download<URL> download(URL url) {
        return this.download(url, (Path)null, null, DownloadCallback.NOOP);
    }

    public static Downloader create(Store store) {
        return new DownloaderImpl(store);
    }

    @FunctionalInterface
    public static interface DownloadCallback {
        public static final DownloadCallback NOOP = (downloaded, total) -> {};

        public void updateProgress(long var1, long var3);
    }

    public static interface HashProvider {
        @Nullable
        public String getHash();

        public @Nullable Supplier<@NotNull MessageDigest> getHashingFunction();

        default public boolean isHashPresent() {
            return this.getHash() == null || this.getHash().isEmpty();
        }

        public static HashProvider of(final String hash, final String hashingFunction) {
            return new HashProvider(){
                private MessageDigest messageDigest;

                @Override
                public String getHash() {
                    return hash;
                }

                @Override
                public Supplier<@NotNull MessageDigest> getHashingFunction() {
                    return () -> {
                        if (this.messageDigest == null) {
                            try {
                                this.messageDigest = MessageDigest.getInstance(hashingFunction);
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.messageDigest;
                    };
                }
            };
        }

        public static HashProvider of(final String hash, final MessageDigest messageDigest) {
            return new HashProvider(){

                @Override
                public String getHash() {
                    return hash;
                }

                @Override
                public Supplier<@NotNull MessageDigest> getHashingFunction() {
                    return () -> messageDigest;
                }
            };
        }
    }

    public static interface Download<S>
    extends Future<Path> {
        @NotNull
        public S getSource();
    }
}

