/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.store;

import dev.deftu.filestream.FileStream;
import dev.deftu.filestream.api.Store;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class FileStore
implements Store {
    @NotNull
    public static final Store GLOBAL_STORE = new FileStore(FileStream.getLocalStorage(), FileStream.GLOBAL_STORE_NAME, Store.ObjectSchema.DIRECT);
    private final Path storeRoot;
    private final Store.ObjectSchema objectSchema;

    public FileStore(@NotNull Path parent, @NotNull String storeDirName) {
        this(parent, storeDirName, Store.ObjectSchema.DIRECT);
    }

    public FileStore(@NotNull Path parent, @NotNull String storeDirName, @NotNull Store.ObjectSchema schema) {
        this.storeRoot = parent.resolve(storeDirName);
        this.objectSchema = schema;
        try {
            Files.createDirectories(this.storeRoot, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (storeDirName.startsWith(".")) {
            try {
                Files.setAttribute(this.storeRoot, "dos:hidden", true, new LinkOption[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public Path getStoreRoot() {
        return this.storeRoot;
    }

    @Override
    @NotNull
    public Path getObject(String name) {
        try {
            return this.objectSchema.getObjectPath(this.storeRoot, name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Store getSubStore(String name) {
        return this.getSubStore(name, this.objectSchema);
    }

    @Override
    @NotNull
    public Store getSubStore(String name, Store.ObjectSchema objectSchema) {
        return new FileStore(this.storeRoot, name, objectSchema);
    }
}

