/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.filestream.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public enum OperatingSystem {
    UNKNOWN("Unknown", "", "", OperatingSystem.createAliases("unknown")),
    WINDOWS("Windows", "", "dll", OperatingSystem.createAliases("windows", "win")),
    LINUX("Linux", "lib", "so", OperatingSystem.createAliases("linux", "nix", "nux"), () -> !OperatingSystem.isMusl() && !OperatingSystem.isAndroid()),
    LINUX_MUSL("Linux-musl", "lib", "so", OperatingSystem.createAliases("linux", "nix", "nux"), () -> OperatingSystem.isMusl() && !OperatingSystem.isAndroid()),
    ANDROID("Android", "lib", "so", OperatingSystem.createAliases("android", "linux", "nix", "nux"), OperatingSystem::isAndroid),
    MACOS("macOS", "lib", "dylib", OperatingSystem.createAliases("mac", "darwin", "osx")),
    SOLARIS("Solaris", "lib", "so", OperatingSystem.createAliases("sunos", "solaris")),
    FREE_BSD("FreeBSD", "lib", "so", OperatingSystem.createAliases("freebsd")),
    NET_BSD("NetBSD", "lib", "so", OperatingSystem.createAliases("netbsd")),
    OPEN_BSD("OpenBSD", "lib", "so", OperatingSystem.createAliases("openbsd")),
    DRAGONFLY_BSD("DragonFly BSD", "lib", "so", OperatingSystem.createAliases("dragonflybsd")),
    UNKNOWN_BSD("Unknown BSD", "lib", "so", OperatingSystem.createAliases("_DO_NOT_DETECT", "bsd")),
    AIX("AIX", "lib", "so", OperatingSystem.createAliases("aix")),
    HAIKU("Haiku", "lib", "so", OperatingSystem.createAliases("haiku", "hrev")),
    ILLUMOS("Illumos", "lib", "so", OperatingSystem.createAliases("illumos", "omnios", "openindiana"));

    private final String name;
    private final String nativePrefix;
    private final String nativeExtension;
    private final Set<String> aliases;
    private final BooleanSupplier condition;

    private OperatingSystem(String name, String nativePrefix, String nativeExtension, Set<String> aliases, BooleanSupplier condition) {
        this.name = name;
        this.nativePrefix = nativePrefix;
        this.nativeExtension = nativeExtension;
        this.aliases = aliases;
        this.condition = condition;
    }

    private OperatingSystem(String name, String nativePrefix, String nativeExtension, Set<String> aliases) {
        this(name, nativePrefix, nativeExtension, aliases, () -> true);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getNativePrefix() {
        return this.nativePrefix;
    }

    @NotNull
    public String getNativeExtension() {
        return this.nativeExtension;
    }

    @NotNull
    public Set<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public BooleanSupplier getCondition() {
        return this.condition;
    }

    public boolean isUnixLike() {
        return this == LINUX || this == ANDROID || this == MACOS || this == SOLARIS || this == FREE_BSD || this == NET_BSD || this == OPEN_BSD || this == DRAGONFLY_BSD || this == UNKNOWN_BSD || this == AIX || this == HAIKU || this == ILLUMOS;
    }

    @NotNull
    public static OperatingSystem find() {
        OperatingSystem value = UNKNOWN;
        String name = System.getProperty("os.name").toLowerCase().replace(" ", "");
        int maxAliases = Arrays.stream(OperatingSystem.values()).mapToInt(os -> os.getAliases().size()).max().orElse(0);
        for (int i2 = 0; i2 < maxAliases; ++i2) {
            for (OperatingSystem os2 : OperatingSystem.values()) {
                String alias;
                Set<String> aliases = os2.getAliases();
                if (aliases.size() <= i2 || !name.contains(alias = (String)aliases.toArray()[i2]) || !os2.getCondition().getAsBoolean()) continue;
                value = os2;
            }
        }
        return value;
    }

    public static boolean isAndroid() {
        try {
            return System.getProperty("java.vm.name").toLowerCase().contains("android");
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static boolean isMusl() {
        try {
            Process process = new ProcessBuilder("ldd", "--version").start();
            String line = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            if (line == null) {
                line = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
            }
            return line != null && line.toLowerCase().contains("musl");
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static Set<String> createAliases(String ... aliases) {
        return new HashSet<String>(Arrays.asList(aliases));
    }

    private static byte[] readAllBytes(InputStream inputStream2) throws IOException {
        int read;
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = inputStream2.read(buffer)) != -1) {
            outputStream2.write(buffer, 0, read);
        }
        return outputStream2.toByteArray();
    }
}

