/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader;

import dev.deftu.filestream.util.HashingHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Lwjgl3Transformer {
    private static final Map<String, String> remappingMap = new HashMap<String, String>();
    private static final Class<? extends ClassVisitor> remapperAdapter;

    private Lwjgl3Transformer() {
    }

    public static Path maybeTransform(Path path) {
        boolean[] modified;
        Path targetFinal;
        Path target;
        block57: {
            File file = path.toFile();
            String filename = file.getName();
            String name = filename.lastIndexOf(46) > 0 ? filename.substring(0, filename.lastIndexOf(46)) : filename;
            String ext = filename.lastIndexOf(46) > 0 ? filename.substring(filename.lastIndexOf(46)) : "";
            target = path.getParent().resolve(name + "-patched.tmp" + ext);
            targetFinal = path.getParent().resolve(name + "-patched" + ext);
            if (Files.exists(target, new LinkOption[0])) {
                try {
                    Files.delete(target);
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't delete target file " + target, e);
                }
            }
            modified = new boolean[]{false};
            try (ZipFile zipFile = new ZipFile(path.toFile());
                 ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    byte[] buffer;
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entryName.endsWith(".class") && !entryName.startsWith("META-INF/") && !entryName.contains("actually3") && !entryName.endsWith("-info.class")) {
                        ClassReader classReader = new ClassReader(zipFile.getInputStream(entry));
                        ClassNode dummyNode = new ClassNode();
                        classReader.accept((ClassVisitor)dummyNode, 5);
                        Remapper remapper = new Remapper(){

                            public String map(String desc) {
                                if (remappingMap.containsKey(desc)) {
                                    modified[0] = true;
                                    return (String)remappingMap.get(desc);
                                }
                                return desc;
                            }
                        };
                        ClassWriter classWriter = new ClassWriter(classReader, 1);
                        Constructor<? extends ClassVisitor> constructor = remapperAdapter.getConstructor(ClassVisitor.class, Remapper.class);
                        ClassVisitor remapperInstance = constructor.newInstance(classWriter, remapper);
                        classReader.accept(remapperInstance, 8);
                        byte[] tempBuf = classWriter.toByteArray();
                        ClassNode node2 = new ClassNode();
                        new ClassReader(tempBuf).accept((ClassVisitor)node2, 8);
                        boolean isModified = Lwjgl3Transformer.transformGLConfig(node2);
                        ClassWriter writer = new ClassWriter(1);
                        node2.accept((ClassVisitor)writer);
                        buffer = writer.toByteArray();
                        if (isModified && System.getProperty("isolatedlwjgl3loader.debug") != null) {
                            String className = node2.name.replace('/', '.');
                            try (FileOutputStream fos = new FileOutputStream(className + ".class");){
                                byte[] copiedBuffer = new byte[buffer.length];
                                System.arraycopy(buffer, 0, copiedBuffer, 0, buffer.length);
                                fos.write(copiedBuffer);
                            }
                        }
                        zos.putNextEntry(new ZipEntry(entryName.replace(dummyNode.name, node2.name)));
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Lwjgl3Transformer.transferTo(zipFile.getInputStream(entry), baos);
                        buffer = baos.toByteArray();
                        zos.putNextEntry(new ZipEntry(entry.getName()));
                    }
                    zos.write(buffer);
                    zos.closeEntry();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (Files.exists(targetFinal, new LinkOption[0])) {
                try {
                    String currentHash = HashingHelper.hash(target, HashingHelper.MD5);
                    String oldHash = HashingHelper.hash(targetFinal, HashingHelper.MD5);
                    if (currentHash.equals(oldHash)) break block57;
                    try {
                        Files.delete(targetFinal);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Couldn't delete target file " + targetFinal, e);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't hash target file " + target, e);
                }
            }
        }
        try {
            Files.move(target, targetFinal, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't move target file " + target + " to " + targetFinal, e);
        }
        if (modified[0]) {
            return targetFinal;
        }
        try {
            Files.delete(targetFinal);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    private static void transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer, 0, 1024)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    private static boolean transformGLConfig(ClassNode node2) {
        if (node2.name.equalsIgnoreCase("org/lwjgl/nanovg/NanoVGGLConfig")) {
            block0: for (MethodNode method : node2.methods) {
                if (!method.name.equals("configGL")) continue;
                for (AbstractInsnNode insn : method.instructions.toArray()) {
                    if (!(insn instanceof LdcInsnNode)) continue;
                    LdcInsnNode ldc = (LdcInsnNode)insn;
                    if (!ldc.cst.equals("org.lwjgl.opengl.GL")) continue;
                    ldc.cst = "dev.deftu.lwjgl.isolatedloader.utils.LwjglFunctionProviderFactory";
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    static {
        remappingMap.put("org/lwjgl/BufferUtils", "org/lwjgl/actually3/BufferUtils");
        remappingMap.put("org/lwjgl/PointerBuffer", "org/lwjgl/actually3/PointerBuffer");
        remappingMap.put("org/lwjgl/CLongBuffer", "org/lwjgl/actually3/CLongBuffer");
        boolean asm5 = false;
        try {
            Class.forName("net.minecraftforge.common.ForgeVersion");
            asm5 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            remapperAdapter = asm5 ? Class.forName("org.objectweb.asm.commons.RemappingClassAdapter") : Class.forName("org.objectweb.asm.commons.ClassRemapper");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

