/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader.metadata;

import dev.deftu.filestream.util.Architecture;
import dev.deftu.filestream.util.OperatingSystem;
import org.jetbrains.annotations.NotNull;

public final class PlatformMetadata {
    private static final String LWJGL_VERSION = "3.3.3";
    @NotNull
    private final String lwjglVersion;
    @NotNull
    private final String lwjglNativeClassifier;

    public PlatformMetadata(@NotNull String lwjglVersion, @NotNull String lwjglNativeClassifier) {
        this.lwjglVersion = lwjglVersion;
        this.lwjglNativeClassifier = lwjglNativeClassifier;
    }

    @NotNull
    public String getLwjglVersion() {
        return this.lwjglVersion;
    }

    @NotNull
    public String getLwjglNativeClassifier() {
        return this.lwjglNativeClassifier;
    }

    @NotNull
    public static PlatformMetadata from() {
        OperatingSystem operatingSystem = OperatingSystem.find();
        Architecture architecture = Architecture.find();
        String classifier = "natives-" + operatingSystem.getName().toLowerCase();
        if (architecture != Architecture.X86_64 && (classifier = classifier + "-" + architecture.getName().toLowerCase()).contains("aarch")) {
            classifier = classifier.replace("aarch", "arm");
        }
        return new PlatformMetadata(LWJGL_VERSION, classifier);
    }
}

