/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.lwjgl.isolatedloader.utils;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public class LwjglFunctionProviderFactory {
    public static void getCapabilities() {
    }

    public static FunctionProvider getFunctionProvider() {
        ClassLoader classLoader = LwjglFunctionProviderFactory.class.getClassLoader().getClass().getClassLoader();
        try {
            Class<?> clz = Class.forName("org.lwjgl.opengl.GLContext", true, classLoader);
            final Method method = clz.getDeclaredMethod("ngetFunctionAddress", Long.TYPE);
            method.setAccessible(true);
            return new FunctionProvider(){

                public long getFunctionAddress(ByteBuffer functionName) {
                    try {
                        return (Long)method.invoke(null, MemoryUtil.memAddress((ByteBuffer)functionName));
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            };
        }
        catch (Throwable t) {
            try {
                Class<?> clz = Class.forName("org.lwjgl.opengl.GL", true, classLoader);
                Method method = clz.getDeclaredMethod("getFunctionProvider", new Class[0]);
                method.setAccessible(true);
                final Object wrappingProvider = method.invoke(null, new Object[0]);
                Class<?> providerClass = Class.forName("org.lwjgl.system.FunctionProvider", true, classLoader);
                final Method getFunctionAddress = providerClass.getDeclaredMethod("getFunctionAddress", ByteBuffer.class);
                getFunctionAddress.setAccessible(true);
                return new FunctionProvider(){

                    public long getFunctionAddress(ByteBuffer functionName) {
                        try {
                            return (Long)getFunctionAddress.invoke(wrappingProvider, functionName);
                        }
                        catch (Throwable t1) {
                            throw new RuntimeException(t1);
                        }
                    }
                };
            }
            catch (Throwable t1) {
                t1.addSuppressed(t);
                throw new RuntimeException(t1);
            }
        }
    }
}

