/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.command.parsers.impl;

import com.mojang.brigadier.StringReader;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.command.functions.FunctionInvoker;
import xyz.meowing.knit.api.command.functions.Parameter;
import xyz.meowing.knit.api.command.parsers.CommandParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B3\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u001a\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR,\u0010\u001d\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002`\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lxyz/meowing/knit/api/command/parsers/impl/FunctionParser;", "T", "Lxyz/meowing/knit/api/command/parsers/CommandParser;", "Lkotlin/Function;", "function", "", "Ljava/lang/Class;", "parameterTypes", "<init>", "(Lkotlin/Function;[Ljava/lang/Class;)V", "Lkotlin/Function1;", "", "", "invoker", "(Lkotlin/jvm/functions/Function1;)V", "", "initParsers", "()V", "Lcom/mojang/brigadier/StringReader;", "reader", "parse", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Object;", "Lxyz/meowing/knit/api/command/functions/FunctionInvoker;", "funInvoker", "Lxyz/meowing/knit/api/command/functions/FunctionInvoker;", "constructorInvoker", "Lkotlin/jvm/functions/Function1;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "parsers", "Ljava/util/ArrayList;", "Knit"})
@SourceDebugExtension(value={"SMAP\nFunctionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionParser.kt\nxyz/meowing/knit/api/command/parsers/impl/FunctionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class FunctionParser<T>
implements CommandParser<T> {
    @Nullable
    private final FunctionInvoker<T> funInvoker;
    @Nullable
    private final Function1<List<? extends Object>, T> constructorInvoker;
    @NotNull
    private final ArrayList<CommandParser<?>> parsers;

    public FunctionParser(@NotNull Function<? extends T> function, Class<?> ... parameterTypes) {
        Intrinsics.checkNotNullParameter(function, "function");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        this.parsers = new ArrayList();
        this.funInvoker = parameterTypes.length == 0 ? FunctionInvoker.Companion.from(function, new Class[0]) : FunctionInvoker.Companion.from(function, Arrays.copyOf(parameterTypes, parameterTypes.length));
        this.constructorInvoker = null;
        this.initParsers();
    }

    public FunctionParser(@NotNull Function1<? super List<? extends Object>, ? extends T> invoker) {
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        this.parsers = new ArrayList();
        this.funInvoker = null;
        this.constructorInvoker = invoker;
        Object object = invoker.getClass().getEnclosingClass();
        if (object == null || (object = ((Class)object).getConstructors()) == null || (object = ArraysKt.firstOrNull(object)) == null) {
            throw new IllegalStateException("Cannot find constructor");
        }
        Object constructor = object;
        Iterator<java.lang.reflect.Parameter> iterator2 = ArrayIteratorKt.iterator(((Executable)constructor).getParameters());
        while (iterator2.hasNext()) {
            CommandParser<?> parser2;
            java.lang.reflect.Parameter param = iterator2.next();
            Class<?> clazz = param.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, "getType(...)");
            if (CommandParser.Companion.getParser(clazz) == null) {
                throw new IllegalStateException("No parser found for parameter: " + param.getName() + "(type=" + param.getType() + ')');
            }
            this.parsers.add(parser2);
        }
        if (!(!((Collection)this.parsers).isEmpty())) {
            boolean bl = false;
            String string = "You need at least one parameter in the function for this parser.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void initParsers() {
        FunctionInvoker<T> functionInvoker = this.funInvoker;
        Intrinsics.checkNotNull(functionInvoker);
        for (Parameter<?> parameter : functionInvoker.getParameters()) {
            CommandParser<?> parser2;
            if (CommandParser.Companion.getParser(parameter.getType()) == null) {
                throw new IllegalStateException("No parser found for parameter: " + parameter.getName() + "(type=" + parameter.getType() + ')');
            }
            this.parsers.add(parser2);
        }
        if (!(!((Collection)this.parsers).isEmpty())) {
            boolean bl = false;
            String string = "You need at least one parameter in the function for this parser.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public T parse(@NotNull StringReader reader) {
        T t;
        Intrinsics.checkNotNullParameter(reader, "reader");
        List arguments = new ArrayList();
        Iterator<CommandParser<?>> iterator2 = this.parsers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<CommandParser<?>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CommandParser<?> parser2;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            reader.skipWhitespace();
            arguments.add(parser2.parse(reader));
        }
        if (this.funInvoker != null) {
            t = this.funInvoker.invoke(arguments);
        } else {
            Function1<List<Object>, T> function1 = this.constructorInvoker;
            Intrinsics.checkNotNull(function1);
            t = function1.invoke(arguments);
        }
        return t;
    }

    @Override
    @NotNull
    public Collection<String> suggestions() {
        return CommandParser.DefaultImpls.suggestions(this);
    }

    @Override
    @NotNull
    public Collection<String> examples() {
        return CommandParser.DefaultImpls.examples(this);
    }
}

