/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.knit.api.text.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.text.KnitText;
import xyz.meowing.knit.api.text.core.ClickEvent;
import xyz.meowing.knit.api.text.core.HoverEvent;
import xyz.meowing.knit.api.text.internal.ColorMapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\r\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\rJ\r\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\rJ\r\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\rJ\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\rJ\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\rJ\r\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\rJ\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\rJ\r\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\rJ\r\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\rJ\r\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\rJ\r\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\rJ\r\u0010\u0019\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\rJ\r\u0010\u001a\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\rJ\r\u0010\u001b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\rJ\r\u0010\u001c\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001c\u0010\rJ\u0017\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b!\u0010 J\u0017\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010 J\u0017\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b#\u0010 J\u0017\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b$\u0010 J\r\u0010%\u001a\u00020\u0000\u00a2\u0006\u0004\b%\u0010\rJ\u0015\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010(\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0002\u00a2\u0006\u0004\b(\u0010\bJ\u0015\u0010,\u001a\u00020\u00002\u0006\u0010'\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010,\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010\bJ\u0015\u0010,\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000\u00a2\u0006\u0004\b,\u0010/J\u0015\u00100\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b0\u0010\bJ\u0015\u00101\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000\u00a2\u0006\u0004\b1\u0010/J\u0015\u00101\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b1\u0010\bJ\r\u00102\u001a\u00020\u0000\u00a2\u0006\u0004\b2\u0010\rJ\u0015\u00102\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u0010\bJ\u0015\u00102\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000\u00a2\u0006\u0004\b2\u0010/J\u0015\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0002\u00a2\u0006\u0004\b4\u0010\bJ\u0015\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u0010\bJ\u0015\u00106\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b6\u0010\bJ\u0015\u00107\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0002\u00a2\u0006\u0004\b7\u0010\bJ\u0015\u00109\u001a\u00020\u00002\u0006\u00108\u001a\u00020\t\u00a2\u0006\u0004\b9\u0010\u000bJ\r\u0010;\u001a\u00020:\u00a2\u0006\u0004\b;\u0010<J\r\u0010=\u001a\u00020:\u00a2\u0006\u0004\b=\u0010<J\r\u0010>\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010?J\r\u0010@\u001a\u00020\u0002\u00a2\u0006\u0004\b@\u0010?J\u0018\u0010B\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\bB\u0010/J\u0018\u0010B\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\bB\u0010\bR\"\u0010\u0003\u001a\u00020\u00028\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010C\u001a\u0004\bD\u0010?\"\u0004\bE\u0010\u0005R$\u0010F\u001a\u0004\u0018\u00010:8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010<\"\u0004\bI\u0010JR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00000K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010NR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010OR\u0018\u0010!\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010OR\u0018\u0010\"\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010OR\u0018\u0010#\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010OR\u0018\u0010$\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010OR\u0018\u0010P\u001a\u0004\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0018\u0010R\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u0018\u00100\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010C\u00a8\u0006T"}, d2={"Lxyz/meowing/knit/api/text/internal/TextBuilder;", "", "", "text", "<init>", "(Ljava/lang/String;)V", "hex", "color", "(Ljava/lang/String;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "", "rgb", "(I)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "black", "()Lxyz/meowing/knit/api/text/internal/TextBuilder;", "darkBlue", "darkGreen", "darkAqua", "darkRed", "darkPurple", "gold", "gray", "darkGray", "blue", "green", "aqua", "red", "lightPurple", "yellow", "white", "", "value", "bold", "(Z)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "italic", "underlined", "strikethrough", "obfuscated", "reset", "Lxyz/meowing/knit/api/text/core/ClickEvent;", "event", "onClick", "(Lxyz/meowing/knit/api/text/core/ClickEvent;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "url", "Lxyz/meowing/knit/api/text/core/HoverEvent;", "onHover", "(Lxyz/meowing/knit/api/text/core/HoverEvent;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "builder", "(Lxyz/meowing/knit/api/text/internal/TextBuilder;)Lxyz/meowing/knit/api/text/internal/TextBuilder;", "insertion", "append", "appendLine", "command", "suggestCommand", "runCommand", "copyToClipboard", "openUrl", "page", "changePage", "Lnet/minecraft/util/IChatComponent;", "build", "()Lnet/minecraft/util/IChatComponent;", "toVanilla", "string", "()Ljava/lang/String;", "formatted", "other", "plus", "Ljava/lang/String;", "getText$Knit", "setText$Knit", "vanilla", "Lnet/minecraft/util/IChatComponent;", "getVanilla$Knit", "setVanilla$Knit", "(Lnet/minecraft/util/IChatComponent;)V", "", "siblings", "Ljava/util/List;", "Ljava/lang/Integer;", "Ljava/lang/Boolean;", "clickEvent", "Lxyz/meowing/knit/api/text/core/ClickEvent;", "hoverEvent", "Lxyz/meowing/knit/api/text/core/HoverEvent;", "Knit"})
@SourceDebugExtension(value={"SMAP\nTextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBuilder.kt\nxyz/meowing/knit/api/text/internal/TextBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,335:1\n1#2:336\n1869#3,2:337\n*S KotlinDebug\n*F\n+ 1 TextBuilder.kt\nxyz/meowing/knit/api/text/internal/TextBuilder\n*L\n296#1:337,2\n*E\n"})
public final class TextBuilder {
    @NotNull
    private String text;
    @Nullable
    private IChatComponent vanilla;
    @NotNull
    private final List<TextBuilder> siblings;
    @Nullable
    private Integer color;
    @Nullable
    private Boolean bold;
    @Nullable
    private Boolean italic;
    @Nullable
    private Boolean underlined;
    @Nullable
    private Boolean strikethrough;
    @Nullable
    private Boolean obfuscated;
    @Nullable
    private ClickEvent clickEvent;
    @Nullable
    private HoverEvent hoverEvent;
    @Nullable
    private String insertion;

    public TextBuilder(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.text = text;
        this.siblings = new ArrayList();
    }

    @NotNull
    public final String getText$Knit() {
        return this.text;
    }

    public final void setText$Knit(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.text = string;
    }

    @Nullable
    public final IChatComponent getVanilla$Knit() {
        return this.vanilla;
    }

    public final void setVanilla$Knit(@Nullable IChatComponent iChatComponent) {
        this.vanilla = iChatComponent;
    }

    @NotNull
    public final TextBuilder color(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        this.color = Integer.parseInt(StringsKt.removePrefix(hex, (CharSequence)"#"), CharsKt.checkRadix(16));
        return this;
    }

    @NotNull
    public final TextBuilder color(int rgb) {
        this.color = rgb;
        return this;
    }

    @NotNull
    public final TextBuilder black() {
        return this.color(0);
    }

    @NotNull
    public final TextBuilder darkBlue() {
        return this.color(170);
    }

    @NotNull
    public final TextBuilder darkGreen() {
        return this.color(43520);
    }

    @NotNull
    public final TextBuilder darkAqua() {
        return this.color(43690);
    }

    @NotNull
    public final TextBuilder darkRed() {
        return this.color(0xAA0000);
    }

    @NotNull
    public final TextBuilder darkPurple() {
        return this.color(0xAA00AA);
    }

    @NotNull
    public final TextBuilder gold() {
        return this.color(0xFFAA00);
    }

    @NotNull
    public final TextBuilder gray() {
        return this.color(0xAAAAAA);
    }

    @NotNull
    public final TextBuilder darkGray() {
        return this.color(0x555555);
    }

    @NotNull
    public final TextBuilder blue() {
        return this.color(0x5555FF);
    }

    @NotNull
    public final TextBuilder green() {
        return this.color(0x55FF55);
    }

    @NotNull
    public final TextBuilder aqua() {
        return this.color(0x55FFFF);
    }

    @NotNull
    public final TextBuilder red() {
        return this.color(0xFF5555);
    }

    @NotNull
    public final TextBuilder lightPurple() {
        return this.color(0xFF55FF);
    }

    @NotNull
    public final TextBuilder yellow() {
        return this.color(0xFFFF55);
    }

    @NotNull
    public final TextBuilder white() {
        return this.color(0xFFFFFF);
    }

    @NotNull
    public final TextBuilder bold(boolean value) {
        this.bold = value;
        return this;
    }

    public static /* synthetic */ TextBuilder bold$default(TextBuilder textBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return textBuilder.bold(bl);
    }

    @NotNull
    public final TextBuilder italic(boolean value) {
        this.italic = value;
        return this;
    }

    public static /* synthetic */ TextBuilder italic$default(TextBuilder textBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return textBuilder.italic(bl);
    }

    @NotNull
    public final TextBuilder underlined(boolean value) {
        this.underlined = value;
        return this;
    }

    public static /* synthetic */ TextBuilder underlined$default(TextBuilder textBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return textBuilder.underlined(bl);
    }

    @NotNull
    public final TextBuilder strikethrough(boolean value) {
        this.strikethrough = value;
        return this;
    }

    public static /* synthetic */ TextBuilder strikethrough$default(TextBuilder textBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return textBuilder.strikethrough(bl);
    }

    @NotNull
    public final TextBuilder obfuscated(boolean value) {
        this.obfuscated = value;
        return this;
    }

    public static /* synthetic */ TextBuilder obfuscated$default(TextBuilder textBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return textBuilder.obfuscated(bl);
    }

    @NotNull
    public final TextBuilder reset() {
        this.color = null;
        this.bold = null;
        this.italic = null;
        this.underlined = null;
        this.strikethrough = null;
        this.obfuscated = null;
        return this;
    }

    @NotNull
    public final TextBuilder onClick(@NotNull ClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.clickEvent = event;
        return this;
    }

    @NotNull
    public final TextBuilder onClick(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue(uRI, "create(...)");
        this.clickEvent = new ClickEvent.OpenUrl(uRI);
        return this;
    }

    @NotNull
    public final TextBuilder onHover(@NotNull HoverEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.hoverEvent = event;
        return this;
    }

    @NotNull
    public final TextBuilder onHover(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.hoverEvent = new HoverEvent.ShowText(KnitText.literal(text));
        return this;
    }

    @NotNull
    public final TextBuilder onHover(@NotNull TextBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.hoverEvent = new HoverEvent.ShowText(builder);
        return this;
    }

    @NotNull
    public final TextBuilder insertion(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.insertion = text;
        return this;
    }

    @NotNull
    public final TextBuilder append(@NotNull TextBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.siblings.add(builder);
        return this;
    }

    @NotNull
    public final TextBuilder append(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.siblings.add(KnitText.literal(text));
        return this;
    }

    @NotNull
    public final TextBuilder appendLine() {
        this.siblings.add(KnitText.literal("\n"));
        return this;
    }

    @NotNull
    public final TextBuilder appendLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.siblings.add(KnitText.literal(text));
        this.siblings.add(KnitText.literal("\n"));
        return this;
    }

    @NotNull
    public final TextBuilder appendLine(@NotNull TextBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.siblings.add(builder);
        this.siblings.add(KnitText.literal("\n"));
        return this;
    }

    @NotNull
    public final TextBuilder suggestCommand(@NotNull String command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        this.clickEvent = new ClickEvent.SuggestCommand(command2);
        return this;
    }

    @NotNull
    public final TextBuilder runCommand(@NotNull String command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        this.clickEvent = new ClickEvent.RunCommand(command2);
        return this;
    }

    @NotNull
    public final TextBuilder copyToClipboard(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.clickEvent = new ClickEvent.CopyToClipboard(text);
        return this;
    }

    @NotNull
    public final TextBuilder openUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        URI uRI = URI.create(url);
        Intrinsics.checkNotNullExpressionValue(uRI, "create(...)");
        this.clickEvent = new ClickEvent.OpenUrl(uRI);
        return this;
    }

    @NotNull
    public final TextBuilder changePage(int page) {
        this.clickEvent = new ClickEvent.ChangePage(page);
        return this;
    }

    @NotNull
    public final IChatComponent build() {
        Object nearest;
        IChatComponent iChatComponent = this.vanilla;
        if (iChatComponent != null) {
            IChatComponent it2 = iChatComponent;
            boolean bl = false;
            return it2;
        }
        ChatComponentText base = new ChatComponentText(this.text);
        ChatStyle style = base.func_150256_b();
        Integer n = this.color;
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl = false;
            nearest = ColorMapper.INSTANCE.findNearest(n2);
            style.func_150238_a(nearest);
        }
        Boolean bl = this.bold;
        if (bl != null) {
            boolean bl2 = bl;
            boolean bl22 = false;
            style.func_150227_a(Boolean.valueOf(bl2));
        }
        Boolean bl3 = this.italic;
        if (bl3 != null) {
            boolean bl4 = bl3;
            boolean bl42 = false;
            style.func_150217_b(Boolean.valueOf(bl4));
        }
        Boolean bl5 = this.underlined;
        if (bl5 != null) {
            boolean bl6 = bl5;
            boolean bl62 = false;
            style.func_150228_d(Boolean.valueOf(bl6));
        }
        Boolean bl7 = this.strikethrough;
        if (bl7 != null) {
            boolean bl8 = bl7;
            boolean bl82 = false;
            style.func_150225_c(Boolean.valueOf(bl8));
        }
        Boolean bl9 = this.obfuscated;
        if (bl9 != null) {
            boolean bl10 = bl9;
            boolean bl102 = false;
            style.func_150237_e(Boolean.valueOf(bl10));
        }
        String string = this.insertion;
        if (string != null) {
            String string2 = string;
            boolean bl11 = false;
            style.func_150241_a(new net.minecraft.event.ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, string2));
        }
        ClickEvent clickEvent = this.clickEvent;
        if (clickEvent != null) {
            net.minecraft.event.ClickEvent clickEvent2;
            ClickEvent clickEvent3 = clickEvent;
            boolean bl12 = false;
            nearest = clickEvent3;
            if (nearest instanceof ClickEvent.OpenUrl) {
                clickEvent2 = new net.minecraft.event.ClickEvent(ClickEvent.Action.OPEN_URL, ((ClickEvent.OpenUrl)clickEvent3).getUrl().toString());
            } else if (nearest instanceof ClickEvent.RunCommand) {
                clickEvent2 = new net.minecraft.event.ClickEvent(ClickEvent.Action.RUN_COMMAND, ((ClickEvent.RunCommand)clickEvent3).getCommand());
            } else if (nearest instanceof ClickEvent.SuggestCommand) {
                clickEvent2 = new net.minecraft.event.ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ((ClickEvent.SuggestCommand)clickEvent3).getCommand());
            } else if (nearest instanceof ClickEvent.CopyToClipboard) {
                clickEvent2 = new net.minecraft.event.ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ((ClickEvent.CopyToClipboard)clickEvent3).getText());
            } else if (nearest instanceof ClickEvent.ChangePage) {
                clickEvent2 = new net.minecraft.event.ClickEvent(ClickEvent.Action.CHANGE_PAGE, String.valueOf(((ClickEvent.ChangePage)clickEvent3).getPage()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            style.func_150241_a(clickEvent2);
        }
        HoverEvent hoverEvent = this.hoverEvent;
        if (hoverEvent != null) {
            net.minecraft.event.HoverEvent hoverEvent2;
            HoverEvent hoverEvent3 = hoverEvent;
            boolean bl13 = false;
            nearest = hoverEvent3;
            if (nearest instanceof HoverEvent.ShowText) {
                hoverEvent2 = new net.minecraft.event.HoverEvent(HoverEvent.Action.SHOW_TEXT, ((HoverEvent.ShowText)hoverEvent3).getText().build());
            } else if (nearest instanceof HoverEvent.ShowItem) {
                hoverEvent2 = new net.minecraft.event.HoverEvent(HoverEvent.Action.SHOW_ITEM, ((HoverEvent.ShowItem)hoverEvent3).getStack());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            style.func_150209_a(hoverEvent2);
        }
        base.func_150255_a(style);
        Iterable $this$forEach$iv = this.siblings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextBuilder it6 = (TextBuilder)element$iv;
            boolean bl14 = false;
            base.func_150257_a(it6.build());
        }
        return (IChatComponent)base;
    }

    @NotNull
    public final IChatComponent toVanilla() {
        return this.build();
    }

    @NotNull
    public final String string() {
        String string = this.build().func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        return string;
    }

    @NotNull
    public final String formatted() {
        String string = this.build().func_150254_d();
        Intrinsics.checkNotNullExpressionValue(string, "getFormattedText(...)");
        return string;
    }

    @NotNull
    public final TextBuilder plus(@NotNull TextBuilder other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.append(other);
    }

    @NotNull
    public final TextBuilder plus(@NotNull String other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.append(other);
    }
}

