/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.components.base;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Container;
import xyz.meowing.vexel.components.core.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\r\u0082\u0001\u0004\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lxyz/meowing/vexel/components/base/DimensionValue;", "", "<init>", "()V", "Lxyz/meowing/vexel/components/base/VexelElement;", "element", "", "isWidth", "", "resolve", "(Lxyz/meowing/vexel/components/base/VexelElement;Z)F", "other", "minus", "(Lxyz/meowing/vexel/components/base/DimensionValue;)Lxyz/meowing/vexel/components/base/DimensionValue;", "plus", "Pixels", "Percent", "Minus", "Plus", "Lxyz/meowing/vexel/components/base/DimensionValue$Minus;", "Lxyz/meowing/vexel/components/base/DimensionValue$Percent;", "Lxyz/meowing/vexel/components/base/DimensionValue$Pixels;", "Lxyz/meowing/vexel/components/base/DimensionValue$Plus;", "Vexel"})
public abstract class DimensionValue {
    private DimensionValue() {
    }

    public abstract float resolve(@NotNull VexelElement<?> var1, boolean var2);

    @NotNull
    public final DimensionValue minus(@NotNull DimensionValue other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Minus(this, other);
    }

    @NotNull
    public final DimensionValue plus(@NotNull DimensionValue other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Plus(this, other);
    }

    public /* synthetic */ DimensionValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u00020\n2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lxyz/meowing/vexel/components/base/DimensionValue$Minus;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "left", "right", "<init>", "(Lxyz/meowing/vexel/components/base/DimensionValue;Lxyz/meowing/vexel/components/base/DimensionValue;)V", "Lxyz/meowing/vexel/components/base/VexelElement;", "element", "", "isWidth", "", "resolve", "(Lxyz/meowing/vexel/components/base/VexelElement;Z)F", "component1", "()Lxyz/meowing/vexel/components/base/DimensionValue;", "component2", "copy", "(Lxyz/meowing/vexel/components/base/DimensionValue;Lxyz/meowing/vexel/components/base/DimensionValue;)Lxyz/meowing/vexel/components/base/DimensionValue$Minus;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "getLeft", "getRight", "Vexel"})
    public static final class Minus
    extends DimensionValue {
        @NotNull
        private final DimensionValue left;
        @NotNull
        private final DimensionValue right;

        public Minus(@NotNull DimensionValue left2, @NotNull DimensionValue right) {
            Intrinsics.checkNotNullParameter(left2, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            super(null);
            this.left = left2;
            this.right = right;
        }

        @NotNull
        public final DimensionValue getLeft() {
            return this.left;
        }

        @NotNull
        public final DimensionValue getRight() {
            return this.right;
        }

        @Override
        public float resolve(@NotNull VexelElement<?> element, boolean isWidth) {
            Intrinsics.checkNotNullParameter(element, "element");
            return this.left.resolve(element, isWidth) - this.right.resolve(element, isWidth);
        }

        @NotNull
        public final DimensionValue component1() {
            return this.left;
        }

        @NotNull
        public final DimensionValue component2() {
            return this.right;
        }

        @NotNull
        public final Minus copy(@NotNull DimensionValue left2, @NotNull DimensionValue right) {
            Intrinsics.checkNotNullParameter(left2, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            return new Minus(left2, right);
        }

        public static /* synthetic */ Minus copy$default(Minus minus2, DimensionValue dimensionValue, DimensionValue dimensionValue2, int n, Object object) {
            if ((n & 1) != 0) {
                dimensionValue = minus2.left;
            }
            if ((n & 2) != 0) {
                dimensionValue2 = minus2.right;
            }
            return minus2.copy(dimensionValue, dimensionValue2);
        }

        @NotNull
        public String toString() {
            return "Minus(left=" + this.left + ", right=" + this.right + ')';
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Minus)) {
                return false;
            }
            Minus minus2 = (Minus)other;
            if (!Intrinsics.areEqual(this.left, minus2.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, minus2.right);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\n\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\r\u00a8\u0006\u001c"}, d2={"Lxyz/meowing/vexel/components/base/DimensionValue$Percent;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "", "value", "<init>", "(F)V", "Lxyz/meowing/vexel/components/base/VexelElement;", "element", "", "isWidth", "resolve", "(Lxyz/meowing/vexel/components/base/VexelElement;Z)F", "component1", "()F", "copy", "(F)Lxyz/meowing/vexel/components/base/DimensionValue$Percent;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getValue", "Vexel"})
    public static final class Percent
    extends DimensionValue {
        private final float value;

        public Percent(float value) {
            super(null);
            this.value = value;
        }

        public final float getValue() {
            return this.value;
        }

        @Override
        public float resolve(@NotNull VexelElement<?> element, boolean isWidth) {
            float f;
            Intrinsics.checkNotNullParameter(element, "element");
            VexelElement<?> parentElement = element.findFirstVisibleParent();
            if (parentElement != null) {
                float[] padding;
                float[] fArray;
                VexelElement<?> vexelElement = parentElement;
                if (vexelElement instanceof Rectangle) {
                    fArray = ((Rectangle)parentElement).getPadding();
                } else if (vexelElement instanceof Container) {
                    fArray = ((Container)parentElement).getPadding();
                } else {
                    float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    fArray = padding = fArray2;
                }
                if (isWidth) {
                    float availableWidth = parentElement.getWidth() - (padding[1] + padding[3]);
                    f = availableWidth * (this.value / 100.0f);
                } else {
                    float availableHeight = parentElement.getHeight() - (padding[0] + padding[2]);
                    f = availableHeight * (this.value / 100.0f);
                }
            } else {
                f = isWidth ? (float)element.getScreenWidth() * (this.value / 100.0f) : (float)element.getScreenHeight() * (this.value / 100.0f);
            }
            return f;
        }

        public final float component1() {
            return this.value;
        }

        @NotNull
        public final Percent copy(float value) {
            return new Percent(value);
        }

        public static /* synthetic */ Percent copy$default(Percent percent2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = percent2.value;
            }
            return percent2.copy(f);
        }

        @NotNull
        public String toString() {
            return "Percent(value=" + this.value + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Percent)) {
                return false;
            }
            Percent percent2 = (Percent)other;
            return Float.compare(this.value, percent2.value) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\n\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\r\u00a8\u0006\u001c"}, d2={"Lxyz/meowing/vexel/components/base/DimensionValue$Pixels;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "", "value", "<init>", "(F)V", "Lxyz/meowing/vexel/components/base/VexelElement;", "element", "", "isWidth", "resolve", "(Lxyz/meowing/vexel/components/base/VexelElement;Z)F", "component1", "()F", "copy", "(F)Lxyz/meowing/vexel/components/base/DimensionValue$Pixels;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getValue", "Vexel"})
    public static final class Pixels
    extends DimensionValue {
        private final float value;

        public Pixels(float value) {
            super(null);
            this.value = value;
        }

        public final float getValue() {
            return this.value;
        }

        @Override
        public float resolve(@NotNull VexelElement<?> element, boolean isWidth) {
            Intrinsics.checkNotNullParameter(element, "element");
            return this.value;
        }

        public final float component1() {
            return this.value;
        }

        @NotNull
        public final Pixels copy(float value) {
            return new Pixels(value);
        }

        public static /* synthetic */ Pixels copy$default(Pixels pixels2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = pixels2.value;
            }
            return pixels2.copy(f);
        }

        @NotNull
        public String toString() {
            return "Pixels(value=" + this.value + ')';
        }

        public int hashCode() {
            return Float.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pixels)) {
                return false;
            }
            Pixels pixels2 = (Pixels)other;
            return Float.compare(this.value, pixels2.value) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u00020\n2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lxyz/meowing/vexel/components/base/DimensionValue$Plus;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "left", "right", "<init>", "(Lxyz/meowing/vexel/components/base/DimensionValue;Lxyz/meowing/vexel/components/base/DimensionValue;)V", "Lxyz/meowing/vexel/components/base/VexelElement;", "element", "", "isWidth", "", "resolve", "(Lxyz/meowing/vexel/components/base/VexelElement;Z)F", "component1", "()Lxyz/meowing/vexel/components/base/DimensionValue;", "component2", "copy", "(Lxyz/meowing/vexel/components/base/DimensionValue;Lxyz/meowing/vexel/components/base/DimensionValue;)Lxyz/meowing/vexel/components/base/DimensionValue$Plus;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lxyz/meowing/vexel/components/base/DimensionValue;", "getLeft", "getRight", "Vexel"})
    public static final class Plus
    extends DimensionValue {
        @NotNull
        private final DimensionValue left;
        @NotNull
        private final DimensionValue right;

        public Plus(@NotNull DimensionValue left2, @NotNull DimensionValue right) {
            Intrinsics.checkNotNullParameter(left2, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            super(null);
            this.left = left2;
            this.right = right;
        }

        @NotNull
        public final DimensionValue getLeft() {
            return this.left;
        }

        @NotNull
        public final DimensionValue getRight() {
            return this.right;
        }

        @Override
        public float resolve(@NotNull VexelElement<?> element, boolean isWidth) {
            Intrinsics.checkNotNullParameter(element, "element");
            return this.left.resolve(element, isWidth) + this.right.resolve(element, isWidth);
        }

        @NotNull
        public final DimensionValue component1() {
            return this.left;
        }

        @NotNull
        public final DimensionValue component2() {
            return this.right;
        }

        @NotNull
        public final Plus copy(@NotNull DimensionValue left2, @NotNull DimensionValue right) {
            Intrinsics.checkNotNullParameter(left2, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            return new Plus(left2, right);
        }

        public static /* synthetic */ Plus copy$default(Plus plus, DimensionValue dimensionValue, DimensionValue dimensionValue2, int n, Object object) {
            if ((n & 1) != 0) {
                dimensionValue = plus.left;
            }
            if ((n & 2) != 0) {
                dimensionValue2 = plus.right;
            }
            return plus.copy(dimensionValue, dimensionValue2);
        }

        @NotNull
        public String toString() {
            return "Plus(left=" + this.left + ", right=" + this.right + ')';
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plus)) {
                return false;
            }
            Plus plus = (Plus)other;
            if (!Intrinsics.areEqual(this.left, plus.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, plus.right);
        }
    }
}

