/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.components.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.core.VexelWindow;
import xyz.meowing.vexel.utils.render.NVGRendererKt;
import xyz.meowing.vexel.utils.render.api.RenderApi;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\bB\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0010J+\u0010\u0017\u001a\u00020\u000e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001c\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0014J'\u0010!\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b#\u0010\"J\r\u0010$\u001a\u00020\u000b\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b&\u0010\u0014J\r\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b)\u0010%J\u000f\u0010*\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b*\u0010%J\u001f\u0010+\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b+\u0010\u0010J\u000f\u0010,\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b,\u0010%J\u000f\u0010-\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b-\u0010%J\u0017\u0010\u0005\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010/J\u0017\u00101\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b1\u0010/J\u0017\u00103\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u00109\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b9\u00104J\u0017\u0010:\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b:\u00104J7\u0010\u0003\u001a\u00020\u00002\b\b\u0002\u0010;\u001a\u00020\u000b2\b\b\u0002\u0010<\u001a\u00020\u000b2\b\b\u0002\u0010=\u001a\u00020\u000b2\b\b\u0002\u0010>\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0003\u0010?J\u0017\u0010\u0003\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0003\u00104J\u0017\u00102\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b2\u00104J\u0017\u0010C\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bC\u00104R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010I\u001a\u0004\bJ\u0010(\"\u0004\bK\u0010LR\"\u0010M\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010%\"\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010IR\u0016\u0010S\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010NR\"\u00101\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010I\u001a\u0004\bT\u0010(\"\u0004\bU\u0010LR\"\u00103\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010N\u001a\u0004\bV\u0010%\"\u0004\bW\u0010QR\"\u00106\u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\"\u00109\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010N\u001a\u0004\b]\u0010%\"\u0004\b^\u0010QR\"\u0010:\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010N\u001a\u0004\b_\u0010%\"\u0004\b`\u0010Q\u00a8\u0006a"}, d2={"Lxyz/meowing/vexel/components/core/Container;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "padding", "", "scrollable", "Lxyz/meowing/vexel/components/base/Size;", "widthType", "heightType", "<init>", "([FZLxyz/meowing/vexel/components/base/Size;Lxyz/meowing/vexel/components/base/Size;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "drawScrollbar", "()V", "isPointInScrollbar", "(FF)Z", "updateHoverStates", "element", "unhoverRecursive", "(Lxyz/meowing/vexel/components/base/VexelElement;FF)V", "", "horizontal", "vertical", "handleMouseScroll", "(FFDD)Z", "handleMouseMove", "", "button", "handleMouseClick", "(FFI)Z", "handleMouseRelease", "getContentHeight", "()F", "isMouseOnVisible", "isVisibleInScrollableParents", "()Z", "getAutoWidth", "getAutoHeight", "renderChildren", "getScreenX", "getScreenY", "enabled", "(Z)Lxyz/meowing/vexel/components/core/Container;", "show", "showScrollbar", "width", "scrollbarWidth", "(F)Lxyz/meowing/vexel/components/core/Container;", "color", "scrollbarColor", "(I)Lxyz/meowing/vexel/components/core/Container;", "radius", "scrollbarRadius", "scrollbarPadding", "top", "right", "bottom", "left", "(FFFF)Lxyz/meowing/vexel/components/core/Container;", "all", "newWidth", "newHeight", "height", "[F", "getPadding", "()[F", "setPadding", "([F)V", "Z", "getScrollable", "setScrollable", "(Z)V", "scrollOffset", "F", "getScrollOffset", "setScrollOffset", "(F)V", "isDraggingScrollbar", "scrollbarDragOffset", "getShowScrollbar", "setShowScrollbar", "getScrollbarWidth", "setScrollbarWidth", "I", "getScrollbarColor", "()I", "setScrollbarColor", "(I)V", "getScrollbarRadius", "setScrollbarRadius", "getScrollbarPadding", "setScrollbarPadding", "Vexel"})
@SourceDebugExtension(value={"SMAP\nContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Container.kt\nxyz/meowing/vexel/components/core/Container\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1869#2,2:320\n1869#2,2:322\n1869#2,2:324\n1869#2,2:326\n1869#2,2:328\n1869#2,2:330\n1761#2,3:332\n1869#2:335\n1869#2,2:336\n1870#2:338\n1761#2,3:339\n1761#2,3:342\n1761#2,3:345\n1761#2,3:348\n774#2:351\n865#2,2:352\n1999#2,14:354\n774#2:368\n865#2,2:369\n774#2:372\n865#2,2:373\n1869#2,2:375\n1#3:371\n*S KotlinDebug\n*F\n+ 1 Container.kt\nxyz/meowing/vexel/components/core/Container\n*L\n58#1:320,2\n59#1:322,2\n62#1:324,2\n64#1:326,2\n76#1:328,2\n79#1:330,2\n87#1:332,3\n121#1:335\n125#1:336,2\n121#1:338\n150#1:339,3\n157#1:342,3\n178#1:345,3\n182#1:348,3\n186#1:351\n186#1:352,2\n188#1:354,14\n227#1:368\n227#1:369,2\n235#1:372\n235#1:373,2\n259#1:375,2\n*E\n"})
public class Container
extends VexelElement<Container> {
    @NotNull
    private float[] padding;
    private boolean scrollable;
    private float scrollOffset;
    private boolean isDraggingScrollbar;
    private float scrollbarDragOffset;
    private boolean showScrollbar;
    private float scrollbarWidth;
    private int scrollbarColor;
    private float scrollbarRadius;
    private float scrollbarPadding;

    public Container(@NotNull float[] padding, boolean scrollable, @NotNull Size widthType, @NotNull Size heightType) {
        Intrinsics.checkNotNullParameter(padding, "padding");
        Intrinsics.checkNotNullParameter((Object)widthType, "widthType");
        Intrinsics.checkNotNullParameter((Object)heightType, "heightType");
        super(widthType, heightType);
        this.padding = padding;
        this.scrollable = scrollable;
        this.showScrollbar = true;
        this.scrollbarWidth = 6.0f;
        this.scrollbarColor = -8618883;
        this.scrollbarRadius = 3.0f;
    }

    public /* synthetic */ Container(float[] fArray, boolean bl, Size size, Size size2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            fArray = fArray2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            size = Size.Auto;
        }
        if ((n & 8) != 0) {
            size2 = Size.Auto;
        }
        this(fArray, bl, size, size2);
    }

    @NotNull
    public final float[] getPadding() {
        return this.padding;
    }

    public final void setPadding(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<set-?>");
        this.padding = fArray;
    }

    public final boolean getScrollable() {
        return this.scrollable;
    }

    public final void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public final float getScrollOffset() {
        return this.scrollOffset;
    }

    public final void setScrollOffset(float f) {
        this.scrollOffset = f;
    }

    public final boolean getShowScrollbar() {
        return this.showScrollbar;
    }

    public final void setShowScrollbar(boolean bl) {
        this.showScrollbar = bl;
    }

    public final float getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public final void setScrollbarWidth(float f) {
        this.scrollbarWidth = f;
    }

    public final int getScrollbarColor() {
        return this.scrollbarColor;
    }

    public final void setScrollbarColor(int n) {
        this.scrollbarColor = n;
    }

    public final float getScrollbarRadius() {
        return this.scrollbarRadius;
    }

    public final void setScrollbarRadius(float f) {
        this.scrollbarRadius = f;
    }

    public final float getScrollbarPadding() {
        return this.scrollbarPadding;
    }

    public final void setScrollbarPadding(float f) {
        this.scrollbarPadding = f;
    }

    @Override
    protected void onRender(float mouseX, float mouseY) {
    }

    private final void drawScrollbar() {
        float viewHeight;
        if (!this.scrollable || !this.showScrollbar) {
            return;
        }
        float contentHeight = this.getContentHeight();
        if (contentHeight <= (viewHeight = this.getHeight() - this.padding[0] - this.padding[2])) {
            return;
        }
        float scrollbarX = this.getX() + this.getWidth() - this.padding[1] - this.scrollbarWidth - this.scrollbarPadding;
        float scrollbarHeight = viewHeight / contentHeight * viewHeight;
        float scrollbarY = this.getY() + this.padding[0] + this.scrollOffset / contentHeight * viewHeight;
        RenderApi.DefaultImpls.rect$default(NVGRendererKt.getNVGRenderer(), scrollbarX, scrollbarY, this.scrollbarWidth, scrollbarHeight, this.scrollbarColor, this.scrollbarRadius, 0.0f, 0.0f, 0.0f, 448, null);
    }

    private final boolean isPointInScrollbar(float mouseX, float mouseY) {
        float viewHeight;
        if (!this.scrollable || !this.showScrollbar) {
            return false;
        }
        float contentHeight = this.getContentHeight();
        if (contentHeight <= (viewHeight = this.getHeight() - this.padding[0] - this.padding[2])) {
            return false;
        }
        float scrollbarWidth = 6.0f;
        float scrollbarX = this.getX() + this.getWidth() - this.padding[1] - scrollbarWidth - this.scrollbarPadding;
        float scrollbarHeight = viewHeight / contentHeight * viewHeight;
        float scrollbarY = this.getY() + this.padding[0] + this.scrollOffset / contentHeight * viewHeight;
        return mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= scrollbarY && mouseY <= scrollbarY + scrollbarHeight;
    }

    private final void updateHoverStates(float mouseX, float mouseY) {
        Function2 it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        float adjustedMouseY = this.scrollable ? mouseY + this.scrollOffset : mouseY;
        boolean wasHovered = this.isHovered();
        this.setHovered(this.isPointInside(mouseX, mouseY));
        if (this.isHovered() && !wasHovered) {
            $this$forEach$iv = this.getMouseEnterListeners();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY));
            }
        } else if (!this.isHovered() && wasHovered) {
            $this$forEach$iv = this.getMouseExitListeners();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY));
            }
        }
        if (this.isHovered()) {
            $this$forEach$iv = this.getMouseMoveListeners();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY));
            }
        }
        $this$forEach$iv = CollectionsKt.reversed((Iterable)this.getChildren());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VexelElement child = (VexelElement)element$iv;
            boolean bl = false;
            if (this.scrollable && !this.isMouseOnVisible(mouseX, mouseY)) {
                this.unhoverRecursive(child, mouseX, adjustedMouseY);
                continue;
            }
            child.handleMouseMove(mouseX, adjustedMouseY);
        }
    }

    private final void unhoverRecursive(VexelElement<?> element, float mouseX, float mouseY) {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        if (element.isHovered()) {
            element.setHovered(false);
            $this$forEach$iv = element.getMouseExitListeners();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY));
            }
        }
        $this$forEach$iv = element.getChildren();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VexelElement)element$iv;
            boolean bl = false;
            this.unhoverRecursive((VexelElement<?>)it, mouseX, mouseY);
        }
    }

    @Override
    public boolean handleMouseScroll(float mouseX, float mouseY, double horizontal, double vertical) {
        float viewHeight;
        float contentHeight;
        boolean childHandled;
        block6: {
            boolean bl;
            if (!this.getVisible()) {
                return false;
            }
            if (!this.isMouseOnVisible(mouseX, mouseY)) {
                return false;
            }
            float adjustedMouseY = this.scrollable ? mouseY + this.scrollOffset : mouseY;
            Iterable $this$any$iv = CollectionsKt.reversed((Iterable)this.getChildren());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VexelElement it = (VexelElement)element$iv;
                    boolean bl2 = false;
                    if (!it.handleMouseScroll(mouseX, adjustedMouseY, horizontal, vertical)) continue;
                    bl = true;
                    break block6;
                }
                bl = childHandled = false;
            }
        }
        if (!childHandled && this.scrollable && this.isPointInside(mouseX, mouseY) && (contentHeight = this.getContentHeight()) > (viewHeight = this.getHeight() - this.padding[0] - this.padding[2])) {
            float scrollAmount = (float)vertical * -30.0f;
            float maxScroll = contentHeight - viewHeight;
            this.scrollOffset = RangesKt.coerceIn(this.scrollOffset + scrollAmount, 0.0f, maxScroll);
            this.updateHoverStates(mouseX, mouseY);
            return true;
        }
        return childHandled;
    }

    @Override
    public boolean handleMouseMove(float mouseX, float mouseY) {
        if (!this.getVisible()) {
            return false;
        }
        if (this.isDraggingScrollbar) {
            float contentHeight = this.getContentHeight();
            float viewHeight = this.getHeight() - this.padding[0] - this.padding[2];
            float relativeY = mouseY - this.scrollbarDragOffset - (this.getY() + this.padding[0]);
            float scrollRatio = RangesKt.coerceIn(relativeY / viewHeight, 0.0f, 1.0f);
            float maxScroll = contentHeight - viewHeight;
            this.scrollOffset = RangesKt.coerceIn(scrollRatio * maxScroll, 0.0f, maxScroll);
            this.updateHoverStates(mouseX, mouseY);
            return true;
        }
        this.updateHoverStates(mouseX, mouseY);
        float adjustedMouseY = this.scrollable ? mouseY + this.scrollOffset : mouseY;
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.getChildren());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VexelElement child = (VexelElement)element$iv;
            boolean bl = false;
            if (this.scrollable && !this.isMouseOnVisible(mouseX, mouseY)) {
                if (!child.isHovered()) continue;
                child.setHovered(false);
                Iterable $this$forEach$iv2 = child.getMouseExitListeners();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Function2 it = (Function2)element$iv2;
                    boolean bl2 = false;
                    it.invoke(Float.valueOf(mouseX), Float.valueOf(adjustedMouseY));
                }
                continue;
            }
            child.handleMouseMove(mouseX, adjustedMouseY);
        }
        return this.isHovered();
    }

    @Override
    public boolean handleMouseClick(float mouseX, float mouseY, int button2) {
        boolean bl;
        Object it;
        boolean bl2;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block13: {
            if (!this.getVisible()) {
                return false;
            }
            if (this.isPointInScrollbar(mouseX, mouseY)) {
                this.isDraggingScrollbar = true;
                float contentHeight = this.getContentHeight();
                float viewHeight = this.getHeight() - this.padding[0] - this.padding[2];
                float scrollbarY = this.getY() + this.padding[0] + this.scrollOffset / contentHeight * viewHeight;
                this.scrollbarDragOffset = mouseY - scrollbarY;
                return true;
            }
            if (this.scrollable && !this.isMouseOnVisible(mouseX, mouseY)) {
                return false;
            }
            float adjustedMouseY = this.scrollable ? mouseY + this.scrollOffset : mouseY;
            $this$any$iv = CollectionsKt.reversed((Iterable)this.getChildren());
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (VexelElement)element$iv;
                    boolean bl3 = false;
                    if (!((VexelElement)it).handleMouseClick(mouseX, adjustedMouseY, button2)) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
        }
        boolean childHandled = bl2;
        if (childHandled) {
            bl = true;
        } else if (this.isPointInside(mouseX, mouseY)) {
            boolean bl4;
            block14: {
                this.setPressed(true);
                this.focus();
                $this$any$iv = this.getMouseClickListeners();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Function3)element$iv;
                        boolean bl5 = false;
                        if (!((Boolean)it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY), button2)).booleanValue()) continue;
                        bl4 = true;
                        break block14;
                    }
                    bl4 = false;
                }
            }
            bl = bl4 || this.getMouseClickListeners().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleMouseRelease(float mouseX, float mouseY, int button2) {
        boolean bl;
        Object it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        boolean bl2;
        if (!this.getVisible()) {
            return false;
        }
        if (this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        float adjustedMouseY = this.scrollable ? mouseY + this.scrollOffset : mouseY;
        boolean wasPressed = this.isPressed();
        this.setPressed(false);
        if (this.scrollable && !this.isMouseOnVisible(mouseX, mouseY)) {
            bl2 = false;
        } else {
            $this$any$iv = CollectionsKt.reversed((Iterable)this.getChildren());
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (VexelElement)element$iv;
                    boolean bl3 = false;
                    if (!((VexelElement)it).handleMouseRelease(mouseX, adjustedMouseY, button2)) continue;
                    return true;
                }
                bl2 = false;
            }
        }
        boolean childHandled = bl2;
        if (childHandled) return true;
        if (!wasPressed) return false;
        if (!this.isPointInside(mouseX, mouseY)) return false;
        $this$any$iv = this.getMouseReleaseListeners();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (Function3)element$iv;
                boolean bl4 = false;
                if (!((Boolean)it.invoke(Float.valueOf(mouseX), Float.valueOf(mouseY), button2)).booleanValue()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!this.getMouseReleaseListeners().isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final float getContentHeight() {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VexelElement it = (VexelElement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isFloating())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleChildren = (List)destination$iv$iv;
        if (visibleChildren.isEmpty()) {
            return 0.0f;
        }
        Iterable $this$maxByOrNull$iv = visibleChildren;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                VexelElement it = (VexelElement)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getY() + it.getHeight();
                do {
                    Object e$iv = iterator$iv.next();
                    VexelElement it2 = (VexelElement)e$iv;
                    $i$a$-maxByOrNull-Container$getContentHeight$bottomChild$1 = false;
                    float v$iv = it2.getY() + it2.getHeight();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        VexelElement vexelElement = v0;
        if (vexelElement == null) {
            return 0.0f;
        }
        VexelElement bottomChild = vexelElement;
        return bottomChild.getY() + bottomChild.getHeight() - (this.getY() + this.padding[0]);
    }

    public final boolean isMouseOnVisible(float mouseX, float mouseY) {
        if (!this.scrollable) {
            return true;
        }
        float contentX = this.getX() + this.padding[3];
        float contentY = this.getY() + this.padding[0];
        float viewWidth = this.getWidth() - this.padding[1] - this.padding[3];
        float viewHeight = this.getHeight() - this.padding[0] - this.padding[2];
        return mouseX >= contentX && mouseX <= contentX + viewWidth && mouseY >= contentY && mouseY <= contentY + viewHeight;
    }

    public final boolean isVisibleInScrollableParents() {
        Object current = this;
        while (current != null) {
            Object object = current;
            if (object instanceof VexelElement) {
                if (!((VexelElement)current).getVisible()) {
                    return false;
                }
                float centerX = this.getScreenX() + this.getWidth() / (float)2;
                float centerY = this.getScreenY() + this.getHeight() / (float)2;
                VexelElement vexelElement = (VexelElement)current;
                if (vexelElement instanceof Container ? ((Container)current).scrollable && !((Container)current).isMouseOnVisible(centerX, centerY) : vexelElement instanceof Rectangle && ((Rectangle)current).getScrollable() && !((Rectangle)current).isMouseOnVisible(centerX, centerY)) {
                    return false;
                }
                current = ((VexelElement)current).getParent();
                continue;
            }
            if (!(object instanceof VexelWindow)) break;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getAutoWidth() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VexelElement it = (VexelElement)element$iv$iv;
            boolean bl = false;
            if (!(it.getVisible() && !it.isFloating())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleChildren = (List)destination$iv$iv;
        if (visibleChildren.isEmpty()) {
            return this.padding[1] + this.padding[3];
        }
        iterator2 = ((Iterable)visibleChildren).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        VexelElement it = (VexelElement)iterator2.next();
        boolean bl = false;
        float f = it.getX();
        while (iterator2.hasNext()) {
            VexelElement it22 = (VexelElement)iterator2.next();
            $i$a$-minOf-Container$getAutoWidth$minX$1 = false;
            float it22 = it22.getX();
            f = Math.min(f, it22);
        }
        float minX = f;
        Iterator iterator3 = ((Iterable)visibleChildren).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        VexelElement it2 = (VexelElement)iterator3.next();
        boolean bl2 = false;
        float f2 = it2.getX() + it2.getWidth();
        while (iterator3.hasNext()) {
            VexelElement it3 = (VexelElement)iterator3.next();
            $i$a$-maxOf-Container$getAutoWidth$maxX$1 = false;
            float f3 = it3.getX() + it3.getWidth();
            f2 = Math.max(f2, f3);
        }
        float maxX = f2;
        return maxX - minX + this.padding[3] + this.padding[1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getAutoHeight() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VexelElement it = (VexelElement)element$iv$iv;
            boolean bl = false;
            if (!(it.getVisible() && !it.isFloating())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleChildren = (List)destination$iv$iv;
        if (visibleChildren.isEmpty()) {
            return this.padding[0] + this.padding[2];
        }
        iterator2 = ((Iterable)visibleChildren).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        VexelElement it = (VexelElement)iterator2.next();
        boolean bl = false;
        float f = it.getY();
        while (iterator2.hasNext()) {
            VexelElement it22 = (VexelElement)iterator2.next();
            $i$a$-minOf-Container$getAutoHeight$minY$1 = false;
            float it22 = it22.getY();
            f = Math.min(f, it22);
        }
        float minY = f;
        Iterator iterator3 = ((Iterable)visibleChildren).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        VexelElement it2 = (VexelElement)iterator3.next();
        boolean bl2 = false;
        float f2 = it2.getY() + it2.getHeight();
        while (iterator3.hasNext()) {
            VexelElement it3 = (VexelElement)iterator3.next();
            $i$a$-maxOf-Container$getAutoHeight$maxY$1 = false;
            float f3 = it3.getY() + it3.getHeight();
            f2 = Math.max(f2, f3);
        }
        float maxY = f2;
        return maxY - minY + this.padding[0] + this.padding[2];
    }

    @Override
    protected void renderChildren(float mouseX, float mouseY) {
        if (this.scrollable) {
            float contentX = this.getX() + this.padding[3];
            float contentY = this.getY() + this.padding[0];
            float viewWidth = this.getWidth() - this.padding[1] - this.padding[3];
            float viewHeight = this.getHeight() - this.padding[0] - this.padding[2];
            NVGRendererKt.getNVGRenderer().push();
            NVGRendererKt.getNVGRenderer().pushScissor(contentX, contentY, viewWidth, viewHeight);
            NVGRendererKt.getNVGRenderer().translate(0.0f, -this.scrollOffset);
        }
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VexelElement it = (VexelElement)element$iv;
            boolean bl = false;
            it.render(mouseX, mouseY);
        }
        if (this.scrollable) {
            NVGRendererKt.getNVGRenderer().popScissor();
            NVGRendererKt.getNVGRenderer().pop();
        }
        if (this.showScrollbar && (this.isHovered() || this.isDraggingScrollbar)) {
            this.drawScrollbar();
        }
    }

    public float getScreenX() {
        return this.getX();
    }

    public float getScreenY() {
        float totalScrollOffset = 0.0f;
        Object current = this.getParent();
        while (current != null) {
            Object object = current;
            if (object instanceof Container) {
                totalScrollOffset += ((Container)current).scrollOffset;
            } else if (object instanceof Rectangle) {
                totalScrollOffset += ((Rectangle)current).getScrollOffset();
            } else if (object instanceof VexelWindow) break;
            current = current instanceof VexelElement ? ((VexelElement)current).getParent() : null;
        }
        return this.getY() - totalScrollOffset;
    }

    @NotNull
    public Container scrollable(boolean enabled) {
        Container container;
        Container $this$scrollable_u24lambda_u2422 = container = this;
        boolean bl = false;
        $this$scrollable_u24lambda_u2422.scrollable = enabled;
        return container;
    }

    @NotNull
    public Container showScrollbar(boolean show) {
        Container container;
        Container $this$showScrollbar_u24lambda_u2423 = container = this;
        boolean bl = false;
        $this$showScrollbar_u24lambda_u2423.showScrollbar = show;
        return container;
    }

    @NotNull
    public Container scrollbarWidth(float width) {
        Container container;
        Container $this$scrollbarWidth_u24lambda_u2424 = container = this;
        boolean bl = false;
        $this$scrollbarWidth_u24lambda_u2424.scrollbarWidth = width;
        return container;
    }

    @NotNull
    public Container scrollbarColor(int color) {
        Container container;
        Container $this$scrollbarColor_u24lambda_u2425 = container = this;
        boolean bl = false;
        $this$scrollbarColor_u24lambda_u2425.scrollbarColor = color;
        return container;
    }

    @NotNull
    public Container scrollbarRadius(float radius) {
        Container container;
        Container $this$scrollbarRadius_u24lambda_u2426 = container = this;
        boolean bl = false;
        $this$scrollbarRadius_u24lambda_u2426.scrollbarRadius = radius;
        return container;
    }

    @NotNull
    public Container scrollbarPadding(float padding) {
        Container container;
        Container $this$scrollbarPadding_u24lambda_u2427 = container = this;
        boolean bl = false;
        $this$scrollbarPadding_u24lambda_u2427.scrollbarPadding = padding;
        return container;
    }

    @NotNull
    public Container padding(float top, float right, float bottom, float left2) {
        Container container;
        Container $this$padding_u24lambda_u2428 = container = this;
        boolean bl = false;
        $this$padding_u24lambda_u2428.padding[0] = top;
        $this$padding_u24lambda_u2428.padding[1] = right;
        $this$padding_u24lambda_u2428.padding[2] = bottom;
        $this$padding_u24lambda_u2428.padding[3] = left2;
        return container;
    }

    public static /* synthetic */ Container padding$default(Container container, float f, float f2, float f3, float f4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: padding");
        }
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        return container.padding(f, f2, f3, f4);
    }

    @NotNull
    public Container padding(float all2) {
        return this.padding(all2, all2, all2, all2);
    }

    @NotNull
    public Container width(float newWidth) {
        Container container;
        Container $this$width_u24lambda_u2429 = container = this;
        boolean bl = false;
        $this$width_u24lambda_u2429.setWidth(newWidth);
        return container;
    }

    @NotNull
    public Container height(float newHeight) {
        Container container;
        Container $this$height_u24lambda_u2430 = container = this;
        boolean bl = false;
        $this$height_u24lambda_u2430.setHeight(newHeight);
        return container;
    }

    public Container() {
        this(null, false, null, null, 15, null);
    }
}

