/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.elements;

import java.awt.Color;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.input.KnitInputs;
import xyz.meowing.knit.api.input.KnitKeyboard;
import xyz.meowing.knit.api.input.KnitKeys;
import xyz.meowing.vexel.Vexel;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.vexel.utils.render.api.RenderApi;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\bE\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0097\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0019\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0005\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010)\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0007\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0007\u00a2\u0006\u0004\b/\u0010*J\u001d\u00102\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020 \u00a2\u0006\u0004\b2\u00103J\u001d\u00105\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u00072\u0006\u00101\u001a\u00020 \u00a2\u0006\u0004\b5\u00103J\u001d\u00106\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00072\u0006\u00101\u001a\u00020 \u00a2\u0006\u0004\b6\u00103J\u001d\u00108\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007\u00a2\u0006\u0004\b8\u00109J\r\u0010:\u001a\u00020\u0019\u00a2\u0006\u0004\b:\u0010$J\r\u0010;\u001a\u00020\u0019\u00a2\u0006\u0004\b;\u0010$J\r\u0010<\u001a\u00020\u0019\u00a2\u0006\u0004\b<\u0010$J\r\u0010=\u001a\u00020\u0002\u00a2\u0006\u0004\b=\u0010>J\r\u0010?\u001a\u00020\u0019\u00a2\u0006\u0004\b?\u0010$J\r\u0010@\u001a\u00020\u0019\u00a2\u0006\u0004\b@\u0010$J\r\u0010A\u001a\u00020\u0019\u00a2\u0006\u0004\bA\u0010$J\u000f\u0010B\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\bB\u0010$J\u000f\u0010C\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\bC\u0010DJ\u000f\u0010E\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\bE\u0010DJ-\u0010\u000f\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010JJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010LJ\u0015\u0010\u0006\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010LJ\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010OJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010OJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010LJ\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010LJ\u0015\u0010\u0010\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010OJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010OR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010R\u001a\u0004\bS\u0010>\"\u0004\bT\u0010-R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010U\u001a\u0004\bV\u0010D\"\u0004\bW\u0010XR\"\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010*R*\u0010^\u001a\u00020\u00022\u0006\u0010]\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010R\u001a\u0004\b_\u0010>\"\u0004\b`\u0010-R\"\u0010a\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\ba\u0010c\"\u0004\bd\u0010eR$\u0010g\u001a\u00020f2\u0006\u0010^\u001a\u00020f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bg\u0010h\u001a\u0004\bi\u0010jR\"\u0010k\u001a\u00020f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010h\u001a\u0004\bl\u0010j\"\u0004\bm\u0010nR\"\u0010o\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bo\u0010Y\u001a\u0004\bp\u0010[\"\u0004\bq\u0010*R\"\u0010r\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\br\u0010Y\u001a\u0004\bs\u0010[\"\u0004\bt\u0010*R\u0014\u0010v\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010[R\u0014\u0010x\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bw\u0010[R\u0014\u0010z\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010cR\"\u0010{\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b{\u0010U\u001a\u0004\b|\u0010D\"\u0004\b}\u0010XR\u0016\u0010~\u001a\u00020f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b~\u0010hR\u0016\u0010\u007f\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u007f\u0010YR\u0018\u0010\u0080\u0001\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0080\u0001\u0010bR\u001d\u0010\u0082\u0001\u001a\u00030\u0081\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0082\u0001\u0010\u0083\u0001\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001d\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001R\u001d\u0010\u008b\u0001\u001a\u00030\u0081\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u008b\u0001\u0010\u0083\u0001\u001a\u0006\b\u008c\u0001\u0010\u0085\u0001R\u001d\u0010\u008d\u0001\u001a\u00030\u0081\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u008d\u0001\u0010\u0083\u0001\u001a\u0006\b\u008e\u0001\u0010\u0085\u0001\u00a8\u0006\u008f\u0001"}, d2={"Lxyz/meowing/vexel/elements/TextInput;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "initialValue", "placeholder", "", "fontSize", "", "selectionColor", "textColor", "backgroundColor", "borderColor", "borderRadius", "borderThickness", "", "padding", "hoverColor", "pressedColor", "Lxyz/meowing/vexel/components/base/Size;", "widthType", "heightType", "<init>", "(Ljava/lang/String;Ljava/lang/String;FIIIIFF[FLjava/lang/Integer;Ljava/lang/Integer;Lxyz/meowing/vexel/components/base/Size;Lxyz/meowing/vexel/components/base/Size;)V", "mouseX", "mouseY", "", "onRender", "(FF)V", "keyCode", "scanCode", "", "char", "", "keyTyped", "(IIC)Z", "resetCaretBlink", "()V", "absClickX", "getCharIndexAtAbsX", "(F)I", "pos", "selectWordAt", "(I)V", "text", "insertText", "(Ljava/lang/String;)V", "direction", "deleteChar", "amount", "shiftHeld", "moveCaret", "(IZ)V", "position", "moveCaretTo", "moveWord", "startIndex", "findWordBoundary", "(II)I", "deletePrevWord", "deleteNextWord", "selectAll", "getSelectedText", "()Ljava/lang/String;", "copySelection", "cutSelection", "paste", "ensureCaretVisible", "getAutoWidth", "()F", "getAutoHeight", "top", "right", "bottom", "left", "(FFFF)Lxyz/meowing/vexel/elements/TextInput;", "all", "(F)Lxyz/meowing/vexel/elements/TextInput;", "size", "color", "(I)Lxyz/meowing/vexel/elements/TextInput;", "radius", "thickness", "Ljava/lang/String;", "getPlaceholder", "setPlaceholder", "F", "getFontSize", "setFontSize", "(F)V", "I", "getTextColor", "()I", "setTextColor", "newVal", "value", "getValue", "setValue", "isDragging", "Z", "()Z", "setDragging", "(Z)V", "", "lastBlink", "J", "getLastBlink", "()J", "caretBlinkRate", "getCaretBlinkRate", "setCaretBlinkRate", "(J)V", "cursorIndex", "getCursorIndex", "setCursorIndex", "selectionAnchor", "getSelectionAnchor", "setSelectionAnchor", "getSelectionStart", "selectionStart", "getSelectionEnd", "selectionEnd", "getHasSelection", "hasSelection", "scrollOffset", "getScrollOffset", "setScrollOffset", "lastClickTime", "clickCount", "caretVisible", "Lxyz/meowing/vexel/components/core/Rectangle;", "background", "Lxyz/meowing/vexel/components/core/Rectangle;", "getBackground", "()Lxyz/meowing/vexel/components/core/Rectangle;", "Lxyz/meowing/vexel/components/core/Text;", "innerText", "Lxyz/meowing/vexel/components/core/Text;", "getInnerText", "()Lxyz/meowing/vexel/components/core/Text;", "selectionRectangle", "getSelectionRectangle", "caret", "getCaret", "Vexel"})
public final class TextInput
extends VexelElement<TextInput> {
    @NotNull
    private String placeholder;
    private float fontSize;
    private int textColor;
    @NotNull
    private String value;
    private boolean isDragging;
    private long lastBlink;
    private long caretBlinkRate;
    private int cursorIndex;
    private int selectionAnchor;
    private float scrollOffset;
    private long lastClickTime;
    private int clickCount;
    private boolean caretVisible;
    @NotNull
    private final Rectangle background;
    @NotNull
    private final Text innerText;
    @NotNull
    private final Rectangle selectionRectangle;
    @NotNull
    private final Rectangle caret;

    public TextInput(@NotNull String initialValue, @NotNull String placeholder, float fontSize, int selectionColor, int textColor, int backgroundColor, int borderColor, float borderRadius, float borderThickness, @NotNull float[] padding, @Nullable Integer hoverColor, @Nullable Integer pressedColor, @NotNull Size widthType, @NotNull Size heightType) {
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(padding, "padding");
        Intrinsics.checkNotNullParameter((Object)widthType, "widthType");
        Intrinsics.checkNotNullParameter((Object)heightType, "heightType");
        super(widthType, heightType);
        this.placeholder = placeholder;
        this.fontSize = fontSize;
        this.textColor = textColor;
        this.value = initialValue;
        this.lastBlink = System.currentTimeMillis();
        this.caretBlinkRate = 500L;
        this.cursorIndex = this.value.length();
        this.selectionAnchor = this.value.length();
        this.caretVisible = true;
        this.background = (Rectangle)((Rectangle)((Rectangle)new Rectangle(backgroundColor, borderColor, borderRadius, borderThickness, padding, hoverColor, pressedColor, Size.ParentPerc, Size.ParentPerc, false, 512, null).setSizing(100.0f, Size.ParentPerc, 100.0f, Size.ParentPerc)).ignoreMouseEvents()).childOf(this);
        this.innerText = (Text)((Text)new Text(this.placeholder, this.textColor, this.fontSize, false, null, 24, null).setPositioning(Pos.ParentPixels, Pos.ParentCenter)).childOf(this.background);
        this.selectionRectangle = (Rectangle)((Rectangle)((Rectangle)((Rectangle)((Rectangle)new Rectangle(selectionColor, 0, 0.0f, 0.0f, null, null, null, null, null, false, 1008, null).setPositioning(Pos.ParentPixels, Pos.ParentCenter)).setSizing(Size.Pixels, Size.Pixels)).ignoreMouseEvents()).ignoreFocus()).childOf(this.background);
        this.caret = (Rectangle)((Rectangle)((Rectangle)((Rectangle)((Rectangle)new Rectangle(-1, -16777216, 1.0f, 0.0f, null, null, null, null, null, false, 1008, null).setPositioning(Pos.ParentPixels, Pos.ParentCenter)).setSizing(Size.Pixels, Size.Pixels)).ignoreMouseEvents()).ignoreFocus()).childOf(this.background);
        this.setPositioning(Pos.ParentPixels, Pos.ParentPixels);
        this.setRequiresFocus();
        this.onClick((arg_0, arg_1, arg_2) -> TextInput._init_$lambda$0(this, arg_0, arg_1, arg_2));
        this.onCharType((arg_0, arg_1, arg_2) -> TextInput._init_$lambda$1(this, arg_0, arg_1, arg_2));
    }

    public /* synthetic */ TextInput(String string, String string2, float f, int n, int n2, int n3, int n4, float f2, float f3, float[] fArray, Integer n5, Integer n6, Size size, Size size2, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 1) != 0) {
            string = "";
        }
        if ((n7 & 2) != 0) {
            string2 = "";
        }
        if ((n7 & 4) != 0) {
            f = 12.0f;
        }
        if ((n7 & 8) != 0) {
            n = -2136291329;
        }
        if ((n7 & 0x10) != 0) {
            n2 = -1;
        }
        if ((n7 & 0x20) != 0) {
            n3 = -2143272896;
        }
        if ((n7 & 0x40) != 0) {
            n4 = -10461088;
        }
        if ((n7 & 0x80) != 0) {
            f2 = 4.0f;
        }
        if ((n7 & 0x100) != 0) {
            f3 = 1.0f;
        }
        if ((n7 & 0x200) != 0) {
            float[] fArray2 = new float[]{6.0f, 6.0f, 6.0f, 6.0f};
            fArray = fArray2;
        }
        if ((n7 & 0x400) != 0) {
            n5 = -2142220208;
        }
        if ((n7 & 0x800) != 0) {
            n6 = -2142220208;
        }
        if ((n7 & 0x1000) != 0) {
            size = Size.Auto;
        }
        if ((n7 & 0x2000) != 0) {
            size2 = Size.Auto;
        }
        this(string, string2, f, n, n2, n3, n4, f2, f3, fArray, n5, n6, size, size2);
    }

    @NotNull
    public final String getPlaceholder() {
        return this.placeholder;
    }

    public final void setPlaceholder(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.placeholder = string;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final void setFontSize(float f) {
        this.fontSize = f;
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int n) {
        this.textColor = n;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String newVal) {
        block1: {
            Intrinsics.checkNotNullParameter(newVal, "newVal");
            if (Intrinsics.areEqual(this.value, newVal)) {
                return;
            }
            this.value = newVal;
            this.cursorIndex = RangesKt.coerceIn(this.cursorIndex, 0, this.value.length());
            this.selectionAnchor = RangesKt.coerceIn(this.selectionAnchor, 0, this.value.length());
            Function1<Object, Unit> function1 = this.getOnValueChange();
            if (function1 == null) break block1;
            function1.invoke(this.value);
        }
    }

    public final boolean isDragging() {
        return this.isDragging;
    }

    public final void setDragging(boolean bl) {
        this.isDragging = bl;
    }

    public final long getLastBlink() {
        return this.lastBlink;
    }

    public final long getCaretBlinkRate() {
        return this.caretBlinkRate;
    }

    public final void setCaretBlinkRate(long l) {
        this.caretBlinkRate = l;
    }

    public final int getCursorIndex() {
        return this.cursorIndex;
    }

    public final void setCursorIndex(int n) {
        this.cursorIndex = n;
    }

    public final int getSelectionAnchor() {
        return this.selectionAnchor;
    }

    public final void setSelectionAnchor(int n) {
        this.selectionAnchor = n;
    }

    private final int getSelectionStart() {
        return Math.min(this.cursorIndex, this.selectionAnchor);
    }

    private final int getSelectionEnd() {
        return Math.max(this.cursorIndex, this.selectionAnchor);
    }

    private final boolean getHasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public final float getScrollOffset() {
        return this.scrollOffset;
    }

    public final void setScrollOffset(float f) {
        this.scrollOffset = f;
    }

    @NotNull
    public final Rectangle getBackground() {
        return this.background;
    }

    @NotNull
    public final Text getInnerText() {
        return this.innerText;
    }

    @NotNull
    public final Rectangle getSelectionRectangle() {
        return this.selectionRectangle;
    }

    @NotNull
    public final Rectangle getCaret() {
        return this.caret;
    }

    @Override
    protected void onRender(float mouseX, float mouseY) {
        this.background.setHovered(this.getHovered());
        this.background.setPressed(this.getPressed());
        boolean shouldShowPlaceholder = ((CharSequence)this.value).length() == 0 && !this.getFocused();
        int textColor = shouldShowPlaceholder ? new Color(120, 120, 120).getRGB() : this.textColor;
        this.innerText.setText(shouldShowPlaceholder ? this.placeholder : this.value);
        this.innerText.setTextColor(textColor);
        if (this.getHasSelection() && !shouldShowPlaceholder) {
            String string = this.value.substring(0, this.getSelectionStart());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String selStartStr = string;
            String string2 = this.value.substring(0, this.getSelectionEnd());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String selEndStr = string2;
            float x1 = this.scrollOffset + Vexel.INSTANCE.getRenderEngine().textWidth(selStartStr, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont());
            float x2 = this.scrollOffset + Vexel.INSTANCE.getRenderEngine().textWidth(selEndStr, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont());
            this.selectionRectangle.setPositioning(x1, Pos.ParentPixels, 0.0f, Pos.ParentCenter);
            this.selectionRectangle.setSizing(x2 - x1, Size.Pixels, this.fontSize, Size.Pixels);
            this.selectionRectangle.setVisible(true);
        } else {
            this.selectionRectangle.setVisible(false);
        }
        this.caret.setHeight(this.fontSize);
        this.caret.setWidth(1.0f);
        RenderApi renderApi = Vexel.INSTANCE.getRenderEngine();
        String string = this.value.substring(0, RangesKt.coerceIn(this.cursorIndex, 0, this.value.length()));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        float x = renderApi.textWidth(string, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont()) - this.scrollOffset;
        this.caret.setPositioning(x, Pos.ParentPixels, 0.0f, Pos.ParentCenter);
        this.caret.setVisible(this.getFocused() && this.caretVisible && !shouldShowPlaceholder);
        if (System.currentTimeMillis() - this.lastBlink > this.caretBlinkRate) {
            this.caretVisible = !this.caretVisible;
            this.lastBlink = System.currentTimeMillis();
        }
    }

    public final boolean keyTyped(int keyCode, int scanCode, char c) {
        block33: {
            String keyName;
            if (!this.isFocused()) {
                return false;
            }
            boolean ctrlDown = KnitKeyboard.isCtrlKeyPressed();
            boolean shiftDown = KnitKeyboard.isShiftKeyPressed();
            int n = keyCode;
            if (n == KnitKeys.INSTANCE.getKEY_ESCAPE().getCode() || n == KnitKeys.INSTANCE.getKEY_ENTER().getCode()) {
                this.setFocused(false);
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_BACKSPACE().getCode()) {
                if (ctrlDown) {
                    this.deletePrevWord();
                } else {
                    this.deleteChar(-1);
                }
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_DELETE().getCode()) {
                if (ctrlDown) {
                    this.deleteNextWord();
                } else {
                    this.deleteChar(1);
                }
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_LEFT().getCode()) {
                if (ctrlDown) {
                    this.moveWord(-1, shiftDown);
                } else {
                    this.moveCaret(-1, shiftDown);
                }
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_RIGHT().getCode()) {
                if (ctrlDown) {
                    this.moveWord(1, shiftDown);
                } else {
                    this.moveCaret(1, shiftDown);
                }
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_HOME().getCode()) {
                this.moveCaretTo(0, shiftDown);
                return true;
            }
            if (n == KnitKeys.INSTANCE.getKEY_END().getCode()) {
                this.moveCaretTo(this.value.length(), shiftDown);
                return true;
            }
            if (!ctrlDown) break block33;
            String string = StringsKt.substringAfterLast$default(KnitInputs.getDisplayName(keyCode, scanCode), ".", null, 2, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            switch (keyName = string) {
                case "a": {
                    this.selectAll();
                    return true;
                }
                case "c": {
                    this.copySelection();
                    return true;
                }
                case "v": {
                    this.paste();
                    return true;
                }
                case "x": {
                    this.cutSelection();
                    return true;
                }
            }
            return false;
        }
        if (c >= ' ' && c != '\u007f') {
            this.insertText(String.valueOf(c));
            return true;
        }
        return false;
    }

    public final void resetCaretBlink() {
        this.lastBlink = System.currentTimeMillis();
        this.caretVisible = true;
    }

    public final int getCharIndexAtAbsX(float absClickX) {
        if (absClickX <= 0.0f) {
            return 0;
        }
        float currentWidth = 0.0f;
        int n = ((CharSequence)this.value).length();
        for (int i2 = 0; i2 < n; ++i2) {
            float charWidth = Vexel.INSTANCE.getRenderEngine().textWidth(String.valueOf(this.value.charAt(i2)), this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont());
            if (absClickX < currentWidth + charWidth / (float)2) {
                return i2;
            }
            currentWidth += charWidth;
        }
        return this.value.length();
    }

    public final void selectWordAt(int pos) {
        if (((CharSequence)this.value).length() == 0) {
            return;
        }
        int currentPos = RangesKt.coerceIn(pos, 0, this.value.length());
        if (currentPos < this.value.length() && !CharsKt.isWhitespace(this.value.charAt(currentPos))) {
            int end;
            int start;
            for (start = currentPos; start > 0 && !CharsKt.isWhitespace(this.value.charAt(start - 1)); --start) {
            }
            for (end = currentPos; end < this.value.length() && !CharsKt.isWhitespace(this.value.charAt(end)); ++end) {
            }
            this.cursorIndex = end;
            this.selectionAnchor = start;
        } else {
            this.cursorIndex = currentPos;
            this.selectionAnchor = currentPos;
        }
        this.ensureCaretVisible();
    }

    public final void insertText(@NotNull String text) {
        int n;
        Intrinsics.checkNotNullParameter(text, "text");
        StringBuilder builder = new StringBuilder(this.value);
        if (!this.getHasSelection()) {
            n = this.cursorIndex;
        } else {
            int currentSelectionStart = this.getSelectionStart();
            builder.delete(currentSelectionStart, this.getSelectionEnd());
            n = currentSelectionStart;
        }
        int newCursorPos = n;
        builder.insert(newCursorPos, text);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.setValue(string);
        this.selectionAnchor = this.cursorIndex = RangesKt.coerceIn(newCursorPos + text.length(), 0, this.value.length());
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    public final void deleteChar(int direction) {
        StringBuilder builder;
        boolean textChanged = false;
        String newText = this.value;
        int newCursor = this.cursorIndex;
        if (this.getHasSelection()) {
            builder = new StringBuilder(this.value);
            int selStart = this.getSelectionStart();
            builder.delete(selStart, this.getSelectionEnd());
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            newCursor = selStart;
            textChanged = true;
        } else if (direction == -1 && this.cursorIndex > 0) {
            builder = new StringBuilder(this.value);
            builder.deleteCharAt(this.cursorIndex - 1);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            newCursor = this.cursorIndex - 1;
            textChanged = true;
        } else if (direction == 1 && this.cursorIndex < this.value.length()) {
            builder = new StringBuilder(this.value);
            builder.deleteCharAt(this.cursorIndex);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            newText = string;
            textChanged = true;
        }
        if (textChanged) {
            this.setValue(newText);
            this.selectionAnchor = this.cursorIndex = RangesKt.coerceIn(newCursor, 0, this.value.length());
            float maxScroll = Math.max(0.0f, (float)((int)Vexel.INSTANCE.getRenderEngine().textWidth(this.value, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont())) - this.getWidth() * (float)2);
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
            this.ensureCaretVisible();
        }
        this.resetCaretBlink();
    }

    public final void moveCaret(int amount, boolean shiftHeld) {
        this.cursorIndex = RangesKt.coerceIn(this.cursorIndex + amount, 0, this.value.length());
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    public final void moveCaretTo(int position, boolean shiftHeld) {
        this.cursorIndex = RangesKt.coerceIn(position, 0, this.value.length());
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    public final void moveWord(int direction, boolean shiftHeld) {
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, direction);
        if (!shiftHeld) {
            this.selectionAnchor = this.cursorIndex;
        }
        this.ensureCaretVisible();
        this.resetCaretBlink();
    }

    public final int findWordBoundary(int startIndex, int direction) {
        int i2;
        int len = this.value.length();
        if (direction < 0) {
            if (i2 > 0) {
                --i2;
            }
            while (i2 > 0 && CharsKt.isWhitespace(this.value.charAt(i2))) {
                --i2;
            }
            while (i2 > 0 && !CharsKt.isWhitespace(this.value.charAt(i2 - 1))) {
                --i2;
            }
        } else {
            for (i2 = startIndex; i2 < len && !CharsKt.isWhitespace(this.value.charAt(i2)); ++i2) {
            }
            while (i2 < len && CharsKt.isWhitespace(this.value.charAt(i2))) {
                ++i2;
            }
        }
        return RangesKt.coerceIn(i2, 0, len);
    }

    public final void deletePrevWord() {
        if (this.getHasSelection()) {
            this.deleteChar(0);
            return;
        }
        if (this.cursorIndex == 0) {
            return;
        }
        int oldCursor = this.cursorIndex;
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, -1);
        this.selectionAnchor = oldCursor;
        this.deleteChar(0);
    }

    public final void deleteNextWord() {
        if (this.getHasSelection()) {
            this.deleteChar(0);
            return;
        }
        if (this.cursorIndex == this.value.length()) {
            return;
        }
        int oldCursor = this.cursorIndex;
        this.cursorIndex = this.findWordBoundary(this.cursorIndex, 1);
        this.selectionAnchor = oldCursor;
        this.deleteChar(0);
    }

    public final void selectAll() {
        this.selectionAnchor = 0;
        this.cursorIndex = this.value.length();
        this.resetCaretBlink();
    }

    @NotNull
    public final String getSelectedText() {
        String string;
        if (this.getHasSelection()) {
            String string2 = this.value.substring(this.getSelectionStart(), this.getSelectionEnd());
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    public final void copySelection() {
        if (!this.getHasSelection()) {
            return;
        }
        GuiScreen.func_146275_d((String)this.getSelectedText());
    }

    public final void cutSelection() {
        if (!this.getHasSelection()) {
            return;
        }
        this.copySelection();
        this.deleteChar(0);
    }

    public final void paste() {
        String clipboardText = GuiScreen.func_146277_j();
        Intrinsics.checkNotNull(clipboardText);
        if (((CharSequence)clipboardText).length() > 0) {
            this.insertText(clipboardText);
        }
    }

    private final void ensureCaretVisible() {
        RenderApi renderApi = Vexel.INSTANCE.getRenderEngine();
        String string = this.value.substring(0, RangesKt.coerceIn(this.cursorIndex, 0, this.value.length()));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        int caretXAbsolute = (int)renderApi.textWidth(string, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont());
        float visibleTextStart = this.scrollOffset;
        float visibleTextEnd = this.scrollOffset + this.getWidth() * (float)2;
        if ((float)caretXAbsolute < visibleTextStart) {
            this.scrollOffset = caretXAbsolute;
        } else if ((float)caretXAbsolute > visibleTextEnd - 1.0f) {
            this.scrollOffset = (float)caretXAbsolute - this.getWidth() * (float)2 + 1.0f;
        }
        float maxScrollPossible = Math.max(0.0f, (float)((int)Vexel.INSTANCE.getRenderEngine().textWidth(this.value, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont())) - this.getWidth() * (float)2);
        this.scrollOffset = RangesKt.coerceIn(this.scrollOffset, 0.0f, maxScrollPossible);
        if ((float)((int)Vexel.INSTANCE.getRenderEngine().textWidth(this.value, this.fontSize, Vexel.INSTANCE.getRenderEngine().getDefaultFont())) <= this.getWidth() * (float)2) {
            this.scrollOffset = 0.0f;
        }
    }

    @Override
    protected float getAutoWidth() {
        return this.background.getAutoWidth();
    }

    @Override
    protected float getAutoHeight() {
        return this.background.getAutoHeight();
    }

    @NotNull
    public final TextInput padding(float top, float right, float bottom, float left2) {
        TextInput textInput;
        TextInput $this$padding_u24lambda_u242 = textInput = this;
        boolean bl = false;
        $this$padding_u24lambda_u242.background.padding(top, right, bottom, left2);
        return textInput;
    }

    @NotNull
    public final TextInput padding(float all2) {
        TextInput textInput;
        TextInput $this$padding_u24lambda_u243 = textInput = this;
        boolean bl = false;
        $this$padding_u24lambda_u243.background.padding(all2);
        return textInput;
    }

    @NotNull
    public final TextInput fontSize(float size) {
        TextInput textInput;
        TextInput $this$fontSize_u24lambda_u244 = textInput = this;
        boolean bl = false;
        $this$fontSize_u24lambda_u244.fontSize = size;
        $this$fontSize_u24lambda_u244.innerText.setFontSize(size);
        return textInput;
    }

    @NotNull
    public final TextInput backgroundColor(int color) {
        TextInput textInput;
        TextInput $this$backgroundColor_u24lambda_u245 = textInput = this;
        boolean bl = false;
        $this$backgroundColor_u24lambda_u245.background.backgroundColor(color);
        return textInput;
    }

    @NotNull
    public final TextInput borderColor(int color) {
        TextInput textInput;
        TextInput $this$borderColor_u24lambda_u246 = textInput = this;
        boolean bl = false;
        $this$borderColor_u24lambda_u246.background.borderColor(color);
        return textInput;
    }

    @NotNull
    public final TextInput borderRadius(float radius) {
        TextInput textInput;
        TextInput $this$borderRadius_u24lambda_u247 = textInput = this;
        boolean bl = false;
        $this$borderRadius_u24lambda_u247.background.borderRadius(radius);
        return textInput;
    }

    @NotNull
    public final TextInput borderThickness(float thickness) {
        TextInput textInput;
        TextInput $this$borderThickness_u24lambda_u248 = textInput = this;
        boolean bl = false;
        $this$borderThickness_u24lambda_u248.background.borderThickness(thickness);
        return textInput;
    }

    @NotNull
    public final TextInput hoverColor(int color) {
        TextInput textInput;
        TextInput $this$hoverColor_u24lambda_u249 = textInput = this;
        boolean bl = false;
        $this$hoverColor_u24lambda_u249.background.hoverColor(color);
        return textInput;
    }

    @NotNull
    public final TextInput pressedColor(int color) {
        TextInput textInput;
        TextInput $this$pressedColor_u24lambda_u2410 = textInput = this;
        boolean bl = false;
        $this$pressedColor_u24lambda_u2410.background.pressedColor(color);
        return textInput;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean _init_$lambda$0(TextInput this$0, float mouseX, float mouseY, int button) {
        if (button != 0) {
            return false;
        }
        var5_4 = this$0.getX();
        v0 = mouseX <= this$0.getX() + this$0.getWidth() ? var5_4 <= mouseX : false;
        if (!v0) ** GOTO lbl-1000
        var5_4 = this$0.getY();
        v1 = mouseY <= this$0.getY() + this$0.getHeight() ? var5_4 <= mouseY : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = clickedOnField = false;
        }
        if (clickedOnField) {
            this$0.setFocused(true);
            this$0.isDragging = true;
            clickRelX = mouseX - (this$0.getX() - this$0.scrollOffset);
            newCursorIndex = this$0.getCharIndexAtAbsX(clickRelX);
            currentTime = System.currentTimeMillis();
            if (currentTime - this$0.lastClickTime < 250L) {
                var9_8 = this$0.clickCount;
                this$0.clickCount = var9_8 + 1;
            } else {
                this$0.clickCount = 1;
            }
            this$0.lastClickTime = currentTime;
            switch (this$0.clickCount) {
                case 1: {
                    this$0.cursorIndex = newCursorIndex;
                    if (KnitKeyboard.isShiftKeyPressed()) break;
                    this$0.selectionAnchor = this$0.cursorIndex;
                    break;
                }
                case 2: {
                    this$0.selectWordAt(newCursorIndex);
                    break;
                }
                default: {
                    this$0.selectAll();
                    this$0.clickCount = 0;
                }
            }
            this$0.resetCaretBlink();
            return true;
        }
        this$0.setFocused(false);
        this$0.isDragging = false;
        return false;
    }

    private static final boolean _init_$lambda$1(TextInput this$0, int keyCode, int scanCode, char c) {
        return this$0.keyTyped(keyCode, scanCode, c);
    }

    public TextInput() {
        this(null, null, 0.0f, 0, 0, 0, 0, 0.0f, 0.0f, null, null, null, null, null, 16383, null);
    }
}

