/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.utils.render.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.nanovg.NSVGImage;
import org.lwjgl.opengl.GL11;
import xyz.meowing.vexel.Vexel;
import xyz.meowing.vexel.utils.render.api.MemoryApi;
import xyz.meowing.vexel.utils.render.api.NanoVgApi;
import xyz.meowing.vexel.utils.render.api.RenderApi;
import xyz.meowing.vexel.utils.render.api.StbApi;
import xyz.meowing.vexel.utils.style.Color;
import xyz.meowing.vexel.utils.style.Font;
import xyz.meowing.vexel.utils.style.Gradient;
import xyz.meowing.vexel.utils.style.Image;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006\u009d\u0001\u009e\u0001\u009f\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0014J\u001f\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0014J\u0017\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b \u0010\u001fJ/\u0010#\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b%\u0010\u0016J?\u0010-\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.JG\u00101\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b1\u00102JW\u00107\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b7\u00108JG\u00109\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010/\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b9\u0010:JW\u0010?\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020+2\u0006\u0010>\u001a\u00020=2\u0006\u0010/\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b?\u0010@JO\u0010A\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020+2\u0006\u0010>\u001a\u00020=2\u0006\u0010/\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bA\u0010BJO\u0010G\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020E2\u0006\u0010/\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bG\u0010HJ/\u0010I\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\bI\u0010JJ?\u0010L\u001a\u00020\u00122\u0006\u0010L\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010N\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bL\u0010OJ?\u0010P\u001a\u00020\u00122\u0006\u0010L\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010N\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bP\u0010OJ'\u0010Q\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010N\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bQ\u0010RJO\u0010T\u001a\u00020\u00122\u0006\u0010L\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020+2\u0006\u0010N\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bT\u0010UJ7\u0010W\u001a\u00020V2\u0006\u0010L\u001a\u00020K2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000f2\u0006\u0010N\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bW\u0010XJo\u0010Y\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020+2\u0006\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u00020+2\u0006\u0010\\\u001a\u00020+2\u0006\u0010]\u001a\u00020+2\u0006\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bY\u0010`J'\u0010b\u001a\u00020+2\u0006\u0010a\u001a\u00020+2\u0006\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u00020+H\u0016\u00a2\u0006\u0004\bb\u0010cJW\u0010Y\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020d2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bY\u0010eJ7\u0010h\u001a\u00020d2\u0006\u0010f\u001a\u00020K2\u0006\u0010\u0010\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020+2\u0006\u0010,\u001a\u00020E2\u0006\u0010g\u001a\u00020KH\u0016\u00a2\u0006\u0004\bh\u0010iJ\u0017\u0010j\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020dH\u0016\u00a2\u0006\u0004\bj\u0010kJ?\u0010m\u001a\u00020\u00122\u0006\u0010g\u001a\u00020K2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bm\u0010nJ\u000f\u0010o\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\bo\u0010\u0016J\u0017\u0010p\u001a\u00020\u00122\u0006\u0010g\u001a\u00020KH\u0016\u00a2\u0006\u0004\bp\u0010qJ\u0017\u0010r\u001a\u00020+2\u0006\u0010Y\u001a\u00020dH\u0002\u00a2\u0006\u0004\br\u0010sJ\u0017\u0010t\u001a\u00020+2\u0006\u0010Y\u001a\u00020dH\u0002\u00a2\u0006\u0004\bt\u0010sJ/\u0010w\u001a\u00020+2\u0006\u0010Y\u001a\u00020d2\u0006\u0010u\u001a\u00020+2\u0006\u0010v\u001a\u00020+2\u0006\u0010,\u001a\u00020EH\u0002\u00a2\u0006\u0004\bw\u0010xJ\u001f\u0010{\u001a\u00020\u00122\u0006\u0010,\u001a\u00020+2\u0006\u0010z\u001a\u00020yH\u0002\u00a2\u0006\u0004\b{\u0010|J\u001f\u0010}\u001a\u00020\u00122\u0006\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0002\u00a2\u0006\u0004\b}\u0010~JJ\u0010\u0080\u0001\u001a\u00020\u00122\u0006\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010\u007f\u001a\u00020=H\u0002\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J\u001a\u0010\u0082\u0001\u001a\u00020+2\u0006\u0010N\u001a\u00020\fH\u0002\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0015\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0003\u0010\u0084\u0001R\u0015\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0005\u0010\u0085\u0001R\u0015\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0007\u0010\u0086\u0001R\u0015\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\t\u0010\u0087\u0001R\u0017\u0010\u0088\u0001\u001a\u00020y8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0088\u0001\u0010\u0089\u0001R\u0017\u0010\u008a\u0001\u001a\u00020y8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008a\u0001\u0010\u0089\u0001R\u0017\u0010\u008b\u0001\u001a\u00020y8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008b\u0001\u0010\u0089\u0001R\u001e\u0010\u008c\u0001\u001a\u00020\f8\u0016X\u0096\u0004\u00a2\u0006\u000f\n\u0006\b\u008c\u0001\u0010\u008d\u0001\u001a\u0005\b\u008e\u0001\u0010\u000eR7\u0010\u0092\u0001\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0005\u0012\u00030\u0090\u00010\u008f\u0001j\u0010\u0012\u0004\u0012\u00020\f\u0012\u0005\u0012\u00030\u0090\u0001`\u0091\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0093\u0001R\u0017\u0010\u0094\u0001\u001a\u00020V8\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0094\u0001\u0010\u0095\u0001R7\u0010\u0097\u0001\u001a\"\u0012\u0004\u0012\u00020d\u0012\u0005\u0012\u00030\u0096\u00010\u008f\u0001j\u0010\u0012\u0004\u0012\u00020d\u0012\u0005\u0012\u00030\u0096\u0001`\u0091\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0097\u0001\u0010\u0093\u0001R7\u0010\u0098\u0001\u001a\"\u0012\u0004\u0012\u00020K\u0012\u0005\u0012\u00030\u0096\u00010\u008f\u0001j\u0010\u0012\u0004\u0012\u00020K\u0012\u0005\u0012\u00030\u0096\u0001`\u0091\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0098\u0001\u0010\u0093\u0001R\u001c\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0099\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u009a\u0001\u0010\u009b\u0001R\u0019\u0010\u009c\u0001\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u0087\u0001\u00a8\u0006\u00a0\u0001"}, d2={"Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl;", "Lxyz/meowing/vexel/utils/render/api/RenderApi;", "Lxyz/meowing/vexel/utils/render/api/NanoVgApi;", "nanoVg", "Lxyz/meowing/vexel/utils/render/api/StbApi;", "stb", "Lxyz/meowing/vexel/utils/render/api/MemoryApi;", "memory", "", "isOdin", "<init>", "(Lxyz/meowing/vexel/utils/render/api/NanoVgApi;Lxyz/meowing/vexel/utils/render/api/StbApi;Lxyz/meowing/vexel/utils/render/api/MemoryApi;Z)V", "Lxyz/meowing/vexel/utils/style/Font;", "getDefFont", "()Lxyz/meowing/vexel/utils/style/Font;", "", "width", "height", "", "beginFrame", "(FF)V", "endFrame", "()V", "push", "pop", "x", "y", "scale", "translate", "amount", "rotate", "(F)V", "globalAlpha", "w", "h", "pushScissor", "(FFFF)V", "popScissor", "x1", "y1", "x2", "y2", "thickness", "", "color", "line", "(FFFFFI)V", "radius", "roundTop", "drawHalfRoundedRect", "(FFFFIFZ)V", "tr", "tl", "br", "bl", "rect", "(FFFFIFFFF)V", "hollowRect", "(FFFFFIF)V", "color1", "color2", "Lxyz/meowing/vexel/utils/style/Gradient;", "gradient", "hollowGradientRect", "(FFFFFIILxyz/meowing/vexel/utils/style/Gradient;F)V", "gradientRect", "(FFFFIILxyz/meowing/vexel/utils/style/Gradient;F)V", "blur", "spread", "Ljava/awt/Color;", "shadowColor", "dropShadow", "(FFFFFFLjava/awt/Color;F)V", "circle", "(FFFI)V", "", "text", "size", "font", "(Ljava/lang/String;FFFILxyz/meowing/vexel/utils/style/Font;)V", "textShadow", "textWidth", "(Ljava/lang/String;FLxyz/meowing/vexel/utils/style/Font;)F", "lineHeight", "drawWrappedString", "(Ljava/lang/String;FFFFILxyz/meowing/vexel/utils/style/Font;F)V", "", "wrappedTextBounds", "(Ljava/lang/String;FFLxyz/meowing/vexel/utils/style/Font;F)[F", "image", "textureWidth", "textureHeight", "subX", "subY", "subW", "subH", "(IIIIIIIFFFFF)V", "textureId", "createNVGImage", "(III)I", "Lxyz/meowing/vexel/utils/style/Image;", "(Lxyz/meowing/vexel/utils/style/Image;FFFFFFFF)V", "resourcePath", "id", "createImage", "(Ljava/lang/String;IILjava/awt/Color;Ljava/lang/String;)Lxyz/meowing/vexel/utils/style/Image;", "deleteImage", "(Lxyz/meowing/vexel/utils/style/Image;)V", "a", "svg", "(Ljava/lang/String;FFFFF)V", "cleanCache", "deleteSVG", "(Ljava/lang/String;)V", "getImage", "(Lxyz/meowing/vexel/utils/style/Image;)I", "loadImage", "svgWidth", "svgHeight", "loadSVG", "(Lxyz/meowing/vexel/utils/style/Image;IILjava/awt/Color;)I", "", "address", "setColor", "(IJ)V", "setColors", "(II)V", "direction", "applyGradient", "(IIFFFFLxyz/meowing/vexel/utils/style/Gradient;)V", "getFontID", "(Lxyz/meowing/vexel/utils/style/Font;)I", "Lxyz/meowing/vexel/utils/render/api/NanoVgApi;", "Lxyz/meowing/vexel/utils/render/api/StbApi;", "Lxyz/meowing/vexel/utils/render/api/MemoryApi;", "Z", "nvgColor", "J", "nvgColor2", "nvgPaint", "defaultFont", "Lxyz/meowing/vexel/utils/style/Font;", "getDefaultFont", "Ljava/util/HashMap;", "Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGFont;", "Lkotlin/collections/HashMap;", "fontMap", "Ljava/util/HashMap;", "fontBounds", "[F", "Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGImage;", "images", "svgCache", "Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;", "scissor", "Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;", "drawing", "NVGImage", "NVGFont", "Scissor", "Vexel"})
@SourceDebugExtension(value={"SMAP\nNVGRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NVGRendererImpl.kt\nxyz/meowing/vexel/utils/render/impl/NVGRendererImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Color.kt\nxyz/meowing/vexel/utils/style/Color$Companion\n*L\n1#1,397:1\n382#2,7:398\n382#2,7:409\n382#2,7:421\n1869#3,2:405\n1869#3,2:407\n1#4:416\n114#5,4:417\n*S KotlinDebug\n*F\n+ 1 NVGRendererImpl.kt\nxyz/meowing/vexel/utils/render/impl/NVGRendererImpl\n*L\n303#1:398,7\n343#1:409,7\n392#1:421,7\n327#1:405,2\n329#1:407,2\n374#1:417,4\n*E\n"})
public final class NVGRendererImpl
implements RenderApi {
    @NotNull
    private final NanoVgApi nanoVg;
    @NotNull
    private final StbApi stb;
    @NotNull
    private final MemoryApi memory;
    private final boolean isOdin;
    private final long nvgColor;
    private final long nvgColor2;
    private final long nvgPaint;
    @NotNull
    private final Font defaultFont;
    @NotNull
    private final HashMap<Font, NVGFont> fontMap;
    @NotNull
    private final float[] fontBounds;
    @NotNull
    private final HashMap<Image, NVGImage> images;
    @NotNull
    private final HashMap<String, NVGImage> svgCache;
    @Nullable
    private Scissor scissor;
    private boolean drawing;

    public NVGRendererImpl(@NotNull NanoVgApi nanoVg, @NotNull StbApi stb, @NotNull MemoryApi memory, boolean isOdin) {
        Intrinsics.checkNotNullParameter(nanoVg, "nanoVg");
        Intrinsics.checkNotNullParameter(stb, "stb");
        Intrinsics.checkNotNullParameter(memory, "memory");
        this.nanoVg = nanoVg;
        this.stb = stb;
        this.memory = memory;
        this.isOdin = isOdin;
        this.defaultFont = this.getDefFont();
        this.fontMap = new HashMap();
        this.fontBounds = new float[4];
        this.images = new HashMap();
        this.svgCache = new HashMap();
        this.nanoVg.maybeSetup();
        this.nvgColor = this.nanoVg.createColor();
        this.nvgColor2 = this.nanoVg.createColor();
        this.nvgPaint = this.nanoVg.createPaint();
    }

    public /* synthetic */ NVGRendererImpl(NanoVgApi nanoVgApi, StbApi stbApi, MemoryApi memoryApi, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(nanoVgApi, stbApi, memoryApi, bl);
    }

    @Override
    @NotNull
    public Font getDefaultFont() {
        return this.defaultFont;
    }

    private final Font getDefFont() {
        Font font;
        try {
            InputStream inputStream2 = Vexel.INSTANCE.getClient().func_110442_L().func_110536_a(new ResourceLocation("vexel:font.ttf")).func_110527_b();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
            font = new Font("Default", inputStream2);
        }
        catch (Exception exception) {
            font = new Font("Default", "/assets/vexel/font.ttf");
        }
        return font;
    }

    @Override
    public void beginFrame(float width, float height) {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing");
        }
        GlStateManager.func_179094_E();
        if (!Vexel.INSTANCE.getClient().func_147110_a().isStencilEnabled()) {
            Vexel.INSTANCE.getClient().func_147110_a().enableStencil();
        }
        GL11.glPushAttrib((int)1048575);
        GlStateManager.func_179118_c();
        this.nanoVg.beginFrame(width, height, 1.0f);
        this.nanoVg.textAlign(this.nanoVg.getConstants().getNVG_ALIGN_LEFT() | this.nanoVg.getConstants().getNVG_ALIGN_TOP());
        this.drawing = true;
    }

    @Override
    public void endFrame() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing");
        }
        this.nanoVg.endFrame();
        GlStateManager.func_179126_j();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179144_i((int)5);
        GL11.glPopAttrib();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        this.drawing = false;
    }

    @Override
    public void push() {
        this.nanoVg.save();
    }

    @Override
    public void pop() {
        this.nanoVg.restore();
    }

    @Override
    public void scale(float x, float y) {
        this.nanoVg.scale(x, y);
    }

    @Override
    public void translate(float x, float y) {
        this.nanoVg.translate(x, y);
    }

    @Override
    public void rotate(float amount) {
        this.nanoVg.rotate(amount);
    }

    @Override
    public void globalAlpha(float amount) {
        this.nanoVg.globalAlpha(RangesKt.coerceIn(amount, 0.0f, 1.0f));
    }

    @Override
    public void pushScissor(float x, float y, float w, float h) {
        block0: {
            Scissor scissor = this.scissor = new Scissor(this.scissor, x, y, w + x, h + y);
            if (scissor == null) break block0;
            scissor.apply(this.nanoVg);
        }
    }

    @Override
    public void popScissor() {
        block0: {
            this.nanoVg.resetScissor();
            Scissor scissor = this.scissor;
            Scissor scissor2 = this.scissor = scissor != null ? scissor.getPrevious() : null;
            if (scissor2 == null) break block0;
            scissor2.apply(this.nanoVg);
        }
    }

    @Override
    public void line(float x1, float y1, float x2, float y2, float thickness, int color) {
        this.nanoVg.beginPath();
        this.nanoVg.moveTo(x1, y1);
        this.nanoVg.lineTo(x2, y2);
        this.nanoVg.strokeWidth(thickness);
        this.setColor(color, this.nvgColor);
        this.nanoVg.strokeColor(this.nvgColor);
        this.nanoVg.stroke();
    }

    @Override
    public void drawHalfRoundedRect(float x, float y, float w, float h, int color, float radius, boolean roundTop) {
        this.nanoVg.beginPath();
        if (roundTop) {
            this.nanoVg.moveTo(x, y + h);
            this.nanoVg.lineTo(x + w, y + h);
            this.nanoVg.lineTo(x + w, y + radius);
            this.nanoVg.arcTo(x + w, y, x + w - radius, y, radius);
            this.nanoVg.lineTo(x + radius, y);
            this.nanoVg.arcTo(x, y, x, y + radius, radius);
            this.nanoVg.lineTo(x, y + h);
        } else {
            this.nanoVg.moveTo(x, y);
            this.nanoVg.lineTo(x + w, y);
            this.nanoVg.lineTo(x + w, y + h - radius);
            this.nanoVg.arcTo(x + w, y + h, x + w - radius, y + h, radius);
            this.nanoVg.lineTo(x + radius, y + h);
            this.nanoVg.arcTo(x, y + h, x, y + h - radius, radius);
            this.nanoVg.lineTo(x, y);
        }
        this.nanoVg.closePath();
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.fill();
    }

    @Override
    public void rect(float x, float y, float w, float h, int color, float tr, float tl, float br, float bl) {
        this.nanoVg.beginPath();
        this.nanoVg.roundedRectVarying((float)Math.rint(x), (float)Math.rint(y), (float)Math.rint(w), (float)Math.rint(h), tr, tl, br, bl);
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.fill();
    }

    @Override
    public void hollowRect(float x, float y, float w, float h, float thickness, int color, float radius) {
        this.nanoVg.beginPath();
        this.nanoVg.roundedRect(x, y, w, h, radius);
        this.nanoVg.strokeWidth(thickness);
        this.nanoVg.pathWinding(this.nanoVg.getConstants().getNVG_HOLE());
        this.setColor(color, this.nvgColor);
        this.nanoVg.strokeColor(this.nvgColor);
        this.nanoVg.stroke();
    }

    @Override
    public void hollowGradientRect(float x, float y, float w, float h, float thickness, int color1, int color2, @NotNull Gradient gradient, float radius) {
        Intrinsics.checkNotNullParameter((Object)gradient, "gradient");
        this.nanoVg.beginPath();
        this.nanoVg.roundedRect(x, y, w, h, radius);
        this.nanoVg.strokeWidth(thickness);
        this.applyGradient(color1, color2, x, y, w, h, gradient);
        this.nanoVg.strokeColor(this.nvgColor);
        this.nanoVg.stroke();
    }

    @Override
    public void gradientRect(float x, float y, float w, float h, int color1, int color2, @NotNull Gradient gradient, float radius) {
        Intrinsics.checkNotNullParameter((Object)gradient, "gradient");
        this.nanoVg.beginPath();
        this.nanoVg.roundedRect(x, y, w, h, radius);
        this.applyGradient(color1, color2, x, y, w, h, gradient);
        this.nanoVg.fillPaint(this.nvgPaint);
        this.nanoVg.fill();
    }

    @Override
    public void dropShadow(float x, float y, float width, float height, float blur, float spread, @NotNull java.awt.Color shadowColor, float radius) {
        Intrinsics.checkNotNullParameter(shadowColor, "shadowColor");
        byte r = (byte)shadowColor.getRed();
        byte g = (byte)shadowColor.getGreen();
        byte b = (byte)shadowColor.getBlue();
        this.nanoVg.rgba(this.nvgColor, r, g, b, (byte)125);
        this.nanoVg.rgba(this.nvgColor2, r, g, b, (byte)0);
        this.nanoVg.boxGradient(x - spread, y - spread, width + (float)2 * spread, height + (float)2 * spread, radius + spread, blur, this.nvgColor, this.nvgColor2, this.nvgPaint);
        this.nanoVg.beginPath();
        this.nanoVg.roundedRect(x - spread - blur, y - spread - blur, width + (float)2 * spread + (float)2 * blur, height + (float)2 * spread + (float)2 * blur, radius + spread);
        this.nanoVg.roundedRect(x, y, width, height, radius);
        this.nanoVg.pathWinding(this.nanoVg.getConstants().getNVG_HOLE());
        this.nanoVg.fillPaint(this.nvgPaint);
        this.nanoVg.fill();
    }

    @Override
    public void circle(float x, float y, float radius, int color) {
        this.nanoVg.beginPath();
        this.nanoVg.circle(x, y, radius);
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.fill();
    }

    @Override
    public void text(@NotNull String text, float x, float y, float size, int color, @NotNull Font font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(font, "font");
        this.nanoVg.fontSize(size);
        this.nanoVg.fontFaceId(this.getFontID(font));
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.text((float)Math.rint(x), (float)Math.rint(y + 0.5f), text);
    }

    @Override
    public void textShadow(@NotNull String text, float x, float y, float size, int color, @NotNull Font font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(font, "font");
        this.nanoVg.fontFaceId(this.getFontID(font));
        this.nanoVg.fontSize(size);
        this.setColor(-16777216, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.text((float)Math.rint(x + 3.0f), (float)Math.rint(y + 3.0f), text);
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.text((float)Math.rint(x), (float)Math.rint(y), text);
    }

    @Override
    public float textWidth(@NotNull String text, float size, @NotNull Font font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(font, "font");
        this.nanoVg.fontSize(size);
        this.nanoVg.fontFaceId(this.getFontID(font));
        return this.nanoVg.textBounds(0.0f, 0.0f, text, this.fontBounds);
    }

    @Override
    public void drawWrappedString(@NotNull String text, float x, float y, float w, float size, int color, @NotNull Font font, float lineHeight) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(font, "font");
        this.nanoVg.fontSize(size);
        this.nanoVg.fontFaceId(this.getFontID(font));
        this.nanoVg.textLineHeight(lineHeight);
        this.setColor(color, this.nvgColor);
        this.nanoVg.fillColor(this.nvgColor);
        this.nanoVg.textBox(x, y, w, text);
    }

    @Override
    @NotNull
    public float[] wrappedTextBounds(@NotNull String text, float w, float size, @NotNull Font font, float lineHeight) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(font, "font");
        float[] bounds = new float[4];
        this.nanoVg.fontSize(size);
        this.nanoVg.fontFaceId(this.getFontID(font));
        this.nanoVg.textLineHeight(lineHeight);
        this.nanoVg.textBoxBounds(0.0f, 0.0f, w, text, bounds);
        return bounds;
    }

    @Override
    public void image(int image, int textureWidth, int textureHeight, int subX, int subY, int subW, int subH, float x, float y, float w, float h, float radius) {
        if (image == -1) {
            return;
        }
        float sx = (float)subX / (float)textureWidth;
        float sy = (float)subY / (float)textureHeight;
        float sw = (float)subW / (float)textureWidth;
        float sh = (float)subH / (float)textureHeight;
        float iw = w / sw;
        float ih = h / sh;
        float ix = x - iw * sx;
        float iy = y - ih * sy;
        this.nanoVg.imagePattern(ix, iy, iw, ih, 0.0f, image, 1.0f, this.nvgPaint);
        this.nanoVg.beginPath();
        this.nanoVg.roundedRect(x, y, w, h + 0.5f, radius);
        this.nanoVg.fillPaint(this.nvgPaint);
        this.nanoVg.fill();
    }

    @Override
    public int createNVGImage(int textureId, int textureWidth, int textureHeight) {
        return this.nanoVg.createImageFromHandle(textureId, textureWidth, textureHeight, this.nanoVg.getConstants().getNVG_IMAGE_NEAREST() | this.nanoVg.getConstants().getNVG_IMAGE_NODELETE());
    }

    @Override
    public void image(@NotNull Image image, float x, float y, float w, float h, float tr, float tl, float br, float bl) {
        Intrinsics.checkNotNullParameter(image, "image");
        this.nanoVg.imagePattern(x, y, w, h, 0.0f, this.getImage(image), 1.0f, this.nvgPaint);
        this.nanoVg.beginPath();
        this.nanoVg.roundedRectVarying(x, y, w, h + 0.5f, tr, tl, br, bl);
        this.nanoVg.fillPaint(this.nvgPaint);
        this.nanoVg.fill();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Image createImage(@NotNull String resourcePath, int width, int height, @NotNull java.awt.Color color, @NotNull String id2) {
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(id2, "id");
        Image image = new Image(resourcePath, false, null, null, 14, null);
        if (image.isSVG()) {
            ((Map)this.svgCache).put(id2, new NVGImage(0, this.loadSVG(image, width, height, color)));
            NVGImage nVGImage = this.svgCache.get(id2);
            Intrinsics.checkNotNull(nVGImage);
            NVGImage nVGImage2 = nVGImage;
            int n = nVGImage2.getCount();
            nVGImage2.setCount(n + 1);
        } else {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.images;
            Image key$iv = image;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                NVGImage answer$iv = new NVGImage(0, this.loadImage(image));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            NVGImage nVGImage = (NVGImage)object;
            int n = nVGImage.getCount();
            nVGImage.setCount(n + 1);
        }
        return image;
    }

    @Override
    public void deleteImage(@NotNull Image image) {
        Intrinsics.checkNotNullParameter(image, "image");
        NVGImage nVGImage = this.images.get(image);
        if (nVGImage == null) {
            return;
        }
        NVGImage nvgImage = nVGImage;
        int n = nvgImage.getCount();
        nvgImage.setCount(n + -1);
        if (nvgImage.getCount() == 0) {
            this.nanoVg.deleteImage(nvgImage.getNvg());
            this.images.remove(image);
        }
    }

    @Override
    public void svg(@NotNull String id2, float x, float y, float w, float h, float a) {
        Intrinsics.checkNotNullParameter(id2, "id");
        NVGImage nVGImage = this.svgCache.get(id2);
        if (nVGImage == null) {
            throw new IllegalStateException("SVG Image (" + id2 + ") doesn't exist");
        }
        int nvg = nVGImage.getNvg();
        this.nanoVg.imagePattern(x, y, w, h, 0.0f, nvg, a, this.nvgPaint);
        this.nanoVg.beginPath();
        this.nanoVg.rect(x, y, w, h + 0.5f);
        this.nanoVg.fillPaint(this.nvgPaint);
        this.nanoVg.fill();
    }

    @Override
    public void cleanCache() {
        Map.Entry it;
        Set<Map.Entry<Image, NVGImage>> set = this.images.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Map.Entry)element$iv;
            boolean bl = false;
            this.nanoVg.deleteImage(((NVGImage)it.getValue()).getNvg());
        }
        this.images.clear();
        Set<Map.Entry<String, NVGImage>> set2 = this.svgCache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Map.Entry)element$iv;
            boolean bl = false;
            this.nanoVg.deleteImage(((NVGImage)it.getValue()).getNvg());
        }
        this.svgCache.clear();
    }

    @Override
    public void deleteSVG(@NotNull String id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        NVGImage nVGImage = this.svgCache.get(id2);
        if (nVGImage == null) {
            return;
        }
        NVGImage nvgImage = nVGImage;
        int n = nvgImage.getCount();
        nvgImage.setCount(n + -1);
        if (nvgImage.getCount() == 0) {
            this.nanoVg.deleteImage(nvgImage.getNvg());
            this.svgCache.remove(id2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getImage(Image image) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.images;
        Image key$iv = image;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            NVGImage answer$iv = new NVGImage(0, this.loadImage(image));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((NVGImage)object).getNvg();
    }

    private final int loadImage(Image image) {
        int[] w = new int[1];
        int[] h = new int[1];
        int[] channels = new int[1];
        ByteBuffer buffer = this.stb.loadFromMemory(image.buffer(), w, h, channels, 4);
        return this.nanoVg.createImageRGBA(w[0], h[0], 0, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int loadSVG(Image image, int svgWidth, int svgHeight, java.awt.Color color) {
        Object[] it;
        Closeable closeable = image.getStream();
        Object object = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            it = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        Object vec = it;
        object = "#%06X";
        it = new Object[]{color.getRGB() & 0xFFFFFF};
        String string = String.format((String)object, Arrays.copyOf(it, it.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        String hexColor = string;
        vec = StringsKt.replace$default((String)vec, "currentColor", hexColor, false, 4, null);
        NSVGImage svgAddress = this.nanoVg.svgParse((String)vec, "px", 96.0f);
        int width = svgWidth > 0 ? svgWidth : (int)this.nanoVg.svgWidth(svgAddress);
        int height = svgHeight > 0 ? svgHeight : (int)this.nanoVg.svgHeight(svgAddress);
        ByteBuffer buffer = this.memory.memAlloc(width * height * 4);
        try {
            float scale = (float)width / this.nanoVg.svgWidth(svgAddress);
            this.nanoVg.svgRasterize(this.nanoVg.getSvgHandle(), svgAddress, 0.0f, 0.0f, scale, buffer, width, height, width * 4);
            int n = this.nanoVg.createImageRGBA(width, height, 0, buffer);
            return n;
        }
        finally {
            this.nanoVg.svgDelete(svgAddress);
            if (this.isOdin) {
                buffer.clear();
            } else {
                this.memory.memFree(buffer);
            }
        }
    }

    private final void setColor(int color, long address) {
        Color.Companion companion = Color.Companion;
        int $this$red$iv = color;
        boolean $i$f$getRed = false;
        Color.Companion this_$iv = Color.Companion;
        int $this$green$iv = color;
        boolean $i$f$getGreen = false;
        this_$iv = Color.Companion;
        int $this$blue$iv = color;
        boolean $i$f$getBlue = false;
        this_$iv = Color.Companion;
        int $this$alpha$iv = color;
        boolean $i$f$getAlpha = false;
        this.nanoVg.rgba(address, (byte)($this$red$iv >> 16 & 0xFF), (byte)($this$green$iv >> 8 & 0xFF), (byte)($this$blue$iv & 0xFF), (byte)($this$alpha$iv >> 24 & 0xFF));
    }

    private final void setColors(int color1, int color2) {
        this.setColor(color1, this.nvgColor);
        this.setColor(color2, this.nvgColor2);
    }

    private final void applyGradient(int color1, int color2, float x, float y, float w, float h, Gradient direction) {
        this.setColors(color1, color2);
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                this.nanoVg.linearGradient(this.nvgPaint, x, y, x + w, y, this.nvgColor, this.nvgColor2);
                break;
            }
            case 2: {
                this.nanoVg.linearGradient(this.nvgPaint, x, y, x, y + h, this.nvgColor, this.nvgColor2);
                break;
            }
            case 3: {
                this.nanoVg.linearGradient(this.nvgPaint, x, y, x + w, y + h, this.nvgColor, this.nvgColor2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getFontID(Font font) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.fontMap;
        Font key$iv = font;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ByteBuffer buffer = font.buffer();
            NVGFont answer$iv = new NVGFont(this.nanoVg.createFontMem(font.getName(), buffer, false), buffer);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((NVGFont)object).getId();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGFont;", "", "", "id", "Ljava/nio/ByteBuffer;", "buffer", "<init>", "(ILjava/nio/ByteBuffer;)V", "component1", "()I", "component2", "()Ljava/nio/ByteBuffer;", "copy", "(ILjava/nio/ByteBuffer;)Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGFont;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getId", "Ljava/nio/ByteBuffer;", "getBuffer", "Vexel"})
    private static final class NVGFont {
        private final int id;
        @NotNull
        private final ByteBuffer buffer;

        public NVGFont(int id2, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this.id = id2;
            this.buffer = buffer;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final ByteBuffer component2() {
            return this.buffer;
        }

        @NotNull
        public final NVGFont copy(int id2, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            return new NVGFont(id2, buffer);
        }

        public static /* synthetic */ NVGFont copy$default(NVGFont nVGFont, int n, ByteBuffer byteBuffer, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = nVGFont.id;
            }
            if ((n2 & 2) != 0) {
                byteBuffer = nVGFont.buffer;
            }
            return nVGFont.copy(n, byteBuffer);
        }

        @NotNull
        public String toString() {
            return "NVGFont(id=" + this.id + ", buffer=" + this.buffer + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + this.buffer.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NVGFont)) {
                return false;
            }
            NVGFont nVGFont = (NVGFont)other;
            if (this.id != nVGFont.id) {
                return false;
            }
            return Intrinsics.areEqual(this.buffer, nVGFont.buffer);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGImage;", "", "", "count", "nvg", "<init>", "(II)V", "component1", "()I", "component2", "copy", "(II)Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$NVGImage;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getCount", "setCount", "(I)V", "getNvg", "Vexel"})
    private static final class NVGImage {
        private int count;
        private final int nvg;

        public NVGImage(int count2, int nvg) {
            this.count = count2;
            this.nvg = nvg;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int getNvg() {
            return this.nvg;
        }

        public final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.nvg;
        }

        @NotNull
        public final NVGImage copy(int count2, int nvg) {
            return new NVGImage(count2, nvg);
        }

        public static /* synthetic */ NVGImage copy$default(NVGImage nVGImage, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = nVGImage.count;
            }
            if ((n3 & 2) != 0) {
                n2 = nVGImage.nvg;
            }
            return nVGImage.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "NVGImage(count=" + this.count + ", nvg=" + this.nvg + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.count);
            result = result * 31 + Integer.hashCode(this.nvg);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NVGImage)) {
                return false;
            }
            NVGImage nVGImage = (NVGImage)other;
            if (this.count != nVGImage.count) {
                return false;
            }
            return this.nvg == nVGImage.nvg;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u0019\u0010\u0002\u001a\u0004\u0018\u00010\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0006\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;", "", "previous", "", "x", "y", "maxX", "maxY", "<init>", "(Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;FFFF)V", "Lxyz/meowing/vexel/utils/render/api/NanoVgApi;", "nanoVg", "", "apply", "(Lxyz/meowing/vexel/utils/render/api/NanoVgApi;)V", "Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;", "getPrevious", "()Lxyz/meowing/vexel/utils/render/impl/NVGRendererImpl$Scissor;", "F", "getX", "()F", "getY", "getMaxX", "getMaxY", "Vexel"})
    private static final class Scissor {
        @Nullable
        private final Scissor previous;
        private final float x;
        private final float y;
        private final float maxX;
        private final float maxY;

        public Scissor(@Nullable Scissor previous, float x, float y, float maxX, float maxY) {
            this.previous = previous;
            this.x = x;
            this.y = y;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        @Nullable
        public final Scissor getPrevious() {
            return this.previous;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float getMaxX() {
            return this.maxX;
        }

        public final float getMaxY() {
            return this.maxY;
        }

        public final void apply(@NotNull NanoVgApi nanoVg) {
            Intrinsics.checkNotNullParameter(nanoVg, "nanoVg");
            if (this.previous == null) {
                nanoVg.scissor(this.x, this.y, this.maxX - this.x, this.maxY - this.y);
            } else {
                float nx = Math.max(this.x, this.previous.x);
                float ny = Math.max(this.y, this.previous.y);
                float width = Math.max(0.0f, Math.min(this.maxX, this.previous.maxX) - nx);
                float height = Math.max(0.0f, Math.min(this.maxY, this.previous.maxY) - ny);
                nanoVg.scissor(nx, ny, width, height);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Gradient.values().length];
            try {
                nArray[Gradient.LeftToRight.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Gradient.TopToBottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Gradient.TopLeftToBottomRight.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

