/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.vexel.utils.style;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b.\u0018\u0000 D2\u00020\u0001:\u0001DB)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bB+\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0007\u0010\u0016J\u0017\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001a\u0010\u001f\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0000\u00a2\u0006\u0004\b!\u0010\"R*\u0010\u0003\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R*\u0010\u0004\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010$\u001a\u0004\b)\u0010&\"\u0004\b*\u0010(R*\u0010\u0005\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010$\u001a\u0004\b+\u0010&\"\u0004\b,\u0010(R*\u0010-\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010$\u001a\u0004\b.\u0010&\"\u0004\b/\u0010(R\u0016\u00100\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\"\u0010\u0011\u001a\u00020\f8F@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u00102\u001a\u0004\b3\u0010\u001d\"\u0004\b4\u0010\u0012R\u0012\u00106\u001a\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001dR\u0012\u00108\u001a\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u001dR\u0012\u0010:\u001a\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001dR\u0012\u0010\u0006\u001a\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u001dR\u0012\u0010=\u001a\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b<\u0010&R\u0012\u0010?\u001a\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b>\u0010&R\u0012\u0010A\u001a\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b@\u0010&R\u0012\u0010B\u001a\u00020\u00178\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Lxyz/meowing/vexel/utils/style/Color;", "", "", "hue", "saturation", "brightness", "alpha", "<init>", "(FFFF)V", "", "hsb", "([FF)V", "", "r", "g", "b", "(IIIF)V", "rgba", "(I)V", "(IF)V", "", "hex", "(Ljava/lang/String;)V", "", "includeAlpha", "(Z)Ljava/lang/String;", "toString", "()Ljava/lang/String;", "hashCode", "()I", "other", "equals", "(Ljava/lang/Object;)Z", "copy", "()Lxyz/meowing/vexel/utils/style/Color;", "value", "F", "getHue", "()F", "setHue", "(F)V", "getSaturation", "setSaturation", "getBrightness", "setBrightness", "alphaFloat", "getAlphaFloat", "setAlphaFloat", "needsUpdate", "Z", "I", "getRgba", "setRgba", "getRed", "red", "getGreen", "green", "getBlue", "blue", "getAlpha", "getRedFloat", "redFloat", "getGreenFloat", "greenFloat", "getBlueFloat", "blueFloat", "isTransparent", "()Z", "Companion", "Vexel"})
@SourceDebugExtension(value={"SMAP\nColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Color.kt\nxyz/meowing/vexel/utils/style/Color\n+ 2 Color.kt\nxyz/meowing/vexel/utils/style/Color$Companion\n*L\n1#1,146:1\n70#1:158\n71#1:160\n72#1:162\n70#1:164\n71#1:166\n72#1:168\n73#1:170\n114#2,4:147\n114#2,3:151\n114#2:154\n115#2:155\n116#2:156\n117#2:157\n114#2:159\n115#2:161\n116#2:163\n114#2:165\n115#2:167\n116#2:169\n117#2:171\n*S KotlinDebug\n*F\n+ 1 Color.kt\nxyz/meowing/vexel/utils/style/Color\n*L\n75#1:158\n76#1:160\n77#1:162\n93#1:164\n93#1:166\n93#1:168\n93#1:170\n13#1:147,4\n14#1:151,3\n70#1:154\n71#1:155\n72#1:156\n73#1:157\n75#1:159\n76#1:161\n77#1:163\n93#1:165\n93#1:167\n93#1:169\n93#1:171\n*E\n"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float hue;
    private float saturation;
    private float brightness;
    private float alphaFloat;
    private transient boolean needsUpdate;
    private int rgba;

    public Color(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alphaFloat = alpha;
        this.needsUpdate = true;
    }

    public /* synthetic */ Color(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public Color(@NotNull float[] hsb, float alpha) {
        Intrinsics.checkNotNullParameter(hsb, "hsb");
        this(hsb[0], hsb[1], hsb[2], alpha);
    }

    public /* synthetic */ Color(float[] fArray, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(fArray, f);
    }

    public Color(int r, int g, int b, float alpha) {
        float[] fArray = java.awt.Color.RGBtoHSB(r, g, b, new float[3]);
        Intrinsics.checkNotNullExpressionValue(fArray, "RGBtoHSB(...)");
        this(fArray, alpha);
    }

    public /* synthetic */ Color(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, f);
    }

    public Color(int rgba) {
        Companion companion = Companion;
        int $this$red$iv = rgba;
        boolean $i$f$getRed = false;
        Companion this_$iv = Companion;
        int $this$green$iv = rgba;
        boolean $i$f$getGreen = false;
        this_$iv = Companion;
        int $this$blue$iv = rgba;
        boolean $i$f$getBlue = false;
        this_$iv = Companion;
        int $this$alpha$iv = rgba;
        boolean $i$f$getAlpha = false;
        this($this$red$iv >> 16 & 0xFF, $this$green$iv >> 8 & 0xFF, $this$blue$iv & 0xFF, (float)($this$alpha$iv >> 24 & 0xFF) / 255.0f);
    }

    public Color(int rgba, float alpha) {
        Companion companion = Companion;
        int $this$red$iv = rgba;
        boolean $i$f$getRed = false;
        Companion this_$iv = Companion;
        int $this$green$iv = rgba;
        boolean $i$f$getGreen = false;
        this_$iv = Companion;
        int $this$blue$iv = rgba;
        boolean $i$f$getBlue = false;
        this($this$red$iv >> 16 & 0xFF, $this$green$iv >> 8 & 0xFF, $this$blue$iv & 0xFF, alpha);
    }

    public Color(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        int n = Integer.parseInt(StringsKt.take(hex, 2), CharsKt.checkRadix(16));
        String string = hex.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        int n2 = Integer.parseInt(string, CharsKt.checkRadix(16));
        String string2 = hex.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        int n3 = Integer.parseInt(string2, CharsKt.checkRadix(16));
        String string3 = hex.substring(6, 8);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        this(n, n2, n3, (float)Integer.parseInt(string3, CharsKt.checkRadix(16)) / 255.0f);
    }

    public final float getHue() {
        return this.hue;
    }

    public final void setHue(float value) {
        this.hue = value;
        this.needsUpdate = true;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float value) {
        this.saturation = value;
        this.needsUpdate = true;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float value) {
        this.brightness = value;
        this.needsUpdate = true;
    }

    public final float getAlphaFloat() {
        return this.alphaFloat;
    }

    public final void setAlphaFloat(float value) {
        this.alphaFloat = value;
        this.needsUpdate = true;
    }

    public final int getRgba() {
        if (this.needsUpdate) {
            this.rgba = java.awt.Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF | (int)(this.alphaFloat * (float)255) << 24;
            this.needsUpdate = false;
        }
        return this.rgba;
    }

    public final void setRgba(int n) {
        this.rgba = n;
    }

    public final int getRed() {
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv = this.getRgba();
        boolean $i$f$getRed2 = false;
        return $this$red$iv >> 16 & 0xFF;
    }

    public final int getGreen() {
        boolean $i$f$getGreen = false;
        Companion companion = Companion;
        int $this$green$iv = this.getRgba();
        boolean $i$f$getGreen2 = false;
        return $this$green$iv >> 8 & 0xFF;
    }

    public final int getBlue() {
        boolean $i$f$getBlue = false;
        Companion companion = Companion;
        int $this$blue$iv = this.getRgba();
        boolean $i$f$getBlue2 = false;
        return $this$blue$iv & 0xFF;
    }

    public final int getAlpha() {
        boolean $i$f$getAlpha = false;
        Companion companion = Companion;
        int $this$alpha$iv = this.getRgba();
        boolean $i$f$getAlpha2 = false;
        return $this$alpha$iv >> 24 & 0xFF;
    }

    public final float getRedFloat() {
        boolean $i$f$getRedFloat = false;
        Color this_$iv = this;
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv$iv = this_$iv.getRgba();
        boolean $i$f$getRed2 = false;
        return (float)($this$red$iv$iv >> 16 & 0xFF) / 255.0f;
    }

    public final float getGreenFloat() {
        boolean $i$f$getGreenFloat = false;
        Color this_$iv = this;
        boolean $i$f$getGreen = false;
        Companion companion = Companion;
        int $this$green$iv$iv = this_$iv.getRgba();
        boolean $i$f$getGreen2 = false;
        return (float)($this$green$iv$iv >> 8 & 0xFF) / 255.0f;
    }

    public final float getBlueFloat() {
        boolean $i$f$getBlueFloat = false;
        Color this_$iv = this;
        boolean $i$f$getBlue = false;
        Companion companion = Companion;
        int $this$blue$iv$iv = this_$iv.getRgba();
        boolean $i$f$getBlue2 = false;
        return (float)($this$blue$iv$iv & 0xFF) / 255.0f;
    }

    @NotNull
    public final String hex(boolean includeAlpha) {
        String string;
        String hexString = HexExtensionsKt.toHexString(this.getRgba(), HexFormat.Companion.getUpperCase());
        if (includeAlpha) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = hexString.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            string = stringBuilder.append(string2).append(StringsKt.take(hexString, 2)).toString();
        } else {
            String string3 = hexString.substring(2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String hex$default(Color color, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return color.hex(bl);
    }

    public final boolean isTransparent() {
        boolean $i$f$isTransparent = false;
        return this.getAlphaFloat() == 0.0f;
    }

    @NotNull
    public String toString() {
        Color this_$iv = this;
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv$iv = this_$iv.getRgba();
        boolean $i$f$getRed2 = false;
        this_$iv = this;
        boolean $i$f$getGreen = false;
        Companion this_$iv$iv = Companion;
        int $this$green$iv$iv = this_$iv.getRgba();
        boolean $i$f$getGreen2 = false;
        this_$iv = this;
        boolean $i$f$getBlue = false;
        this_$iv$iv = Companion;
        int $this$blue$iv$iv = this_$iv.getRgba();
        boolean $i$f$getBlue2 = false;
        this_$iv = this;
        boolean $i$f$getAlpha = false;
        this_$iv$iv = Companion;
        int $this$alpha$iv$iv = this_$iv.getRgba();
        boolean $i$f$getAlpha2 = false;
        return "Color(red=" + ($this$red$iv$iv >> 16 & 0xFF) + ",green=" + ($this$green$iv$iv >> 8 & 0xFF) + ",blue=" + ($this$blue$iv$iv & 0xFF) + ",alpha=" + ($this$alpha$iv$iv >> 24 & 0xFF) + ')';
    }

    public int hashCode() {
        int result = (int)this.hue;
        result = 31 * result + (int)this.saturation;
        result = 31 * result + (int)this.brightness;
        result = 31 * result + (int)this.alphaFloat;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Color) {
            return this.getRgba() == ((Color)other).getRgba();
        }
        return false;
    }

    @NotNull
    public final Color copy() {
        return new Color(this.getRgba());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\bJ#\u0010\r\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u000f\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\bJ\u0011\u0010\u0010\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0015\u001a\u00020\u0012*\u00020\u00128\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u0012*\u00020\u00128\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0019\u001a\u00020\u0012*\u00020\u00128\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0016\u0010\n\u001a\u00020\u0012*\u00020\u00128\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lxyz/meowing/vexel/utils/style/Color$Companion;", "", "<init>", "()V", "Lxyz/meowing/vexel/utils/style/Color;", "", "factor", "brighter", "(Lxyz/meowing/vexel/utils/style/Color;F)Lxyz/meowing/vexel/utils/style/Color;", "darker", "alpha", "", "newInstance", "withAlpha", "(Lxyz/meowing/vexel/utils/style/Color;FZ)Lxyz/meowing/vexel/utils/style/Color;", "multiplyAlpha", "hsbMax", "(Lxyz/meowing/vexel/utils/style/Color;)Lxyz/meowing/vexel/utils/style/Color;", "", "getRed", "(I)I", "red", "getGreen", "green", "getBlue", "blue", "getAlpha", "Vexel"})
    @SourceDebugExtension(value={"SMAP\nColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Color.kt\nxyz/meowing/vexel/utils/style/Color$Companion\n+ 2 Color.kt\nxyz/meowing/vexel/utils/style/Color\n*L\n1#1,146:1\n114#1:148\n115#1:150\n116#1:152\n114#1:154\n115#1:156\n116#1:158\n70#2:147\n71#2:149\n72#2:151\n70#2:153\n71#2:155\n72#2:157\n*S KotlinDebug\n*F\n+ 1 Color.kt\nxyz/meowing/vexel/utils/style/Color$Companion\n*L\n131#1:148\n131#1:150\n131#1:152\n139#1:154\n139#1:156\n139#1:158\n131#1:147\n131#1:149\n131#1:151\n139#1:153\n139#1:155\n139#1:157\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRed(int $this$red) {
            boolean $i$f$getRed = false;
            return $this$red >> 16 & 0xFF;
        }

        public final int getGreen(int $this$green) {
            boolean $i$f$getGreen = false;
            return $this$green >> 8 & 0xFF;
        }

        public final int getBlue(int $this$blue) {
            boolean $i$f$getBlue = false;
            return $this$blue & 0xFF;
        }

        public final int getAlpha(int $this$alpha) {
            boolean $i$f$getAlpha = false;
            return $this$alpha >> 24 & 0xFF;
        }

        @NotNull
        public final Color brighter(@NotNull Color $this$brighter, float factor) {
            Intrinsics.checkNotNullParameter($this$brighter, "<this>");
            return new Color($this$brighter.getHue(), $this$brighter.getSaturation(), RangesKt.coerceAtMost($this$brighter.getBrightness() * RangesKt.coerceAtLeast(factor, 1.0f), 1.0f), $this$brighter.getAlphaFloat());
        }

        public static /* synthetic */ Color brighter$default(Companion companion, Color color, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 1.3f;
            }
            return companion.brighter(color, f);
        }

        @NotNull
        public final Color darker(@NotNull Color $this$darker, float factor) {
            Intrinsics.checkNotNullParameter($this$darker, "<this>");
            return new Color($this$darker.getHue(), $this$darker.getSaturation(), $this$darker.getBrightness() * factor, $this$darker.getAlphaFloat());
        }

        public static /* synthetic */ Color darker$default(Companion companion, Color color, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 0.7f;
            }
            return companion.darker(color, f);
        }

        @NotNull
        public final Color withAlpha(@NotNull Color $this$withAlpha, float alpha, boolean newInstance) {
            Color color;
            Intrinsics.checkNotNullParameter($this$withAlpha, "<this>");
            if (newInstance) {
                Color this_$iv = $this$withAlpha;
                boolean $i$f$getRed = false;
                Companion companion = Companion;
                int $this$red$iv$iv = this_$iv.getRgba();
                boolean $i$f$getRed2 = false;
                this_$iv = $this$withAlpha;
                boolean $i$f$getGreen = false;
                Companion this_$iv$iv = Companion;
                int $this$green$iv$iv = this_$iv.getRgba();
                boolean $i$f$getGreen2 = false;
                this_$iv = $this$withAlpha;
                boolean $i$f$getBlue = false;
                this_$iv$iv = Companion;
                int $this$blue$iv$iv = this_$iv.getRgba();
                boolean $i$f$getBlue2 = false;
                Color color2 = new Color($this$red$iv$iv >> 16 & 0xFF, $this$green$iv$iv >> 8 & 0xFF, $this$blue$iv$iv & 0xFF, alpha);
                color = color2;
            } else {
                $this$withAlpha.setAlphaFloat(alpha);
                color = $this$withAlpha;
            }
            return color;
        }

        public static /* synthetic */ Color withAlpha$default(Companion companion, Color color, float f, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.withAlpha(color, f, bl);
        }

        @NotNull
        public final Color multiplyAlpha(@NotNull Color $this$multiplyAlpha, float factor) {
            Intrinsics.checkNotNullParameter($this$multiplyAlpha, "<this>");
            Color this_$iv = $this$multiplyAlpha;
            boolean $i$f$getRed = false;
            Companion companion = Companion;
            int $this$red$iv$iv = this_$iv.getRgba();
            boolean $i$f$getRed2 = false;
            this_$iv = $this$multiplyAlpha;
            boolean $i$f$getGreen = false;
            Companion this_$iv$iv = Companion;
            int $this$green$iv$iv = this_$iv.getRgba();
            boolean $i$f$getGreen2 = false;
            this_$iv = $this$multiplyAlpha;
            boolean $i$f$getBlue = false;
            this_$iv$iv = Companion;
            int $this$blue$iv$iv = this_$iv.getRgba();
            boolean $i$f$getBlue2 = false;
            return new Color($this$red$iv$iv >> 16 & 0xFF, $this$green$iv$iv >> 8 & 0xFF, $this$blue$iv$iv & 0xFF, RangesKt.coerceIn($this$multiplyAlpha.getAlphaFloat() * factor, 0.0f, 1.0f));
        }

        @NotNull
        public final Color hsbMax(@NotNull Color $this$hsbMax) {
            Intrinsics.checkNotNullParameter($this$hsbMax, "<this>");
            return new Color($this$hsbMax.getHue(), 1.0f, 1.0f, 0.0f, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

