/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.api.ItemAPI;
import xyz.meowing.zen.api.NEUApi;
import xyz.meowing.zen.utils.DataUtils;
import xyz.meowing.zen.utils.ItemUtils;
import xyz.meowing.zen.utils.LoopUtils;
import xyz.meowing.zen.utils.NetworkUtils;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\nJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lxyz/meowing/zen/api/ItemAPI;", "", "<init>", "()V", "isLoading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initializationComplete", "Lkotlinx/coroutines/CompletableDeferred;", "", "skyblockItemData", "Lcom/google/gson/JsonObject;", "liveAuctionData", "itemDataFile", "Lxyz/meowing/zen/utils/DataUtils;", "liveAuctionDataFile", "convertNeuItemToZen", "", "neuId", "neuData", "convertNeuPetID", "intToPetTier", "tier", "", "loadNeuRepo", "force", "", "extractRarity", "itemDescription", "updateSkyblockItemData", "loadPricingData", "getItemInfo", "itemId", "getSkyblockItems", "stack", "Lnet/minecraft/item/ItemStack;", "zen"})
@SourceDebugExtension(value={"SMAP\nItemAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemAPI.kt\nxyz/meowing/zen/api/ItemAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ItemUtils.kt\nxyz/meowing/zen/utils/ItemUtils\n*L\n1#1,253:1\n1869#2,2:254\n1#3:256\n22#4:257\n20#4:258\n*S KotlinDebug\n*F\n+ 1 ItemAPI.kt\nxyz/meowing/zen/api/ItemAPI\n*L\n99#1:254,2\n251#1:257\n251#1:258\n*E\n"})
public final class ItemAPI {
    @NotNull
    public static final ItemAPI INSTANCE = new ItemAPI();
    @NotNull
    private static final AtomicBoolean isLoading = new AtomicBoolean(false);
    @NotNull
    private static final CompletableDeferred<Unit> initializationComplete = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
    @NotNull
    private static JsonObject skyblockItemData = new JsonObject();
    @NotNull
    private static JsonObject liveAuctionData = new JsonObject();
    @NotNull
    private static final DataUtils<JsonObject> itemDataFile = new DataUtils<JsonObject>("itemData", new JsonObject());
    @NotNull
    private static final DataUtils<JsonObject> liveAuctionDataFile = new DataUtils<JsonObject>("liveAuctionData", new JsonObject());

    private ItemAPI() {
    }

    @NotNull
    public final String convertNeuItemToZen(@NotNull String neuId, @NotNull JsonObject neuData) {
        Intrinsics.checkNotNullParameter(neuId, "neuId");
        Intrinsics.checkNotNullParameter(neuData, "neuData");
        String newId = neuId;
        if (StringsKt.contains$default((CharSequence)newId, ";", false, 2, null)) {
            String string = neuData.get("displayname").getAsString();
            Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
            if (StringsKt.contains$default((CharSequence)string, "[Lvl", false, 2, null)) {
                newId = this.convertNeuPetID(neuId);
            }
            if (Intrinsics.areEqual(neuData.get("itemid").getAsString(), "minecraft:enchanted_book")) {
                newId = "ENCHANTMENT_" + StringsKt.replace$default(newId, ";", "_", false, 4, null);
            }
        }
        return newId;
    }

    @NotNull
    public final String convertNeuPetID(@NotNull String neuId) {
        Intrinsics.checkNotNullParameter(neuId, "neuId");
        String[] stringArray = new String[]{";"};
        List parts = StringsKt.split$default((CharSequence)neuId, stringArray, false, 0, 6, null);
        return (String)parts.get(0) + '-' + this.intToPetTier(Integer.parseInt((String)parts.get(1)));
    }

    @NotNull
    public final String intToPetTier(int tier) {
        String string;
        switch (tier) {
            case 5: {
                string = "MYTHIC";
                break;
            }
            case 4: {
                string = "LEGENDARY";
                break;
            }
            case 3: {
                string = "EPIC";
                break;
            }
            case 2: {
                string = "RARE";
                break;
            }
            case 1: {
                string = "UNCOMMON";
                break;
            }
            case 0: {
                string = "COMMON";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    private final void loadNeuRepo(boolean force) {
        Zen.LOGGER.info("Loading Skyblock Items from NEU Repo..");
        skyblockItemData = new JsonObject();
        try {
            NEUApi.INSTANCE.downloadAndProcessRepo(force);
            Set set = NEUApi.INSTANCE.getNeuItemData().getData().entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "entrySet(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                String string = (String)k;
                JsonObject jsonObject = ((JsonElement)it.getValue()).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
                String newKey = INSTANCE.convertNeuItemToZen(string, jsonObject);
                ((JsonElement)it.getValue()).getAsJsonObject().addProperty("sbtID", newKey);
                if (((JsonElement)it.getValue()).getAsJsonObject().has("lore")) {
                    JsonArray lore = ((JsonElement)it.getValue()).getAsJsonObject().get("lore").getAsJsonArray();
                    Intrinsics.checkNotNull(lore);
                    Iterable iterable = CollectionsKt.reversed((Iterable)lore);
                    for (Object t : iterable) {
                        boolean bl2;
                        JsonElement loreEntry = (JsonElement)t;
                        boolean bl3 = false;
                        String string2 = loreEntry.getAsString();
                        Intrinsics.checkNotNullExpressionValue(string2, "getAsString(...)");
                        String rarity = INSTANCE.extractRarity(string2);
                        if (rarity != null) {
                            ((JsonElement)it.getValue()).getAsJsonObject().addProperty("rarity", rarity);
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                    }
                }
                skyblockItemData.add(newKey, (JsonElement)it.getValue());
            }
            Zen.LOGGER.info("Loaded Skyblock Items from NEU Repo!");
        }
        catch (Exception e) {
            Zen.LOGGER.error("There was a problem loading NEU Repo.. " + e.getMessage());
        }
    }

    @Nullable
    public final String extractRarity(@NotNull String itemDescription) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(itemDescription, "itemDescription");
            String[] stringArray = new String[]{"SUPREME", "VERY_SPECIAL", "SPECIAL", "DIVINE", "MYTHIC", "LEGENDARY", "EPIC", "RARE", "UNCOMMON", "COMMON"};
            List<String> rarities = CollectionsKt.listOf(stringArray);
            Iterable iterable = rarities;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)itemDescription, it, true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void updateSkyblockItemData(boolean force) {
        if (!isLoading.compareAndSet(false, true)) {
            return;
        }
        BuildersKt.launch$default(Zen.Companion.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(force, null){
            int label;
            final /* synthetic */ boolean $force;
            {
                this.$force = $force;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay(5000L, this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        try {
                            Zen.LOGGER.info("Updating Skyblock Item Data..");
                            if (this.$force) {
                                ItemAPI.access$setSkyblockItemData$p(new JsonObject());
                            }
                            if (ItemAPI.access$getSkyblockItemData$p().entrySet().isEmpty()) {
                                ItemAPI.access$loadNeuRepo(ItemAPI.INSTANCE, this.$force);
                            }
                            ItemAPI.access$loadPricingData(ItemAPI.INSTANCE);
                            ItemAPI.access$getItemDataFile$p().setData(ItemAPI.access$getSkyblockItemData$p());
                            ItemAPI.access$getLiveAuctionDataFile$p().setData(ItemAPI.access$getLiveAuctionData$p());
                            ItemAPI.access$getItemDataFile$p().save();
                            ItemAPI.access$getLiveAuctionDataFile$p().save();
                            if (!ItemAPI.access$getInitializationComplete$p().isCompleted()) {
                                ItemAPI.access$getInitializationComplete$p().complete(Unit.INSTANCE);
                            }
                        }
                        finally {
                            ItemAPI.access$isLoading$p().set(false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public static /* synthetic */ void updateSkyblockItemData$default(ItemAPI itemAPI, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        itemAPI.updateSkyblockItemData(bl);
    }

    private final void loadPricingData() {
        Zen.LOGGER.info("Loading Lowest Item Prices from SBT API");
        try {
            NetworkUtils.getJson$default(NetworkUtils.INSTANCE, "https://zen.mrfast-developer.com/pricingData", null, loadPricingData.1.INSTANCE, loadPricingData.2.INSTANCE, 2, null);
            NetworkUtils.getJson$default(NetworkUtils.INSTANCE, "https://zen.mrfast-developer.com/liveAuctions", null, loadPricingData.3.INSTANCE, loadPricingData.4.INSTANCE, 2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Zen.LOGGER.error("There was a problem loading SBT Pricing Data..");
        }
    }

    @Nullable
    public final JsonObject getItemInfo(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = ItemAPI.access$getInitializationComplete$p().await(this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        JsonElement jsonElement = skyblockItemData.get(itemId);
        return jsonElement != null ? jsonElement.getAsJsonObject() : null;
    }

    @NotNull
    public final JsonObject getSkyblockItems() {
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = ItemAPI.access$getInitializationComplete$p().await(this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return skyblockItemData;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsonObject getItemInfo(@NotNull ItemStack stack) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(stack, "stack");
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = ItemAPI.access$getInitializationComplete$p().await(this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        ItemUtils itemUtils = ItemUtils.INSTANCE;
        ItemStack $this$skyblockID$iv = stack;
        boolean $i$f$getSkyblockID = false;
        void var5_5 = this_$iv;
        ItemStack $this$extraAttributes$iv$iv = $this$skyblockID$iv;
        boolean $i$f$getExtraAttributes = false;
        Object object = $this$extraAttributes$iv$iv.func_179543_a("ExtraAttributes", false);
        if (object == null || (object = object.func_74779_i("id")) == null) {
            object = "";
        }
        Object it = object;
        boolean bl = false;
        JsonElement jsonElement = skyblockItemData.get((String)it);
        return jsonElement != null ? jsonElement.getAsJsonObject() : null;
    }

    public static final /* synthetic */ void access$loadNeuRepo(ItemAPI $this, boolean force) {
        $this.loadNeuRepo(force);
    }

    public static final /* synthetic */ void access$loadPricingData(ItemAPI $this) {
        $this.loadPricingData();
    }

    public static final /* synthetic */ JsonObject access$getLiveAuctionData$p() {
        return liveAuctionData;
    }

    static {
        BuildersKt.launch$default(Zen.Companion.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            @Override
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        Set set = ((JsonObject)itemDataFile.getData()).entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, "entrySet(...)");
                        if (!((Collection)set).isEmpty()) {
                            skyblockItemData = (JsonObject)itemDataFile.getData();
                        }
                        Set set2 = ((JsonObject)liveAuctionDataFile.getData()).entrySet();
                        Intrinsics.checkNotNullExpressionValue(set2, "entrySet(...)");
                        if (!((Collection)set2).isEmpty()) {
                            liveAuctionData = (JsonObject)liveAuctionDataFile.getData();
                        }
                        NEUApi.downloadAndProcessRepo$default(NEUApi.INSTANCE, false, 1, null);
                        Zen.LOGGER.info("Loaded " + skyblockItemData.entrySet().size() + " Items from saved data file");
                        if (skyblockItemData.entrySet().isEmpty()) {
                            INSTANCE.updateSkyblockItemData(false);
                        } else {
                            initializationComplete.complete(Unit.INSTANCE);
                            BuildersKt.launch$default(Zen.Companion.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                int label;

                                @Override
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            INSTANCE.updateSkyblockItemData(false);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @Override
                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Override
                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        LoopUtils.loop$default(LoopUtils.INSTANCE, 600000L, null, (Function0)2.INSTANCE, 2, null);
    }
}

