/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.elements;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.config.ui.core.CustomFontProvider;
import xyz.meowing.zen.deps.gg.essential.elementa.UIComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.UIConstraints;
import xyz.meowing.zen.deps.gg.essential.elementa.components.UIContainer;
import xyz.meowing.zen.deps.gg.essential.elementa.components.input.UITextInput;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.CenterConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.SiblingConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.animation.AnimatingConstraints;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.animation.Animations;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.ComponentsKt;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.ConstraintsKt;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.UtilitiesKt;
import xyz.meowing.zen.deps.gg.essential.elementa.events.UIClickEvent;
import xyz.meowing.zen.utils.Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001BG\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/meowing/zen/config/ui/elements/SliderElement;", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/UIContainer;", "min", "", "max", "initialValue", "showDouble", "", "onChange", "Lkotlin/Function1;", "", "<init>", "(DDDZLkotlin/jvm/functions/Function1;)V", "value", "sliderContainer", "Lxyz/meowing/zen/deps/gg/essential/elementa/UIComponent;", "textContainer", "progress", "input", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/input/UITextInput;", "formatDisplayValue", "", "setupHoverEffects", "setupMouseHandlers", "setupInputHandlers", "processInputValue", "updateSliderValue", "percent", "", "getValue", "setValue", "newValue", "zen"})
@SourceDebugExtension(value={"SMAP\nSliderElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SliderElement.kt\nxyz/meowing/zen/config/ui/elements/SliderElement\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 animations.kt\ngg/essential/elementa/dsl/AnimationsKt\n*L\n1#1,179:1\n9#2,3:180\n9#2,3:183\n9#2,3:186\n9#2,3:189\n10#3,5:192\n10#3,5:197\n*S KotlinDebug\n*F\n+ 1 SliderElement.kt\nxyz/meowing/zen/config/ui/elements/SliderElement\n*L\n32#1:180,3\n39#1:183,3\n47#1:186,3\n54#1:189,3\n160#1:192,5\n173#1:197,5\n*E\n"})
public final class SliderElement
extends UIContainer {
    private final double min;
    private final double max;
    private final boolean showDouble;
    @Nullable
    private final Function1<Double, Unit> onChange;
    private double value;
    @NotNull
    private final UIComponent sliderContainer;
    @NotNull
    private final UIComponent textContainer;
    @NotNull
    private final UIComponent progress;
    @NotNull
    private final UITextInput input;

    /*
     * WARNING - void declaration
     */
    public SliderElement(double min, double max, double initialValue, boolean showDouble, @Nullable Function1<? super Double, Unit> onChange) {
        void $this$_init__u24lambda_u243;
        UIComponent uIComponent;
        void $this$_init__u24lambda_u242;
        void $this$_init__u24lambda_u241;
        UIConstraints $this$_init__u24lambda_u240;
        UIComponent uIComponent2;
        this.min = min;
        this.max = max;
        this.showDouble = showDouble;
        this.onChange = onChange;
        this.value = Math.max(this.min, Math.min(this.max, initialValue));
        UIComponent $this$constrain$iv = Utils.INSTANCE.createBlock(3.0f);
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        SliderElement sliderElement = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setX(UtilitiesKt.pixels$default(0, false, false, 3, null));
        $this$_init__u24lambda_u240.setY(new CenterConstraint());
        $this$_init__u24lambda_u240.setWidth(UtilitiesKt.percent(85));
        $this$_init__u24lambda_u240.setHeight(UtilitiesKt.percent(60));
        sliderElement.sliderContainer = ComponentsKt.childOf(uIComponent2.setColor(new Color(18, 24, 28, 255)), this);
        $this$constrain$iv = Utils.INSTANCE.createBlock(3.0f);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv;
        bl = false;
        $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        sliderElement = this;
        boolean $i$a$-constrain-SliderElement$52 = false;
        $this$_init__u24lambda_u241.setX(new SiblingConstraint(5.0f, false, 2, null));
        $this$_init__u24lambda_u241.setY(new CenterConstraint());
        $this$_init__u24lambda_u241.setWidth(ConstraintsKt.minus(UtilitiesKt.percent(15), UtilitiesKt.getPixels(5)));
        $this$_init__u24lambda_u241.setHeight(UtilitiesKt.percent(80));
        sliderElement.textContainer = ComponentsKt.childOf(uIComponent2.setColor(new Color(18, 24, 28, 255)), this);
        float initialPercent = (float)(this.value - this.min) / (float)(this.max - this.min);
        UIComponent $this$constrain$iv2 = Utils.INSTANCE.createBlock(3.0f);
        boolean $i$f$constrain2 = false;
        UIComponent $this$constrain_u24lambda_u240$iv2 = $this$constrain_u24lambda_u240$iv = $this$constrain$iv2;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $i$a$-constrain-SliderElement$52 = $this$constrain_u24lambda_u240$iv2.getConstraints();
        sliderElement = this;
        boolean $i$a$-constrain-SliderElement$62 = false;
        $this$_init__u24lambda_u242.setX(UtilitiesKt.percent(0));
        $this$_init__u24lambda_u242.setY(UtilitiesKt.percent(0));
        $this$_init__u24lambda_u242.setWidth(UtilitiesKt.percent(Float.valueOf(initialPercent * (float)100)));
        $this$_init__u24lambda_u242.setHeight(UtilitiesKt.percent(100));
        sliderElement.progress = ComponentsKt.childOf($this$constrain_u24lambda_u240$iv.setColor(new Color(100, 245, 255, 255)), this.sliderContainer);
        UIComponent $this$constrain$iv3 = new UITextInput(this.formatDisplayValue(this.value), false, null, null, false, null, null, null, 254, null);
        boolean $i$f$constrain3 = false;
        UIComponent $this$constrain_u24lambda_u240$iv3 = uIComponent = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $i$a$-constrain-SliderElement$62 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        sliderElement = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u243.setX(new CenterConstraint());
        $this$_init__u24lambda_u243.setY(new CenterConstraint());
        $this$_init__u24lambda_u243.setWidth(UtilitiesKt.pixels$default(Zen.Companion.getMc().field_71466_p.func_78256_a(this.formatDisplayValue(this.value)), false, false, 3, null));
        UIComponent uIComponent3 = ComponentsKt.childOf(((UITextInput)uIComponent).setColor(new Color(170, 230, 240, 255)).setFontProvider(CustomFontProvider.INSTANCE), this.textContainer);
        Intrinsics.checkNotNull(uIComponent3, "null cannot be cast to non-null type gg.essential.elementa.components.input.UITextInput");
        sliderElement.input = (UITextInput)uIComponent3;
        this.setupMouseHandlers();
        this.setupInputHandlers();
        this.setupHoverEffects();
    }

    public /* synthetic */ SliderElement(double d, double d2, double d3, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 100.0;
        }
        if ((n & 4) != 0) {
            d3 = 50.0;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        this(d, d2, d3, bl, function1);
    }

    private final String formatDisplayValue(double value) {
        return !this.showDouble && value == (double)((int)value) ? String.valueOf((int)value) : String.valueOf(value);
    }

    private final void setupHoverEffects() {
        this.sliderContainer.onMouseEnter((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(UIComponent $this$onMouseEnter) {
                AnimatingConstraints anim$iv;
                UIComponent uIComponent;
                Intrinsics.checkNotNullParameter($this$onMouseEnter, "$this$onMouseEnter");
                UIComponent $this$animate$iv = SliderElement.access$getSliderContainer$p(this.this$0);
                boolean $i$f$animate = false;
                UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.OUT_EXP, 0.3f, UtilitiesKt.toConstraint(new Color(28, 34, 38, 255)), 0.0f, 8, null);
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        });
        this.sliderContainer.onMouseLeave((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(UIComponent $this$onMouseLeave) {
                AnimatingConstraints anim$iv;
                UIComponent uIComponent;
                Intrinsics.checkNotNullParameter($this$onMouseLeave, "$this$onMouseLeave");
                UIComponent $this$animate$iv = SliderElement.access$getSliderContainer$p(this.this$0);
                boolean $i$f$animate = false;
                UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.OUT_EXP, 0.3f, UtilitiesKt.toConstraint(new Color(18, 24, 28, 255)), 0.0f, 8, null);
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        });
        this.textContainer.onMouseEnter((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(UIComponent $this$onMouseEnter) {
                AnimatingConstraints anim$iv;
                UIComponent uIComponent;
                Intrinsics.checkNotNullParameter($this$onMouseEnter, "$this$onMouseEnter");
                UIComponent $this$animate$iv = SliderElement.access$getTextContainer$p(this.this$0);
                boolean $i$f$animate = false;
                UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.OUT_EXP, 0.3f, UtilitiesKt.toConstraint(new Color(28, 34, 38, 255)), 0.0f, 8, null);
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        });
        this.textContainer.onMouseLeave((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(UIComponent $this$onMouseLeave) {
                AnimatingConstraints anim$iv;
                UIComponent uIComponent;
                Intrinsics.checkNotNullParameter($this$onMouseLeave, "$this$onMouseLeave");
                UIComponent $this$animate$iv = SliderElement.access$getTextContainer$p(this.this$0);
                boolean $i$f$animate = false;
                UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.OUT_EXP, 0.3f, UtilitiesKt.toConstraint(new Color(18, 24, 28, 255)), 0.0f, 8, null);
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        });
        this.textContainer.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(UIComponent $this$onMouseClick, UIClickEvent it) {
                Intrinsics.checkNotNullParameter($this$onMouseClick, "$this$onMouseClick");
                Intrinsics.checkNotNullParameter(it, "it");
                SliderElement.access$getInput$p(this.this$0).setText(SliderElement.access$formatDisplayValue(this.this$0, SliderElement.access$getValue$p(this.this$0)));
                SliderElement.access$getInput$p(this.this$0).grabWindowFocus();
            }
        });
    }

    private final void setupMouseHandlers() {
        this.sliderContainer.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void invoke(UIComponent $this$onMouseClick, UIClickEvent event) {
                Intrinsics.checkNotNullParameter($this$onMouseClick, "$this$onMouseClick");
                Intrinsics.checkNotNullParameter(event, "event");
                float f = SliderElement.access$getSliderContainer$p(this.this$0).getWidth();
                float f2 = event.getRelativeX();
                if (!(0.0f <= f2)) return;
                if (!(f2 <= f)) return;
                boolean bl = true;
                if (!bl) return;
                f = SliderElement.access$getSliderContainer$p(this.this$0).getHeight();
                f2 = event.getRelativeY();
                if (!(0.0f <= f2)) return;
                if (!(f2 <= f)) return;
                boolean bl2 = true;
                if (!bl2) return;
                boolean bl3 = true;
                boolean withinBounds = bl3;
                if (!withinBounds) {
                    return;
                }
                SliderElement.access$setupMouseHandlers$updateSliderPosition(this.this$0, event.getRelativeX());
            }
        });
        this.sliderContainer.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)new Function4<UIComponent, Float, Float, Integer, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void invoke(UIComponent $this$onMouseDrag, float x, float y, int n) {
                Intrinsics.checkNotNullParameter($this$onMouseDrag, "$this$onMouseDrag");
                if (!(0.0f <= x)) return;
                if (!(x <= SliderElement.access$getSliderContainer$p(this.this$0).getWidth())) return;
                boolean bl = true;
                if (!bl) return;
                if (!(-5.0f <= y)) return;
                if (!(y <= SliderElement.access$getSliderContainer$p(this.this$0).getHeight() + 5.0f)) return;
                boolean bl2 = true;
                if (!bl2) return;
                boolean bl3 = true;
                boolean withinBounds = bl3;
                if (!withinBounds) {
                    return;
                }
                SliderElement.access$setupMouseHandlers$updateSliderPosition(this.this$0, x);
            }
        });
    }

    private final void setupInputHandlers() {
        this.input.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)new Function3<UIComponent, Character, Integer, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(UIComponent $this$onKeyType, char c, int n) {
                Intrinsics.checkNotNullParameter($this$onKeyType, "$this$onKeyType");
                SliderElement.access$processInputValue(this.this$0);
                SliderElement.access$getInput$p(this.this$0).setWidth(UtilitiesKt.pixels$default(Zen.Companion.getMc().field_71466_p.func_78256_a(SliderElement.access$formatDisplayValue(this.this$0, SliderElement.access$getValue$p(this.this$0))), false, false, 3, null));
            }
        });
        this.input.onFocusLost((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ SliderElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(UIComponent $this$onFocusLost) {
                Intrinsics.checkNotNullParameter($this$onFocusLost, "$this$onFocusLost");
                SliderElement.access$processInputValue(this.this$0);
                SliderElement.access$getInput$p(this.this$0).setWidth(UtilitiesKt.pixels$default(Zen.Companion.getMc().field_71466_p.func_78256_a(SliderElement.access$formatDisplayValue(this.this$0, SliderElement.access$getValue$p(this.this$0))), false, false, 3, null));
            }
        });
    }

    private final void processInputValue() {
        String inputText = ((Object)StringsKt.trim((CharSequence)this.input.getText())).toString();
        if (((CharSequence)inputText).length() == 0) {
            this.setValue(this.min);
            return;
        }
        Double newValue = StringsKt.toDoubleOrNull(inputText);
        if (newValue != null) {
            double constrainedValue = Math.max(this.min, Math.min(this.max, newValue));
            this.setValue(constrainedValue);
            if (!Intrinsics.areEqual(constrainedValue, newValue)) {
                this.input.setText(this.formatDisplayValue(constrainedValue));
            }
        } else {
            this.input.setText(this.formatDisplayValue(this.value));
        }
    }

    private final void updateSliderValue(float percent2) {
        AnimatingConstraints anim$iv;
        UIComponent uIComponent;
        float clampedPercent = RangesKt.coerceIn(percent2, 0.0f, 1.0f);
        double rawValue = this.min + (this.max - this.min) * (double)clampedPercent;
        double newValue = this.showDouble ? Math.rint(rawValue * (double)10) / 10.0 : Math.rint(rawValue);
        if (!(newValue == this.value)) {
            this.value = newValue;
            this.input.setText(this.formatDisplayValue(this.value));
            this.input.setWidth(UtilitiesKt.pixels$default(Zen.Companion.getMc().field_71466_p.func_78256_a(this.formatDisplayValue(this.value)), false, false, 3, null));
            Function1<Double, Unit> function1 = this.onChange;
            if (function1 != null) {
                function1.invoke(this.value);
            }
        }
        UIComponent $this$animate$iv = this.progress;
        boolean $i$f$animate = false;
        UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
        boolean bl = false;
        AnimatingConstraints $this$updateSliderValue_u24lambda_u244 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
        boolean bl2 = false;
        AnimatingConstraints.setWidthAnimation$default($this$updateSliderValue_u24lambda_u244, Animations.OUT_EXP, 0.5f, UtilitiesKt.percent(Float.valueOf(clampedPercent * (float)100)), 0.0f, 8, null);
        $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double newValue) {
        block1: {
            AnimatingConstraints anim$iv;
            UIComponent uIComponent;
            double clampedValue = Math.max(this.min, Math.min(this.max, newValue));
            if (clampedValue == this.value) break block1;
            this.value = clampedValue;
            this.input.setText(this.formatDisplayValue(this.value));
            float percent2 = (float)(this.value - this.min) / (float)(this.max - this.min);
            UIComponent $this$animate$iv = this.progress;
            boolean $i$f$animate = false;
            UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
            boolean bl = false;
            AnimatingConstraints $this$setValue_u24lambda_u245 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
            boolean bl2 = false;
            AnimatingConstraints.setWidthAnimation$default($this$setValue_u24lambda_u245, Animations.OUT_EXP, 0.5f, UtilitiesKt.percent(Float.valueOf(percent2 * (float)100)), 0.0f, 8, null);
            $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            Function1<Double, Unit> function1 = this.onChange;
            if (function1 != null) {
                function1.invoke(this.value);
            }
        }
    }

    private static final void setupMouseHandlers$updateSliderPosition(SliderElement this$0, float mouseX) {
        float clamped = RangesKt.coerceIn(mouseX, 0.0f, this$0.sliderContainer.getWidth());
        float percent2 = clamped / this$0.sliderContainer.getWidth();
        this$0.updateSliderValue(percent2);
    }

    public SliderElement() {
        this(0.0, 0.0, 0.0, false, null, 31, null);
    }

    public static final /* synthetic */ UIComponent access$getSliderContainer$p(SliderElement $this) {
        return $this.sliderContainer;
    }

    public static final /* synthetic */ UIComponent access$getTextContainer$p(SliderElement $this) {
        return $this.textContainer;
    }

    public static final /* synthetic */ UITextInput access$getInput$p(SliderElement $this) {
        return $this.input;
    }

    public static final /* synthetic */ String access$formatDisplayValue(SliderElement $this, double value) {
        return $this.formatDisplayValue(value);
    }

    public static final /* synthetic */ double access$getValue$p(SliderElement $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setupMouseHandlers$updateSliderPosition(SliderElement this$0, float mouseX) {
        SliderElement.setupMouseHandlers$updateSliderPosition(this$0, mouseX);
    }

    public static final /* synthetic */ void access$processInputValue(SliderElement $this) {
        $this.processInputValue();
    }
}

