/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.types;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.config.ui.elements.MCColorCode;
import xyz.meowing.zen.utils.Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00018\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H&R\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "validate", "input", "(Ljava/lang/Object;)Ljava/lang/Object;", "serialize", "BooleanValue", "IntValue", "DoubleValue", "StringValue", "ColorValue", "SetValue", "MCColorCodeValue", "Lxyz/meowing/zen/config/ui/types/ConfigValue$BooleanValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$ColorValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$DoubleValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$IntValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$MCColorCodeValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$SetValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue$StringValue;", "zen"})
public abstract class ConfigValue<T> {
    private final T value;

    private ConfigValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Nullable
    public abstract T validate(@Nullable Object var1);

    @NotNull
    public abstract Object serialize();

    public /* synthetic */ ConfigValue(Object value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$BooleanValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "", "value", "<init>", "(Z)V", "getValue", "()Ljava/lang/Boolean;", "validate", "input", "", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "serialize", "zen"})
    public static final class BooleanValue
    extends ConfigValue<Boolean> {
        private final boolean value;

        public BooleanValue(boolean value) {
            super(value, null);
            this.value = value;
        }

        @Override
        @NotNull
        public Boolean getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Boolean validate(@Nullable Object input) {
            return input instanceof Boolean ? (Boolean)input : null;
        }

        @Override
        @NotNull
        public Boolean serialize() {
            return this.getValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$ColorValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "Ljava/awt/Color;", "value", "<init>", "(Ljava/awt/Color;)V", "getValue", "()Ljava/awt/Color;", "validate", "input", "", "serialize", "", "", "", "zen"})
    public static final class ColorValue
    extends ConfigValue<Color> {
        @NotNull
        private final Color value;

        public ColorValue(@NotNull Color value) {
            Intrinsics.checkNotNullParameter(value, "value");
            super(value, null);
            this.value = value;
        }

        @Override
        @NotNull
        public Color getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Color validate(@Nullable Object input) {
            Object object = input;
            return object instanceof Color ? (Color)input : (object instanceof Map ? Utils.INSTANCE.toColorFromMap((Map)input) : (object instanceof List ? Utils.INSTANCE.toColorFromList((List)input) : (object instanceof Number ? new Color(((Number)input).intValue(), true) : null)));
        }

        @Override
        @NotNull
        public Map<String, Integer> serialize() {
            Pair[] pairArray = new Pair[]{TuplesKt.to("r", this.getValue().getRed()), TuplesKt.to("g", this.getValue().getGreen()), TuplesKt.to("b", this.getValue().getBlue()), TuplesKt.to("a", this.getValue().getAlpha())};
            return MapsKt.mapOf(pairArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$DoubleValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "", "value", "min", "max", "<init>", "(DDD)V", "getValue", "()Ljava/lang/Double;", "validate", "input", "", "(Ljava/lang/Object;)Ljava/lang/Double;", "serialize", "zen"})
    public static final class DoubleValue
    extends ConfigValue<Double> {
        private final double value;
        private final double min;
        private final double max;

        public DoubleValue(double value, double min, double max) {
            super(value, null);
            this.value = value;
            this.min = min;
            this.max = max;
        }

        public /* synthetic */ DoubleValue(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d2 = Double.NEGATIVE_INFINITY;
            }
            if ((n & 4) != 0) {
                d3 = Double.POSITIVE_INFINITY;
            }
            this(d, d2, d3);
        }

        @Override
        @NotNull
        public Double getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Double validate(@Nullable Object input) {
            Number number = input instanceof Number ? (Number)((Number)input) : (Number)null;
            return number != null ? Double.valueOf(RangesKt.coerceIn(number.doubleValue(), this.min, this.max)) : null;
        }

        @Override
        @NotNull
        public Double serialize() {
            return this.getValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$IntValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "", "value", "min", "max", "<init>", "(III)V", "getValue", "()Ljava/lang/Integer;", "validate", "input", "", "(Ljava/lang/Object;)Ljava/lang/Integer;", "serialize", "zen"})
    public static final class IntValue
    extends ConfigValue<Integer> {
        private final int value;
        private final int min;
        private final int max;

        public IntValue(int value, int min, int max) {
            super(value, null);
            this.value = value;
            this.min = min;
            this.max = max;
        }

        public /* synthetic */ IntValue(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 2) != 0) {
                n2 = Integer.MIN_VALUE;
            }
            if ((n4 & 4) != 0) {
                n3 = Integer.MAX_VALUE;
            }
            this(n, n2, n3);
        }

        @Override
        @NotNull
        public Integer getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Integer validate(@Nullable Object input) {
            Integer n;
            if (input instanceof Integer) {
                n = RangesKt.coerceIn(((Number)input).intValue(), this.min, this.max);
            } else {
                Number number = input instanceof Number ? (Number)((Number)input) : (Number)null;
                n = number != null ? Integer.valueOf(RangesKt.coerceIn(number.intValue(), this.min, this.max)) : null;
            }
            return n;
        }

        @Override
        @NotNull
        public Integer serialize() {
            return this.getValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$MCColorCodeValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "Lxyz/meowing/zen/config/ui/elements/MCColorCode;", "value", "<init>", "(Lxyz/meowing/zen/config/ui/elements/MCColorCode;)V", "getValue", "()Lxyz/meowing/zen/config/ui/elements/MCColorCode;", "validate", "input", "", "serialize", "", "zen"})
    @SourceDebugExtension(value={"SMAP\nConfigValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigValue.kt\nxyz/meowing/zen/config/ui/types/ConfigValue$MCColorCodeValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class MCColorCodeValue
    extends ConfigValue<MCColorCode> {
        @NotNull
        private final MCColorCode value;

        public MCColorCodeValue(@NotNull MCColorCode value) {
            Intrinsics.checkNotNullParameter((Object)value, "value");
            super((Object)value, null);
            this.value = value;
        }

        @Override
        @NotNull
        public MCColorCode getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public MCColorCode validate(@Nullable Object input) {
            MCColorCode mCColorCode;
            Object object = input;
            if (object instanceof String) {
                Object v0;
                block3: {
                    Iterable iterable = MCColorCode.getEntries();
                    for (Object t : iterable) {
                        MCColorCode it = (MCColorCode)((Object)t);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getCode(), input)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                mCColorCode = v0;
            } else {
                mCColorCode = object instanceof MCColorCode ? (MCColorCode)((Object)input) : null;
            }
            return mCColorCode;
        }

        @Override
        @NotNull
        public String serialize() {
            return this.getValue().getCode();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$SetValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "", "", "value", "minValue", "maxValue", "<init>", "(Ljava/util/Set;II)V", "getValue", "()Ljava/util/Set;", "validate", "input", "", "serialize", "zen"})
    @SourceDebugExtension(value={"SMAP\nConfigValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigValue.kt\nxyz/meowing/zen/config/ui/types/ConfigValue$SetValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n774#2:100\n865#2,2:101\n1617#2,9:103\n1869#2:112\n1870#2:114\n1626#2:115\n774#2:116\n865#2,2:117\n774#2:132\n865#2,2:133\n1#3:97\n1#3:113\n1#3:129\n11546#4,9:119\n13472#4:128\n13473#4:130\n11555#4:131\n*S KotlinDebug\n*F\n+ 1 ConfigValue.kt\nxyz/meowing/zen/config/ui/types/ConfigValue$SetValue\n*L\n69#1:87,9\n69#1:96\n69#1:98\n69#1:99\n69#1:100\n69#1:101,2\n70#1:103,9\n70#1:112\n70#1:114\n70#1:115\n70#1:116\n70#1:117,2\n71#1:132\n71#1:133,2\n69#1:97\n70#1:113\n71#1:129\n71#1:119,9\n71#1:128\n71#1:130\n71#1:131\n*E\n"})
    public static final class SetValue
    extends ConfigValue<Set<? extends Integer>> {
        @NotNull
        private final Set<Integer> value;
        private final int minValue;
        private final int maxValue;

        public SetValue(@NotNull Set<Integer> value, int minValue, int maxValue) {
            Intrinsics.checkNotNullParameter(value, "value");
            super(value, null);
            this.value = value;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public /* synthetic */ SetValue(Set set, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = Integer.MAX_VALUE;
            }
            this(set, n, n2);
        }

        @Override
        @NotNull
        public Set<Integer> getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Set<Integer> validate(@Nullable Object input) {
            Set set;
            Object object = input;
            if (object instanceof List) {
                void $this$filterTo$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)input;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Integer it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Object it = element$iv$iv2;
                    boolean bl22 = false;
                    Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                    if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    int it = ((Number)t).intValue();
                    boolean bl3 = false;
                    int element$iv$iv2 = this.minValue;
                    boolean bl4 = it <= this.maxValue ? element$iv$iv2 <= it : false;
                    if (!bl4) continue;
                    destination$iv$iv.add(t);
                }
                set = CollectionsKt.toSet((List)destination$iv$iv);
            } else if (object instanceof Set) {
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)input;
                boolean $i$f$mapNotNull = false;
                Iterable $this$filterTo$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                Iterator it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Integer it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv3 = element$iv$iv$iv = it.next();
                    boolean bl5 = false;
                    Object it2 = element$iv$iv3;
                    boolean bl52 = false;
                    Number number = it2 instanceof Number ? (Number)((Number)it2) : (Number)null;
                    if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    int it3 = ((Number)t).intValue();
                    boolean bl6 = false;
                    int element$iv$iv3 = this.minValue;
                    boolean bl7 = it3 <= this.maxValue ? element$iv$iv3 <= it3 : false;
                    if (!bl7) continue;
                    destination$iv$iv.add(t);
                }
                set = CollectionsKt.toSet((List)destination$iv$iv);
            } else if (object instanceof Object[]) {
                Iterable $this$mapNotNullTo$iv$iv;
                Object[] $this$mapNotNull$iv = (Object[])input;
                boolean $i$f$mapNotNull = false;
                Object[] $this$filterTo$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                int bl6 = ((void)$this$forEach$iv$iv$iv).length;
                for (int it3 = 0; it3 < bl6; ++it3) {
                    Integer it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[it3];
                    boolean bl8 = false;
                    void it = element$iv$iv;
                    boolean bl9 = false;
                    Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                    if ((number != null ? Integer.valueOf(number.intValue()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl10 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    int it = ((Number)t).intValue();
                    boolean bl11 = false;
                    int n = this.minValue;
                    boolean bl8 = it <= this.maxValue ? n <= it : false;
                    if (!bl8) continue;
                    destination$iv$iv.add(t);
                }
                set = CollectionsKt.toSet((List)destination$iv$iv);
            } else {
                set = null;
            }
            return set;
        }

        @Override
        @NotNull
        public Set<Integer> serialize() {
            return this.getValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/meowing/zen/config/ui/types/ConfigValue$StringValue;", "Lxyz/meowing/zen/config/ui/types/ConfigValue;", "", "value", "maxLength", "", "<init>", "(Ljava/lang/String;I)V", "getValue", "()Ljava/lang/String;", "validate", "input", "", "serialize", "zen"})
    public static final class StringValue
    extends ConfigValue<String> {
        @NotNull
        private final String value;
        private final int maxLength;

        public StringValue(@NotNull String value, int maxLength) {
            Intrinsics.checkNotNullParameter(value, "value");
            super(value, null);
            this.value = value;
            this.maxLength = maxLength;
        }

        public /* synthetic */ StringValue(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = Integer.MAX_VALUE;
            }
            this(string, n);
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public String validate(@Nullable Object input) {
            String string = input instanceof String ? (String)input : null;
            return string != null ? StringsKt.take(string, this.maxLength) : null;
        }

        @Override
        @NotNull
        public String serialize() {
            return this.getValue();
        }
    }
}

