/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.components.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.zen.deps.gg.essential.elementa.UIComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.components.UIImage;
import xyz.meowing.zen.deps.gg.essential.elementa.components.image.ImageProvider;
import xyz.meowing.zen.deps.gg.essential.elementa.utils.ImageKt;
import xyz.meowing.zen.deps.gg.essential.universal.UGraphics;
import xyz.meowing.zen.deps.gg.essential.universal.UMatrixStack;
import xyz.meowing.zen.deps.gg.essential.universal.utils.ReleasedDynamicTexture;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/components/image/BlurHashImage;", "Lxyz/meowing/zen/deps/gg/essential/elementa/UIComponent;", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/image/ImageProvider;", "hash", "", "(Ljava/lang/String;)V", "dimensions", "Lkotlin/Pair;", "", "texture", "Lxyz/meowing/zen/deps/gg/essential/universal/utils/ReleasedDynamicTexture;", "draw", "", "matrixStack", "Lxyz/meowing/zen/deps/gg/essential/universal/UMatrixStack;", "drawImage", "x", "y", "width", "height", "color", "Ljava/awt/Color;", "generateTexture", "Companion", "Elementa"})
public class BlurHashImage
extends UIComponent
implements ImageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hash;
    private ReleasedDynamicTexture texture;
    @NotNull
    private Pair<Double, Double> dimensions;
    public static final double BASE_WIDTH = 50.0;
    public static final double BASE_HEIGHT = 50.0;
    public static final int SIZE_THRESHOLD = 2000;

    public BlurHashImage(@NotNull String hash) {
        Intrinsics.checkNotNullParameter(hash, "hash");
        this.hash = hash;
        this.dimensions = TuplesKt.to(50.0, 50.0);
    }

    private final ReleasedDynamicTexture generateTexture() {
        ReleasedDynamicTexture releasedDynamicTexture;
        ReleasedDynamicTexture releasedDynamicTexture2;
        ReleasedDynamicTexture releasedDynamicTexture3;
        Object object;
        BufferedImage bufferedImage = ImageKt.decodeBlurHash$default(this.hash, (int)((Number)this.dimensions.getFirst()).doubleValue(), (int)((Number)this.dimensions.getSecond()).doubleValue(), 0.0f, 8, null);
        if (bufferedImage != null) {
            object = bufferedImage;
            BufferedImage it = object;
            boolean bl = false;
            releasedDynamicTexture3 = UGraphics.getTexture(it);
        } else {
            releasedDynamicTexture3 = releasedDynamicTexture2 = null;
        }
        if (releasedDynamicTexture2 == null) {
            object = this;
            BlurHashImage $this$generateTexture_u24lambda_u241 = (BlurHashImage)object;
            boolean bl = false;
            ReleasedDynamicTexture releasedDynamicTexture4 = UGraphics.getEmptyTexture();
            releasedDynamicTexture = releasedDynamicTexture4;
            Intrinsics.checkNotNullExpressionValue((Object)releasedDynamicTexture4, "run {\n            // We \u2026tEmptyTexture()\n        }");
        } else {
            releasedDynamicTexture = releasedDynamicTexture2;
        }
        return releasedDynamicTexture;
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        ReleasedDynamicTexture releasedDynamicTexture;
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(color, "color");
        if (this.texture != null) {
            double sizeDifference;
            if (width > 0.0 && height > 0.0 && (sizeDifference = Math.abs(((Number)this.dimensions.getFirst()).doubleValue() * ((Number)this.dimensions.getSecond()).doubleValue() - width * height)) > (double)2000) {
                this.dimensions = TuplesKt.to(width, height);
                this.texture = this.generateTexture();
            }
        } else {
            this.texture = this.generateTexture();
        }
        if ((releasedDynamicTexture = this.texture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
            releasedDynamicTexture = null;
        }
        ImageKt.drawTexture$default(matrixStack, releasedDynamicTexture, color, x, y, width, height, 0, 0, 384, null);
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDrawCompat(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        this.drawImageCompat(matrixStack, x, y, width, height, color);
        super.draw(matrixStack);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofFile(@NotNull String hash, @NotNull File file) {
        return Companion.ofFile(hash, file);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofURL(@NotNull String hash, @NotNull URL url) {
        return Companion.ofURL(hash, url);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResource(@NotNull String hash, @NotNull String path) {
        return Companion.ofResource(hash, path);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/components/image/BlurHashImage$Companion;", "", "()V", "BASE_HEIGHT", "", "BASE_WIDTH", "SIZE_THRESHOLD", "", "ofFile", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/UIImage;", "hash", "", "file", "Ljava/io/File;", "ofResource", "path", "ofURL", "url", "Ljava/net/URL;", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UIImage ofFile(@NotNull String hash, @NotNull File file) {
            Intrinsics.checkNotNullParameter(hash, "hash");
            Intrinsics.checkNotNullParameter(file, "file");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofFile$lambda$0(file));
            Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync { ImageIO.read(file) }");
            return new UIImage(completableFuture, new BlurHashImage(hash), null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofURL(@NotNull String hash, @NotNull URL url) {
            Intrinsics.checkNotNullParameter(hash, "hash");
            Intrinsics.checkNotNullParameter(url, "url");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofURL$lambda$1(url));
            Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync { UIImage.get(url) }");
            return new UIImage(completableFuture, new BlurHashImage(hash), null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResource(@NotNull String hash, @NotNull String path) {
            Intrinsics.checkNotNullParameter(hash, "hash");
            Intrinsics.checkNotNullParameter(path, "path");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofResource$lambda$2(this, path));
            Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync {\n          \u2026ream(path))\n            }");
            return new UIImage(completableFuture, new BlurHashImage(hash), null, 4, null);
        }

        private static final BufferedImage ofFile$lambda$0(File $file) {
            Intrinsics.checkNotNullParameter($file, "$file");
            return ImageIO.read($file);
        }

        private static final BufferedImage ofURL$lambda$1(URL $url) {
            Intrinsics.checkNotNullParameter($url, "$url");
            return UIImage.Companion.get($url);
        }

        private static final BufferedImage ofResource$lambda$2(Companion this$0, String $path) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($path, "$path");
            return ImageIO.read(this$0.getClass().getResourceAsStream($path));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

