/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.components.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xyz.meowing.zen.deps.gg.essential.elementa.components.image.ImageCache;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0019\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fH\u0096\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u001fH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010\u0016*\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0016*\u00020\u001f2\u0006\u0010#\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/components/image/FileImageCache;", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/image/ImageCache;", "directory", "Ljava/io/File;", "cacheTime", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "deleteOnCacheMiss", "", "(Ljava/io/File;JLjava/util/concurrent/TimeUnit;Z)V", "get", "Ljava/awt/image/BufferedImage;", "url", "Ljava/net/URL;", "moveDown", "", "hashCode", "", "index", "readEntry", "Lkotlin/Triple;", "", "file", "set", "image", "writeEntry", "img", "asSequence", "Lkotlin/sequences/Sequence;", "Lorg/w3c/dom/Node;", "Lorg/w3c/dom/NodeList;", "attributeValue", "name", "findValueByKeyword", "keyword", "Elementa"})
@SourceDebugExtension(value={"SMAP\nFileImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileImageCache.kt\ngg/essential/elementa/components/image/FileImageCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class FileImageCache
implements ImageCache {
    @NotNull
    private final File directory;
    private final long cacheTime;
    @NotNull
    private final TimeUnit timeUnit;
    private final boolean deleteOnCacheMiss;

    public FileImageCache(@NotNull File directory, long cacheTime, @NotNull TimeUnit timeUnit, boolean deleteOnCacheMiss) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.directory = directory;
        this.cacheTime = cacheTime;
        this.timeUnit = timeUnit;
        this.deleteOnCacheMiss = deleteOnCacheMiss;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + this.directory.getAbsolutePath() + " is not a valid directory for a FileImageCache");
        }
    }

    public /* synthetic */ FileImageCache(File file, long l, TimeUnit timeUnit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(file, l, timeUnit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public BufferedImage get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        hashCode = url.hashCode();
        index = 0;
        var4_4 = FileChannel.open(new File(this.directory, "" + hashCode + '-' + index + ".png").toPath(), new OpenOption[0]);
        var5_5 = null;
        try {
            open = (FileChannel)var4_4;
            $i$a$-use-FileImageCache$get$1 = false;
            lock = open.lock();
            while (true) {
                if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                    lock.release();
                    var12_13 = null;
                    return var12_13;
                }
                cacheItem = this.readEntry(file);
                if (!Intrinsics.areEqual(cacheItem.getSecond(), url.toString())) ** GOTO lbl28
                if (System.currentTimeMillis() - ((Number)cacheItem.getThird()).longValue() < this.timeUnit.toMillis(this.cacheTime)) {
                    lock.release();
                    var11_14 = cacheItem.getFirst();
                    return var11_14;
                }
                if (this.deleteOnCacheMiss) {
                    file.delete();
                    this.moveDown(hashCode, index);
                }
lbl28:
                // 4 sources

                ++index;
                continue;
                break;
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
        }
        finally {
            CloseableKt.closeFinally(var4_4, var5_5);
        }
    }

    @Override
    public void set(@NotNull URL url, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(image, "image");
        int hashCode = url.hashCode();
        int index = 0;
        while (true) {
            File file;
            if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                this.writeEntry(file, image, url);
                return;
            }
            ++index;
        }
    }

    private final void moveDown(int hashCode, int index) {
        int tmp = index + 1;
        File src;
        while ((src = new File(this.directory, "" + hashCode + '-' + tmp + ".png")).exists()) {
            src.renameTo(new File(this.directory, "" + hashCode + '-' + (tmp - 1) + ".png"));
            ++tmp;
        }
        return;
    }

    private final void writeEntry(File file, BufferedImage img, URL url) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode urlEntry = new IIOMetadataNode("tEXtEntry");
        urlEntry.setAttribute("keyword", "image_url");
        urlEntry.setAttribute("value", url.toString());
        IIOMetadataNode cacheTimeEntry = new IIOMetadataNode("tEXtEntry");
        cacheTimeEntry.setAttribute("keyword", "cache_time");
        cacheTimeEntry.setAttribute("value", String.valueOf(System.currentTimeMillis()));
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(urlEntry);
        text.appendChild(cacheTimeEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_png_1.0", root);
        FileOutputStream fos = new FileOutputStream(file);
        ImageOutputStream stream = ImageIO.createImageOutputStream(fos);
        writer.setOutput(stream);
        writer.write(metadata, new IIOImage(img, null, metadata), writeParam);
        stream.close();
        fos.close();
    }

    private final Triple<BufferedImage, String, Long> readEntry(File file) {
        Node node2;
        Object object;
        byte[] imageData;
        block2: {
            Sequence<Node> sequence2;
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
            imageData = FilesKt.readBytes(file);
            imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)), true);
            Node metadata = imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
            NodeList nodeList = metadata.getChildNodes();
            Intrinsics.checkNotNullExpressionValue(nodeList, "metadata.childNodes");
            Sequence<Node> sequence3 = sequence2 = this.asSequence(nodeList);
            object = sequence3.iterator();
            while (object.hasNext()) {
                Node node3;
                Node it = node3 = object.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getNodeName(), "Text")) continue;
                node2 = node3;
                break block2;
            }
            node2 = null;
        }
        Intrinsics.checkNotNull(node2);
        NodeList nodeList = ((Node)node2).getChildNodes();
        Intrinsics.checkNotNullExpressionValue(nodeList, "metadata.childNodes.asSe\u2026 == \"Text\" }!!.childNodes");
        NodeList childNodes = nodeList;
        String string = this.findValueByKeyword(childNodes, "image_url");
        if (string == null) {
            string = "";
        }
        String cacheUrl = string;
        object = this.findValueByKeyword(childNodes, "cache_time");
        long timeCached = object != null ? Long.parseLong((String)object) : 0L;
        return new Triple<BufferedImage, String, Long>(ImageIO.read(new ByteArrayInputStream(imageData)), cacheUrl, timeCached);
    }

    private final Sequence<Node> asSequence(NodeList $this$asSequence) {
        return SequencesKt.map(CollectionsKt.asSequence(RangesKt.until(0, $this$asSequence.getLength())), (Function1)new Function1<Integer, Node>($this$asSequence){
            final /* synthetic */ NodeList $this_asSequence;
            {
                this.$this_asSequence = $receiver;
                super(1);
            }

            public final Node invoke(int it) {
                return this.$this_asSequence.item(it);
            }
        });
    }

    private final String attributeValue(Node $this$attributeValue, String name) {
        Node node2 = $this$attributeValue.getAttributes().getNamedItem(name);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private final String findValueByKeyword(NodeList $this$findValueByKeyword, String keyword) {
        Node node2;
        block1: {
            Sequence<Node> sequence2;
            Sequence<Node> sequence3 = sequence2 = this.asSequence($this$findValueByKeyword);
            Iterator<Node> iterator2 = sequence3.iterator();
            while (iterator2.hasNext()) {
                Node node3;
                Node it = node3 = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(this.attributeValue(it, "keyword"), keyword)) continue;
                node2 = node3;
                break block1;
            }
            node2 = null;
        }
        Node node4 = node2;
        return node4 != null ? this.attributeValue(node4, "value") : null;
    }
}

