/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.components.input;

import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.deps.gg.essential.elementa.UIComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.components.input.AbstractTextInput;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.SuperConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.WidthConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.BasicConstraintsKt;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.ConstraintsKt;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.UtilitiesKt;
import xyz.meowing.zen.deps.gg.essential.elementa.font.FontProvider;
import xyz.meowing.zen.deps.gg.essential.universal.UMatrixStack;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BW\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0014J\b\u0010!\u001a\u00020\u001cH\u0014J\b\u0010\"\u001a\u00020\u001cH\u0014J\u001c\u0010#\u001a\u00060$R\u00020\u00012\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0018H\u0014J\u0014\u0010'\u001a\u00020\u001c2\n\u0010(\u001a\u00060$R\u00020\u0001H\u0014J\b\u0010)\u001a\u00020\u001cH\u0014J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000fJ\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0018H\u0014J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030,2\u0006\u0010-\u001a\u00020\u0003H\u0014R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/components/input/UITextInput;", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/input/AbstractTextInput;", "placeholder", "", "shadow", "", "selectionBackgroundColor", "Ljava/awt/Color;", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "maxWidth", "Lxyz/meowing/zen/deps/gg/essential/elementa/constraints/WidthConstraint;", "getMaxWidth", "()Lgg/essential/elementa/constraints/WidthConstraint;", "setMaxWidth", "(Lgg/essential/elementa/constraints/WidthConstraint;)V", "minWidth", "getMinWidth", "setMinWidth", "placeholderWidth", "", "getPlaceholderWidth", "()F", "draw", "", "matrixStack", "Lxyz/meowing/zen/deps/gg/essential/universal/UMatrixStack;", "getText", "getTextForRender", "onEnterPressed", "recalculateDimensions", "screenPosToVisualPos", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/input/AbstractTextInput$LinePosition;", "x", "y", "scrollIntoView", "pos", "setCursorPos", "constraint", "splitTextForWrapping", "", "text", "maxLineWidth", "textToLines", "Elementa"})
public class UITextInput
extends AbstractTextInput {
    @Nullable
    private WidthConstraint minWidth;
    @Nullable
    private WidthConstraint maxWidth;
    private final float placeholderWidth;

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionForegroundColor, "inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter(cursorColor, "cursorColor");
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        super(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, color);
        this.placeholderWidth = UtilitiesKt.width$default(placeholder, 0.0f, null, 3, null);
    }

    public /* synthetic */ UITextInput(String string, boolean bl, Color color, Color color2, boolean bl2, Color color3, Color color4, Color color5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            Color color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color6, "WHITE");
            color = color6;
        }
        if ((n & 8) != 0) {
            color2 = new Color(64, 139, 229);
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            color3 = new Color(176, 176, 176);
        }
        if ((n & 0x40) != 0) {
            Color color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color7, "WHITE");
            color4 = color7;
        }
        if ((n & 0x80) != 0) {
            Color color8 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color8, "WHITE");
            color5 = color8;
        }
        this(string, bl, color, color2, bl2, color3, color4, color5);
    }

    @Nullable
    protected final WidthConstraint getMinWidth() {
        return this.minWidth;
    }

    protected final void setMinWidth(@Nullable WidthConstraint widthConstraint) {
        this.minWidth = widthConstraint;
    }

    @Nullable
    protected final WidthConstraint getMaxWidth() {
        return this.maxWidth;
    }

    protected final void setMaxWidth(@Nullable WidthConstraint widthConstraint) {
        this.maxWidth = widthConstraint;
    }

    protected final float getPlaceholderWidth() {
        return this.placeholderWidth;
    }

    @NotNull
    public final UITextInput setMinWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter(constraint, "constraint");
        UITextInput $this$setMinWidth_u24lambda_u240 = uITextInput = this;
        boolean bl = false;
        $this$setMinWidth_u24lambda_u240.minWidth = constraint;
        return uITextInput;
    }

    @NotNull
    public final UITextInput setMaxWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter(constraint, "constraint");
        UITextInput $this$setMaxWidth_u24lambda_u241 = uITextInput = this;
        boolean bl = false;
        $this$setMaxWidth_u24lambda_u241.maxWidth = constraint;
        return uITextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return CollectionsKt.first(this.getTextualLines()).getText();
    }

    @NotNull
    protected String getTextForRender() {
        return this.getText();
    }

    protected void setCursorPos() {
        UIComponent.unhide$default(this.getCursorComponent(), false, 1, null);
        float cursorPosX = ((Number)this.getCursor().toScreenPos().component1()).floatValue();
        this.getCursorComponent().setX(UtilitiesKt.pixels$default(Float.valueOf(cursorPosX), false, false, 3, null));
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return CollectionsKt.listOf(StringsKt.replace$default(text, '\n', ' ', false, 4, null));
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        int column = pos.getColumn();
        String lineText = this.getTextForRender();
        if (column < 0 || column > lineText.length()) {
            return;
        }
        String string = lineText;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, column);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        float widthBeforePosition = UtilitiesKt.width$default(string3, this.getTextScale(), null, 2, null);
        if (UtilitiesKt.width$default(this.getTextForRender(), this.getTextScale(), null, 2, null) < this.getWidth()) {
            this.setHorizontalScrollingOffset(0.0f);
        } else if (this.getHorizontalScrollingOffset() > widthBeforePosition) {
            this.setHorizontalScrollingOffset(widthBeforePosition);
        } else if (widthBeforePosition - this.getHorizontalScrollingOffset() > this.getWidth()) {
            this.setHorizontalScrollingOffset(widthBeforePosition - this.getWidth());
        }
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float targetXPos = x + this.getHorizontalScrollingOffset();
        float currentX = 0.0f;
        String line = this.getTextForRender();
        int n = line.length();
        for (int i2 = 0; i2 < n; ++i2) {
            float charWidth = UtilitiesKt.width(line.charAt(i2), this.getTextScale());
            if (currentX + charWidth / (float)2 >= targetXPos) {
                return new AbstractTextInput.LinePosition(0, i2, true);
            }
            currentX += charWidth;
        }
        return new AbstractTextInput.LinePosition(0, line.length(), true);
    }

    @Override
    protected void recalculateDimensions() {
        if (this.minWidth != null && this.maxWidth != null) {
            float width = !this.hasText() && !this.getActive() ? this.placeholderWidth : UtilitiesKt.width$default(this.getTextForRender(), this.getTextScale(), null, 2, null) + 1.0f;
            SuperConstraint superConstraint = UtilitiesKt.pixels$default(Float.valueOf(width), false, false, 3, null);
            WidthConstraint widthConstraint = this.minWidth;
            Intrinsics.checkNotNull(widthConstraint);
            SuperConstraint superConstraint2 = widthConstraint;
            WidthConstraint widthConstraint2 = this.maxWidth;
            Intrinsics.checkNotNull(widthConstraint2);
            this.setWidth(ConstraintsKt.coerceIn(superConstraint, superConstraint2, widthConstraint2));
        }
    }

    @Override
    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text, float maxLineWidth) {
        Intrinsics.checkNotNullParameter(text, "text");
        return CollectionsKt.listOf(text);
    }

    @Override
    protected void onEnterPressed() {
        this.getActivateAction().invoke(this.getText());
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDrawCompat(matrixStack);
        if (!this.getActive() && !this.hasText()) {
            FontProvider.drawString$default(this.getFontProvider(), matrixStack, this.getPlaceholder(), this.getColor(), this.getLeft(), this.getTop(), 10.0f, this.getTextScale(), this.getShadow(), null, 256, null);
            super.draw(matrixStack);
            return;
        }
        String lineText = this.getTextForRender();
        if (this.hasSelection()) {
            int n;
            int n2;
            String string;
            float currentX = this.getLeft();
            this.getCursorComponent().hide(true);
            if (!this.selectionStart().isAtLineStart()) {
                string = lineText;
                n2 = 0;
                n = this.selectionStart().getColumn();
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String preSelectionText = string3;
                this.drawUnselectedTextCompat(matrixStack, preSelectionText, currentX, 0);
                currentX += UtilitiesKt.width$default(preSelectionText, this.getTextScale(), null, 2, null);
            }
            string = lineText;
            n2 = this.selectionStart().getColumn();
            n = this.selectionEnd().getColumn();
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String selectedText2 = string5;
            float selectedTextWidth = UtilitiesKt.width$default(selectedText2, this.getTextScale(), null, 2, null);
            this.drawSelectedTextCompat(matrixStack, selectedText2, currentX, currentX + selectedTextWidth, 0);
            currentX += selectedTextWidth;
            if (!this.selectionEnd().isAtLineEnd()) {
                String string6 = lineText;
                n = this.selectionEnd().getColumn();
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n);
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.String).substring(startIndex)");
                this.drawUnselectedTextCompat(matrixStack, string8, currentX, 0);
            }
        } else {
            if (this.getActive()) {
                this.getCursorComponent().setY(BasicConstraintsKt.basicYConstraint((Function1<? super UIComponent, Float>)new Function1<UIComponent, Float>(this){
                    final /* synthetic */ UITextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull UIComponent it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Float.valueOf(this.this$0.getTop());
                    }
                }));
                this.setCursorPos();
            }
            this.drawUnselectedTextCompat(matrixStack, lineText, this.getLeft(), 0);
        }
        super.draw(matrixStack);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionForegroundColor, "inactiveSelectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 128, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 192, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 224, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 240, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        this(placeholder, shadow, selectionBackgroundColor, null, false, null, null, null, 248, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        this(placeholder, shadow, null, null, false, null, null, null, 252, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        this(placeholder, false, null, null, false, null, null, null, 254, null);
    }

    @JvmOverloads
    public UITextInput() {
        this(null, false, null, null, false, null, null, null, 255, null);
    }
}

