/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal;

import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.util.Escaping;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.Block;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.FencedCodeBlock;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.SourceLine;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private final FencedCodeBlock block = new FencedCodeBlock();
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char fenceChar, int fenceLength, int fenceIndent) {
        this.block.setFenceChar(fenceChar);
        this.block.setFenceLength(fenceLength);
        this.block.setFenceIndent(fenceIndent);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        CharSequence line = state.getLine().getContent();
        if (state.getIndent() < Parsing.CODE_BLOCK_INDENT && nextNonSpace < line.length() && line.charAt(nextNonSpace) == this.block.getFenceChar() && this.isClosing(line, nextNonSpace)) {
            return BlockContinue.finished();
        }
        int length = line.length();
        for (int i2 = this.block.getFenceIndent(); i2 > 0 && newIndex < length && line.charAt(newIndex) == ' '; ++newIndex, --i2) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(SourceLine line) {
        if (this.firstLine == null) {
            this.firstLine = line.getContent().toString();
        } else {
            this.otherLines.append(line.getContent());
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    private static FencedCodeBlockParser checkOpener(CharSequence line, int index, int indent) {
        int backticks = 0;
        int tildes = 0;
        int length = line.length();
        block4: for (int i2 = index; i2 < length; ++i2) {
            switch (line.charAt(i2)) {
                case '`': {
                    ++backticks;
                    continue block4;
                }
                case '~': {
                    ++tildes;
                    continue block4;
                }
            }
        }
        if (backticks >= 3 && tildes == 0) {
            if (Parsing.find('`', line, index + backticks) != -1) {
                return null;
            }
            return new FencedCodeBlockParser('`', backticks, indent);
        }
        if (tildes >= 3 && backticks == 0) {
            return new FencedCodeBlockParser('~', tildes, indent);
        }
        return null;
    }

    private boolean isClosing(CharSequence line, int index) {
        char fenceChar = this.block.getFenceChar();
        int fenceLength = this.block.getFenceLength();
        int fences = Parsing.skip(fenceChar, line, index, line.length()) - index;
        if (fences < fenceLength) {
            return false;
        }
        int after = Parsing.skipSpaceTab(line, index + fences, line.length());
        return after == line.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int indent = state.getIndent();
            if (indent >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            FencedCodeBlockParser blockParser = FencedCodeBlockParser.checkOpener(state.getLine().getContent(), nextNonSpace, indent);
            if (blockParser != null) {
                return BlockStart.of(blockParser).atIndex(nextNonSpace + blockParser.block.getFenceLength());
            }
            return BlockStart.none();
        }
    }
}

