/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.inline;

import java.util.regex.Pattern;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.inline.InlineContentParser;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.inline.InlineParserState;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.inline.ParsedInline;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal.inline.Scanner;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.HardLineBreak;
import xyz.meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.Text;

public class BackslashInlineParser
implements InlineContentParser {
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        char next = scanner.peek();
        if (next == '\n') {
            scanner.next();
            return ParsedInline.of(new HardLineBreak(), scanner.position());
        }
        if (ESCAPABLE.matcher(String.valueOf(next)).matches()) {
            scanner.next();
            return ParsedInline.of(new Text(String.valueOf(next)), scanner.position());
        }
        return ParsedInline.of(new Text("\\"), scanner.position());
    }
}

