/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables;

import java.awt.Color;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.zen.deps.gg.essential.elementa.UIComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.components.UIImage;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.ConstraintType;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.XConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.YConstraint;
import xyz.meowing.zen.deps.gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.ComponentsKt;
import xyz.meowing.zen.deps.gg.essential.elementa.dsl.UtilitiesKt;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.DrawState;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.MarkdownComponent;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.drawables.Drawable;
import xyz.meowing.zen.deps.gg.essential.elementa.markdown.selection.ImageCursor;
import xyz.meowing.zen.deps.gg.essential.universal.UMatrixStack;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\tH\u0016J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001eH\u0014J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\rR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ImageDrawable;", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable;", "md", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/MarkdownComponent;", "url", "Ljava/net/URL;", "fallback", "(Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/net/URL;Lgg/essential/elementa/markdown/drawables/Drawable;)V", "hasLoaded", "", "image", "Lxyz/meowing/zen/deps/gg/essential/elementa/components/UIImage;", "imageX", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "imageY", "value", "selected", "getSelected", "()Z", "setSelected", "(Z)V", "getUrl", "()Ljava/net/URL;", "beforeDraw", "", "state", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/DrawState;", "cursorAt", "", "mouseX", "", "mouseY", "dragged", "mouseButton", "", "cursorAtEnd", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/selection/ImageCursor;", "cursorAtStart", "draw", "matrixStack", "Lxyz/meowing/zen/deps/gg/essential/universal/UMatrixStack;", "hasSelectedText", "layoutImpl", "Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "", "asMarkdown", "ShiftableMDPixelConstraint", "Elementa"})
public final class ImageDrawable
extends Drawable {
    @NotNull
    private final URL url;
    @NotNull
    private final Drawable fallback;
    private boolean selected;
    private ShiftableMDPixelConstraint imageX;
    private ShiftableMDPixelConstraint imageY;
    @NotNull
    private final UIImage image;
    private boolean hasLoaded;

    public ImageDrawable(@NotNull MarkdownComponent md, @NotNull URL url, @NotNull Drawable fallback) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(fallback, "fallback");
        super(md);
        this.url = url;
        this.fallback = fallback;
        this.image = (UIImage)ComponentsKt.childOf((UIComponent)UIImage.Companion.ofURL(this.url), md);
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selected = value;
        if (value) {
            this.image.setColor(UtilitiesKt.toConstraint(new Color(200, 200, 255, 255)));
        } else {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            this.image.setColor(UtilitiesKt.toConstraint(color));
        }
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        Drawable.Layout layout;
        if (this.image.isLoaded()) {
            this.imageX = new ShiftableMDPixelConstraint(x, 0.0f);
            this.imageY = new ShiftableMDPixelConstraint(y, 0.0f);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint = this.imageX;
            if (shiftableMDPixelConstraint == null) {
                Intrinsics.throwUninitializedPropertyAccessException("imageX");
                shiftableMDPixelConstraint = null;
            }
            this.image.setX(shiftableMDPixelConstraint);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("imageY");
                shiftableMDPixelConstraint2 = null;
            }
            this.image.setY(shiftableMDPixelConstraint2);
            float aspectRatio = this.image.getImageWidth() / this.image.getImageHeight();
            float imageWidth = RangesKt.coerceAtMost(this.image.getImageWidth(), width);
            float imageHeight = imageWidth / aspectRatio;
            this.image.setWidth(UtilitiesKt.pixels$default(Float.valueOf(imageWidth), false, false, 3, null));
            this.image.setHeight(UtilitiesKt.pixels$default(Float.valueOf(imageHeight), false, false, 3, null));
            layout = new Drawable.Layout(x, y, imageWidth, imageHeight, null, 16, null);
        } else {
            layout = this.fallback.layout(x, y, width);
        }
        return layout;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        if (!this.hasLoaded) {
            this.fallback.drawCompat(matrixStack, state);
        } else {
            this.image.drawCompat(matrixStack);
        }
    }

    @Override
    public void beforeDraw(@NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        if (this.image.isLoaded() && !this.hasLoaded) {
            this.hasLoaded = true;
            this.getMd().layout();
        }
        if (this.hasLoaded) {
            ShiftableMDPixelConstraint shiftableMDPixelConstraint = this.imageX;
            if (shiftableMDPixelConstraint == null) {
                Intrinsics.throwUninitializedPropertyAccessException("imageX");
                shiftableMDPixelConstraint = null;
            }
            shiftableMDPixelConstraint.setShift(state.getXShift());
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("imageY");
                shiftableMDPixelConstraint2 = null;
            }
            shiftableMDPixelConstraint2.setShift(state.getYShift());
        }
    }

    @NotNull
    public Void cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        throw new IllegalStateException("never called");
    }

    @NotNull
    public ImageCursor cursorAtStart() {
        return new ImageCursor(this);
    }

    @NotNull
    public ImageCursor cursorAtEnd() {
        return new ImageCursor(this);
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (asMarkdown) {
            return " ![" + this.fallback.selectedText(true) + "](" + this.url + ") ";
        }
        return "" + ' ' + this.url + ' ';
    }

    @Override
    public boolean hasSelectedText() {
        return this.selected;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\r\u00a8\u0006&"}, d2={"Lxyz/meowing/zen/deps/gg/essential/elementa/markdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "Lxyz/meowing/zen/deps/gg/essential/elementa/constraints/XConstraint;", "Lxyz/meowing/zen/deps/gg/essential/elementa/constraints/YConstraint;", "base", "", "shift", "(Lgg/essential/elementa/markdown/drawables/ImageDrawable;FF)V", "getBase", "()F", "cachedValue", "getCachedValue", "()Ljava/lang/Float;", "setCachedValue", "(F)V", "constrainTo", "Lxyz/meowing/zen/deps/gg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "recalculate", "", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "value", "getShift", "setShift", "getXPositionImpl", "component", "getYPositionImpl", "visitImpl", "", "visitor", "Lxyz/meowing/zen/deps/gg/essential/elementa/constraints/resolution/ConstraintVisitor;", "type", "Lxyz/meowing/zen/deps/gg/essential/elementa/constraints/ConstraintType;", "Elementa"})
    private final class ShiftableMDPixelConstraint
    implements XConstraint,
    YConstraint {
        private final float base;
        private float shift;
        private float cachedValue;
        private boolean recalculate;
        @Nullable
        private UIComponent constrainTo;

        public ShiftableMDPixelConstraint(float base, float shift) {
            this.base = base;
            this.shift = shift;
            this.recalculate = true;
        }

        public final float getBase() {
            return this.base;
        }

        public final float getShift() {
            return this.shift;
        }

        public final void setShift(float value) {
            this.setRecalculate(true);
            this.shift = value;
        }

        @Override
        @NotNull
        public Float getCachedValue() {
            return Float.valueOf(this.cachedValue);
        }

        @Override
        public void setCachedValue(float f) {
            this.cachedValue = f;
        }

        @Override
        public boolean getRecalculate() {
            return this.recalculate;
        }

        @Override
        public void setRecalculate(boolean bl) {
            this.recalculate = bl;
        }

        @Override
        @Nullable
        public UIComponent getConstrainTo() {
            return this.constrainTo;
        }

        @Override
        public void setConstrainTo(@Nullable UIComponent uIComponent) {
            this.constrainTo = uIComponent;
        }

        @Override
        public float getXPositionImpl(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter(component2, "component");
            return this.base + this.shift;
        }

        @Override
        public float getYPositionImpl(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter(component2, "component");
            return this.base + this.shift;
        }

        @Override
        public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type2) {
            Intrinsics.checkNotNullParameter(visitor, "visitor");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
        }
    }
}

