/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.features.slayers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.api.SlayerTracker;
import xyz.meowing.zen.config.Handler;
import xyz.meowing.zen.config.ui.ConfigUI;
import xyz.meowing.zen.config.ui.types.ConfigElement;
import xyz.meowing.zen.config.ui.types.ElementType;
import xyz.meowing.zen.events.EventBus;
import xyz.meowing.zen.events.RenderEvent;
import xyz.meowing.zen.events.SkyblockEvent;
import xyz.meowing.zen.features.Feature;
import xyz.meowing.zen.features.slayers.SlayerStats;
import xyz.meowing.zen.hud.HUDManager;
import xyz.meowing.zen.utils.ChatUtils;
import xyz.meowing.zen.utils.NumberUtils;
import xyz.meowing.zen.utils.Render2D;
import xyz.meowing.zen.utils.SimpleTimeMark;
import xyz.meowing.zen.utils.TimeUtils;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0005*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lxyz/meowing/zen/features/slayers/SlayerStats;", "Lxyz/meowing/zen/features/Feature;", "<init>", "()V", "name", "", "slayertimer", "", "getSlayertimer", "()Z", "slayertimer$delegate", "Lxyz/meowing/zen/config/Handler;", "slayerStatsLines", "", "", "getSlayerStatsLines", "()Ljava/util/Set;", "slayerStatsLines$delegate", "addConfig", "Lxyz/meowing/zen/config/ui/ConfigUI;", "configUI", "initialize", "", "getBPH", "reset", "render", "getLines", "", "format", "", "decimals", "zen"})
@SourceDebugExtension(value={"SMAP\nSlayerStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerStats.kt\nxyz/meowing/zen/features/slayers/SlayerStats\n+ 2 Feature.kt\nxyz/meowing/zen/features/Feature\n+ 3 EventBus.kt\nxyz/meowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TimeUtils.kt\nxyz/meowing/zen/utils/TimeUtils\n+ 7 TimeUtils.kt\nxyz/meowing/zen/utils/SimpleTimeMark\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 ConfigDelegate.kt\nxyz/meowing/zen/config/ConfigDelegateKt\n*L\n1#1,151:1\n113#2,2:152\n115#2:162\n113#2,2:163\n115#2:173\n194#3,2:154\n196#3,3:159\n194#3,2:165\n196#3,3:170\n72#4,2:156\n72#4,2:167\n1#5:158\n1#5:169\n63#6:174\n58#6:176\n58#6:179\n63#6:181\n63#6:183\n63#6:184\n23#7:175\n27#7:177\n27#7:178\n23#7:180\n1869#8:182\n1870#8:185\n7#9:186\n*S KotlinDebug\n*F\n+ 1 SlayerStats.kt\nxyz/meowing/zen/features/slayers/SlayerStats\n*L\n55#1:152,2\n55#1:162\n59#1:163,2\n59#1:173\n55#1:154,2\n55#1:159,3\n59#1:165,2\n59#1:170,3\n55#1:156,2\n59#1:167,2\n55#1:158\n59#1:169\n69#1:174\n95#1:176\n106#1:179\n107#1:181\n118#1:183\n123#1:184\n95#1:175\n95#1:177\n102#1:178\n106#1:180\n112#1:182\n112#1:185\n-1#1:186\n*E\n"})
public final class SlayerStats
extends Feature {
    @NotNull
    public static final SlayerStats INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String name = "SlayerStats";
    @NotNull
    private static final Handler slayertimer$delegate;
    @NotNull
    private static final Handler slayerStatsLines$delegate;

    private SlayerStats() {
        super("slayerstats", true, null, null, 12, null);
    }

    private final boolean getSlayertimer() {
        return (Boolean)slayertimer$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Set<Integer> getSlayerStatsLines() {
        return (Set)slayerStatsLines$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        Object[] objectArray = new String[]{"Show Bosses Killed", "Show Bosses/hr", "Show Average kill time", "Show Average spawn time", "Show Total Session time", "Show XP/hr"};
        List<String> list = CollectionsKt.listOf(objectArray);
        objectArray = new Integer[]{0, 1, 4, 5};
        return ConfigUI.addElement$default(ConfigUI.addElement$default(configUI.addElement("Slayers", "Slayer stats", new ConfigElement("slayerstats", "Slayer stats", new ElementType.Switch(false), null, 8, null), true), "Slayers", "Slayer stats", "", new ConfigElement("", null, new ElementType.TextParagraph("Shows slayer statistics such as total bosses killed, bosses per hour, and average kill time. \u00a7c/slayerstats reset \u00a7rto reset stats. Requires \u00a7eSlayer Timer\u00a7r to be enabled."), null, 8, null), false, 16, null), "Slayers", "Slayer stats", "Options", new ConfigElement("slayerstatslines", "", new ElementType.MultiCheckbox(list, SetsKt.setOf(objectArray)), null, 8, null), false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        Function1 callback$iv$iv;
        int priority$iv$iv;
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        void $this$getOrPut$iv$iv$iv;
        EventBus this_$iv$iv;
        Feature $this$iv;
        HUDManager.INSTANCE.register(name, "\u00a77[\u00a7bZen\u00a77] \u00a7f\u00a7lSlayer Stats: \n\u00a77> \u00a7bBosses Killed\u00a7f: \u00a7c15\n\u00a77> \u00a7bBosses/hr\u00a7f: \u00a7c12\n\u00a77> \u00a7bAvg. kill\u00a7f: \u00a7c45.2s");
        Feature feature = this;
        Function1 cb$iv = initialize.1.INSTANCE;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = $this$iv.getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        int n = priority$iv;
        Function1 function1 = cb$iv;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = RenderEvent.Text.class;
        ConcurrentMap concurrentMap = this_$iv$iv.getListeners();
        Class<RenderEvent.Text> key$iv$iv$iv = eventClass$iv$iv;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(key$iv$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv$iv, callback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        $this$iv = this;
        cb$iv = initialize.2.INSTANCE;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list2 = $this$iv.getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        priority$iv$iv = priority$iv;
        callback$iv$iv = cb$iv;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = SkyblockEvent.Slayer.Death.class;
        prioritizedCallback$iv$iv = this_$iv$iv.getListeners();
        key$iv$iv$iv = eventClass$iv$iv;
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(key$iv$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv$iv, callback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list2.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    private final int getBPH() {
        if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
            return 0;
        }
        TimeUtils timeUtils = TimeUtils.INSTANCE;
        long $this$millis$iv = Duration.plus-LRDsOJo(SlayerTracker.INSTANCE.getTotalKillTime-UwyO8pc(), SlayerTracker.INSTANCE.getTotalSpawnTime-UwyO8pc());
        boolean bl = false;
        double avgTotal = (double)(Duration.getInWholeMilliseconds-impl($this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0;
        int bph = (int)(3600.0 / avgTotal);
        return bph;
    }

    public final void reset() {
        SlayerTracker.INSTANCE.reset();
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSlayer stats reset!", null, null, null, null, 30, null);
    }

    private final void render() {
        float x = HUDManager.INSTANCE.getX(name);
        float y = HUDManager.INSTANCE.getY(name);
        float scale = HUDManager.INSTANCE.getScale(name);
        List<String> lines = this.getLines();
        if (!((Collection)lines).isEmpty()) {
            float currentY = y;
            for (String line : lines) {
                Render2D.renderString$default(Render2D.INSTANCE, line, x, currentY, scale, 0, null, 48, null);
                currentY += (float)(this.getFontRenderer().field_78288_b + 2);
            }
        }
    }

    private final List<String> getLines() {
        block21: {
            block20: {
                long arg0$iv = SlayerTracker.INSTANCE.getMobLastKilledAt-1PqtNZY();
                boolean bl = false;
                TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
                boolean bl2 = false;
                if (Duration.getInWholeMinutes-impl(SimpleTimeMark.minus-_2EpEBk(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv)) > 5L) break block20;
                arg0$iv = SlayerTracker.INSTANCE.getMobLastKilledAt-1PqtNZY();
                boolean bl3 = false;
                if (!(arg0$iv == 0L)) break block21;
            }
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{"\u00a77[\u00a7bZen\u00a77] \u00a7f\u00a7lSlayer Stats: "};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        if (this.getSlayerStatsLines().contains(4)) {
            boolean bl;
            long arg0$iv = SlayerTracker.INSTANCE.getSessionStart-1PqtNZY();
            boolean bl4 = false;
            if (arg0$iv == 0L) {
                bl = list.add(" \u00a77> \u00a7bSession time\u00a7f: \u00a7c-");
            } else {
                long l;
                SimpleTimeMark pauseMark = SlayerTracker.INSTANCE.getPauseStart-eNnxT_E();
                TimeUtils this_$iv = TimeUtils.INSTANCE;
                boolean $i$f$getNow-1PqtNZY22 = false;
                long l2 = SimpleTimeMark.minus-_2EpEBk(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), SlayerTracker.INSTANCE.getSessionStart-1PqtNZY());
                SimpleTimeMark simpleTimeMark = pauseMark;
                if (simpleTimeMark != null) {
                    long arg0$iv2 = simpleTimeMark.unbox-impl();
                    boolean bl5 = false;
                    TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
                    $i$f$getNow-1PqtNZY = false;
                    l = SimpleTimeMark.minus-_2EpEBk(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv2);
                } else {
                    l = Duration.Companion.getZERO-UwyO8pc();
                }
                long totalTime = Duration.minus-LRDsOJo(Duration.minus-LRDsOJo(l2, l), DurationKt.toDuration(SlayerTracker.INSTANCE.getTotalSessionPaused(), DurationUnit.MILLISECONDS));
                TimeUtils $i$f$getNow-1PqtNZY22 = TimeUtils.INSTANCE;
                long $this$millis$iv = totalTime;
                boolean bl6 = false;
                String timeString = NumberUtils.INSTANCE.toFormattedDuration(Duration.getInWholeMilliseconds-impl($this$millis$iv), false);
                bl = list.add(" \u00a77> \u00a7bSession time\u00a7f: \u00a7c" + timeString + (SlayerTracker.INSTANCE.isPaused() ? " \u00a77(Paused)" : ""));
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.getSlayerStatsLines());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int line = ((Number)element$iv).intValue();
            boolean bl = false;
            switch (line) {
                case 0: {
                    list.add(" \u00a77> \u00a7bBosses Killed\u00a7f: \u00a7c" + SlayerTracker.INSTANCE.getSessionBossKills());
                    break;
                }
                case 1: {
                    list.add(" \u00a77> \u00a7bBosses/hr\u00a7f: \u00a7c" + (SlayerTracker.INSTANCE.getSessionBossKills() == 0 ? "-" : Integer.valueOf(INSTANCE.getBPH())));
                    break;
                }
                case 2: {
                    boolean bl7;
                    String string;
                    if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
                        string = "-";
                    } else {
                        TimeUtils timeUtils = TimeUtils.INSTANCE;
                        long $this$millis$iv = SlayerTracker.INSTANCE.getTotalKillTime-UwyO8pc();
                        bl7 = false;
                        string = INSTANCE.format((double)(Duration.getInWholeMilliseconds-impl($this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0, 1) + 's';
                    }
                    String avgKill = string;
                    list.add(" \u00a77> \u00a7bAvg. kill\u00a7f: \u00a7c" + avgKill);
                    break;
                }
                case 3: {
                    String string;
                    boolean bl7;
                    if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
                        string = "-";
                    } else {
                        TimeUtils this_$iv = TimeUtils.INSTANCE;
                        long $this$millis$iv = SlayerTracker.INSTANCE.getTotalSpawnTime-UwyO8pc();
                        bl7 = false;
                        string = INSTANCE.format((double)(Duration.getInWholeMilliseconds-impl($this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0, 1) + 's';
                    }
                    String avgSpawn = string;
                    list.add(" \u00a77> \u00a7bAvg. spawn\u00a7f: \u00a7c" + avgSpawn);
                    break;
                }
                case 5: {
                    int xpPH = INSTANCE.getBPH() * SlayerTracker.INSTANCE.getXpPerKill();
                    list.add(" \u00a77> \u00a7bXP/hr\u00a7f: \u00a7c" + NumberUtils.INSTANCE.formatNumber(xpPH) + " XP");
                }
            }
        }
        return list;
    }

    private final String format(double $this$format, int decimals) {
        String string = "%." + decimals + 'f';
        Object[] objectArray = new Object[]{$this$format};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public static final /* synthetic */ void access$render(SlayerStats $this) {
        $this.render();
    }

    public static final /* synthetic */ boolean access$getSlayertimer(SlayerStats $this) {
        return $this.getSlayertimer();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SlayerStats.class, "slayertimer", "getSlayertimer()Z", 0)), Reflection.property1(new PropertyReference1Impl(SlayerStats.class, "slayerStatsLines", "getSlayerStatsLines()Ljava/util/Set;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerStats();
        String key$iv = "slayertimer";
        boolean $i$f$ConfigDelegate = false;
        slayertimer$delegate = new Handler<Boolean>(key$iv, Boolean.class);
        key$iv = "slayerstatslines";
        $i$f$ConfigDelegate = false;
        slayerStatsLines$delegate = new Handler<Set>(key$iv, Set.class);
    }
}

