/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u00020\b*\u00020\bJ\n\u0010\t\u001a\u00020\b*\u00020\bJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\b2\u0006\u0010\f\u001a\u00020\u0005J\n\u0010\r\u001a\u00020\u000e*\u00020\bJ\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/meowing/zen/utils/StringUtils;", "", "<init>", "()V", "emoteRegex", "Lkotlin/text/Regex;", "formatRegex", "removeFormatting", "", "removeEmotes", "getRegexGroups", "Lkotlin/text/MatchGroupCollection;", "regex", "decodeRoman", "", "getFormattedDate", "getDaySuffix", "day", "zen"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    @NotNull
    private static final Regex emoteRegex = new Regex("[^\\u0000-\\u007F]");
    @NotNull
    private static final Regex formatRegex = new Regex("[\u00a7&][0-9a-fk-or]");

    private StringUtils() {
    }

    @NotNull
    public final String removeFormatting(@NotNull String $this$removeFormatting) {
        Intrinsics.checkNotNullParameter($this$removeFormatting, "<this>");
        CharSequence charSequence = $this$removeFormatting;
        Regex regex = formatRegex;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public final String removeEmotes(@NotNull String $this$removeEmotes) {
        Intrinsics.checkNotNullParameter($this$removeEmotes, "<this>");
        CharSequence charSequence = $this$removeEmotes;
        Regex regex = emoteRegex;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @Nullable
    public final MatchGroupCollection getRegexGroups(@NotNull String $this$getRegexGroups, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter($this$getRegexGroups, "<this>");
        Intrinsics.checkNotNullParameter(regex, "regex");
        MatchResult matchResult = Regex.find$default(regex, $this$getRegexGroups, 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult regexMatchResult = matchResult;
        return regexMatchResult.getGroups();
    }

    public final int decodeRoman(@NotNull String $this$decodeRoman) {
        Intrinsics.checkNotNullParameter($this$decodeRoman, "<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('I'), 1), TuplesKt.to(Character.valueOf('V'), 5), TuplesKt.to(Character.valueOf('X'), 10), TuplesKt.to(Character.valueOf('L'), 50), TuplesKt.to(Character.valueOf('C'), 100), TuplesKt.to(Character.valueOf('D'), 500), TuplesKt.to(Character.valueOf('M'), 1000)};
        Map values2 = MapsKt.mapOf(pairArray);
        int result = 0;
        int prev = 0;
        String string = ((Object)StringsKt.reversed((CharSequence)$this$decodeRoman)).toString();
        int n = string.length();
        for (int j = 0; j < n; ++j) {
            int current;
            char c = string.charAt(j);
            Integer n2 = (Integer)values2.get(Character.valueOf(c));
            int n3 = current = n2 != null ? n2 : 0;
            result = current < prev ? (result -= current) : (result += current);
            prev = current;
        }
        return result;
    }

    @NotNull
    public final String getFormattedDate() {
        LocalDate today = LocalDate.now();
        int day = today.getDayOfMonth();
        String suffix = this.getDaySuffix(day);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM d'" + suffix + "', yyyy", Locale.ENGLISH);
        String string = today.format(formatter);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    private final String getDaySuffix(int day) {
        return (11 <= day ? day < 14 : false) ? "th" : (day % 10 == 1 ? "st" : (day % 10 == 2 ? "nd" : (day % 10 == 3 ? "rd" : "th")));
    }
}

