/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.elements;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.skyblockapi.utils.extentions.StringExtensionsKt;
import xyz.meowing.knit.api.input.KnitMouse;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.utils.render.NVGRenderer;
import xyz.meowing.vexel.utils.style.Font;
import xyz.meowing.zen.config.ui.elements.FeatureTooltip;
import xyz.meowing.zen.ui.Theme;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u000eJG\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\bR\u0014\u0010\u0013\u001a\u00020\n8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010\u0012\u001a\u00020\n8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001fR\u0014\u0010#\u001a\u00020\n8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b#\u0010\u001fR\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lxyz/meowing/zen/config/ui/elements/FeatureTooltip;", "Lxyz/meowing/vexel/components/base/VexelElement;", "<init>", "()V", "", "text", "", "setText", "(Ljava/lang/String;)V", "updateSize", "", "mouseX", "mouseY", "onRender", "(FF)V", "renderChildren", "x", "y", "fontSize", "maxWidth", "", "defaultColor", "Lxyz/meowing/vexel/utils/style/Font;", "font", "drawMinecraftString", "(Ljava/lang/String;FFFFILxyz/meowing/vexel/utils/style/Font;)V", "currentText", "Ljava/lang/String;", "getCurrentText", "()Ljava/lang/String;", "setCurrentText", "F", "", "padding", "[F", "lineHeight", "Lkotlin/text/Regex;", "tokenRegex", "Lkotlin/text/Regex;", "Lxyz/meowing/vexel/components/core/Rectangle;", "background", "Lxyz/meowing/vexel/components/core/Rectangle;", "MCColor", "Zen"})
public final class FeatureTooltip
extends VexelElement<FeatureTooltip> {
    @NotNull
    private String currentText = "";
    private final float maxWidth;
    @NotNull
    private final float[] padding;
    private final float fontSize;
    private final float lineHeight;
    @NotNull
    private final Regex tokenRegex;
    @NotNull
    private final Rectangle background;

    public FeatureTooltip() {
        super(null, null, 3, null);
        this.maxWidth = 350.0f;
        float[] fArray = new float[]{8.0f, 12.0f, 8.0f, 12.0f};
        this.padding = fArray;
        this.fontSize = 14.0f;
        this.lineHeight = 1.2f;
        this.tokenRegex = new Regex("\u00a7.|\\s+|[^\\s\u00a7]+");
        this.background = (Rectangle)((Rectangle)new Rectangle(Theme.Bg.getColor(), Theme.Border.getColor(), 6.0f, 1.0f, this.padding, null, null, null, null, false, 992, null).setSizing(0.0f, Size.Pixels, 0.0f, Size.Pixels)).childOf((VexelElement)this);
        this.setSizing(0.0f, Size.Pixels, 0.0f, Size.Pixels);
        this.setPositioning(0.0f, Pos.ScreenPixels, 0.0f, Pos.ScreenPixels);
        this.setVisible(false);
        this.setFloating();
    }

    @NotNull
    public final String getCurrentText() {
        return this.currentText;
    }

    public final void setCurrentText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentText = string;
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.currentText = text;
        this.setVisible(((CharSequence)text).length() > 0);
        this.updateSize();
    }

    private final void updateSize() {
        if (((CharSequence)this.currentText).length() == 0) {
            this.setWidth(0.0f);
            this.setHeight(0.0f);
            this.background.setWidth(0.0f);
            this.background.setHeight(0.0f);
            return;
        }
        float[] bounds = NVGRenderer.INSTANCE.wrappedTextBounds(StringExtensionsKt.stripColor((String)this.currentText), this.maxWidth - this.padding[1] - this.padding[3], this.fontSize, NVGRenderer.INSTANCE.getDefaultFont(), this.lineHeight);
        float textHeight = bounds[3] - bounds[1];
        float contentWidth = RangesKt.coerceAtMost((float)this.maxWidth, (float)(bounds[2] - bounds[0] + this.padding[1] + this.padding[3]));
        float contentHeight = textHeight + this.padding[0] + this.padding[2];
        this.setWidth(contentWidth);
        this.setHeight(contentHeight);
        this.background.setWidth(contentWidth);
        this.background.setHeight(contentHeight);
        this.getCache().invalidate();
    }

    protected void onRender(float mouseX, float mouseY) {
        this.setX((float)KnitMouse.Raw.INSTANCE.getX() + 10.0f);
        this.setY((float)KnitMouse.Raw.INSTANCE.getY() + 10.0f);
    }

    protected void renderChildren(float mouseX, float mouseY) {
        super.renderChildren(mouseX, mouseY);
        if (((CharSequence)this.currentText).length() == 0) {
            return;
        }
        float textX = this.getX() + this.padding[3];
        float textY = this.getY() + this.padding[0];
        this.drawMinecraftString(this.currentText, textX, textY, this.fontSize, this.maxWidth - this.padding[1] - this.padding[3], Theme.Text.getColor(), NVGRenderer.INSTANCE.getDefaultFont());
    }

    private final void drawMinecraftString(String text, float x, float y, float fontSize, float maxWidth, int defaultColor, Font font) {
        int currentColor = defaultColor;
        Ref.FloatRef currentY = new Ref.FloatRef();
        currentY.element = y;
        List tokens2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.tokenRegex, (CharSequence)text, (int)0, (int)2, null), (Function1)drawMinecraftString.tokens.1.INSTANCE));
        List lineWords = new ArrayList();
        Ref.FloatRef lineWidth = new Ref.FloatRef();
        int i = 0;
        while (i < tokens2.size()) {
            String token = (String)tokens2.get(i);
            if (StringsKt.startsWith$default((String)token, (String)"\u00a7", (boolean)false, (int)2, null) && token.length() == 2) {
                currentColor = MCColor.INSTANCE.getColor(token.charAt(1));
                ++i;
                continue;
            }
            if (Intrinsics.areEqual((Object)token, (Object)"\n")) {
                FeatureTooltip.drawMinecraftString$flushLine(lineWords, x, currentY, fontSize, font, this, lineWidth);
                ++i;
                continue;
            }
            if (StringsKt.isBlank((CharSequence)token)) {
                float spaceWidth = NVGRenderer.INSTANCE.textWidth(token, fontSize, font);
                if (lineWidth.element + spaceWidth > maxWidth) {
                    FeatureTooltip.drawMinecraftString$flushLine(lineWords, x, currentY, fontSize, font, this, lineWidth);
                } else {
                    lineWords.add(TuplesKt.to((Object)token, (Object)currentColor));
                    lineWidth.element += spaceWidth;
                }
                ++i;
                continue;
            }
            float wordWidth = NVGRenderer.INSTANCE.textWidth(token, fontSize, font);
            if (lineWidth.element + wordWidth > maxWidth && !((Collection)lineWords).isEmpty()) {
                FeatureTooltip.drawMinecraftString$flushLine(lineWords, x, currentY, fontSize, font, this, lineWidth);
            }
            lineWords.add(TuplesKt.to((Object)token, (Object)currentColor));
            lineWidth.element += wordWidth;
            ++i;
        }
        FeatureTooltip.drawMinecraftString$flushLine(lineWords, x, currentY, fontSize, font, this, lineWidth);
    }

    private static final void drawMinecraftString$flushLine(List<Pair<String, Integer>> lineWords, float $x, Ref.FloatRef currentY, float $fontSize, Font $font, FeatureTooltip this$0, Ref.FloatRef lineWidth) {
        if (lineWords.isEmpty()) {
            return;
        }
        float cursorX = $x;
        for (Pair<String, Integer> pair : lineWords) {
            String word = (String)pair.component1();
            int color = ((Number)pair.component2()).intValue();
            NVGRenderer.INSTANCE.text(word, cursorX, currentY.element, $fontSize, color, $font);
            cursorX += NVGRenderer.INSTANCE.textWidth(word, $fontSize, $font);
        }
        currentY.element += $fontSize * this$0.lineHeight;
        lineWords.clear();
        lineWidth.element = 0.0f;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/meowing/zen/config/ui/elements/FeatureTooltip$MCColor;", "", "<init>", "()V", "", "code", "", "getColor", "(C)I", "", "Ljava/awt/Color;", "COLORS", "Ljava/util/Map;", "Zen"})
    private static final class MCColor {
        @NotNull
        public static final MCColor INSTANCE = new MCColor();
        @NotNull
        private static final Map<Character, Color> COLORS;

        private MCColor() {
        }

        public final int getColor(char code) {
            Color color = COLORS.get(Character.valueOf(code));
            return color != null ? color.getRGB() : Color.WHITE.getRGB();
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('0'), (Object)new Color(0, 0, 0)), TuplesKt.to((Object)Character.valueOf('1'), (Object)new Color(0, 0, 170)), TuplesKt.to((Object)Character.valueOf('2'), (Object)new Color(0, 170, 0)), TuplesKt.to((Object)Character.valueOf('3'), (Object)new Color(0, 170, 170)), TuplesKt.to((Object)Character.valueOf('4'), (Object)new Color(170, 0, 0)), TuplesKt.to((Object)Character.valueOf('5'), (Object)new Color(170, 0, 170)), TuplesKt.to((Object)Character.valueOf('6'), (Object)new Color(255, 170, 0)), TuplesKt.to((Object)Character.valueOf('7'), (Object)new Color(170, 170, 170)), TuplesKt.to((Object)Character.valueOf('8'), (Object)new Color(85, 85, 85)), TuplesKt.to((Object)Character.valueOf('9'), (Object)new Color(85, 85, 255)), TuplesKt.to((Object)Character.valueOf('a'), (Object)new Color(85, 255, 85)), TuplesKt.to((Object)Character.valueOf('b'), (Object)new Color(85, 255, 255)), TuplesKt.to((Object)Character.valueOf('c'), (Object)new Color(255, 85, 85)), TuplesKt.to((Object)Character.valueOf('d'), (Object)new Color(255, 85, 255)), TuplesKt.to((Object)Character.valueOf('e'), (Object)new Color(255, 255, 85)), TuplesKt.to((Object)Character.valueOf('f'), (Object)new Color(255, 255, 255))};
            COLORS = MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

