/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.updateChecker;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.KnitChat;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.scheduler.TickScheduler;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.updateChecker.StateTracker;
import xyz.meowing.zen.updateChecker.UpdateChecker;
import xyz.meowing.zen.utils.NetworkUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J%\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lxyz/meowing/zen/updateChecker/UpdateChecker;", "", "<init>", "()V", "", "check", "Lkotlin/Triple;", "", "checkGitHub", "()Lkotlin/Triple;", "checkModrinth", "v1", "v2", "", "compareVersions", "(Ljava/lang/String;Ljava/lang/String;)I", "Zen"})
@SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\nxyz/meowing/zen/updateChecker/UpdateChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n295#2,2:94\n295#2,2:96\n774#2:98\n865#2,2:99\n1999#2,14:101\n295#2,2:115\n1563#2:117\n1634#2,3:118\n1563#2:121\n1634#2,3:122\n1999#2,14:126\n1#3:125\n*S KotlinDebug\n*F\n+ 1 UpdateChecker.kt\nxyz/meowing/zen/updateChecker/UpdateChecker\n*L\n52#1:94,2\n53#1:96,2\n70#1:98\n70#1:99,2\n74#1:101,14\n75#1:115,2\n84#1:117\n84#1:118,3\n85#1:121\n85#1:122,3\n21#1:126,14\n*E\n"})
public final class UpdateChecker {
    @NotNull
    public static final UpdateChecker INSTANCE = new UpdateChecker();

    private UpdateChecker() {
    }

    public final void check() {
        CompletableFuture.supplyAsync(UpdateChecker::check$lambda$1);
    }

    private final Triple<String, String, String> checkGitHub() {
        Object object;
        Object object2 = this;
        try {
            Triple triple;
            UpdateChecker $this$checkGitHub_u24lambda_u245 = object2;
            boolean bl = false;
            HttpURLConnection connection = NetworkUtils.createConnection$default(NetworkUtils.INSTANCE, "https://api.github.com/repos/StellariumMC/zen/releases", null, 2, null);
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200) {
                Object v2;
                block8: {
                    Gson gson = new Gson();
                    InputStream inputStream = connection.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Object object3 = gson.fromJson((Reader)new InputStreamReader(inputStream2, charset), new TypeToken<List<? extends StateTracker.GitHubRelease>>(){}.getType());
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                    List releases2 = (List)object3;
                    Iterable $this$firstOrNull$iv = releases2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        StateTracker.GitHubRelease it = (StateTracker.GitHubRelease)element$iv;
                        boolean bl2 = false;
                        if (!(!it.getPrerelease())) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                StateTracker.GitHubRelease gitHubRelease = v2;
                if (gitHubRelease != null) {
                    Object v4;
                    StateTracker.GitHubRelease release;
                    block9: {
                        release = gitHubRelease;
                        boolean bl3 = false;
                        Iterable $this$firstOrNull$iv = release.getAssets();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            StateTracker.GitHubAsset it = (StateTracker.GitHubAsset)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.endsWith$default((String)it.getName(), (String)".jar", (boolean)false, (int)2, null)) continue;
                            v4 = element$iv;
                            break block9;
                        }
                        v4 = null;
                    }
                    StateTracker.GitHubAsset gitHubAsset = v4;
                    String downloadUrl = gitHubAsset != null ? gitHubAsset.getBrowser_download_url() : null;
                    triple = new Triple((Object)StringsKt.replace$default((String)release.getTag_name(), (String)"v", (String)"", (boolean)false, (int)4, null), (Object)release.getHtml_url(), (Object)downloadUrl);
                } else {
                    triple = null;
                }
            } else {
                triple = null;
            }
            object = Result.constructor-impl(triple);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Triple)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<String, String, String> checkModrinth() {
        Object object;
        Object object2 = this;
        try {
            Triple triple;
            UpdateChecker $this$checkModrinth_u24lambda_u2411 = object2;
            boolean bl = false;
            HttpURLConnection connection = NetworkUtils.createConnection$default(NetworkUtils.INSTANCE, "https://api.modrinth.com/v2/project/stWFyj4m/version", null, 2, null);
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200) {
                Object v2;
                StateTracker.ModrinthVersion it;
                void $this$filterTo$iv$iv;
                Gson gson = new Gson();
                InputStream inputStream = connection.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Object object3 = gson.fromJson((Reader)new InputStreamReader(inputStream2, charset), new TypeToken<List<? extends StateTracker.ModrinthVersion>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                List versions2 = (List)object3;
                Iterable $this$filter$iv = versions2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (StateTracker.ModrinthVersion)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getLoaders().contains("fabric") && Intrinsics.areEqual((Object)it.getStatus(), (Object)"listed") && Intrinsics.areEqual((Object)it.getVersion_type(), (Object)"release") && it.getGame_versions().contains(KnitClient.getMinecraftVersion()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredVersions = (List)destination$iv$iv;
                Iterable $this$maxByOrNull$iv = filteredVersions;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = maxElem$iv;
                    } else {
                        StateTracker.ModrinthVersion it2 = (StateTracker.ModrinthVersion)maxElem$iv;
                        boolean bl3 = false;
                        Comparable maxValue$iv = (Comparable)((Object)it2.getDate_published());
                        do {
                            Object e$iv = iterator$iv.next();
                            it = (StateTracker.ModrinthVersion)e$iv;
                            $i$a$-maxByOrNull-UpdateChecker$checkModrinth$1$1 = false;
                            Comparable v$iv = (Comparable)((Object)it.getDate_published());
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = maxElem$iv;
                    }
                }
                StateTracker.ModrinthVersion modrinthVersion = v2;
                if (modrinthVersion != null) {
                    StateTracker.ModrinthFile primaryFile;
                    StateTracker.ModrinthFile modrinthFile;
                    Object v4;
                    StateTracker.ModrinthVersion version;
                    block16: {
                        version = modrinthVersion;
                        boolean bl4 = false;
                        Iterable $this$firstOrNull$iv = version.getFiles();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            StateTracker.ModrinthFile it3 = (StateTracker.ModrinthFile)element$iv;
                            boolean bl5 = false;
                            if (!it3.getPrimary()) continue;
                            v4 = element$iv;
                            break block16;
                        }
                        v4 = null;
                    }
                    if ((modrinthFile = (StateTracker.ModrinthFile)v4) == null) {
                        modrinthFile = (StateTracker.ModrinthFile)CollectionsKt.firstOrNull(version.getFiles());
                    }
                    StateTracker.ModrinthFile modrinthFile2 = primaryFile = modrinthFile;
                    if (modrinthFile2 != null) {
                        StateTracker.ModrinthFile it4 = modrinthFile2;
                        boolean bl6 = false;
                        triple = new Triple((Object)version.getVersion_number(), (Object)("https://modrinth.com/mod/stWFyj4m/version/" + version.getId()), (Object)it4.getUrl());
                    } else {
                        triple = null;
                    }
                } else {
                    triple = null;
                }
            } else {
                triple = null;
            }
            object = Result.constructor-impl(triple);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Triple)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private final int compareVersions(String v1, String v2) {
        void $this$mapTo$iv$iv3;
        Collection collection;
        Regex $this$mapTo$iv$iv2;
        String[] stringArray = (String[])v1;
        Regex regex = new Regex("[^0-9.]");
        Object object = "";
        CharSequence charSequence = regex.replace((CharSequence)stringArray, (String)object);
        stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        object = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = StringsKt.toIntOrNull((String)it);
            collection.add(n != null ? n : 0);
        }
        List parts1 = (List)destination$iv$iv;
        String[] $i$f$map22 = (String[])v2;
        $this$mapTo$iv$iv2 = new Regex("[^0-9.]");
        destination$iv$iv = "";
        CharSequence charSequence2 = $this$mapTo$iv$iv2.replace((CharSequence)$i$f$map22, (String)destination$iv$iv);
        $i$f$map22 = new String[]{"."};
        Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)charSequence2, (String[])$i$f$map22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv222 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv222;
            boolean bl2 = false;
            Integer n = StringsKt.toIntOrNull((String)it);
            collection.add(n != null ? n : 0);
        }
        List parts2 = (List)destination$iv$iv222;
        int $this$mapTo$iv$iv3 = parts1.size();
        int destination$iv$iv222 = parts2.size();
        int n = Math.max($this$mapTo$iv$iv3, destination$iv$iv222);
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3;
            List destination$iv$iv222 = parts1;
            boolean bl = 0 <= i ? i < destination$iv$iv222.size() : false;
            if (bl) {
                object3 = destination$iv$iv222.get(i);
            } else {
                int it = i;
                boolean bl3 = false;
                object3 = 0;
            }
            int p1 = ((Number)object3).intValue();
            List list = parts2;
            boolean bl4 = 0 <= i ? i < list.size() : false;
            if (bl4) {
                object2 = list.get(i);
            } else {
                int it = i;
                boolean bl5 = false;
                object2 = 0;
            }
            int p2 = ((Number)object2).intValue();
            if (p1 == p2) continue;
            return p1 - p2;
        }
        return 0;
    }

    private static final Unit check$lambda$1() {
        Object v2;
        Triple<String, String, String> github = INSTANCE.checkGitHub();
        Triple<String, String, String> modrinth = INSTANCE.checkModrinth();
        Object[] objectArray = new String[2];
        Triple<String, String, String> triple = github;
        objectArray[0] = triple != null ? (String)triple.getFirst() : null;
        Triple<String, String, String> triple2 = modrinth;
        objectArray[1] = triple2 != null ? (String)triple2.getFirst() : null;
        Iterable $this$maxByOrNull$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                String it = (String)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = INSTANCE.compareVersions(it, Zen.getModInfo().getVersion());
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-maxByOrNull-UpdateChecker$check$1$latest$1 = false;
                    int v$iv = INSTANCE.compareVersions(it2, Zen.getModInfo().getVersion());
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        String string = v2;
        if (string == null) {
            Triple<String, String, String> triple3 = github;
            Triple<String, String, String> triple4 = modrinth;
            KnitChat.fakeMessage((String)((triple3 != null ? (String)triple3.getFirst() : null) + ", " + (triple4 != null ? (String)triple4.getFirst() : null)));
            return Unit.INSTANCE;
        }
        String latest = string;
        if (INSTANCE.compareVersions(latest, Zen.getModInfo().getVersion()) > 0 && !Intrinsics.areEqual((Object)latest, (Object)StateTracker.INSTANCE.getDontShowForVersion()) || StateTracker.INSTANCE.getForceUpdate()) {
            StateTracker.INSTANCE.setMessageShown(true);
            StateTracker.INSTANCE.setForceUpdate(false);
            StateTracker.INSTANCE.setLatestVersion(latest);
            Triple<String, String, String> triple5 = github;
            StateTracker.INSTANCE.setGithubUrl(triple5 != null ? (String)triple5.getSecond() : null);
            Triple<String, String, String> triple6 = github;
            StateTracker.INSTANCE.setGithubDownloadUrl(triple6 != null ? (String)triple6.getThird() : null);
            Triple<String, String, String> triple7 = modrinth;
            StateTracker.INSTANCE.setModrinthUrl(triple7 != null ? (String)triple7.getSecond() : null);
            Triple<String, String, String> triple8 = modrinth;
            StateTracker.INSTANCE.setModrinthDownloadUrl(triple8 != null ? (String)triple8.getThird() : null);
            TickScheduler.Client.INSTANCE.post((Function0)check.1.1.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

