/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.config.ui.elements;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIText;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.RelativeConstraint;
import gg.essential.elementa.constraints.SiblingConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.effects.OutlineEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import meowing.zen.config.ui.elements.ColorPickerComponent;
import meowing.zen.config.ui.elements.ConfigTheme;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\r\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\r2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\bJ!\u0010\u001a\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010\u001fJ\u001f\u0010!\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b!\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\"R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0016\u0010*\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010(R\u0016\u0010+\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010(R\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010,R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010/R\u0016\u00101\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010/R\u0016\u00102\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010/R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lmeowing/zen/config/ui/elements/ColorPickerComponent;", "Lgg/essential/elementa/components/UIContainer;", "Ljava/awt/Color;", "initialColor", "<init>", "(Ljava/awt/Color;)V", "", "setupUI", "()V", "Lkotlin/Function2;", "Lgg/essential/universal/UMatrixStack;", "Lgg/essential/elementa/UIComponent;", "renderer", "meowing/zen/config/ui/elements/ColorPickerComponent.createCustomRenderer.1", "createCustomRenderer", "(Lkotlin/jvm/functions/Function2;)Lmeowing/zen/config/ui/elements/ColorPickerComponent$createCustomRenderer$1;", "Lgg/essential/elementa/components/UIText;", "indicator", "updateHueIndicator", "(Lgg/essential/elementa/components/UIText;)V", "updateAlphaIndicator", "updatePickerIndicator", "(Lgg/essential/elementa/components/UIContainer;)V", "recalculateColor", "Lkotlin/Function1;", "listener", "onValueChange", "(Lkotlin/jvm/functions/Function1;)V", "matrixStack", "component", "drawColorPicker", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/UIComponent;)V", "drawHueLine", "drawAlphaLine", "Ljava/awt/Color;", "getInitialColor", "()Ljava/awt/Color;", "currentColor", "", "currentHue", "F", "currentSaturation", "currentBrightness", "currentAlpha", "Lkotlin/jvm/functions/Function1;", "", "draggingHue", "Z", "draggingPicker", "draggingAlpha", "isChroma", "Lmeowing/zen/config/ui/elements/ConfigTheme;", "theme", "Lmeowing/zen/config/ui/elements/ConfigTheme;", "Zen"})
@SourceDebugExtension(value={"SMAP\nColorPickerElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPickerElement.kt\nmeowing/zen/config/ui/elements/ColorPickerComponent\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n*L\n1#1,347:1\n9#2,3:348\n9#2,3:351\n9#2,3:354\n9#2,3:357\n9#2,3:360\n9#2,3:363\n9#2,3:366\n9#2,3:369\n9#2,3:372\n9#2,3:375\n*S KotlinDebug\n*F\n+ 1 ColorPickerElement.kt\nmeowing/zen/config/ui/elements/ColorPickerComponent\n*L\n113#1:348,3\n119#1:351,3\n128#1:354,3\n148#1:357,3\n155#1:360,3\n163#1:363,3\n181#1:366,3\n188#1:369,3\n196#1:372,3\n213#1:375,3\n*E\n"})
public final class ColorPickerComponent
extends UIContainer {
    @NotNull
    private final Color initialColor;
    @NotNull
    private Color currentColor;
    private float currentHue;
    private float currentSaturation;
    private float currentBrightness;
    private float currentAlpha;
    @NotNull
    private Function1<? super Color, Unit> onValueChange;
    private boolean draggingHue;
    private boolean draggingPicker;
    private boolean draggingAlpha;
    private boolean isChroma;
    @NotNull
    private final ConfigTheme theme;

    public ColorPickerComponent(@NotNull Color initialColor) {
        Intrinsics.checkNotNullParameter((Object)initialColor, (String)"initialColor");
        this.currentColor = this.initialColor = initialColor;
        this.currentAlpha = (float)this.initialColor.getAlpha() / 255.0f;
        this.onValueChange = ColorPickerComponent::onValueChange$lambda$0;
        this.theme = new ConfigTheme();
        float[] hsb = Color.RGBtoHSB(this.initialColor.getRed(), this.initialColor.getGreen(), this.initialColor.getBlue(), null);
        this.currentHue = hsb[0];
        this.currentSaturation = hsb[1];
        this.currentBrightness = hsb[2];
        this.setupUI();
    }

    @NotNull
    public final Color getInitialColor() {
        return this.initialColor;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupUI() {
        void $this$setupUI_u24lambda_u2418;
        UIComponent uIComponent;
        void $this$setupUI_u24lambda_u2411;
        void $this$setupUI_u24lambda_u244;
        UIComponent $this$constrain$iv;
        UIComponent uIComponent2;
        UIComponent $this$constrain$iv2 = (UIComponent)new UIBlock(null, 1, null);
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv2;
        boolean bl = false;
        UIConstraints $this$setupUI_u24lambda_u241 = $this$constrain_u24lambda_u240$iv.getConstraints();
        boolean bl2 = false;
        $this$setupUI_u24lambda_u241.setWidth((WidthConstraint)UtilitiesKt.pixels$default((Number)80, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u241.setHeight((HeightConstraint)UtilitiesKt.percent((Number)100));
        $this$setupUI_u24lambda_u241.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this.theme.getBorder()));
        UIBlock pickerBox = (UIBlock)ComponentsKt.childOf((UIComponent)uIComponent2, (UIComponent)((UIComponent)this));
        UIComponent $this$constrain$iv3 = (UIComponent)new UIContainer();
        boolean $i$f$constrain22 = false;
        UIComponent $this$constrain_u24lambda_u240$iv2 = $this$constrain_u24lambda_u240$iv = $this$constrain$iv3;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u242 = $this$constrain_u24lambda_u240$iv2.getConstraints();
        boolean $i$a$-constrain-ColorPickerComponent$setupUI$pickerIndicator$22 = false;
        $this$setupUI_u24lambda_u242.setX((XConstraint)ConstraintsKt.coerceIn((SuperConstraint)((SuperConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(this.currentSaturation)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(3.5f), (boolean)false, (boolean)false, (int)3, null)))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)true, (boolean)false, (int)2, null))));
        $this$setupUI_u24lambda_u242.setY((YConstraint)ConstraintsKt.coerceIn((SuperConstraint)((SuperConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(1.0f - this.currentBrightness)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(3.5f), (boolean)false, (boolean)false, (int)3, null)))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)true, (boolean)false, (int)2, null))));
        $this$setupUI_u24lambda_u242.setWidth((WidthConstraint)UtilitiesKt.pixels$default((Number)3, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u242.setHeight((HeightConstraint)UtilitiesKt.pixels$default((Number)3, (boolean)false, (boolean)false, (int)3, null));
        UIContainer pickerIndicator = (UIContainer)ComponentsKt.effect((UIComponent)$this$constrain_u24lambda_u240$iv, (Effect)((Effect)new OutlineEffect(this.theme.getAccent(), 1.0f, false, false, null, 28, null)));
        UIComponent $i$f$constrain22 = this.createCustomRenderer((Function2<? super UMatrixStack, ? super UIComponent, Unit>)((Function2)(arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$3(this, arg_0, arg_1)));
        boolean $i$f$constrain3 = false;
        UIComponent $this$constrain_u24lambda_u240$iv3 = $this$constrain_u24lambda_u240$iv2 = $this$constrain$iv;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $i$a$-constrain-ColorPickerComponent$setupUI$pickerIndicator$22 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        UIBlock uIBlock = pickerBox;
        boolean bl3 = false;
        $this$setupUI_u24lambda_u244.setX((XConstraint)UtilitiesKt.pixels$default((Number)1, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u244.setY((YConstraint)UtilitiesKt.pixels$default((Number)-0.5, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u244.setWidth((WidthConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u244.setHeight((HeightConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
        $this$constrain$iv3 = $this$constrain_u24lambda_u240$iv2;
        Intrinsics.checkNotNull((Object)$this$constrain$iv3, (String)"null cannot be cast to non-null type gg.essential.elementa.UIComponent");
        uIBlock.addChild($this$constrain$iv3).addChild((UIComponent)pickerIndicator);
        pickerBox.onMouseClick((arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$5(this, pickerBox, pickerIndicator, arg_0, arg_1)).onMouseDrag((arg_0, arg_1, arg_2, arg_3) -> ColorPickerComponent.setupUI$lambda$6(this, pickerBox, pickerIndicator, arg_0, arg_1, arg_2, arg_3)).onMouseRelease(arg_0 -> ColorPickerComponent.setupUI$lambda$7(this, arg_0));
        $this$constrain$iv = (UIComponent)new UIBlock(null, 1, null);
        $i$f$constrain3 = false;
        $this$constrain_u24lambda_u240$iv3 = $this$constrain_u24lambda_u240$iv2 = $this$constrain$iv;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u248 = $this$constrain_u24lambda_u240$iv3.getConstraints();
        boolean bl4 = false;
        $this$setupUI_u24lambda_u248.setX((XConstraint)new SiblingConstraint(5.0f, false, 2, null));
        $this$setupUI_u24lambda_u248.setWidth((WidthConstraint)UtilitiesKt.pixels$default((Number)14, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u248.setHeight((HeightConstraint)UtilitiesKt.percent((Number)100));
        $this$setupUI_u24lambda_u248.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this.theme.getBorder()));
        UIBlock hueLine = (UIBlock)ComponentsKt.childOf((UIComponent)$this$constrain_u24lambda_u240$iv2, (UIComponent)((UIComponent)this));
        UIComponent $this$constrain$iv4 = (UIComponent)new UIText("\u25c4", false, null, 6, null);
        boolean $i$f$constrain4 = false;
        UIComponent $this$constrain_u24lambda_u240$iv4 = $this$constrain_u24lambda_u240$iv3 = $this$constrain$iv4;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u249 = $this$constrain_u24lambda_u240$iv4.getConstraints();
        boolean bl5 = false;
        $this$setupUI_u24lambda_u249.setX((XConstraint)UtilitiesKt.pixels$default((Number)-4, (boolean)true, (boolean)false, (int)2, null));
        $this$setupUI_u24lambda_u249.setY((YConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(this.currentHue)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)5, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u249.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this.theme.getAccent()));
        UIText hueIndicator = (UIText)$this$constrain_u24lambda_u240$iv3;
        $this$constrain$iv4 = this.createCustomRenderer((Function2<? super UMatrixStack, ? super UIComponent, Unit>)((Function2)(arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$10(this, arg_0, arg_1)));
        $i$f$constrain4 = false;
        $this$constrain_u24lambda_u240$iv4 = $this$constrain_u24lambda_u240$iv3 = $this$constrain$iv4;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$setupUI_u24lambda_u249 = $this$constrain_u24lambda_u240$iv4.getConstraints();
        uIBlock = hueLine;
        boolean bl6 = false;
        $this$setupUI_u24lambda_u2411.setX((XConstraint)UtilitiesKt.pixels$default((Number)1, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u2411.setY((YConstraint)UtilitiesKt.pixels$default((Number)1, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u2411.setWidth((WidthConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u2411.setHeight((HeightConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)3.5, (boolean)false, (boolean)false, (int)3, null))));
        uIBlock.addChild($this$constrain_u24lambda_u240$iv3).addChild((UIComponent)hueIndicator);
        hueLine.onMouseClick((arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$12(this, hueLine, hueIndicator, arg_0, arg_1)).onMouseDrag((arg_0, arg_1, arg_2, arg_3) -> ColorPickerComponent.setupUI$lambda$13(this, hueLine, hueIndicator, arg_0, arg_1, arg_2, arg_3)).onMouseRelease(arg_0 -> ColorPickerComponent.setupUI$lambda$14(this, arg_0));
        UIComponent $this$constrain$iv5 = (UIComponent)new UIBlock(null, 1, null);
        boolean $i$f$constrain5 = false;
        UIComponent $this$constrain_u24lambda_u240$iv5 = $this$constrain_u24lambda_u240$iv4 = $this$constrain$iv5;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u2415 = $this$constrain_u24lambda_u240$iv5.getConstraints();
        boolean bl7 = false;
        $this$setupUI_u24lambda_u2415.setX((XConstraint)new SiblingConstraint(5.0f, false, 2, null));
        $this$setupUI_u24lambda_u2415.setWidth((WidthConstraint)UtilitiesKt.pixels$default((Number)14, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u2415.setHeight((HeightConstraint)UtilitiesKt.percent((Number)75));
        $this$setupUI_u24lambda_u2415.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this.theme.getBorder()));
        UIBlock alphaLine = (UIBlock)ComponentsKt.childOf((UIComponent)$this$constrain_u24lambda_u240$iv4, (UIComponent)((UIComponent)this));
        UIComponent $this$constrain$iv6 = (UIComponent)new UIText("\u25c4", false, null, 6, null);
        boolean $i$f$constrain6 = false;
        UIComponent $this$constrain_u24lambda_u240$iv6 = uIComponent = $this$constrain$iv6;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u2416 = $this$constrain_u24lambda_u240$iv6.getConstraints();
        boolean bl8 = false;
        $this$setupUI_u24lambda_u2416.setX((XConstraint)UtilitiesKt.pixels$default((Number)-4, (boolean)true, (boolean)false, (int)2, null));
        $this$setupUI_u24lambda_u2416.setY((YConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(1.0f - this.currentAlpha)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)5, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u2416.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this.theme.getAccent()));
        UIText alphaIndicator = (UIText)uIComponent;
        $this$constrain$iv6 = this.createCustomRenderer((Function2<? super UMatrixStack, ? super UIComponent, Unit>)((Function2)(arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$17(this, arg_0, arg_1)));
        $i$f$constrain6 = false;
        $this$constrain_u24lambda_u240$iv6 = uIComponent = $this$constrain$iv6;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        $this$setupUI_u24lambda_u2416 = $this$constrain_u24lambda_u240$iv6.getConstraints();
        uIBlock = alphaLine;
        boolean bl9 = false;
        $this$setupUI_u24lambda_u2418.setX((XConstraint)new CenterConstraint());
        $this$setupUI_u24lambda_u2418.setY((YConstraint)new CenterConstraint());
        $this$setupUI_u24lambda_u2418.setWidth((WidthConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u2418.setHeight((HeightConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
        uIBlock.addChild(uIComponent).addChild((UIComponent)alphaIndicator);
        alphaLine.onMouseClick((arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$19(this, alphaLine, alphaIndicator, arg_0, arg_1)).onMouseDrag((arg_0, arg_1, arg_2, arg_3) -> ColorPickerComponent.setupUI$lambda$20(this, alphaLine, alphaIndicator, arg_0, arg_1, arg_2, arg_3)).onMouseRelease(arg_0 -> ColorPickerComponent.setupUI$lambda$21(this, arg_0));
        $this$constrain$iv6 = (UIComponent)new UIBlock(this.initialColor);
        $i$f$constrain6 = false;
        $this$constrain_u24lambda_u240$iv6 = uIComponent = $this$constrain$iv6;
        $i$a$-apply-ComponentsKt$constrain$1$iv = false;
        UIConstraints $this$setupUI_u24lambda_u2422 = $this$constrain_u24lambda_u240$iv6.getConstraints();
        boolean bl10 = false;
        $this$setupUI_u24lambda_u2422.setX((XConstraint)new SiblingConstraint(-12.0f, true));
        $this$setupUI_u24lambda_u2422.setY((YConstraint)ConstraintsKt.plus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)80)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)4, (boolean)false, (boolean)false, (int)3, null))));
        $this$setupUI_u24lambda_u2422.setWidth((WidthConstraint)UtilitiesKt.pixels$default((Number)10, (boolean)false, (boolean)false, (int)3, null));
        $this$setupUI_u24lambda_u2422.setHeight((HeightConstraint)UtilitiesKt.pixels$default((Number)10, (boolean)false, (boolean)false, (int)3, null));
        ((UIBlock)ComponentsKt.effect((UIComponent)ComponentsKt.childOf((UIComponent)uIComponent, (UIComponent)((UIComponent)this)), (Effect)((Effect)new OutlineEffect(this.theme.getBorder(), 1.0f, false, false, null, 28, null)))).onMouseClick((arg_0, arg_1) -> ColorPickerComponent.setupUI$lambda$23(this, arg_0, arg_1));
    }

    private final createCustomRenderer.1 createCustomRenderer(Function2<? super UMatrixStack, ? super UIComponent, Unit> renderer) {
        return new UIComponent(renderer){
            final /* synthetic */ Function2<UMatrixStack, UIComponent, Unit> $renderer;
            {
                this.$renderer = $renderer;
            }

            public void draw(UMatrixStack matrixStack) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                super.beforeDraw(matrixStack);
                this.$renderer.invoke((Object)matrixStack, (Object)((Object)this));
                super.draw(matrixStack);
            }
        };
    }

    private final void updateHueIndicator(UIText indicator) {
        indicator.setY((YConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(RangesKt.coerceAtMost((float)this.currentHue, (float)0.98f))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)3, (boolean)false, (boolean)false, (int)3, null))));
        this.recalculateColor();
    }

    private final void updateAlphaIndicator(UIText indicator) {
        indicator.setY((YConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(1.0f - RangesKt.coerceAtMost((float)this.currentAlpha, (float)0.98f))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)3, (boolean)false, (boolean)false, (int)3, null))));
        this.recalculateColor();
    }

    private final void updatePickerIndicator(UIContainer indicator) {
        indicator.setX((XConstraint)ConstraintsKt.coerceIn((SuperConstraint)((SuperConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(this.currentSaturation)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(2.5f), (boolean)false, (boolean)false, (int)3, null)))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)true, (boolean)false, (int)2, null))));
        indicator.setY((YConstraint)ConstraintsKt.coerceIn((SuperConstraint)((SuperConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)new RelativeConstraint(1.0f - this.currentBrightness)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(2.5f), (boolean)false, (boolean)false, (int)3, null)))), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)true, (boolean)false, (int)2, null))));
        this.recalculateColor();
    }

    private final void recalculateColor() {
        Color color;
        Color color2;
        int alpha = RangesKt.coerceIn((int)MathKt.roundToInt((float)(this.currentAlpha * (float)255)), (int)0, (int)255);
        if (this.isChroma) {
            color2 = new Color(RangesKt.coerceIn((int)this.theme.getAccent().getRed(), (int)0, (int)255), RangesKt.coerceIn((int)this.theme.getAccent().getGreen(), (int)0, (int)255), RangesKt.coerceIn((int)this.theme.getAccent().getBlue(), (int)0, (int)255), alpha);
        } else {
            int rgb = Color.HSBtoRGB(RangesKt.coerceIn((float)this.currentHue, (float)0.0f, (float)1.0f), RangesKt.coerceIn((float)this.currentSaturation, (float)0.0f, (float)1.0f), RangesKt.coerceIn((float)this.currentBrightness, (float)0.0f, (float)1.0f));
            Color c = new Color(rgb);
            color2 = new Color(RangesKt.coerceIn((int)c.getRed(), (int)0, (int)255), RangesKt.coerceIn((int)c.getGreen(), (int)0, (int)255), RangesKt.coerceIn((int)c.getBlue(), (int)0, (int)255), alpha);
        }
        this.currentColor = color = color2;
        this.onValueChange.invoke((Object)color);
    }

    public final void onValueChange(@NotNull Function1<? super Color, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onValueChange = listener;
    }

    private final void drawColorPicker(UMatrixStack matrixStack, UIComponent component) {
        double left = component.getLeft();
        double top = component.getTop();
        double right = component.getRight();
        double bottom = component.getBottom();
        double height = bottom - top;
        for (int x = 0; x < 50; ++x) {
            double leftX = left + (right - left) * (double)x / (double)50.0f;
            double rightX = left + (right - left) * (double)(x + 1) / (double)50.0f;
            boolean first = true;
            for (int y = 0; y < 51; ++y) {
                double yPos = top + (double)y * height / 50.0;
                Color color = new Color(Color.HSBtoRGB(this.currentHue, (float)x / 50.0f, 1.0f - (float)y / 50.0f));
                if (!first) {
                    UIBlock.Companion.drawBlock(matrixStack, color, leftX, yPos, rightX, yPos + height / 50.0);
                }
                first = false;
            }
        }
    }

    private final void drawHueLine(UMatrixStack matrixStack, UIComponent component) {
        double left = component.getLeft();
        double top = component.getTop();
        double right = component.getRight();
        double height = component.getHeight();
        for (int i = 0; i < 51; ++i) {
            double yPos = top + (double)i * height / 50.0;
            Color color = new Color(Color.HSBtoRGB((float)i / 50.0f, 1.0f, 0.8f));
            UIBlock.Companion.drawBlock(matrixStack, color, left, yPos, right, yPos + height / 50.0);
        }
    }

    private final void drawAlphaLine(UMatrixStack matrixStack, UIComponent component) {
        int y;
        double left = component.getLeft();
        double top = component.getTop();
        double width = component.getWidth();
        double height = component.getHeight();
        double rectSize = 2.0;
        int n = (int)(height / rectSize);
        for (y = 0; y < n; ++y) {
            int n2 = (int)(width / rectSize);
            for (int x = 0; x < n2; ++x) {
                Color baseColor = (x + y) % 2 == 0 ? this.theme.getPanel() : this.theme.getElement();
                UIBlock.Companion.drawBlock(matrixStack, baseColor, left + (double)x * rectSize, top + (double)y * rectSize, left + (double)(x + 1) * rectSize, top + (double)(y + 1) * rectSize);
            }
        }
        n = (int)height;
        for (y = 0; y < n; ++y) {
            int alpha = RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)255 * ((double)1.0f - (double)y / height))), (int)0, (int)255);
            UIBlock.Companion.drawBlock(matrixStack, new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), alpha), left, top + (double)y, left + width, top + (double)y + 1.0);
        }
    }

    private static final Unit onValueChange$lambda$0(Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$3(ColorPickerComponent this$0, UMatrixStack matrixStack, UIComponent component) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.drawColorPicker(matrixStack, component);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$5(ColorPickerComponent this$0, UIBlock $pickerBox, UIContainer $pickerIndicator, UIComponent $this$onMouseClick, UIClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.isChroma = false;
        this$0.draggingPicker = true;
        this$0.currentSaturation = event.getRelativeX() / $pickerBox.getWidth();
        this$0.currentBrightness = 1.0f - event.getRelativeY() / $pickerBox.getHeight();
        this$0.updatePickerIndicator($pickerIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$6(ColorPickerComponent this$0, UIBlock $pickerBox, UIContainer $pickerIndicator, UIComponent $this$onMouseDrag, float mouseX, float mouseY, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
        if (!this$0.draggingPicker) {
            return Unit.INSTANCE;
        }
        this$0.currentSaturation = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseX / $pickerBox.getWidth()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        this$0.currentBrightness = 1.0f - ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseY / $pickerBox.getHeight()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        this$0.updatePickerIndicator($pickerIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$7(ColorPickerComponent this$0, UIComponent $this$onMouseRelease) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
        this$0.draggingPicker = false;
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$10(ColorPickerComponent this$0, UMatrixStack matrixStack, UIComponent component) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.drawHueLine(matrixStack, component);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$12(ColorPickerComponent this$0, UIBlock $hueLine, UIText $hueIndicator, UIComponent $this$onMouseClick, UIClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.draggingHue = true;
        this$0.currentHue = (event.getRelativeY() - 1.0f) / $hueLine.getHeight();
        this$0.isChroma = false;
        this$0.updateHueIndicator($hueIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$13(ColorPickerComponent this$0, UIBlock $hueLine, UIText $hueIndicator, UIComponent $this$onMouseDrag, float f, float mouseY, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
        if (!this$0.draggingHue) {
            return Unit.INSTANCE;
        }
        this$0.currentHue = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((mouseY - 1.0f) / $hueLine.getHeight()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        this$0.updateHueIndicator($hueIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$14(ColorPickerComponent this$0, UIComponent $this$onMouseRelease) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
        this$0.draggingHue = false;
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$17(ColorPickerComponent this$0, UMatrixStack matrixStack, UIComponent component) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.drawAlphaLine(matrixStack, component);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$19(ColorPickerComponent this$0, UIBlock $alphaLine, UIText $alphaIndicator, UIComponent $this$onMouseClick, UIClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.draggingAlpha = true;
        this$0.currentAlpha = 1.0f - (event.getRelativeY() - 1.0f) / $alphaLine.getHeight();
        this$0.updateAlphaIndicator($alphaIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$20(ColorPickerComponent this$0, UIBlock $alphaLine, UIText $alphaIndicator, UIComponent $this$onMouseDrag, float f, float mouseY, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
        if (!this$0.draggingAlpha) {
            return Unit.INSTANCE;
        }
        this$0.currentAlpha = 1.0f - ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((mouseY - 1.0f) / $alphaLine.getHeight()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        this$0.updateAlphaIndicator($alphaIndicator);
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$21(ColorPickerComponent this$0, UIComponent $this$onMouseRelease) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
        this$0.draggingAlpha = false;
        return Unit.INSTANCE;
    }

    private static final Unit setupUI$lambda$23(ColorPickerComponent this$0, UIComponent $this$onMouseClick, UIClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.isChroma = true;
        this$0.onValueChange.invoke((Object)this$0.initialColor);
        return Unit.INSTANCE;
    }
}

