/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.config.ui.elements;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.RelativeConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.constraints.animation.AnimatingConstraints;
import gg.essential.elementa.constraints.animation.AnimationStrategy;
import gg.essential.elementa.constraints.animation.Animations;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ExtensionsKt;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import meowing.zen.config.ui.elements.MCColorCode;
import meowing.zen.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lmeowing/zen/config/ui/elements/MCColorPickerElement;", "Lgg/essential/elementa/components/UIContainer;", "Lmeowing/zen/config/ui/elements/MCColorCode;", "initialValue", "Lkotlin/Function1;", "", "onChange", "<init>", "(Lmeowing/zen/config/ui/elements/MCColorCode;Lkotlin/jvm/functions/Function1;)V", "createColorButtons", "()V", "updateSelection", "colorCode", "setValue", "(Lmeowing/zen/config/ui/elements/MCColorCode;)V", "getValue", "()Lmeowing/zen/config/ui/elements/MCColorCode;", "Lkotlin/jvm/functions/Function1;", "selectedColor", "Lmeowing/zen/config/ui/elements/MCColorCode;", "colorGrid", "Lgg/essential/elementa/components/UIContainer;", "", "Lgg/essential/elementa/UIComponent;", "colorButtons", "Ljava/util/Map;", "selectionBorders", "Zen"})
@SourceDebugExtension(value={"SMAP\nMCColorPickerElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MCColorPickerElement.kt\nmeowing/zen/config/ui/elements/MCColorPickerElement\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 animations.kt\ngg/essential/elementa/dsl/AnimationsKt\n*L\n1#1,123:1\n9#2,3:124\n9#2,3:129\n9#2,3:132\n9#2,3:135\n1872#3,2:127\n1874#3:138\n216#4,2:139\n10#5,5:141\n10#5,5:146\n*S KotlinDebug\n*F\n+ 1 MCColorPickerElement.kt\nmeowing/zen/config/ui/elements/MCColorPickerElement\n*L\n41#1:124,3\n62#1:129,3\n69#1:132,3\n76#1:135,3\n57#1:127,2\n57#1:138\n112#1:139,2\n92#1:141,5\n100#1:146,5\n*E\n"})
public final class MCColorPickerElement
extends UIContainer {
    @Nullable
    private final Function1<MCColorCode, Unit> onChange;
    @NotNull
    private MCColorCode selectedColor;
    @NotNull
    private final UIContainer colorGrid;
    @NotNull
    private final Map<MCColorCode, UIComponent> colorButtons;
    @NotNull
    private final Map<MCColorCode, UIComponent> selectionBorders;

    /*
     * WARNING - void declaration
     */
    public MCColorPickerElement(@NotNull MCColorCode initialValue, @Nullable Function1<? super MCColorCode, Unit> onChange) {
        void $this$_init__u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        this.onChange = onChange;
        this.selectedColor = initialValue;
        this.colorButtons = new LinkedHashMap();
        this.selectionBorders = new LinkedHashMap();
        UIComponent $this$constrain$iv = (UIComponent)new UIContainer();
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        MCColorPickerElement mCColorPickerElement = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setX((XConstraint)UtilitiesKt.pixels$default((Number)0, (boolean)false, (boolean)false, (int)3, null));
        $this$_init__u24lambda_u240.setY((YConstraint)new CenterConstraint());
        $this$_init__u24lambda_u240.setWidth((WidthConstraint)UtilitiesKt.percent((Number)100));
        $this$_init__u24lambda_u240.setHeight((HeightConstraint)UtilitiesKt.pixels$default((Number)18, (boolean)false, (boolean)false, (int)3, null));
        mCColorPickerElement.colorGrid = (UIContainer)ComponentsKt.childOf((UIComponent)uIComponent, (UIComponent)((UIComponent)this));
        this.createColorButtons();
        this.updateSelection();
    }

    public /* synthetic */ MCColorPickerElement(MCColorCode mCColorCode, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mCColorCode = MCColorCode.WHITE;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(mCColorCode, (Function1<? super MCColorCode, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void createColorButtons() {
        EnumEntries<MCColorCode> colors = MCColorCode.getEntries();
        int totalColors = colors.size();
        float spacing = 1.0f;
        Iterable $this$forEachIndexed$iv = (Iterable)colors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void colorCode;
            UIComponent uIComponent;
            UIComponent uIComponent2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MCColorCode mCColorCode = (MCColorCode)((Object)item$iv);
            int index = n;
            boolean bl = false;
            float buttonWidthPercent = (100.0f - (float)(totalColors - 1) * spacing) / (float)totalColors;
            RelativeConstraint buttonWidth = UtilitiesKt.percent((Number)Float.valueOf(buttonWidthPercent));
            RelativeConstraint xOffset = UtilitiesKt.percent((Number)Float.valueOf((float)index * (buttonWidthPercent + spacing)));
            UIComponent $this$constrain$iv = (UIComponent)new UIContainer();
            boolean $i$f$constrain = false;
            UIComponent $this$constrain_u24lambda_u240$iv = uIComponent2 = $this$constrain$iv;
            boolean bl2 = false;
            UIConstraints $this$createColorButtons_u24lambda_u249_u24lambda_u241 = $this$constrain_u24lambda_u240$iv.getConstraints();
            boolean bl3 = false;
            $this$createColorButtons_u24lambda_u249_u24lambda_u241.setX((XConstraint)xOffset);
            $this$createColorButtons_u24lambda_u249_u24lambda_u241.setY((YConstraint)UtilitiesKt.pixels$default((Number)0, (boolean)false, (boolean)false, (int)3, null));
            $this$createColorButtons_u24lambda_u249_u24lambda_u241.setWidth((WidthConstraint)buttonWidth);
            $this$createColorButtons_u24lambda_u249_u24lambda_u241.setHeight((HeightConstraint)UtilitiesKt.percent((Number)100));
            UIContainer borderContainer = (UIContainer)ComponentsKt.childOf((UIComponent)uIComponent2, (UIComponent)((UIComponent)this.colorGrid));
            UIComponent $this$constrain$iv2 = Utils.INSTANCE.createBlock(2.0f);
            boolean $i$f$constrain2 = false;
            UIComponent $this$constrain_u24lambda_u240$iv2 = $this$constrain_u24lambda_u240$iv = $this$constrain$iv2;
            $i$a$-apply-ComponentsKt$constrain$1$iv = false;
            UIConstraints $this$createColorButtons_u24lambda_u249_u24lambda_u242 = $this$constrain_u24lambda_u240$iv2.getConstraints();
            boolean bl4 = false;
            $this$createColorButtons_u24lambda_u249_u24lambda_u242.setX((XConstraint)UtilitiesKt.pixels$default((Number)-1, (boolean)false, (boolean)false, (int)3, null));
            $this$createColorButtons_u24lambda_u249_u24lambda_u242.setY((YConstraint)UtilitiesKt.pixels$default((Number)-1, (boolean)false, (boolean)false, (int)3, null));
            $this$createColorButtons_u24lambda_u249_u24lambda_u242.setWidth((WidthConstraint)ConstraintsKt.plus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
            $this$createColorButtons_u24lambda_u249_u24lambda_u242.setHeight((HeightConstraint)ConstraintsKt.plus((SuperConstraint)((SuperConstraint)UtilitiesKt.percent((Number)100)), (SuperConstraint)((SuperConstraint)UtilitiesKt.pixels$default((Number)2, (boolean)false, (boolean)false, (int)3, null))));
            UIComponent selectionBorder = ComponentsKt.childOf((UIComponent)$this$constrain_u24lambda_u240$iv.setColor(new Color(170, 230, 240, 255)), (UIComponent)((UIComponent)borderContainer));
            UIComponent $this$constrain$iv3 = Utils.INSTANCE.createBlock(2.0f);
            boolean $i$f$constrain3 = false;
            UIComponent $this$constrain_u24lambda_u240$iv3 = uIComponent = $this$constrain$iv3;
            $i$a$-apply-ComponentsKt$constrain$1$iv = false;
            UIConstraints $this$createColorButtons_u24lambda_u249_u24lambda_u243 = $this$constrain_u24lambda_u240$iv3.getConstraints();
            boolean bl5 = false;
            $this$createColorButtons_u24lambda_u249_u24lambda_u243.setX((XConstraint)UtilitiesKt.pixels$default((Number)0, (boolean)false, (boolean)false, (int)3, null));
            $this$createColorButtons_u24lambda_u249_u24lambda_u243.setY((YConstraint)UtilitiesKt.pixels$default((Number)0, (boolean)false, (boolean)false, (int)3, null));
            $this$createColorButtons_u24lambda_u249_u24lambda_u243.setWidth((WidthConstraint)UtilitiesKt.percent((Number)100));
            $this$createColorButtons_u24lambda_u249_u24lambda_u243.setHeight((HeightConstraint)UtilitiesKt.percent((Number)100));
            UIComponent button = ComponentsKt.childOf((UIComponent)uIComponent.setColor(colorCode.getColor()), (UIComponent)((UIComponent)borderContainer));
            button.onMouseClick((arg_0, arg_1) -> MCColorPickerElement.createColorButtons$lambda$9$lambda$4(this, (MCColorCode)colorCode, button, arg_0, arg_1));
            button.onMouseEnter(arg_0 -> MCColorPickerElement.createColorButtons$lambda$9$lambda$6(this, (MCColorCode)colorCode, arg_0));
            button.onMouseLeave(arg_0 -> MCColorPickerElement.createColorButtons$lambda$9$lambda$8(this, (MCColorCode)colorCode, arg_0));
            this.colorButtons.put((MCColorCode)colorCode, button);
            this.selectionBorders.put((MCColorCode)colorCode, selectionBorder);
        }
    }

    private final void updateSelection() {
        Map<MCColorCode, UIComponent> $this$forEach$iv = this.selectionBorders;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<MCColorCode, UIComponent>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MCColorCode, UIComponent> element$iv;
            Map.Entry<MCColorCode, UIComponent> entry = element$iv = iterator.next();
            boolean bl = false;
            MCColorCode colorCode = entry.getKey();
            UIComponent border = entry.getValue();
            if (colorCode == this.selectedColor) {
                UIComponent.unhide$default((UIComponent)border, (boolean)false, (int)1, null);
                continue;
            }
            UIComponent.hide$default((UIComponent)border, (boolean)false, (int)1, null);
        }
    }

    public final void setValue(@NotNull MCColorCode colorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorCode), (String)"colorCode");
        this.selectedColor = colorCode;
        this.updateSelection();
    }

    @NotNull
    public final MCColorCode getValue() {
        return this.selectedColor;
    }

    private static final Unit createColorButtons$lambda$9$lambda$4(MCColorPickerElement this$0, MCColorCode $colorCode, UIComponent $button, UIComponent $this$onMouseClick, UIClickEvent it) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.selectedColor = $colorCode;
        this$0.updateSelection();
        Function1<MCColorCode, Unit> function1 = this$0.onChange;
        if (function1 != null) {
            function1.invoke((Object)$colorCode);
        }
        $button.setColor($colorCode.getColor());
        return Unit.INSTANCE;
    }

    private static final Unit createColorButtons$lambda$9$lambda$6(MCColorPickerElement this$0, MCColorCode $colorCode, UIComponent $this$onMouseEnter) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseEnter, (String)"$this$onMouseEnter");
        if (this$0.selectedColor != $colorCode) {
            AnimatingConstraints anim$iv;
            UIComponent uIComponent;
            UIComponent $this$animate$iv = $this$onMouseEnter;
            boolean $i$f$animate = false;
            UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
            boolean bl = false;
            AnimatingConstraints $this$createColorButtons_u24lambda_u249_u24lambda_u246_u24lambda_u245 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
            boolean bl2 = false;
            AnimatingConstraints.setColorAnimation$default((AnimatingConstraints)$this$createColorButtons_u24lambda_u249_u24lambda_u246_u24lambda_u245, (AnimationStrategy)((AnimationStrategy)Animations.OUT_QUAD), (float)0.1f, (ColorConstraint)((ColorConstraint)UtilitiesKt.toConstraint((Color)ExtensionsKt.withAlpha((Color)$colorCode.getColor(), (int)180))), (float)0.0f, (int)8, null);
            $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createColorButtons$lambda$9$lambda$8(MCColorPickerElement this$0, MCColorCode $colorCode, UIComponent $this$onMouseLeave) {
        Intrinsics.checkNotNullParameter((Object)$this$onMouseLeave, (String)"$this$onMouseLeave");
        if (this$0.selectedColor != $colorCode) {
            AnimatingConstraints anim$iv;
            UIComponent uIComponent;
            UIComponent $this$animate$iv = $this$onMouseLeave;
            boolean $i$f$animate = false;
            UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
            boolean bl = false;
            AnimatingConstraints $this$createColorButtons_u24lambda_u249_u24lambda_u248_u24lambda_u247 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
            boolean bl2 = false;
            AnimatingConstraints.setColorAnimation$default((AnimatingConstraints)$this$createColorButtons_u24lambda_u249_u24lambda_u248_u24lambda_u247, (AnimationStrategy)((AnimationStrategy)Animations.OUT_QUAD), (float)0.1f, (ColorConstraint)((ColorConstraint)UtilitiesKt.toConstraint((Color)$colorCode.getColor())), (float)0.0f, (int)8, null);
            $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
        }
        return Unit.INSTANCE;
    }

    public MCColorPickerElement() {
        this(null, null, 3, null);
    }
}

