/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.dungeons;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.events.TickEvent;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.TickUtils;
import meowing.zen.utils.Utils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0003R\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lmeowing/zen/features/dungeons/ServerLagTimer;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "addConfig", "(Lmeowing/zen/config/ui/ConfigUI;)Lmeowing/zen/config/ui/ConfigUI;", "", "initialize", "onRegister", "onUnregister", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "regex", "Ljava/util/regex/Pattern;", "", "sent", "Z", "ticking", "", "clienttick", "J", "servertick", "Zen"})
@SourceDebugExtension(value={"SMAP\nServerLagTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerLagTimer.kt\nmeowing/zen/features/dungeons/ServerLagTimer\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n112#2,2:78\n114#2:88\n112#2,2:89\n114#2:99\n112#2,2:100\n114#2:110\n205#3,2:80\n207#3,3:85\n205#3,2:91\n207#3,3:96\n205#3,2:102\n207#3,3:107\n72#4,2:82\n72#4,2:93\n72#4,2:104\n1#5:84\n1#5:95\n1#5:106\n*S KotlinDebug\n*F\n+ 1 ServerLagTimer.kt\nmeowing/zen/features/dungeons/ServerLagTimer\n*L\n34#1:78,2\n34#1:88\n53#1:89,2\n53#1:99\n56#1:100,2\n56#1:110\n34#1:80,2\n34#1:85,3\n53#1:91,2\n53#1:96,3\n56#1:102,2\n56#1:107,3\n34#1:82,2\n53#1:93,2\n56#1:104,2\n34#1:84\n53#1:95\n56#1:106\n*E\n"})
public final class ServerLagTimer
extends Feature {
    @NotNull
    public static final ServerLagTimer INSTANCE = new ServerLagTimer();
    private static final Pattern regex = Pattern.compile("^\\s*\u2620 Defeated .+ in 0?[\\dhms ]+?\\s*(?:\\(NEW RECORD!\\))?$");
    private static boolean sent;
    private static boolean ticking;
    private static long clienttick;
    private static long servertick;

    private ServerLagTimer() {
        super("serverlagtimer", false, "catacombs", null, 10, null);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)((Object)configUI), (String)"configUI");
        return configUI.addElement("Dungeons", "Server lag timer", new ConfigElement("serverlagtimer", null, new ElementType.Switch(false), null, 8, null), true);
    }

    @Override
    public void initialize() {
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        Function1 cb$iv = ServerLagTimer::initialize$lambda$1;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = ServerLagTimer::initialize$lambda$2;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list2 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = TickEvent.Server.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list2.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = ServerLagTimer::initialize$lambda$3;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list3 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = TickEvent.Client.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object3 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object3 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object3 == null) {
                object3 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object3;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list3.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    @Override
    public void onRegister() {
        sent = false;
        clienttick = 0L;
        servertick = 0L;
        ticking = false;
        super.onRegister();
    }

    @Override
    public void onUnregister() {
        sent = false;
        clienttick = 0L;
        servertick = 0L;
        ticking = false;
        super.onUnregister();
    }

    private static final Unit initialize$lambda$1$lambda$0(double $lagtime, long $lagtick) {
        String string = "%.1f";
        Object[] objectArray = new Object[]{$lagtime};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fServer lagged for \u00a7c" + string2 + "s \u00a77| \u00a7c" + $lagtick + " ticks\u00a7f.", null, null, null, null, 30, null);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String text = Utils.INSTANCE.removeFormatting(event.getMessage().getString());
        if (Intrinsics.areEqual((Object)text, (Object)"[NPC] Mort: Good luck.")) {
            ticking = true;
            sent = false;
        } else if (regex.matcher(text).matches() && !sent) {
            long lagtick = clienttick - servertick;
            double lagtime = (double)lagtick / 20.0;
            ticking = false;
            sent = true;
            TickUtils.INSTANCE.schedule(2L, (Function0<Unit>)((Function0)() -> ServerLagTimer.initialize$lambda$1$lambda$0(lagtime, lagtick)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(TickEvent.Server event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ticking) {
            long l = servertick;
            servertick = l + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(TickEvent.Client event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ticking) {
            long l = clienttick;
            clienttick = l + 1L;
        }
        return Unit.INSTANCE;
    }
}

