/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.general;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.CommandUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import org.jetbrains.annotations.NotNull;

@Zen.Command
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lmeowing/zen/features/general/CalculatorCommand;", "Lmeowing/zen/utils/CommandUtils;", "<init>", "()V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "", "buildCommand", "(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)V", "", "s", "", "eval", "(Ljava/lang/String;)D", "Zen"})
public final class CalculatorCommand
extends CommandUtils {
    @NotNull
    public static final CalculatorCommand INSTANCE = new CalculatorCommand();

    private CalculatorCommand() {
        super("zencalc", CollectionsKt.listOf((Object)"calc"));
    }

    @Override
    public int execute(@NotNull CommandContext<FabricClientCommandSource> context) {
        int n;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        try {
            String string;
            String eq = StringArgumentType.getString(context, (String)"equation");
            Intrinsics.checkNotNull((Object)eq);
            CharSequence charSequence = eq;
            Regex regex = new Regex("[^0-9+\\-*/().\\s]");
            String string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("\\s");
            string2 = "";
            String clean = regex.replace(charSequence, string2);
            double result = this.eval(clean);
            if (result == (double)((int)result)) {
                string = String.valueOf((int)result);
            } else {
                Object object = "%.10f";
                Object[] objectArray = new Object[]{result};
                String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                object = new char[1];
                object[0] = 48;
                String string4 = StringsKt.trimEnd((String)string3, (char[])object);
                object = new char[1];
                object[0] = 46;
                string = StringsKt.trimEnd((String)string4, (char[])object);
            }
            String display = string;
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7b" + eq + " \u00a7f= \u00a7b" + display, null, null, null, null, 30, null);
            n = 1;
        }
        catch (Exception e) {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fInvalid equation.", null, null, null, null, 30, null);
            n = 0;
        }
        return n;
    }

    @Override
    public void buildCommand(@NotNull LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        builder.then(ClientCommandManager.argument((String)"equation", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(CalculatorCommand::buildCommand$lambda$0));
    }

    public final double eval(@NotNull String s) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Ref.IntRef i = new Ref.IntRef();
        Ref.ObjectRef expr = new Ref.ObjectRef();
        Ref.ObjectRef term = new Ref.ObjectRef();
        Ref.ObjectRef factor = new Ref.ObjectRef();
        expr.element = () -> CalculatorCommand.eval$lambda$1(term, i, s);
        term.element = () -> CalculatorCommand.eval$lambda$2(factor, i, s);
        factor.element = () -> CalculatorCommand.eval$lambda$3(expr, factor, i, s);
        if (expr.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"expr");
            function0 = null;
        } else {
            function0 = (Function0)expr.element;
        }
        return ((Number)function0.invoke()).doubleValue();
    }

    private static final int buildCommand$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<FabricClientCommandSource>)it);
    }

    private static final char eval$next(Ref.IntRef i, String $s) {
        char c;
        if (i.element < $s.length()) {
            int n = i.element;
            i.element = n + 1;
            c = $s.charAt(n);
        } else {
            c = '\u0000';
        }
        return c;
    }

    private static final char eval$peek(Ref.IntRef i, String $s) {
        return i.element < $s.length() ? $s.charAt(i.element) : (char)'\u0000';
    }

    private static final double eval$num(Ref.IntRef i, String $s) {
        double n = 0.0;
        while (Character.isDigit(CalculatorCommand.eval$peek(i, $s))) {
            n = n * (double)10 + (double)(CalculatorCommand.eval$next(i, $s) - 48);
        }
        if (CalculatorCommand.eval$peek(i, $s) == '.') {
            CalculatorCommand.eval$next(i, $s);
            double d = 0.1;
            while (Character.isDigit(CalculatorCommand.eval$peek(i, $s))) {
                n += (double)(CalculatorCommand.eval$next(i, $s) - 48) * d;
                d *= 0.1;
            }
        }
        return n;
    }

    private static final double eval$lambda$1(Ref.ObjectRef $term, Ref.IntRef $i, String $s) {
        Function0 function0;
        if ($term.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"term");
            function0 = null;
        } else {
            function0 = (Function0)$term.element;
        }
        double r = ((Number)function0.invoke()).doubleValue();
        while (StringsKt.contains$default((CharSequence)"+-", (char)CalculatorCommand.eval$peek($i, $s), (boolean)false, (int)2, null)) {
            double d;
            if (CalculatorCommand.eval$next($i, $s) == '+') {
                Function0 function02;
                if ($term.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"term");
                    function02 = null;
                } else {
                    function02 = (Function0)$term.element;
                }
                d = r + ((Number)function02.invoke()).doubleValue();
            } else {
                Function0 function03;
                if ($term.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"term");
                    function03 = null;
                } else {
                    function03 = (Function0)$term.element;
                }
                d = r - ((Number)function03.invoke()).doubleValue();
            }
            r = d;
        }
        return r;
    }

    private static final double eval$lambda$2(Ref.ObjectRef $factor, Ref.IntRef $i, String $s) {
        Function0 function0;
        if ($factor.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factor");
            function0 = null;
        } else {
            function0 = (Function0)$factor.element;
        }
        double r = ((Number)function0.invoke()).doubleValue();
        while (StringsKt.contains$default((CharSequence)"*/", (char)CalculatorCommand.eval$peek($i, $s), (boolean)false, (int)2, null)) {
            double d;
            if (CalculatorCommand.eval$next($i, $s) == '*') {
                Function0 function02;
                if ($factor.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"factor");
                    function02 = null;
                } else {
                    function02 = (Function0)$factor.element;
                }
                d = r * ((Number)function02.invoke()).doubleValue();
            } else {
                Function0 function03;
                if ($factor.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"factor");
                    function03 = null;
                } else {
                    function03 = (Function0)$factor.element;
                }
                d = r / ((Number)function03.invoke()).doubleValue();
            }
            r = d;
        }
        return r;
    }

    private static final double eval$lambda$3(Ref.ObjectRef $expr, Ref.ObjectRef $factor, Ref.IntRef $i, String $s) {
        return switch (CalculatorCommand.eval$peek($i, $s)) {
            case '(' -> {
                Function0 v0;
                CalculatorCommand.eval$next($i, $s);
                if ($expr.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"expr");
                    v0 = null;
                } else {
                    v0 = (Function0)$expr.element;
                }
                double r = ((Number)v0.invoke()).doubleValue();
                CalculatorCommand.eval$next($i, $s);
                yield r;
            }
            case '-' -> {
                Function0 v2;
                CalculatorCommand.eval$next($i, $s);
                if ($factor.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"factor");
                    v2 = null;
                } else {
                    v2 = (Function0)$factor.element;
                }
                yield -((Number)v2.invoke()).doubleValue();
            }
            case '+' -> {
                Function0 v3;
                CalculatorCommand.eval$next($i, $s);
                if ($factor.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"factor");
                    v3 = null;
                } else {
                    v3 = (Function0)$factor.element;
                }
                yield ((Number)v3.invoke()).doubleValue();
            }
            default -> CalculatorCommand.eval$num($i, $s);
        };
    }
}

