/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.general;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\u0003R#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lmeowing/zen/features/general/ChatEmotes;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "addConfig", "(Lmeowing/zen/config/ui/ConfigUI;)Lmeowing/zen/config/ui/ConfigUI;", "", "initialize", "", "", "HYPIXEL_EMOTES", "Ljava/util/Map;", "getHYPIXEL_EMOTES", "()Ljava/util/Map;", "Zen"})
@SourceDebugExtension(value={"SMAP\nChatEmotes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatEmotes.kt\nmeowing/zen/features/general/ChatEmotes\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n112#2,2:80\n114#2:90\n205#3,2:82\n207#3,3:87\n72#4,2:84\n1#5:86\n*S KotlinDebug\n*F\n+ 1 ChatEmotes.kt\nmeowing/zen/features/general/ChatEmotes\n*L\n66#1:80,2\n66#1:90\n66#1:82,2\n66#1:87,3\n66#1:84,2\n66#1:86\n*E\n"})
public final class ChatEmotes
extends Feature {
    @NotNull
    public static final ChatEmotes INSTANCE = new ChatEmotes();
    @NotNull
    private static final Map<String, String> HYPIXEL_EMOTES;

    private ChatEmotes() {
        super("chatemotes", false, null, null, 14, null);
    }

    @NotNull
    public final Map<String, String> getHYPIXEL_EMOTES() {
        return HYPIXEL_EMOTES;
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)((Object)configUI), (String)"configUI");
        return ConfigUI.addElement$default(configUI.addElement("General", "Chat Emotes", new ConfigElement("chatemotes", "Automatically replace emote codes with Unicode symbols in chat messages", new ElementType.Switch(false), null, 8, null), true), "General", "Chat Emotes", "", new ConfigElement("", null, new ElementType.TextParagraph("Automatically replace emote codes with Unicode symbols in chat messages, example: <3 becomes \u2764, use /emotes to see all supported emotes."), null, 8, null), false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        void this_$iv$iv;
        Regex emotePattern = new Regex(CollectionsKt.joinToString$default((Iterable)HYPIXEL_EMOTES.keySet(), (CharSequence)"|", null, null, (int)0, null, ChatEmotes::initialize$lambda$0, (int)30, null));
        Function1 cb$iv = arg_0 -> ChatEmotes.initialize$lambda$2(emotePattern, arg_0);
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class<ChatEvent.Send> eventClass$iv$iv = ChatEvent.Send.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    private static final CharSequence initialize$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Regex.Companion.escape(it);
    }

    private static final CharSequence initialize$lambda$2$lambda$1(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String string = HYPIXEL_EMOTES.get(matchResult.getValue());
        return string != null ? (CharSequence)string : (CharSequence)matchResult.getValue();
    }

    private static final Unit initialize$lambda$2(Regex $emotePattern, ChatEvent.Send event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getChatUtils()) {
            return Unit.INSTANCE;
        }
        String newMessage = $emotePattern.replace((CharSequence)event.getMessage(), ChatEmotes::initialize$lambda$2$lambda$1);
        if (!Intrinsics.areEqual((Object)newMessage, (Object)event.getMessage())) {
            event.cancel();
            ChatUtils.INSTANCE.chat(newMessage);
        }
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"<3", (Object)"\u2764"), TuplesKt.to((Object)":star:", (Object)"\u272e"), TuplesKt.to((Object)":yes:", (Object)"\u2714"), TuplesKt.to((Object)":no:", (Object)"\u2716"), TuplesKt.to((Object)":java:", (Object)"\u2615"), TuplesKt.to((Object)":arrow:", (Object)"\u279c"), TuplesKt.to((Object)":shrug:", (Object)"\u00af\\_(\u30c4)_/\u00af"), TuplesKt.to((Object)":tableflip:", (Object)"(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b"), TuplesKt.to((Object)"o/", (Object)"( \uff9f\u25e1\uff9f)/"), TuplesKt.to((Object)":123:", (Object)"123"), TuplesKt.to((Object)":totem:", (Object)"\u25ce_\u25ce"), TuplesKt.to((Object)":typing:", (Object)"\u270e..."), TuplesKt.to((Object)":maths:", (Object)"\u221a(\u03c0+x)=L"), TuplesKt.to((Object)":snail:", (Object)"@'-'"), TuplesKt.to((Object)":thinking:", (Object)"(0.o?)"), TuplesKt.to((Object)":gimme:", (Object)"\u0f3c\u3064 \u25d5_\u25d5 \u0f3d\u3064"), TuplesKt.to((Object)":wizard:", (Object)"('-')\u2283\u2501\u2606\uff9f.*\uff65\uff61\uff9f"), TuplesKt.to((Object)":pvp:", (Object)"\u2694"), TuplesKt.to((Object)":peace:", (Object)"\u270c"), TuplesKt.to((Object)":oof:", (Object)"OOF"), TuplesKt.to((Object)":puffer:", (Object)"<('O')>"), TuplesKt.to((Object)":snow:", (Object)"\u2603"), TuplesKt.to((Object)":dog:", (Object)"(\u1d54\u1d25\u1d54)"), TuplesKt.to((Object)":sloth:", (Object)"( \u2b29 \u229d \u2b29 )"), TuplesKt.to((Object)":dab:", (Object)"<o/"), TuplesKt.to((Object)":cat:", (Object)"\u14da\u160f\u15e2")};
        HYPIXEL_EMOTES = MapsKt.mapOf((Pair[])pairArray);
    }
}

