/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.slayers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import meowing.zen.Zen;
import meowing.zen.api.SlayerTracker;
import meowing.zen.config.Handler;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.EventBus;
import meowing.zen.events.RenderEvent;
import meowing.zen.events.SkyblockEvent;
import meowing.zen.features.Feature;
import meowing.zen.hud.HUDManager;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.Render2D;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TimeUtils;
import meowing.zen.utils.Utils;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\u0013*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001b\u0010!\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R!\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lmeowing/zen/features/slayers/SlayerStats;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "addConfig", "(Lmeowing/zen/config/ui/ConfigUI;)Lmeowing/zen/config/ui/ConfigUI;", "", "initialize", "", "getBPH", "()I", "reset", "Lnet/minecraft/class_332;", "context", "render", "(Lnet/minecraft/class_332;)V", "", "", "getLines", "()Ljava/util/List;", "", "decimals", "format", "(DI)Ljava/lang/String;", "name", "Ljava/lang/String;", "", "slayertimer$delegate", "Lmeowing/zen/config/Handler;", "getSlayertimer", "()Z", "slayertimer", "", "slayerStatsLines$delegate", "getSlayerStatsLines", "()Ljava/util/Set;", "slayerStatsLines", "Zen"})
@SourceDebugExtension(value={"SMAP\nSlayerStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerStats.kt\nmeowing/zen/features/slayers/SlayerStats\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 7 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 ConfigDelegate.kt\nmeowing/zen/config/ConfigDelegateKt\n*L\n1#1,165:1\n112#2,2:166\n114#2:176\n112#2,2:177\n114#2:187\n205#3,2:168\n207#3,3:173\n205#3,2:179\n207#3,3:184\n72#4,2:170\n72#4,2:181\n1#5:172\n1#5:183\n63#6:188\n58#6:190\n58#6:193\n63#6:195\n63#6:197\n63#6:198\n23#7:189\n27#7:191\n27#7:192\n23#7:194\n1863#8:196\n1864#8:199\n7#9:200\n7#9:201\n*S KotlinDebug\n*F\n+ 1 SlayerStats.kt\nmeowing/zen/features/slayers/SlayerStats\n*L\n61#1:166,2\n61#1:176\n65#1:177,2\n65#1:187\n61#1:168,2\n61#1:173,3\n65#1:179,2\n65#1:184,3\n61#1:170,2\n65#1:181,2\n61#1:172\n65#1:183\n75#1:188\n101#1:190\n112#1:193\n113#1:195\n124#1:197\n129#1:198\n101#1:189\n101#1:191\n108#1:192\n112#1:194\n118#1:196\n118#1:199\n33#1:200\n34#1:201\n*E\n"})
public final class SlayerStats
extends Feature {
    @NotNull
    public static final SlayerStats INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String name = "SlayerStats";
    @NotNull
    private static final Handler slayertimer$delegate;
    @NotNull
    private static final Handler slayerStatsLines$delegate;

    private SlayerStats() {
        super("slayerstats", true, null, null, 12, null);
    }

    private final boolean getSlayertimer() {
        return (Boolean)slayertimer$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Set<Integer> getSlayerStatsLines() {
        return (Set)slayerStatsLines$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)((Object)configUI), (String)"configUI");
        Object[] objectArray = new String[]{"Show Bosses Killed", "Show Bosses/hr", "Show Average kill time", "Show Average spawn time", "Show Total Session time", "Show XP/hr"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{0, 1, 4, 5};
        return ConfigUI.addElement$default(ConfigUI.addElement$default(configUI.addElement("Slayers", "Slayer stats", new ConfigElement("slayerstats", "Slayer stats", new ElementType.Switch(false), null, 8, null), true), "Slayers", "Slayer stats", "", new ConfigElement("", null, new ElementType.TextParagraph("Shows slayer statistics such as total bosses killed, bosses per hour, and average kill time. \u00a7c/slayerstats reset \u00a7rto reset stats. Requires \u00a7eSlayer Timer\u00a7r to be enabled."), null, 8, null), false, 16, null), "Slayers", "Slayer stats", "Options", new ConfigElement("slayerstatslines", "", new ElementType.MultiCheckbox(list, SetsKt.setOf((Object[])objectArray)), null, 8, null), false, 16, null);
    }

    @Override
    public void initialize() {
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        HUDManager.INSTANCE.register(name, "\u00a77[\u00a7bZen\u00a77] \u00a7f\u00a7lSlayer Stats: \n\u00a77> \u00a7bBosses Killed\u00a7f: \u00a7c15\n\u00a77> \u00a7bBosses/hr\u00a7f: \u00a7c12\n\u00a77> \u00a7bAvg. kill\u00a7f: \u00a7c45.2s");
        Function1 cb$iv = SlayerStats::initialize$lambda$0;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = RenderEvent.HUD.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = SlayerStats::initialize$lambda$1;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list2 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = SkyblockEvent.Slayer.Death.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv, cb$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        list2.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    private final int getBPH() {
        if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
            return 0;
        }
        TimeUtils timeUtils = TimeUtils.INSTANCE;
        long $this$millis$iv = Duration.plus-LRDsOJo((long)SlayerTracker.INSTANCE.getTotalKillTime-UwyO8pc(), (long)SlayerTracker.INSTANCE.getTotalSpawnTime-UwyO8pc());
        boolean bl = false;
        double avgTotal = (double)(Duration.getInWholeMilliseconds-impl((long)$this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0;
        int bph = (int)(3600.0 / avgTotal);
        return bph;
    }

    public final void reset() {
        SlayerTracker.INSTANCE.reset();
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSlayer stats reset!", null, null, null, null, 30, null);
    }

    private final void render(class_332 context) {
        float x = HUDManager.INSTANCE.getX(name);
        float y = HUDManager.INSTANCE.getY(name);
        float scale = HUDManager.INSTANCE.getScale(name);
        List<String> lines = this.getLines();
        if (!((Collection)lines).isEmpty()) {
            float currentY = y;
            for (String line : lines) {
                Render2D.renderString$default(Render2D.INSTANCE, context, line, x, currentY, scale, 0, null, 96, null);
                currentY += (float)(this.getFontRenderer().field_2000 + 2);
            }
        }
    }

    private final List<String> getLines() {
        block21: {
            block20: {
                long arg0$iv = SlayerTracker.INSTANCE.getMobLastKilledAt-k-uo7DU();
                boolean bl = false;
                TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
                boolean bl2 = false;
                if (Duration.getInWholeMinutes-impl((long)SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv)) > 5L) break block20;
                arg0$iv = SlayerTracker.INSTANCE.getMobLastKilledAt-k-uo7DU();
                boolean bl3 = false;
                if (!(arg0$iv == 0L)) break block21;
            }
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new String[]{"\u00a77[\u00a7bZen\u00a77] \u00a7f\u00a7lSlayer Stats: "};
        List list = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.getSlayerStatsLines().contains(4)) {
            long arg0$iv = SlayerTracker.INSTANCE.getSessionStart-k-uo7DU();
            boolean bl = false;
            if (arg0$iv == 0L) {
                v0 = list.add(" \u00a77> \u00a7bSession time\u00a7f: \u00a7c-");
            } else {
                long l;
                SimpleTimeMark pauseMark = SlayerTracker.INSTANCE.getPauseStart-ePxmvlU();
                TimeUtils this_$iv = TimeUtils.INSTANCE;
                boolean $i$f$getNow-k-uo7DU22 = false;
                long l2 = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), SlayerTracker.INSTANCE.getSessionStart-k-uo7DU());
                SimpleTimeMark simpleTimeMark = pauseMark;
                if (simpleTimeMark != null) {
                    long arg0$iv2 = simpleTimeMark.unbox-impl();
                    boolean bl4 = false;
                    TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
                    $i$f$getNow-k-uo7DU = false;
                    l = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv2);
                } else {
                    l = Duration.Companion.getZERO-UwyO8pc();
                }
                long totalTime = Duration.minus-LRDsOJo((long)Duration.minus-LRDsOJo((long)l2, (long)l), (long)DurationKt.toDuration((long)SlayerTracker.INSTANCE.getTotalSessionPaused(), (DurationUnit)DurationUnit.MILLISECONDS));
                TimeUtils $i$f$getNow-k-uo7DU22 = TimeUtils.INSTANCE;
                long $this$millis$iv = totalTime;
                boolean bl5 = false;
                String timeString = Utils.INSTANCE.toFormattedDuration(Duration.getInWholeMilliseconds-impl((long)$this$millis$iv), false);
                v0 = list.add(" \u00a77> \u00a7bSession time\u00a7f: \u00a7c" + timeString + (SlayerTracker.INSTANCE.isPaused() ? " \u00a77(Paused)" : ""));
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.getSlayerStatsLines());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int line = ((Number)element$iv).intValue();
            boolean bl = false;
            switch (line) {
                case 0: {
                    list.add(" \u00a77> \u00a7bBosses Killed\u00a7f: \u00a7c" + SlayerTracker.INSTANCE.getSessionBossKills());
                    break;
                }
                case 1: {
                    list.add(" \u00a77> \u00a7bBosses/hr\u00a7f: \u00a7c" + (SlayerTracker.INSTANCE.getSessionBossKills() == 0 ? "-" : Integer.valueOf(INSTANCE.getBPH())));
                    break;
                }
                case 2: {
                    boolean bl6;
                    Object object;
                    if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
                        object = "-";
                    } else {
                        TimeUtils timeUtils = TimeUtils.INSTANCE;
                        long $this$millis$iv = SlayerTracker.INSTANCE.getTotalKillTime-UwyO8pc();
                        bl6 = false;
                        object = INSTANCE.format((double)(Duration.getInWholeMilliseconds-impl((long)$this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0, 1) + "s";
                    }
                    String avgKill = object;
                    list.add(" \u00a77> \u00a7bAvg. kill\u00a7f: \u00a7c" + avgKill);
                    break;
                }
                case 3: {
                    Object object;
                    boolean bl6;
                    if (SlayerTracker.INSTANCE.getSessionBossKills() == 0) {
                        object = "-";
                    } else {
                        TimeUtils this_$iv = TimeUtils.INSTANCE;
                        long $this$millis$iv = SlayerTracker.INSTANCE.getTotalSpawnTime-UwyO8pc();
                        bl6 = false;
                        object = INSTANCE.format((double)(Duration.getInWholeMilliseconds-impl((long)$this$millis$iv) / (long)SlayerTracker.INSTANCE.getSessionBossKills()) / 1000.0, 1) + "s";
                    }
                    String avgSpawn = object;
                    list.add(" \u00a77> \u00a7bAvg. spawn\u00a7f: \u00a7c" + avgSpawn);
                    break;
                }
                case 5: {
                    int xpPH = INSTANCE.getBPH() * SlayerTracker.INSTANCE.getXpPerKill();
                    list.add(" \u00a77> \u00a7bXP/hr\u00a7f: \u00a7c" + Utils.INSTANCE.formatNumber(xpPH) + " XP");
                }
            }
        }
        return list;
    }

    private final String format(double $this$format, int decimals) {
        String string = "%." + decimals + "f";
        Object[] objectArray = new Object[]{$this$format};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final Unit initialize$lambda$0(RenderEvent.HUD it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (HUDManager.INSTANCE.isEnabled(name)) {
            INSTANCE.render(it.getContext());
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(SkyblockEvent.Slayer.Death it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!INSTANCE.getSlayertimer()) {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7cYou must enable the \u00a7eSlayer Timer\u00a7c feature for Slayer Stats to work.", null, null, null, null, 30, null);
        }
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SlayerStats.class, "slayertimer", "getSlayertimer()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SlayerStats.class, "slayerStatsLines", "getSlayerStatsLines()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerStats();
        String key$iv = "slayertimer";
        boolean $i$f$ConfigDelegate = false;
        slayertimer$delegate = new Handler<Boolean>(key$iv, Boolean.class);
        key$iv = "slayerstatslines";
        $i$f$ConfigDelegate = false;
        slayerStatsLines$delegate = new Handler<Set>(key$iv, Set.class);
    }
}

