/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.slayers.carrying;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.config.Handler;
import meowing.zen.features.slayers.carrying.CarryCounter;
import meowing.zen.hud.HUDEditor;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.CommandUtils;
import meowing.zen.utils.TickUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;

@Zen.Command
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u001d\u0010\u0014\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u001d\u0010\u0015\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\u001d\u0010\u0016\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u001d\u0010\u0017\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u001d\u0010\u0018\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000eJ%\u0010\u001a\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u001d\u0010\u001d\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u000eR\u001b\u0010!\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0011R\u0016\u0010\"\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&\u00a8\u0006("}, d2={"Lmeowing/zen/features/slayers/carrying/CarryCommand;", "Lmeowing/zen/utils/CommandUtils;", "<init>", "()V", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "builder", "", "buildCommand", "(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "", "checkEnabled", "()Z", "ctx", "addCarryee", "removeCarryee", "setTotal", "setCount", "clearCarryees", "listCarryees", "page", "showLogs", "(Lcom/mojang/brigadier/context/CommandContext;I)I", "openHudEditor", "showHelp", "carrycounter$delegate", "Lmeowing/zen/config/Handler;", "getCarrycounter", "carrycounter", "currentLogPage", "I", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "playerSuggestions", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "carryeeSuggestions", "Zen"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\nmeowing/zen/features/slayers/carrying/CarryCommand\n+ 2 CarryCounter.kt\nmeowing/zen/features/slayers/carrying/CarryCounter\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ConfigDelegate.kt\nmeowing/zen/config/ConfigDelegateKt\n*L\n1#1,241:1\n44#2:242\n44#2:243\n44#2:244\n44#2:255\n44#2:258\n1863#3,2:245\n1062#3:247\n1863#3,2:249\n1863#3,2:251\n1863#3,2:253\n1863#3,2:256\n1863#3,2:259\n1#4:248\n7#5:261\n*S KotlinDebug\n*F\n+ 1 Command.kt\nmeowing/zen/features/slayers/carrying/CarryCommand\n*L\n147#1:242\n156#1:243\n162#1:244\n32#1:255\n37#1:258\n162#1:245,2\n173#1:247\n204#1:249,2\n238#1:251,2\n29#1:253,2\n32#1:256,2\n37#1:259,2\n25#1:261\n*E\n"})
public final class CarryCommand
extends CommandUtils {
    @NotNull
    public static final CarryCommand INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Handler carrycounter$delegate;
    private static int currentLogPage;
    @NotNull
    private static final SuggestionProvider<FabricClientCommandSource> playerSuggestions;
    @NotNull
    private static final SuggestionProvider<FabricClientCommandSource> carryeeSuggestions;

    private CarryCommand() {
        super("carry", CollectionsKt.listOf((Object)"zencarry"));
    }

    private final boolean getCarrycounter() {
        return (Boolean)carrycounter$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    public void buildCommand(@NotNull LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(playerSuggestions).then(ClientCommandManager.argument((String)"count", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(CarryCommand::buildCommand$lambda$5))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(carryeeSuggestions).executes(CarryCommand::buildCommand$lambda$6)))).then(ClientCommandManager.literal((String)"settotal").then(ClientCommandManager.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(carryeeSuggestions).then(ClientCommandManager.argument((String)"total", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(CarryCommand::buildCommand$lambda$7))))).then(ClientCommandManager.literal((String)"setcount").then(ClientCommandManager.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(carryeeSuggestions).then(ClientCommandManager.argument((String)"count", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(CarryCommand::buildCommand$lambda$8))))).then(ClientCommandManager.literal((String)"list").executes(CarryCommand::buildCommand$lambda$9))).then(ClientCommandManager.literal((String)"clear").executes(CarryCommand::buildCommand$lambda$10))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"log").executes(CarryCommand::buildCommand$lambda$11)).then(ClientCommandManager.argument((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(CarryCommand::buildCommand$lambda$12)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"logs").executes(CarryCommand::buildCommand$lambda$13)).then(ClientCommandManager.argument((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(CarryCommand::buildCommand$lambda$14)))).then(ClientCommandManager.literal((String)"gui").executes(CarryCommand::buildCommand$lambda$15));
    }

    @Override
    public int execute(@NotNull CommandContext<FabricClientCommandSource> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return this.showHelp(context);
    }

    private final boolean checkEnabled() {
        if (!this.getCarrycounter()) {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fPlease enable carry counter first!", "\u00a7cClick to open settings GUI", class_2558.class_2559.field_11750, "/zen", null, 16, null);
            return false;
        }
        return true;
    }

    private final int addCarryee(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        Intrinsics.checkNotNull((Object)playerName);
        CarryCounter.Carryee carryee = CarryCounter.INSTANCE.addCarryee(playerName, count);
        if (carryee != null) {
            if (carryee.getTotal() == count) {
                ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fAdded \u00a7b" + playerName + "\u00a7f for \u00a7b" + count + "\u00a7f carries.", null, null, null, null, 30, null);
            } else {
                ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fUpdated \u00a7b" + playerName + "\u00a7f to \u00a7b" + carryee.getTotal() + "\u00a7f total (\u00a7b" + carryee.getCount() + "\u00a7f/\u00a7b" + carryee.getTotal() + "\u00a7f)", null, null, null, null, 30, null);
            }
        }
        return 1;
    }

    private final int removeCarryee(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        Intrinsics.checkNotNull((Object)playerName);
        boolean removed = CarryCounter.INSTANCE.removeCarryee(playerName);
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7f" + (removed ? "Removed" : "Player not found:") + " \u00a7b" + playerName, null, null, null, null, 30, null);
        return 1;
    }

    private final int setTotal(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        int total = IntegerArgumentType.getInteger(ctx, (String)"total");
        Intrinsics.checkNotNull((Object)playerName);
        CarryCounter.Carryee carryee = CarryCounter.INSTANCE.findCarryee(playerName);
        if (carryee != null) {
            carryee.setTotal(total);
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSet \u00a7b" + playerName + "\u00a7f total to \u00a7b" + total + "\u00a7f (\u00a7b" + carryee.getCount() + "\u00a7f/\u00a7b" + total + "\u00a7f)", null, null, null, null, 30, null);
        } else {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fPlayer \u00a7b" + playerName + "\u00a7f not found!", null, null, null, null, 30, null);
        }
        return 1;
    }

    private final int setCount(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        Intrinsics.checkNotNull((Object)playerName);
        CarryCounter.Carryee carryee = CarryCounter.INSTANCE.findCarryee(playerName);
        if (carryee != null) {
            carryee.setCount(count);
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSet \u00a7b" + playerName + "\u00a7f count to \u00a7b" + count + "\u00a7f (\u00a7b" + count + "\u00a7f/\u00a7b" + carryee.getTotal() + "\u00a7f)", null, null, null, null, 30, null);
            if (count >= carryee.getTotal()) {
                carryee.complete();
            }
        } else {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fPlayer \u00a7b" + playerName + "\u00a7f not found!", null, null, null, null, 30, null);
        }
        return 1;
    }

    private final int clearCarryees(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        CarryCounter this_$iv = CarryCounter.INSTANCE;
        boolean $i$f$getCarryees = false;
        Collection<CarryCounter.Carryee> collection = this_$iv.getCarryeesByName().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        int count = CollectionsKt.toList((Iterable)collection).size();
        CarryCounter.INSTANCE.clearCarryees();
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fCleared \u00a7b" + count + "\u00a7f carries.", null, null, null, null, 30, null);
        return 1;
    }

    private final int listCarryees(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        CarryCounter this_$iv = CarryCounter.INSTANCE;
        boolean $i$f$getCarryees = false;
        Collection<CarryCounter.Carryee> collection = this_$iv.getCarryeesByName().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        if (CollectionsKt.toList((Iterable)collection).isEmpty()) {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fNo active carries.", null, null, null, null, 30, null);
            return 1;
        }
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fActive Carries:", null, null, null, null, 30, null);
        this_$iv = CarryCounter.INSTANCE;
        $i$f$getCarryees = false;
        Collection<CarryCounter.Carryee> collection2 = this_$iv.getCarryeesByName().values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CarryCounter.Carryee carryee = (CarryCounter.Carryee)element$iv;
            boolean bl = false;
            String progress = "\u00a7b" + carryee.getCount() + "\u00a7f/\u00a7b" + carryee.getTotal();
            String lastBoss = carryee.getCount() > 0 ? "\u00a77(" + carryee.getTimeSinceLastBoss() + " ago)" : "";
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77> \u00a7b" + carryee.getName() + "\u00a7f - " + progress + " " + lastBoss, null, null, null, null, 30, null);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int showLogs(CommandContext<FabricClientCommandSource> ctx, int page) {
        if (!this.checkEnabled()) {
            return 0;
        }
        Iterable $this$sortedByDescending$iv = CarryCounter.INSTANCE.getDataUtils().getData().getCompletedCarries();
        boolean $i$f$sortedByDescending22 = false;
        List logs = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CarryCounter.CompletedCarry it = (CarryCounter.CompletedCarry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (CarryCounter.CompletedCarry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        });
        if (logs.isEmpty()) {
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fNo carry logs found.", null, null, null, null, 30, null);
            return 1;
        }
        Iterable $i$f$sortedByDescending22 = logs;
        int n = 0;
        for (Object t : $i$f$sortedByDescending22) {
            void it;
            CarryCounter.CompletedCarry completedCarry = (CarryCounter.CompletedCarry)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getTotalCarries();
            n = n2 + n3;
        }
        int totalCarries = n;
        int totalPages = (logs.size() + 9) / 10;
        currentLogPage = RangesKt.coerceIn((int)page, (int)1, (int)totalPages);
        int startIndex = (currentLogPage - 1) * 10;
        int endIndex = RangesKt.coerceAtMost((int)(startIndex + 10), (int)logs.size());
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, StringsKt.repeat((CharSequence)"\u00a77\u23e4", (int)40), null, null, null, null, 30, null);
        String prevPage = currentLogPage > 1 ? "\u00a7b[<]" : "\u00a77[<]";
        String nextPage = currentLogPage < totalPages ? "\u00a7b[>]" : "\u00a77[>]";
        class_5250 headerText = class_2561.method_43470((String)("\u00a77[\u00a7bZen\u00a77] \u00a7fCarry Logs - \u00a7fPage \u00a7b" + currentLogPage + "\u00a7f/\u00a7b" + totalPages + " ")).method_10852((class_2561)class_2561.method_43470((String)prevPage).method_27694(CarryCommand::showLogs$lambda$19)).method_10852((class_2561)class_2561.method_43470((String)" \u00a77| ")).method_10852((class_2561)class_2561.method_43470((String)nextPage).method_27694(arg_0 -> CarryCommand.showLogs$lambda$20(totalPages, arg_0)));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)headerText);
        Iterable $this$forEach$iv = logs.subList(startIndex, endIndex);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CarryCounter.CompletedCarry log = (CarryCounter.CompletedCarry)element$iv;
            boolean bl = false;
            String date = new SimpleDateFormat("d/M/yyyy").format(new Date(log.getTimestamp()));
            String time = new SimpleDateFormat("HH:mm").format(new Date(log.getTimestamp()));
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77> \u00a7b" + log.getPlayerName() + " \u00a77- \u00a7c" + date + " \u00a7fat \u00a7c" + time + " \u00a77- \u00a7b" + log.getTotalCarries() + " \u00a7fcarries", null, null, null, null, 30, null);
        }
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a7c\u00a7l| \u00a7fTotal carries: \u00a7b" + totalCarries, null, null, null, null, 30, null);
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, StringsKt.repeat((CharSequence)"\u00a77\u23e4", (int)40), null, null, null, null, 30, null);
        return 1;
    }

    private final int openHudEditor(CommandContext<FabricClientCommandSource> ctx) {
        if (!this.checkEnabled()) {
            return 0;
        }
        TickUtils.INSTANCE.schedule(2L, (Function0<Unit>)((Function0)CarryCommand::openHudEditor$lambda$23));
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fOpened HUD editor.", null, null, null, null, 30, null);
        return 1;
    }

    private final int showHelp(CommandContext<FabricClientCommandSource> ctx) {
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fCarry Commands:", null, null, null, null, 30, null);
        Object[] objectArray = new String[]{"add \u00a7c<player> <count>\u00a77 - \u00a7fAdd carries", "settotal \u00a7c<player> <total>\u00a77 - \u00a7fSet total carries", "setcount \u00a7c<player> <count>\u00a77 - \u00a7fSet current count", "remove \u00a7c<player>\u00a77 - \u00a7fRemove player", "log \u00a7c[page]\u00a77 - \u00a7fShow carry history", "list\u00a77 - \u00a7fShow active carries", "clear\u00a77 - \u00a7fClear all carries", "gui\u00a77 - \u00a7fOpen HUD editor"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, "\u00a77> \u00a77/\u00a7bcarry " + it, null, null, null, null, 30, null);
        }
        return 1;
    }

    private static final CompletableFuture playerSuggestions$lambda$2(CommandContext commandContext, SuggestionsBuilder builder) {
        Object object = Zen.Companion.getMc().field_1687;
        if (object != null && (object = object.method_18456()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_742 player = (class_742)element$iv;
                boolean bl = false;
                String string = player.method_5477().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                if (!(!StringsKt.isBlank((CharSequence)string)) || player.method_5667().version() != 4) continue;
                builder.suggest(player.method_5477().getString());
            }
        }
        CarryCounter this_$iv = CarryCounter.INSTANCE;
        boolean $i$f$getCarryees = false;
        Collection<CarryCounter.Carryee> collection = this_$iv.getCarryeesByName().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CarryCounter.Carryee it = (CarryCounter.Carryee)element$iv;
            boolean bl = false;
            builder.suggest(it.getName());
        }
        return builder.buildFuture();
    }

    private static final CompletableFuture carryeeSuggestions$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        CarryCounter this_$iv = CarryCounter.INSTANCE;
        boolean $i$f$getCarryees = false;
        Collection<CarryCounter.Carryee> collection = this_$iv.getCarryeesByName().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CarryCounter.Carryee it = (CarryCounter.Carryee)element$iv;
            boolean bl = false;
            builder.suggest(it.getName());
        }
        return builder.buildFuture();
    }

    private static final int buildCommand$lambda$5(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.addCarryee((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$6(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.removeCarryee((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$7(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.setTotal((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$8(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.setCount((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$9(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.listCarryees((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$10(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.clearCarryees((CommandContext<FabricClientCommandSource>)it);
    }

    private static final int buildCommand$lambda$11(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.showLogs((CommandContext<FabricClientCommandSource>)it, currentLogPage);
    }

    private static final int buildCommand$lambda$12(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.showLogs((CommandContext<FabricClientCommandSource>)it, IntegerArgumentType.getInteger((CommandContext)it, (String)"page"));
    }

    private static final int buildCommand$lambda$13(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.showLogs((CommandContext<FabricClientCommandSource>)it, currentLogPage);
    }

    private static final int buildCommand$lambda$14(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.showLogs((CommandContext<FabricClientCommandSource>)it, IntegerArgumentType.getInteger((CommandContext)it, (String)"page"));
    }

    private static final int buildCommand$lambda$15(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.openHudEditor((CommandContext<FabricClientCommandSource>)it);
    }

    private static final class_2583 showLogs$lambda$19(class_2583 it) {
        return currentLogPage > 1 ? it.method_10958((class_2558)new class_2558.class_10609("/carry log " + (currentLogPage - 1))) : it;
    }

    private static final class_2583 showLogs$lambda$20(int $totalPages, class_2583 it) {
        return currentLogPage < $totalPages ? it.method_10958((class_2558)new class_2558.class_10609("/carry log " + (currentLogPage + 1))) : it;
    }

    private static final void openHudEditor$lambda$23$lambda$22() {
        Zen.Companion.getMc().method_1507((class_437)new HUDEditor());
    }

    private static final Unit openHudEditor$lambda$23() {
        Zen.Companion.getMc().execute(CarryCommand::openHudEditor$lambda$23$lambda$22);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CarryCommand.class, "carrycounter", "getCarrycounter()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CarryCommand();
        String key$iv = "carrycounter";
        boolean $i$f$ConfigDelegate = false;
        carrycounter$delegate = new Handler<Boolean>(key$iv, Boolean.class);
        currentLogPage = 1;
        playerSuggestions = CarryCommand::playerSuggestions$lambda$2;
        carryeeSuggestions = CarryCommand::carryeeSuggestions$lambda$4;
    }
}

