/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import meowing.zen.Zen;
import meowing.zen.events.EventBus;
import meowing.zen.events.GameEvent;
import meowing.zen.utils.LoopUtils;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TimeUtils;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 1*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u00011B)\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\nJ\u000f\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0017\u0010\fJ\u000f\u0010\u0018\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000fJ\u0010\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\fJ&\u0010\u001d\u001a\u00020\r2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ&\u0010\u001f\u001a\u00020\r2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\r\u0010 \u001a\u00020\r\u00a2\u0006\u0004\b \u0010\u000fJ\r\u0010!\u001a\u00020\r\u00a2\u0006\u0004\b!\u0010\u000fJ\r\u0010\"\u001a\u00020\r\u00a2\u0006\u0004\b\"\u0010\u000fJ\r\u0010#\u001a\u00028\u0000\u00a2\u0006\u0004\b#\u0010\fJ\r\u0010%\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020$\u00a2\u0006\u0004\b'\u0010&R\u0014\u0010\u0005\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00028\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010(R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Lmeowing/zen/utils/DataUtils;", "", "T", "", "fileName", "defaultObject", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Lcom/google/gson/reflect/TypeToken;)V", "(Ljava/lang/String;Ljava/lang/Object;)V", "loadData", "()Ljava/lang/Object;", "", "save", "()V", "", "intervalMinutes", "autosave", "(J)V", "newData", "setData", "(Ljava/lang/Object;)V", "getData", "startAutosaveLoop", "invoke", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "block", "update", "(Lkotlin/jvm/functions/Function1;)V", "updateAndSave", "reset", "resetAndSave", "reload", "copy", "", "exists", "()Z", "delete", "Ljava/lang/Object;", "Lcom/google/gson/reflect/TypeToken;", "Ljava/io/File;", "dataFile", "Ljava/io/File;", "data", "Lmeowing/zen/utils/SimpleTimeMark;", "lastSavedTime", "J", "Companion", "Zen"})
@SourceDebugExtension(value={"SMAP\nDataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils\n+ 2 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n*L\n1#1,170:1\n58#2:171\n58#2,6:184\n58#2:190\n217#3:172\n205#3,2:173\n207#3,3:178\n72#4,2:175\n1#5:177\n1#5:181\n216#6:182\n217#6:191\n23#7:183\n*S KotlinDebug\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils\n*L\n74#1:171\n122#1:184,6\n128#1:190\n80#1:172\n80#1:173,2\n80#1:178,3\n80#1:175,2\n80#1:177\n121#1:182\n121#1:191\n122#1:183\n*E\n"})
public final class DataUtils<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T defaultObject;
    @Nullable
    private final TypeToken<T> typeToken;
    @NotNull
    private final File dataFile;
    @NotNull
    private T data;
    private long lastSavedTime;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().setObjectToNumberStrategy(DataUtils::gson$lambda$4).registerTypeAdapter((Type)((Object)Color.class), (Object)new JsonSerializer<Color>(){

        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject obj = new JsonObject();
            obj.addProperty("r", (Number)src.getRed());
            obj.addProperty("g", (Number)src.getGreen());
            obj.addProperty("b", (Number)src.getBlue());
            obj.addProperty("a", (Number)src.getAlpha());
            return (JsonElement)obj;
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject obj = json.getAsJsonObject();
            int r = obj.get("r").getAsInt();
            int g = obj.get("g").getAsInt();
            int b = obj.get("b").getAsInt();
            int a = obj.get("a").getAsInt();
            return new Color(r, g, b, a);
        }
    }).create();
    @NotNull
    private static final ConcurrentHashMap<DataUtils<?>, Long> autosaveIntervals = new ConcurrentHashMap();
    private static boolean loopStarted;

    /*
     * WARNING - void declaration
     */
    public DataUtils(@NotNull String fileName, @NotNull T defaultObject, @Nullable TypeToken<T> typeToken) {
        void priority$iv$iv;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(defaultObject, (String)"defaultObject");
        this.defaultObject = defaultObject;
        this.typeToken = typeToken;
        this.dataFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Zen-1.21/" + fileName + ".json");
        this.data = this.loadData();
        Object this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        this.lastSavedTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
        this.dataFile.getParentFile().mkdirs();
        this.autosave(5L);
        this.startAutosaveLoop();
        this_$iv = EventBus.INSTANCE;
        Function1 callback$iv = arg_0 -> DataUtils._init_$lambda$0(this, arg_0);
        boolean $i$f$register = false;
        Object object = this_$iv;
        boolean bl2 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class<GameEvent.Unload> eventClass$iv$iv = GameEvent.Unload.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            boolean bl3 = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl4 = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object2;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback((int)priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }

    public /* synthetic */ DataUtils(String string, Object object, TypeToken typeToken, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            typeToken = null;
        }
        this(string, object, typeToken);
    }

    public DataUtils(@NotNull String fileName, @NotNull T defaultObject) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(defaultObject, (String)"defaultObject");
        this(fileName, defaultObject, null);
    }

    private final T loadData() {
        T t;
        try {
            Object object;
            if (this.dataFile.exists()) {
                Object type2;
                Object object2 = this.typeToken;
                if (object2 == null || (object2 = object2.getType()) == null) {
                    object2 = type2 = (Type)this.defaultObject.getClass();
                }
                if ((object = gson.fromJson(FilesKt.readText$default((File)this.dataFile, null, (int)1, null), type2)) == null) {
                    object = this.defaultObject;
                }
            } else {
                object = this.defaultObject;
            }
            t = object;
        }
        catch (Exception e) {
            Zen.LOGGER.error("Error loading data from " + this.dataFile.getAbsolutePath() + ": " + e.getMessage());
            t = this.defaultObject;
        }
        return t;
    }

    public final synchronized void save() {
        try {
            String string = gson.toJson(this.data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)this.dataFile, (String)string, null, (int)2, null);
        }
        catch (Exception e) {
            Zen.LOGGER.error("Error saving data to " + this.dataFile.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public final void autosave(long intervalMinutes) {
        ((Map)autosaveIntervals).put(this, intervalMinutes * (long)60000);
    }

    public static /* synthetic */ void autosave$default(DataUtils dataUtils, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 5L;
        }
        dataUtils.autosave(l);
    }

    public final void setData(@NotNull T newData) {
        Intrinsics.checkNotNullParameter(newData, (String)"newData");
        this.data = newData;
    }

    @NotNull
    public final T getData() {
        return this.data;
    }

    private final void startAutosaveLoop() {
        if (loopStarted) {
            return;
        }
        loopStarted = true;
        LoopUtils.loop$default(LoopUtils.INSTANCE, 10000L, null, DataUtils::startAutosaveLoop$lambda$2, 2, null);
    }

    @NotNull
    public final T invoke() {
        return this.data;
    }

    public final void update(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke(this.data);
    }

    public final void updateAndSave(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.update(block);
        this.save();
    }

    public final void reset() {
        this.data = this.defaultObject;
    }

    public final void resetAndSave() {
        this.reset();
        this.save();
    }

    public final void reload() {
        block0: {
            T t = this.loadData();
            if (t == null) break block0;
            T it = t;
            boolean bl = false;
            this.data = it;
        }
    }

    @NotNull
    public final T copy() {
        Object object = gson.fromJson(gson.toJson(this.data), this.data.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (T)object;
    }

    public final boolean exists() {
        return this.dataFile.exists();
    }

    public final boolean delete() {
        boolean bl;
        try {
            bl = this.dataFile.delete();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static final Unit _init_$lambda$0(DataUtils this$0, GameEvent.Unload it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.save();
        return Unit.INSTANCE;
    }

    private static final Unit startAutosaveLoop$lambda$2() {
        Map $this$forEach$iv = autosaveIntervals;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DataUtils dataUtils = (DataUtils)entry.getKey();
            long interval = ((Number)entry.getValue()).longValue();
            TimeUtils timeUtils = TimeUtils.INSTANCE;
            long arg0$iv = dataUtils.lastSavedTime;
            boolean bl2 = false;
            TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
            boolean bl3 = false;
            long $this$millis$iv = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv);
            boolean bl4 = false;
            if (Duration.getInWholeMilliseconds-impl((long)$this$millis$iv) < interval) continue;
            try {
                Object currentData = dataUtils.loadData();
                if (Intrinsics.areEqual(currentData, dataUtils.data)) {
                    continue;
                }
            }
            catch (Exception currentData) {
                // empty catch block
            }
            dataUtils.save();
            TimeUtils this_$iv = TimeUtils.INSTANCE;
            $i$f$getNow-k-uo7DU = false;
            dataUtils.lastSavedTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
        }
        return Unit.INSTANCE;
    }

    private static final Number gson$lambda$4(JsonReader reader) {
        String value = reader.nextString();
        Intrinsics.checkNotNull((Object)value);
        BigDecimal bd = new BigDecimal(value);
        return bd.scale() <= 0 && bd.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) <= 0 && bd.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) >= 0 ? (Number)bd.intValueExact() : (Number)bd.doubleValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R$\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lmeowing/zen/utils/DataUtils$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lmeowing/zen/utils/DataUtils;", "", "autosaveIntervals", "Ljava/util/concurrent/ConcurrentHashMap;", "", "loopStarted", "Z", "Zen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

