/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.events.AreaEvent;
import meowing.zen.events.EventBus;
import meowing.zen.events.TablistEvent;
import meowing.zen.events.WorldEvent;
import meowing.zen.utils.DataUtils;
import meowing.zen.utils.Utils;
import net.minecraft.class_2703;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\bJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0006\u00a2\u0006\u0004\b \u0010\bR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010%\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010#R\u0016\u0010&\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0018\u0010(\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010'R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020,0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0018\u00100\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00067"}, d2={"Lmeowing/zen/utils/DungeonUtils;", "", "<init>", "()V", "", "reset", "", "getCryptCount", "()I", "", "getCurrentClass", "()Ljava/lang/String;", "getCurrentLevel", "", "isMage", "()Z", "playerName", "getPlayerClass", "(Ljava/lang/String;)Ljava/lang/String;", "className", "isDuplicate", "(Ljava/lang/String;)Z", "", "cooldown", "checkClass", "getMageReduction", "(DZ)D", "Lkotlin/Function1;", "Lmeowing/zen/utils/DungeonUtils$PersistentData;", "updater", "updateData", "(Lkotlin/jvm/functions/Function1;)V", "getCurrentCata", "Lkotlin/text/Regex;", "cryptsRegex", "Lkotlin/text/Regex;", "cataRegex", "playerInfoRegex", "crypts", "I", "currentClass", "Ljava/lang/String;", "currentLevel", "", "Lmeowing/zen/utils/DungeonUtils$PlayerData;", "players", "Ljava/util/Map;", "Lmeowing/zen/events/EventBus$EventCall;", "cryptsTab", "Lmeowing/zen/events/EventBus$EventCall;", "Lmeowing/zen/utils/DataUtils;", "Data", "Lmeowing/zen/utils/DataUtils;", "PlayerData", "PersistentData", "Zen"})
@SourceDebugExtension(value={"SMAP\nDungeonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonUtils.kt\nmeowing/zen/utils/DungeonUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1782#2,4:115\n1863#2,2:119\n1863#2,2:130\n217#3:121\n205#3,2:122\n207#3,3:127\n217#3:132\n205#3,2:133\n207#3,3:138\n217#3:141\n205#3,2:142\n207#3,3:147\n217#3:150\n205#3,2:151\n207#3,3:156\n72#4,2:124\n72#4,2:135\n72#4,2:144\n72#4,2:153\n1#5:126\n1#5:137\n1#5:146\n1#5:155\n*S KotlinDebug\n*F\n+ 1 DungeonUtils.kt\nmeowing/zen/utils/DungeonUtils\n*L\n97#1:115,4\n32#1:119,2\n64#1:130,2\n31#1:121\n31#1:122,2\n31#1:127,3\n27#1:132\n27#1:133,2\n27#1:138,3\n63#1:141\n63#1:142,2\n63#1:147,3\n73#1:150\n73#1:151,2\n73#1:156,3\n31#1:124,2\n27#1:135,2\n63#1:144,2\n73#1:153,2\n31#1:126\n27#1:137\n63#1:146\n73#1:155\n*E\n"})
public final class DungeonUtils {
    @NotNull
    public static final DungeonUtils INSTANCE;
    @NotNull
    private static final Regex cryptsRegex;
    @NotNull
    private static final Regex cataRegex;
    @NotNull
    private static final Regex playerInfoRegex;
    private static int crypts;
    @Nullable
    private static String currentClass;
    private static int currentLevel;
    @NotNull
    private static final Map<String, PlayerData> players;
    @Nullable
    private static EventBus.EventCall cryptsTab;
    @NotNull
    private static final DataUtils<PersistentData> Data;

    private DungeonUtils() {
    }

    private final void reset() {
        crypts = 0;
        currentClass = null;
        currentLevel = 0;
        players.clear();
    }

    public final int getCryptCount() {
        return crypts;
    }

    @Nullable
    public final String getCurrentClass() {
        return currentClass;
    }

    public final int getCurrentLevel() {
        return currentLevel;
    }

    public final boolean isMage() {
        return Intrinsics.areEqual((Object)currentClass, (Object)"Mage");
    }

    @Nullable
    public final String getPlayerClass(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerData playerData = players.get(playerName);
        return playerData != null ? playerData.getClassName() : null;
    }

    public final boolean isDuplicate(@NotNull String className) {
        int n;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Iterable $this$count$iv = players.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PlayerData it = (PlayerData)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getClassName(), (String)className, (boolean)true) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 1;
    }

    public final double getMageReduction(double cooldown, boolean checkClass) {
        if (checkClass && !Intrinsics.areEqual((Object)currentClass, (Object)"Mage")) {
            return cooldown;
        }
        int multiplier = this.isDuplicate("mage") ? 1 : 2;
        return cooldown * (0.75 - Math.floor((double)currentLevel / 2.0) / 100.0 * (double)multiplier);
    }

    public static /* synthetic */ double getMageReduction$default(DungeonUtils dungeonUtils, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dungeonUtils.getMageReduction(d, bl);
    }

    private final void updateData(Function1<? super PersistentData, Unit> updater) {
        PersistentData currentData = Data.getData();
        updater.invoke((Object)currentData);
        Data.setData(currentData);
    }

    public final int getCurrentCata() {
        return Data.getData().getCataLevel();
    }

    private static final Unit lambda$4$lambda$3(TablistEvent.Update tabEvent) {
        Intrinsics.checkNotNullParameter((Object)tabEvent, (String)"tabEvent");
        List list = tabEvent.getPacket().method_46329();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult match;
            class_2703.class_2705 entry = (class_2703.class_2705)element$iv;
            boolean bl = false;
            Object object = entry.comp_1111();
            if (object == null || (object = object.getString()) == null || (object = Utils.INSTANCE.removeFormatting((String)object)) == null) continue;
            Object text = object;
            if (Regex.find$default((Regex)cryptsRegex, (CharSequence)((CharSequence)text), (int)0, (int)2, null) != null) {
                MatchResult it;
                boolean bl2 = false;
                Integer n = StringsKt.toIntOrNull((String)((String)it.getGroupValues().get(1)));
                crypts = n != null ? n : crypts;
            }
            if (Regex.find$default((Regex)playerInfoRegex, (CharSequence)((CharSequence)text), (int)0, (int)2, null) == null) continue;
            boolean bl3 = false;
            String playerName = (String)match.getGroupValues().get(1);
            String className = (String)match.getGroupValues().get(2);
            String levelStr = (String)match.getGroupValues().get(4);
            int level = ((CharSequence)levelStr).length() > 0 ? Utils.INSTANCE.decodeRoman(levelStr) : 0;
            players.put(playerName, new PlayerData(playerName, className, level));
            class_746 class_7462 = Zen.Companion.getMc().field_1724;
            if (!Intrinsics.areEqual((Object)playerName, class_7462 != null && (class_7462 = class_7462.method_5477()) != null ? class_7462.getString() : null)) continue;
            currentClass = className;
            currentLevel = level;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$4(AreaEvent.Main event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean inCatacombs = StringsKt.equals((String)event.getArea(), (String)"catacombs", (boolean)true);
        if (inCatacombs && cryptsTab == null) {
            void priority$iv$iv;
            void this_$iv$iv;
            void this_$iv;
            EventBus eventBus = EventBus.INSTANCE;
            Function1 callback$iv = DungeonUtils::lambda$4$lambda$3;
            boolean $i$f$register = false;
            void var5_5 = this_$iv;
            boolean bl = false;
            boolean add$iv$iv = true;
            boolean $i$f$register2 = false;
            Class<TablistEvent.Update> eventClass$iv$iv = TablistEvent.Update.class;
            ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
            if (object == null) {
                boolean bl2 = false;
                Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
                boolean bl3 = false;
                object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
                if (object == null) {
                    object = default$iv$iv$iv;
                }
            }
            Set handlers$iv$iv = (Set)object;
            EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback((int)priority$iv$iv, callback$iv);
            handlers$iv$iv.add(prioritizedCallback$iv$iv);
            Intrinsics.checkNotNull((Object)handlers$iv$iv);
            cryptsTab = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        }
        if (!inCatacombs) {
            EventBus.EventCall eventCall = cryptsTab;
            if (eventCall != null) {
                eventCall.unregister();
            }
            cryptsTab = null;
            INSTANCE.reset();
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7$lambda$6$lambda$5(Integer $cata, PersistentData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCataLevel($cata);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(TablistEvent.Update event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = event.getPacket().method_46329();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult match;
            class_2703.class_2705 entry = (class_2703.class_2705)element$iv;
            boolean bl = false;
            Object object = entry.comp_1111();
            if (object == null || (object = object.getString()) == null || (object = Utils.INSTANCE.removeFormatting((String)object)) == null) continue;
            Object text = object;
            if (Regex.find$default((Regex)cataRegex, (CharSequence)((CharSequence)text), (int)0, (int)2, null) == null) continue;
            boolean bl2 = false;
            Integer cata = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(1)));
            if (cata == null) continue;
            INSTANCE.updateData((Function1<? super PersistentData, Unit>)((Function1)arg_0 -> DungeonUtils.lambda$8$lambda$7$lambda$6$lambda$5(cata, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(WorldEvent.Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EventBus.EventCall eventCall = cryptsTab;
        if (eventCall != null) {
            eventCall.unregister();
        }
        cryptsTab = null;
        INSTANCE.reset();
        return Unit.INSTANCE;
    }

    static {
        int priority$iv$iv;
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        EventBus this_$iv;
        INSTANCE = new DungeonUtils();
        cryptsRegex = new Regex("^ Crypts: (\\d+)$");
        cataRegex = new Regex("^ Catacombs (\\d+):");
        playerInfoRegex = new Regex("^[^\\x00-\\x7F]?(?:\\[\\d+] )?(?:\\[\\w+] )?(\\w{1,16})(?: [^\\x00-\\x7F]+)? \\((\\w+) ?(([IVXLCDM]+))?\\)$");
        players = new LinkedHashMap();
        Data = new DataUtils<PersistentData>("DungeonUtils", new PersistentData(0, 1, null));
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = DungeonUtils::_init_$lambda$4;
        boolean $i$f$register = false;
        void var3_3 = this_$iv;
        boolean bl3 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = AreaEvent.Main.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = DungeonUtils::_init_$lambda$8;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = TablistEvent.Update.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        EventBus.EventCall cfr_ignored_1 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = DungeonUtils::_init_$lambda$9;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = WorldEvent.Change.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object3 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object3 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object3 == null) {
                object3 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object3;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull((Object)handlers$iv$iv);
        EventBus.EventCall cfr_ignored_2 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0005\u00a8\u0006\u0015"}, d2={"Lmeowing/zen/utils/DungeonUtils$PersistentData;", "", "", "cataLevel", "<init>", "(I)V", "component1", "()I", "copy", "(I)Lmeowing/zen/utils/DungeonUtils$PersistentData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getCataLevel", "setCataLevel", "Zen"})
    public static final class PersistentData {
        private int cataLevel;

        public PersistentData(int cataLevel) {
            this.cataLevel = cataLevel;
        }

        public /* synthetic */ PersistentData(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n);
        }

        public final int getCataLevel() {
            return this.cataLevel;
        }

        public final void setCataLevel(int n) {
            this.cataLevel = n;
        }

        public final int component1() {
            return this.cataLevel;
        }

        @NotNull
        public final PersistentData copy(int cataLevel) {
            return new PersistentData(cataLevel);
        }

        public static /* synthetic */ PersistentData copy$default(PersistentData persistentData, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = persistentData.cataLevel;
            }
            return persistentData.copy(n);
        }

        @NotNull
        public String toString() {
            return "PersistentData(cataLevel=" + this.cataLevel + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.cataLevel);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PersistentData)) {
                return false;
            }
            PersistentData persistentData = (PersistentData)other;
            return this.cataLevel == persistentData.cataLevel;
        }

        public PersistentData() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u001a\u0010\r\u00a8\u0006\u001b"}, d2={"Lmeowing/zen/utils/DungeonUtils$PlayerData;", "", "", "name", "className", "", "level", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "component3", "()I", "copy", "(Ljava/lang/String;Ljava/lang/String;I)Lmeowing/zen/utils/DungeonUtils$PlayerData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "getClassName", "I", "getLevel", "Zen"})
    public static final class PlayerData {
        @NotNull
        private final String name;
        @NotNull
        private final String className;
        private final int level;

        public PlayerData(@NotNull String name, @NotNull String className, int level) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.name = name;
            this.className = className;
            this.level = level;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public final int getLevel() {
            return this.level;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.className;
        }

        public final int component3() {
            return this.level;
        }

        @NotNull
        public final PlayerData copy(@NotNull String name, @NotNull String className, int level) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new PlayerData(name, className, level);
        }

        public static /* synthetic */ PlayerData copy$default(PlayerData playerData, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = playerData.name;
            }
            if ((n2 & 2) != 0) {
                string2 = playerData.className;
            }
            if ((n2 & 4) != 0) {
                n = playerData.level;
            }
            return playerData.copy(string, string2, n);
        }

        @NotNull
        public String toString() {
            return "PlayerData(name=" + this.name + ", className=" + this.className + ", level=" + this.level + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.className.hashCode();
            result = result * 31 + Integer.hashCode(this.level);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerData)) {
                return false;
            }
            PlayerData playerData = (PlayerData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)playerData.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.className, (Object)playerData.className)) {
                return false;
            }
            return this.level == playerData.level;
        }
    }
}

