/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.elements;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.PresetsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.zen.config.ui.elements.utils.ExtensionsKt;
import xyz.meowing.zen.config.ui.panels.SectionButton;
import xyz.meowing.zen.ui.Theme;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ+\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\rJ\u001f\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\"8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010+\u00a8\u0006/"}, d2={"Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "name", "", "options", "", "", "selectedIndices", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Set;)V", "", "createOptions", "()V", "updateButtonSize", "expand", "collapse", "index", "checkmark", "Lxyz/meowing/vexel/components/core/Rectangle;", "checkbox", "toggleOption", "(ILxyz/meowing/vexel/components/base/VexelElement;Lxyz/meowing/vexel/components/core/Rectangle;)V", "invalidateParentLayout", "", "mouseX", "mouseY", "onRender", "(FF)V", "Ljava/util/List;", "", "expanded", "Z", "isAnimating", "", "value", "Ljava/util/Set;", "getSelectedIndices", "()Ljava/util/Set;", "Lxyz/meowing/vexel/components/core/Text;", "label", "Lxyz/meowing/vexel/components/core/Text;", "selectedButton", "Lxyz/meowing/vexel/components/core/Rectangle;", "selectedText", "optionsContainer", "Companion", "Zen"})
@SourceDebugExtension(value={"SMAP\nMultiCheckboxElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiCheckboxElement.kt\nxyz/meowing/zen/config/ui/elements/MultiCheckboxElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1878#2,3:215\n1869#2:218\n1869#2,2:219\n1870#2:221\n1869#2,2:222\n*S KotlinDebug\n*F\n+ 1 MultiCheckboxElement.kt\nxyz/meowing/zen/config/ui/elements/MultiCheckboxElement\n*L\n79#1:215,3\n176#1:218\n178#1:219,2\n176#1:221\n199#1:222,2\n*E\n"})
public final class MultiCheckboxElement
extends VexelElement<MultiCheckboxElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> options;
    private boolean expanded;
    private boolean isAnimating;
    @NotNull
    private Set<Integer> selectedIndices;
    @NotNull
    private final Text label;
    @NotNull
    private final Rectangle selectedButton;
    @NotNull
    private final Text selectedText;
    @NotNull
    private final Rectangle optionsContainer;
    @Nullable
    private static MultiCheckboxElement openMultiCheckbox;

    public MultiCheckboxElement(@NotNull String name, @NotNull List<String> options, @NotNull Set<Integer> selectedIndices) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(selectedIndices, (String)"selectedIndices");
        super(null, null, 3, null);
        this.options = options;
        this.selectedIndices = CollectionsKt.toMutableSet((Iterable)selectedIndices);
        this.label = (Text)((Text)new Text(name, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(6.0f, Pos.ParentPixels, 8.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.selectedButton = (Rectangle)((Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), Theme.Border.getColor(), 5.0f, 1.0f, null, null, null, null, null, false, 1008, null).setPositioning(-6.0f, Pos.ParentPixels, 0.0f, Pos.MatchSibling)).alignRight()).setOffset(0.0f, -2.0f)).childOf((VexelElement)this);
        this.selectedText = (Text)((Text)new Text(selectedIndices.size() + " selected", Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(0.0f, Pos.ParentCenter, 0.0f, Pos.ParentCenter)).childOf((VexelElement)this.selectedButton);
        this.optionsContainer = (Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), 0, 5.0f, 0.0f, null, null, null, null, null, false, 1008, null).setSizing(228.0f, Size.Pixels, 0.0f, Size.Pixels)).setPositioning(6.0f, Pos.ParentPixels, 32.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.setSizing(240.0f, Size.Pixels, 32.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.AfterSibling);
        this.updateButtonSize();
        this.selectedButton.onHover((Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)selectedButton), (int)Theme.Highlight.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
            }
        }, (Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)selectedButton), (int)Theme.BgLight.getColor(), (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
            }
        });
        this.selectedButton.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(){

            public final Boolean invoke(float f, float f2, int button2) {
                boolean bl;
                if (button2 == 0) {
                    if (!isAnimating) {
                        if (expanded) {
                            this.collapse();
                        } else {
                            this.expand();
                        }
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        });
        this.optionsContainer.setVisible(false);
        this.createOptions();
    }

    @NotNull
    public final Set<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    /*
     * WARNING - void declaration
     */
    private final void createOptions() {
        Iterable $this$forEachIndexed$iv = this.options;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void option;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            boolean isFirst = index == 0;
            boolean isLast = index == this.options.size() - 1;
            float topLeftRadius = isFirst ? 5.0f : 0.0f;
            float topRightRadius = isFirst ? 5.0f : 0.0f;
            float bottomLeftRadius = isLast ? 5.0f : 0.0f;
            float bottomRightRadius = isLast ? 5.0f : 0.0f;
            Rectangle optionRect = (Rectangle)((Rectangle)((Rectangle)new Rectangle(0, 0, 0.0f, 0.0f, null, null, null, null, null, false, 1008, null).borderRadiusVarying(topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius).setSizing(228.0f, Size.Pixels, 26.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentPixels, 0.0f, Pos.AfterSibling)).childOf((VexelElement)this.optionsContainer);
            Rectangle checkbox = (Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), Theme.Text.getColor(), 3.0f, 1.0f, null, null, null, null, null, false, 1008, null).setSizing(12.0f, Size.Pixels, 12.0f, Size.Pixels)).setPositioning(6.0f, Pos.ParentPixels, 0.0f, Pos.ParentCenter)).childOf((VexelElement)optionRect);
            Rectangle checkmark = (Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.Primary.getColor(), 0, 2.0f, 0.0f, null, null, null, null, null, false, 1008, null).setSizing(8.0f, Size.Pixels, 8.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentCenter, 0.0f, Pos.ParentCenter)).childOf((VexelElement)checkbox);
            boolean isSelected = this.selectedIndices.contains(index);
            checkmark.setVisible(isSelected);
            ((Text)new Text((String)option, Theme.Text.getColor(), 14.0f, false, null, 24, null).setPositioning(24.0f, Pos.ParentPixels, 0.0f, Pos.ParentCenter)).childOf((VexelElement)optionRect);
            optionRect.onHover((Function2)new Function2<Float, Float, Unit>(optionRect){
                final /* synthetic */ Rectangle $optionRect;
                {
                    this.$optionRect = $optionRect;
                    super(2);
                }

                public final void invoke(float f, float f2) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)this.$optionRect), (int)Theme.Highlight.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
                }
            }, (Function2)new Function2<Float, Float, Unit>(optionRect){
                final /* synthetic */ Rectangle $optionRect;
                {
                    this.$optionRect = $optionRect;
                    super(2);
                }

                public final void invoke(float f, float f2) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)this.$optionRect), (int)0, (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
                }
            });
            optionRect.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(this, index, checkmark, checkbox){
                final /* synthetic */ MultiCheckboxElement this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ Rectangle $checkmark;
                final /* synthetic */ Rectangle $checkbox;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$checkmark = $checkmark;
                    this.$checkbox = $checkbox;
                    super(3);
                }

                public final Boolean invoke(float f, float f2, int n) {
                    MultiCheckboxElement.access$toggleOption(this.this$0, this.$index, (VexelElement)this.$checkmark, this.$checkbox);
                    return true;
                }
            });
        }
    }

    private final void updateButtonSize() {
        this.selectedButton.setSizing(100.0f, Size.Pixels, 20.0f, Size.Pixels);
    }

    private final void expand() {
        if (this.expanded) {
            return;
        }
        Companion.closeAllMultiCheckboxes();
        openMultiCheckbox = this;
        this.expanded = true;
        this.isAnimating = true;
        this.optionsContainer.setVisible(true);
        float targetHeight = 32.0f + (float)this.options.size() * 26.0f + 6.0f;
        float containerHeight = (float)this.options.size() * 26.0f;
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)targetHeight, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MultiCheckboxElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MultiCheckboxElement.access$setAnimating$p(this.this$0, false);
                MultiCheckboxElement.access$invalidateParentLayout(this.this$0);
            }
        }));
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)((VexelElement)this.optionsContainer), (float)228.0f, (float)containerHeight, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MultiCheckboxElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEachIndexed$iv;
                Iterable iterable = MultiCheckboxElement.access$getOptionsContainer$p(this.this$0).getChildren();
                MultiCheckboxElement multiCheckboxElement = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void optionRect;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    VexelElement vexelElement = (VexelElement)item$iv;
                    int index = n;
                    boolean bl = false;
                    ExtensionsKt.fadeIn$default((VexelElement)optionRect, 50L, null, false, null, 10, null);
                    Iterable $this$forEach$iv = optionRect.getChildren();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        VexelElement child = (VexelElement)element$iv;
                        boolean bl2 = false;
                        VexelElement vexelElement2 = child;
                        if (vexelElement2 instanceof Text) {
                            ExtensionsKt.fadeIn$default(child, 50L, null, false, null, 10, null);
                            continue;
                        }
                        if (!(vexelElement2 instanceof Rectangle)) continue;
                        ExtensionsKt.fadeIn$default(child, 50L, null, false, null, 10, null);
                        if (!multiCheckboxElement.getSelectedIndices().contains(index)) continue;
                        Iterable $this$forEach$iv2 = ((Rectangle)child).getChildren();
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            VexelElement it = (VexelElement)element$iv2;
                            boolean bl3 = false;
                            ExtensionsKt.fadeIn$default(it, 50L, null, false, null, 10, null);
                        }
                    }
                }
            }
        }));
    }

    private final void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        this.isAnimating = true;
        openMultiCheckbox = null;
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)32.0f, (long)200L, (EasingType)EasingType.EASE_IN, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MultiCheckboxElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MultiCheckboxElement.access$getOptionsContainer$p(this.this$0).setVisible(false);
                MultiCheckboxElement.access$setAnimating$p(this.this$0, false);
                MultiCheckboxElement.access$invalidateParentLayout(this.this$0);
            }
        }));
        Iterable $this$forEach$iv = this.optionsContainer.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VexelElement child = (VexelElement)element$iv;
            boolean bl = false;
            ExtensionsKt.fadeOut$default(child, 50L, null, false, null, 14, null);
            Iterable $this$forEach$iv2 = child.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VexelElement it = (VexelElement)element$iv2;
                boolean bl2 = false;
                ExtensionsKt.fadeOut$default(it, 50L, null, false, null, 14, null);
            }
        }
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize$default((VexelElement)((VexelElement)this.optionsContainer), (float)228.0f, (float)0.0f, (long)200L, (EasingType)EasingType.EASE_IN, null, (int)16, null);
    }

    private final void toggleOption(int index, VexelElement<?> checkmark, Rectangle checkbox) {
        boolean wasSelected = this.selectedIndices.contains(index);
        if (wasSelected) {
            this.selectedIndices.remove(index);
            checkmark.setVisible(false);
        } else {
            this.selectedIndices.add(index);
            checkmark.setVisible(true);
            PresetsKt.colorTo((VexelElement)((VexelElement)checkbox), (int)Theme.Primary.withAlpha(0.3f), (long)100L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(checkbox){
                final /* synthetic */ Rectangle $checkbox;
                {
                    this.$checkbox = $checkbox;
                    super(0);
                }

                public final void invoke() {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)this.$checkbox), (int)Theme.BgLight.getColor(), (long)100L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
                }
            }));
        }
        this.selectedText.setText(this.selectedIndices.size() + " selected");
        Iterable $this$forEach$iv = this.getOnValueChange();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)CollectionsKt.toSet((Iterable)this.selectedIndices));
        }
    }

    private final void invalidateParentLayout() {
        block1: {
            VexelElement current;
            Object object = this.getParent();
            VexelElement vexelElement = current = object instanceof VexelElement ? (VexelElement)object : null;
            while (current != null && !(current instanceof SectionButton)) {
                object = current.getParent();
                current = object instanceof VexelElement ? (VexelElement)object : null;
            }
            SectionButton sectionButton = (SectionButton)current;
            if (sectionButton == null) break block1;
            sectionButton.recalculateHeight();
        }
    }

    protected void onRender(float mouseX, float mouseY) {
    }

    public static final /* synthetic */ void access$setAnimating$p(MultiCheckboxElement $this, boolean bl) {
        $this.isAnimating = bl;
    }

    public static final /* synthetic */ void access$invalidateParentLayout(MultiCheckboxElement $this) {
        $this.invalidateParentLayout();
    }

    public static final /* synthetic */ Rectangle access$getOptionsContainer$p(MultiCheckboxElement $this) {
        return $this.optionsContainer;
    }

    public static final /* synthetic */ void access$toggleOption(MultiCheckboxElement $this, int index, VexelElement checkmark, Rectangle checkbox) {
        $this.toggleOption(index, checkmark, checkbox);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R$\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement$Companion;", "", "<init>", "()V", "", "closeAllMultiCheckboxes", "()Lkotlin/Unit;", "Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement;", "openMultiCheckbox", "Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement;", "getOpenMultiCheckbox", "()Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement;", "setOpenMultiCheckbox", "(Lxyz/meowing/zen/config/ui/elements/MultiCheckboxElement;)V", "Zen"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MultiCheckboxElement getOpenMultiCheckbox() {
            return openMultiCheckbox;
        }

        public final void setOpenMultiCheckbox(@Nullable MultiCheckboxElement multiCheckboxElement) {
            openMultiCheckbox = multiCheckboxElement;
        }

        @Nullable
        public final Unit closeAllMultiCheckboxes() {
            Unit unit;
            MultiCheckboxElement multiCheckboxElement = this.getOpenMultiCheckbox();
            if (multiCheckboxElement != null) {
                multiCheckboxElement.collapse();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

