/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.api.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.events.Event;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.annotations.Module;
import xyz.meowing.zen.api.data.StoredFile;
import xyz.meowing.zen.events.EventBus;
import xyz.meowing.zen.events.core.InternalEvent;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0014R+\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR+\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u001b\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR+\u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u001b\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001fR+\u0010,\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010\u001b\u001a\u0004\b*\u0010\u001d\"\u0004\b+\u0010\u001f\u00a8\u0006-"}, d2={"Lxyz/meowing/zen/api/item/NEUApi;", "", "<init>", "()V", "", "force", "", "downloadAndProcessRepo", "(Z)V", "", "NEU_ZIP_URL", "Ljava/lang/String;", "Lorg/apache/http/impl/client/CloseableHttpClient;", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isDownloading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Lxyz/meowing/zen/api/data/StoredFile;", "neuItemFile", "Lxyz/meowing/zen/api/data/StoredFile;", "neuMobFile", "neuConstantFile", "eTagFile", "Lcom/google/gson/JsonObject;", "<set-?>", "neuItemData$delegate", "Lkotlin/properties/ReadWriteProperty;", "getNeuItemData", "()Lcom/google/gson/JsonObject;", "setNeuItemData", "(Lcom/google/gson/JsonObject;)V", "neuItemData", "neuMobData$delegate", "getNeuMobData", "setNeuMobData", "neuMobData", "neuConstantData$delegate", "getNeuConstantData", "setNeuConstantData", "neuConstantData", "eTagData$delegate", "getETagData", "setETagData", "eTagData", "Zen"})
@SourceDebugExtension(value={"SMAP\nNEUApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NEUApi.kt\nxyz/meowing/zen/api/item/NEUApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class NEUApi {
    @NotNull
    public static final NEUApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String NEU_ZIP_URL = "https://github.com/NotEnoughUpdates/NotEnoughUpdates-Repo/archive/master.zip";
    @NotNull
    private static CloseableHttpClient client;
    @NotNull
    private static final AtomicBoolean isDownloading;
    @NotNull
    private static final StoredFile neuItemFile;
    @NotNull
    private static final StoredFile neuMobFile;
    @NotNull
    private static final StoredFile neuConstantFile;
    @NotNull
    private static final StoredFile eTagFile;
    @NotNull
    private static final ReadWriteProperty neuItemData$delegate;
    @NotNull
    private static final ReadWriteProperty neuMobData$delegate;
    @NotNull
    private static final ReadWriteProperty neuConstantData$delegate;
    @NotNull
    private static final ReadWriteProperty eTagData$delegate;

    private NEUApi() {
    }

    @NotNull
    public final JsonObject getNeuItemData() {
        return (JsonObject)neuItemData$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setNeuItemData(@NotNull JsonObject jsonObject2) {
        Intrinsics.checkNotNullParameter((Object)jsonObject2, (String)"<set-?>");
        neuItemData$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)jsonObject2);
    }

    @NotNull
    public final JsonObject getNeuMobData() {
        return (JsonObject)neuMobData$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setNeuMobData(@NotNull JsonObject jsonObject2) {
        Intrinsics.checkNotNullParameter((Object)jsonObject2, (String)"<set-?>");
        neuMobData$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)jsonObject2);
    }

    @NotNull
    public final JsonObject getNeuConstantData() {
        return (JsonObject)neuConstantData$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setNeuConstantData(@NotNull JsonObject jsonObject2) {
        Intrinsics.checkNotNullParameter((Object)jsonObject2, (String)"<set-?>");
        neuConstantData$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)jsonObject2);
    }

    private final JsonObject getETagData() {
        return (JsonObject)eTagData$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setETagData(JsonObject jsonObject2) {
        eTagData$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)jsonObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void downloadAndProcessRepo(boolean force) {
        block29: {
            if (!isDownloading.compareAndSet(false, true)) {
                return;
            }
            try {
                boolean matchesLastETag;
                HttpHead httpHead;
                Object object = this.getETagData().get("tag");
                if (object == null || (object = object.getAsString()) == null) {
                    object = "";
                }
                Object eTagString = object;
                HttpHead $this$downloadAndProcessRepo_u24lambda_u240 = httpHead = new HttpHead(NEU_ZIP_URL);
                boolean bl = false;
                if (((CharSequence)eTagString).length() > 0) {
                    $this$downloadAndProcessRepo_u24lambda_u240.setHeader("If-None-Match", (String)eTagString);
                }
                HttpHead request = httpHead;
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                boolean bl2 = matchesLastETag = response.getStatusLine().getStatusCode() == 304;
                if (!matchesLastETag || force) {
                    InputStream inputStream;
                    CloseableHttpResponse closeableHttpResponse;
                    CloseableHttpResponse closeableHttpResponse2;
                    CloseableHttpResponse it = closeableHttpResponse2 = client.execute((HttpUriRequest)new HttpGet(NEU_ZIP_URL));
                    boolean bl3 = false;
                    Object object2 = closeableHttpResponse = it.getStatusLine().getStatusCode() == 200 ? closeableHttpResponse2 : null;
                    if (closeableHttpResponse == null || (closeableHttpResponse2 = closeableHttpResponse.getEntity()) == null || (inputStream = closeableHttpResponse2.getContent()) == null) break block29;
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream zipStream = (InputStream)closeable;
                        boolean bl4 = false;
                        Closeable closeable2 = new ZipInputStream(zipStream);
                        Throwable throwable2 = null;
                        try {
                            void $this$downloadAndProcessRepo_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                            InputStream inputStream2;
                            ZipInputStream zip = (ZipInputStream)closeable2;
                            boolean bl5 = false;
                            ZipEntry entry = zip.getNextEntry();
                            JsonObject neuItems = new JsonObject();
                            JsonObject neuMobs = new JsonObject();
                            JsonObject neuConstants = new JsonObject();
                            while (entry != null) {
                                String string = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                if (StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) {
                                    inputStream2 = zip;
                                    String[] stringArray = Charsets.UTF_8;
                                    Reader reader = new InputStreamReader(inputStream2, (Charset)stringArray);
                                    int n = 8192;
                                    String jsonContent = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                                    String string2 = entry.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                    stringArray = new String[]{"/"};
                                    String name = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (CharSequence)".json");
                                    try {
                                        JsonObject value = new JsonParser().parse(jsonContent).getAsJsonObject();
                                        String string3 = entry.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                                        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"/items/", (boolean)false, (int)2, null)) {
                                            neuItems.add(name, (JsonElement)value);
                                        } else {
                                            String string4 = entry.getName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                                            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"/mobs/", (boolean)false, (int)2, null)) {
                                                neuMobs.add(name, (JsonElement)value);
                                            } else {
                                                String string5 = entry.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                                                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"/constants/", (boolean)false, (int)2, null)) {
                                                    neuConstants.add(name, (JsonElement)value);
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        Zen.LOGGER.error("Failed to parse JSON from entry " + entry.getName() + ", skipping...");
                                    }
                                }
                                entry = zip.getNextEntry();
                            }
                            INSTANCE.setNeuItemData(neuItems);
                            INSTANCE.setNeuMobData(neuMobs);
                            INSTANCE.setNeuConstantData(neuConstants);
                            zip.closeEntry();
                            Zen.LOGGER.info("NEU API data downloaded and processed successfully.");
                            Header header = response.getFirstHeader("ETag");
                            String newETag = header != null ? header.getValue() : null;
                            InputStream e = inputStream2 = new JsonObject();
                            NEUApi nEUApi = INSTANCE;
                            boolean bl6 = false;
                            String string = newETag;
                            if (string == null) {
                                string = "";
                            }
                            $this$downloadAndProcessRepo_u24lambda_u244_u24lambda_u243_u24lambda_u242.addProperty("tag", string);
                            nEUApi.setETagData((JsonObject)inputStream2);
                            Zen.LOGGER.info("Saved NEU API Data to file and updated ETag.");
                            neuItemFile.forceSave();
                            neuMobFile.forceSave();
                            neuConstantFile.forceSave();
                            eTagFile.forceSave();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block29;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                Zen.LOGGER.info("ETag matches. No need to download. Loading from file...");
                if (this.getNeuItemData().entrySet().isEmpty() || this.getNeuMobData().entrySet().isEmpty() || this.getNeuConstantData().entrySet().isEmpty()) {
                    Zen.LOGGER.warn("Failed to load NEU API data from file. Redownloading...");
                    isDownloading.set(false);
                    this.downloadAndProcessRepo(true);
                    return;
                }
            }
            finally {
                isDownloading.set(false);
                xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new InternalEvent.NeuAPI.Load(), (boolean)false, (int)2, null);
            }
        }
    }

    public static /* synthetic */ void downloadAndProcessRepo$default(NEUApi nEUApi, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        nEUApi.downloadAndProcessRepo(bl);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(NEUApi.class, "neuItemData", "getNeuItemData()Lcom/google/gson/JsonObject;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(NEUApi.class, "neuMobData", "getNeuMobData()Lcom/google/gson/JsonObject;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(NEUApi.class, "neuConstantData", "getNeuConstantData()Lcom/google/gson/JsonObject;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(NEUApi.class, "eTagData", "getETagData()Lcom/google/gson/JsonObject;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new NEUApi();
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"createDefault(...)");
        client = closeableHttpClient;
        isDownloading = new AtomicBoolean(false);
        neuItemFile = new StoredFile("api/NeuAPI/NeuItems");
        neuMobFile = new StoredFile("api/NeuAPI/NeuMobs");
        neuConstantFile = new StoredFile("api/NeuAPI/NeuConstants");
        eTagFile = new StoredFile("api/NeuAPI/NEUAPI-ETAG");
        neuItemData$delegate = StoredFile.jsonObject$default(neuItemFile, "data", null, 2, null);
        neuMobData$delegate = StoredFile.jsonObject$default(neuMobFile, "data", null, 2, null);
        neuConstantData$delegate = StoredFile.jsonObject$default(neuConstantFile, "data", null, 2, null);
        eTagData$delegate = StoredFile.jsonObject$default(eTagFile, "data", null, 2, null);
    }
}

