/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.elements;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.input.KnitMouseButtons;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.ExtensionsKt;
import xyz.meowing.vexel.animations.PresetsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.vexel.utils.render.NVGRenderer;
import xyz.meowing.vexel.utils.style.Gradient;
import xyz.meowing.zen.config.ui.panels.SectionButton;
import xyz.meowing.zen.ui.Theme;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003PQRB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\nJ\u000f\u0010\u001b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\nJ\u000f\u0010\u001c\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\nJ\u001f\u0010\u001d\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u0016R\"\u0010\u001e\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%R\"\u0010'\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010\u0018R\"\u0010,\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010(\u001a\u0004\b-\u0010*\"\u0004\b.\u0010\u0018R\"\u0010/\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010(\u001a\u0004\b0\u0010*\"\u0004\b1\u0010\u0018R\"\u00102\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010(\u001a\u0004\b3\u0010*\"\u0004\b4\u0010\u0018R\"\u00105\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010%\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010:\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010%\u001a\u0004\b;\u00107\"\u0004\b<\u00109R\"\u0010=\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010%\u001a\u0004\b>\u00107\"\u0004\b?\u00109R\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0014\u0010D\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010ER\u0018\u0010H\u001a\u00060GR\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0018\u0010K\u001a\u00060JR\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0018\u0010N\u001a\u00060MR\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010O\u00a8\u0006S"}, d2={"Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "name", "Ljava/awt/Color;", "initialColor", "<init>", "(Ljava/lang/String;Ljava/awt/Color;)V", "", "setupInteractions", "()V", "", "mouseX", "mouseY", "", "handleMouseMove", "(FF)Z", "", "button", "handleMouseRelease", "(FFI)Z", "updatePickerFromMouse", "(FF)V", "updateHueFromMouse", "(F)V", "updateAlphaFromMouse", "updateColor", "toggleExpanded", "invalidateParentLayout", "onRender", "selectedColor", "Ljava/awt/Color;", "getSelectedColor", "()Ljava/awt/Color;", "setSelectedColor", "(Ljava/awt/Color;)V", "expanded", "Z", "isAnimating", "currentHue", "F", "getCurrentHue", "()F", "setCurrentHue", "currentSaturation", "getCurrentSaturation", "setCurrentSaturation", "currentBrightness", "getCurrentBrightness", "setCurrentBrightness", "currentAlpha", "getCurrentAlpha", "setCurrentAlpha", "draggingPicker", "getDraggingPicker", "()Z", "setDraggingPicker", "(Z)V", "draggingHue", "getDraggingHue", "setDraggingHue", "draggingAlpha", "getDraggingAlpha", "setDraggingAlpha", "Lxyz/meowing/vexel/components/core/Text;", "label", "Lxyz/meowing/vexel/components/core/Text;", "Lxyz/meowing/vexel/components/core/Rectangle;", "previewRect", "Lxyz/meowing/vexel/components/core/Rectangle;", "pickerContainer", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$ColorPickerArea;", "pickerArea", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$ColorPickerArea;", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$HueSlider;", "hueSlider", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$HueSlider;", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$AlphaSlider;", "alphaSlider", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$AlphaSlider;", "ColorPickerArea", "HueSlider", "AlphaSlider", "Zen"})
@SourceDebugExtension(value={"SMAP\nColorPickerElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPickerElement.kt\nxyz/meowing/zen/config/ui/elements/ColorPickerElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1869#2,2:278\n*S KotlinDebug\n*F\n+ 1 ColorPickerElement.kt\nxyz/meowing/zen/config/ui/elements/ColorPickerElement\n*L\n180#1:278,2\n*E\n"})
public final class ColorPickerElement
extends VexelElement<ColorPickerElement> {
    @NotNull
    private Color selectedColor;
    private boolean expanded;
    private boolean isAnimating;
    private float currentHue;
    private float currentSaturation;
    private float currentBrightness;
    private float currentAlpha;
    private boolean draggingPicker;
    private boolean draggingHue;
    private boolean draggingAlpha;
    @NotNull
    private final Text label;
    @NotNull
    private final Rectangle previewRect;
    @NotNull
    private final Rectangle pickerContainer;
    @NotNull
    private final ColorPickerArea pickerArea;
    @NotNull
    private final HueSlider hueSlider;
    @NotNull
    private final AlphaSlider alphaSlider;

    public ColorPickerElement(@NotNull String name, @NotNull Color initialColor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initialColor, (String)"initialColor");
        super(null, null, 3, null);
        this.selectedColor = initialColor;
        this.currentAlpha = (float)initialColor.getAlpha() / 255.0f;
        this.label = (Text)((Text)new Text(name, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(6.0f, Pos.ParentPixels, 8.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.previewRect = (Rectangle)((Rectangle)((Rectangle)((Rectangle)((Rectangle)new Rectangle(this.selectedColor.getRGB(), Theme.Border.getColor(), 3.0f, 1.0f, null, null, null, null, null, false, 1008, null).setSizing(30.0f, Size.Pixels, 20.0f, Size.Pixels)).setPositioning(-6.0f, Pos.ParentPixels, 0.0f, Pos.MatchSibling)).alignRight()).setOffset(0.0f, -2.0f)).childOf((VexelElement)this);
        this.pickerContainer = (Rectangle)((Rectangle)((Rectangle)new Rectangle(0, 0, 0.0f, 0.0f, null, null, null, null, null, false, 1008, null).setSizing(228.0f, Size.Pixels, 0.0f, Size.Pixels)).setPositioning(6.0f, Pos.ParentPixels, 37.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.pickerArea = (ColorPickerArea)((ColorPickerArea)((ColorPickerArea)new ColorPickerArea().setSizing(228.0f, Size.Pixels, 140.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentPixels, 0.0f, Pos.ParentPixels)).childOf((VexelElement)this.pickerContainer);
        this.hueSlider = (HueSlider)((HueSlider)((HueSlider)new HueSlider().setSizing(228.0f, Size.Pixels, 15.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentPixels, 5.0f, Pos.AfterSibling)).childOf((VexelElement)this.pickerContainer);
        this.alphaSlider = (AlphaSlider)((AlphaSlider)((AlphaSlider)new AlphaSlider().setSizing(228.0f, Size.Pixels, 15.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentPixels, 5.0f, Pos.AfterSibling)).childOf((VexelElement)this.pickerContainer);
        this.setSizing(240.0f, Size.Pixels, 32.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.AfterSibling);
        float[] hsb = Color.RGBtoHSB(initialColor.getRed(), initialColor.getGreen(), initialColor.getBlue(), null);
        this.currentHue = hsb[0];
        this.currentSaturation = hsb[1];
        this.currentBrightness = hsb[2];
        this.updateColor();
        ((Rectangle)this.previewRect.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(){

            public final Boolean invoke(float f, float f2, int n) {
                if (!isAnimating) {
                    this.toggleExpanded();
                }
                return true;
            }
        })).onHover((Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)previewRect), (int)this.getSelectedColor().darker().getRGB(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
            }
        }, (Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)previewRect), (int)this.getSelectedColor().getRGB(), (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
            }
        });
        this.setupInteractions();
        this.pickerContainer.setVisible(false);
        this.pickerArea.setVisible(false);
        this.hueSlider.setVisible(false);
        this.alphaSlider.setVisible(false);
    }

    @NotNull
    public final Color getSelectedColor() {
        return this.selectedColor;
    }

    public final void setSelectedColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.selectedColor = color;
    }

    public final float getCurrentHue() {
        return this.currentHue;
    }

    public final void setCurrentHue(float f) {
        this.currentHue = f;
    }

    public final float getCurrentSaturation() {
        return this.currentSaturation;
    }

    public final void setCurrentSaturation(float f) {
        this.currentSaturation = f;
    }

    public final float getCurrentBrightness() {
        return this.currentBrightness;
    }

    public final void setCurrentBrightness(float f) {
        this.currentBrightness = f;
    }

    public final float getCurrentAlpha() {
        return this.currentAlpha;
    }

    public final void setCurrentAlpha(float f) {
        this.currentAlpha = f;
    }

    public final boolean getDraggingPicker() {
        return this.draggingPicker;
    }

    public final void setDraggingPicker(boolean bl) {
        this.draggingPicker = bl;
    }

    public final boolean getDraggingHue() {
        return this.draggingHue;
    }

    public final void setDraggingHue(boolean bl) {
        this.draggingHue = bl;
    }

    public final boolean getDraggingAlpha() {
        return this.draggingAlpha;
    }

    public final void setDraggingAlpha(boolean bl) {
        this.draggingAlpha = bl;
    }

    private final void setupInteractions() {
        this.pickerArea.onMouseClick((Function3)new Function3<Float, Float, Integer, Boolean>(this){
            final /* synthetic */ ColorPickerElement this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final Boolean invoke(float mouseX, float mouseY, int n) {
                this.this$0.setDraggingPicker(true);
                ColorPickerElement.access$updatePickerFromMouse(this.this$0, mouseX, mouseY);
                return true;
            }
        });
        this.hueSlider.onMouseClick((Function3)new Function3<Float, Float, Integer, Boolean>(this){
            final /* synthetic */ ColorPickerElement this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final Boolean invoke(float mouseX, float f, int n) {
                this.this$0.setDraggingHue(true);
                ColorPickerElement.access$updateHueFromMouse(this.this$0, mouseX);
                return true;
            }
        });
        this.alphaSlider.onMouseClick((Function3)new Function3<Float, Float, Integer, Boolean>(this){
            final /* synthetic */ ColorPickerElement this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final Boolean invoke(float mouseX, float f, int n) {
                this.this$0.setDraggingAlpha(true);
                ColorPickerElement.access$updateAlphaFromMouse(this.this$0, mouseX);
                return true;
            }
        });
    }

    public boolean handleMouseMove(float mouseX, float mouseY) {
        boolean result = super.handleMouseMove(mouseX, mouseY);
        if (this.draggingPicker) {
            this.updatePickerFromMouse(mouseX, mouseY);
        } else if (this.draggingHue) {
            this.updateHueFromMouse(mouseX);
        } else if (this.draggingAlpha) {
            this.updateAlphaFromMouse(mouseX);
        }
        return result;
    }

    public boolean handleMouseRelease(float mouseX, float mouseY, int button2) {
        boolean result = super.handleMouseRelease(mouseX, mouseY, button2);
        if (button2 == 0) {
            this.draggingPicker = false;
            this.draggingHue = false;
            this.draggingAlpha = false;
        }
        return result;
    }

    private final void updatePickerFromMouse(float mouseX, float mouseY) {
        float relativeX = (mouseX - this.pickerArea.getX()) / this.pickerArea.getWidth();
        float relativeY = (mouseY - this.pickerArea.getY()) / this.pickerArea.getHeight();
        this.currentSaturation = RangesKt.coerceIn((float)relativeX, (float)0.0f, (float)1.0f);
        this.currentBrightness = RangesKt.coerceIn((float)(1.0f - relativeY), (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private final void updateHueFromMouse(float mouseX) {
        float relativeX = (mouseX - this.hueSlider.getX()) / this.hueSlider.getWidth();
        this.currentHue = RangesKt.coerceIn((float)relativeX, (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private final void updateAlphaFromMouse(float mouseX) {
        float relativeX = (mouseX - this.alphaSlider.getX()) / this.alphaSlider.getWidth();
        this.currentAlpha = RangesKt.coerceIn((float)relativeX, (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private final void updateColor() {
        int rgb = Color.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness);
        Color baseColor = new Color(rgb);
        int alpha = RangesKt.coerceIn((int)MathKt.roundToInt((float)(this.currentAlpha * (float)255)), (int)0, (int)255);
        this.selectedColor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
        this.previewRect.setBackgroundColor(this.selectedColor.getRGB());
        this.pickerArea.setCurrentHue(this.currentHue);
        this.alphaSlider.setCurrentColor(new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue()));
        Iterable $this$forEach$iv = this.getOnValueChange();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this.selectedColor);
        }
    }

    private final void toggleExpanded() {
        this.expanded = !this.expanded;
        this.isAnimating = true;
        if (this.expanded) {
            this.pickerContainer.setVisible(true);
            float targetHeight = 222.0f;
            ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)targetHeight, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ColorPickerElement this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ColorPickerElement.access$setAnimating$p(this.this$0, false);
                    ColorPickerElement.access$invalidateParentLayout(this.this$0);
                }
            }));
            v0 = ExtensionsKt.animateSize((VexelElement)((VexelElement)this.pickerContainer), (float)228.0f, (float)175.0f, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ColorPickerElement this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ColorPickerElement.access$getPickerArea$p(this.this$0).setVisible(true);
                    ColorPickerElement.access$getHueSlider$p(this.this$0).setVisible(true);
                    ColorPickerElement.access$getAlphaSlider$p(this.this$0).setVisible(true);
                }
            }));
        } else {
            ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)32.0f, (long)200L, (EasingType)EasingType.EASE_IN, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ColorPickerElement this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ColorPickerElement.access$getPickerContainer$p(this.this$0).setVisible(false);
                    ColorPickerElement.access$setAnimating$p(this.this$0, false);
                    ColorPickerElement.access$invalidateParentLayout(this.this$0);
                }
            }));
            this.pickerArea.setVisible(false);
            this.hueSlider.setVisible(false);
            this.alphaSlider.setVisible(false);
            v0 = ExtensionsKt.animateSize$default((VexelElement)((VexelElement)this.pickerContainer), (float)228.0f, (float)0.0f, (long)200L, (EasingType)EasingType.EASE_IN, null, (int)16, null);
        }
    }

    private final void invalidateParentLayout() {
        block1: {
            VexelElement current;
            Object object = this.getParent();
            VexelElement vexelElement = current = object instanceof VexelElement ? (VexelElement)object : null;
            while (current != null && !(current instanceof SectionButton)) {
                object = current.getParent();
                current = object instanceof VexelElement ? (VexelElement)object : null;
            }
            SectionButton sectionButton = (SectionButton)current;
            if (sectionButton == null) break block1;
            sectionButton.recalculateHeight();
        }
    }

    protected void onRender(float mouseX, float mouseY) {
        if (this.draggingPicker && !KnitMouseButtons.INSTANCE.getLEFT().isPressed()) {
            this.draggingPicker = false;
        }
        if (this.draggingAlpha && !KnitMouseButtons.INSTANCE.getLEFT().isPressed()) {
            this.draggingAlpha = false;
        }
        if (this.draggingHue && !KnitMouseButtons.INSTANCE.getLEFT().isPressed()) {
            this.draggingHue = false;
        }
    }

    public static final /* synthetic */ void access$updatePickerFromMouse(ColorPickerElement $this, float mouseX, float mouseY) {
        $this.updatePickerFromMouse(mouseX, mouseY);
    }

    public static final /* synthetic */ void access$updateHueFromMouse(ColorPickerElement $this, float mouseX) {
        $this.updateHueFromMouse(mouseX);
    }

    public static final /* synthetic */ void access$updateAlphaFromMouse(ColorPickerElement $this, float mouseX) {
        $this.updateAlphaFromMouse(mouseX);
    }

    public static final /* synthetic */ void access$setAnimating$p(ColorPickerElement $this, boolean bl) {
        $this.isAnimating = bl;
    }

    public static final /* synthetic */ void access$invalidateParentLayout(ColorPickerElement $this) {
        $this.invalidateParentLayout();
    }

    public static final /* synthetic */ ColorPickerArea access$getPickerArea$p(ColorPickerElement $this) {
        return $this.pickerArea;
    }

    public static final /* synthetic */ HueSlider access$getHueSlider$p(ColorPickerElement $this) {
        return $this.hueSlider;
    }

    public static final /* synthetic */ AlphaSlider access$getAlphaSlider$p(ColorPickerElement $this) {
        return $this.alphaSlider;
    }

    public static final /* synthetic */ Rectangle access$getPickerContainer$p(ColorPickerElement $this) {
        return $this.pickerContainer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$AlphaSlider;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;", "<init>", "(Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "Ljava/awt/Color;", "currentColor", "Ljava/awt/Color;", "getCurrentColor", "()Ljava/awt/Color;", "setCurrentColor", "(Ljava/awt/Color;)V", "Zen"})
    public final class AlphaSlider
    extends VexelElement<AlphaSlider> {
        @NotNull
        private Color currentColor;

        public AlphaSlider() {
            super(null, null, 3, null);
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
            this.currentColor = color;
        }

        @NotNull
        public final Color getCurrentColor() {
            return this.currentColor;
        }

        public final void setCurrentColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.currentColor = color;
        }

        protected void onRender(float mouseX, float mouseY) {
            int opaqueColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), 255).getRGB();
            int transparentColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), 0).getRGB();
            NVGRenderer.INSTANCE.gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), transparentColor, opaqueColor, Gradient.LeftToRight, 0.0f);
            float indicatorX = this.getX() + ColorPickerElement.this.getCurrentAlpha() * this.getWidth();
            NVGRenderer.INSTANCE.rect(indicatorX - 2.0f, this.getY() - 2.0f, 4.0f, this.getHeight() + 4.0f, -1, 2.0f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$ColorPickerArea;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;", "<init>", "(Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "currentHue", "F", "getCurrentHue", "()F", "setCurrentHue", "(F)V", "Zen"})
    public final class ColorPickerArea
    extends VexelElement<ColorPickerArea> {
        private float currentHue;

        public ColorPickerArea() {
            super(null, null, 3, null);
        }

        public final float getCurrentHue() {
            return this.currentHue;
        }

        public final void setCurrentHue(float f) {
            this.currentHue = f;
        }

        protected void onRender(float mouseX, float mouseY) {
            int hueColor = Color.HSBtoRGB(this.currentHue, 1.0f, 1.0f);
            int whiteColor = -1;
            int blackColor = -16777216;
            NVGRenderer.INSTANCE.gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), whiteColor, hueColor, Gradient.LeftToRight, 0.0f);
            NVGRenderer.INSTANCE.gradientRect(this.getX(), this.getY(), this.getWidth(), this.getHeight() + 1.0f, 0, blackColor, Gradient.TopToBottom, 0.0f);
            float indicatorX = this.getX() + ColorPickerElement.this.getCurrentSaturation() * this.getWidth();
            float indicatorY = this.getY() + (1.0f - ColorPickerElement.this.getCurrentBrightness()) * this.getHeight();
            NVGRenderer.INSTANCE.hollowRect(indicatorX - 3.0f, indicatorY - 3.0f, 6.0f, 6.0f, 2.0f, -1, 2.0f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lxyz/meowing/zen/config/ui/elements/ColorPickerElement$HueSlider;", "Lxyz/meowing/vexel/components/base/VexelElement;", "Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;", "<init>", "(Lxyz/meowing/zen/config/ui/elements/ColorPickerElement;)V", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "Zen"})
    public final class HueSlider
    extends VexelElement<HueSlider> {
        public HueSlider() {
            super(null, null, 3, null);
        }

        protected void onRender(float mouseX, float mouseY) {
            int steps = (int)(this.getWidth() / 1.0f);
            float stepWidth = this.getWidth() / (float)steps;
            for (int i = 0; i < steps; ++i) {
                float hue = (float)i / (float)steps;
                int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                Color color = new Color(rgb);
                float rectX = this.getX() + (float)i * stepWidth;
                NVGRenderer.INSTANCE.rect(rectX, this.getY(), stepWidth, this.getHeight(), color.getRGB(), 0.0f);
            }
            float indicatorX = this.getX() + ColorPickerElement.this.getCurrentHue() * this.getWidth();
            NVGRenderer.INSTANCE.rect(indicatorX - 2.0f, this.getY() - 2.0f, 4.0f, this.getHeight() + 4.0f, -1, 3.0f);
        }
    }
}

