/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.features.dungeons;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.zen.annotations.Module;
import xyz.meowing.zen.api.dungeons.DungeonFloor;
import xyz.meowing.zen.api.location.SkyBlockIsland;
import xyz.meowing.zen.config.ui.types.ElementType;
import xyz.meowing.zen.events.EventBus;
import xyz.meowing.zen.events.core.ChatEvent;
import xyz.meowing.zen.events.core.GuiEvent;
import xyz.meowing.zen.events.core.LocationEvent;
import xyz.meowing.zen.features.Feature;
import xyz.meowing.zen.features.dungeons.FireFreezeTimer;
import xyz.meowing.zen.hud.HUDManager;
import xyz.meowing.zen.managers.config.ConfigElement;
import xyz.meowing.zen.managers.config.ConfigManager;
import xyz.meowing.zen.utils.Render2D;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lxyz/meowing/zen/features/dungeons/FireFreezeTimer;", "Lxyz/meowing/zen/features/Feature;", "<init>", "()V", "", "addConfig", "initialize", "onRegister", "onUnregister", "Lnet/minecraft/class_332;", "context", "renderHUD", "(Lnet/minecraft/class_332;)V", "", "NAME", "Ljava/lang/String;", "", "ticks", "I", "getTicks", "()I", "setTicks", "(I)V", "Zen"})
@SourceDebugExtension(value={"SMAP\nFireFreezeTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FireFreezeTimer.kt\nxyz/meowing/zen/features/dungeons/FireFreezeTimer\n+ 2 Feature.kt\nxyz/meowing/zen/features/Feature\n+ 3 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n*L\n1#1,85:1\n107#2,2:86\n109#2:89\n107#2,2:90\n109#2:93\n107#2,2:94\n109#2:97\n19#3:88\n19#3:92\n19#3:96\n*S KotlinDebug\n*F\n+ 1 FireFreezeTimer.kt\nxyz/meowing/zen/features/dungeons/FireFreezeTimer\n*L\n45#1:86,2\n45#1:89\n60#1:90,2\n60#1:93\n62#1:94,2\n62#1:97\n45#1:88\n60#1:92\n62#1:96\n*E\n"})
public final class FireFreezeTimer
extends Feature {
    @NotNull
    public static final FireFreezeTimer INSTANCE = new FireFreezeTimer();
    @NotNull
    private static final String NAME = "Fire Freeze Timer";
    private static int ticks;

    private FireFreezeTimer() {
        DungeonFloor[] dungeonFloorArray = new DungeonFloor[]{DungeonFloor.F3, DungeonFloor.M3};
        super("fireFreezeTimer", false, (Object)SkyBlockIsland.THE_CATACOMBS, null, CollectionsKt.listOf((Object[])dungeonFloorArray), 10, null);
    }

    public final int getTicks() {
        return ticks;
    }

    public final void setTicks(int n) {
        ticks = n;
    }

    @Override
    public void addConfig() {
        ConfigManager.INSTANCE.addFeature("Fire freeze timer", "Shows a timer for Fire Freeze staff ability in dungeons", "Dungeons", new ConfigElement("fireFreezeTimer", new ElementType.Switch(false), null, null, 12, null));
    }

    @Override
    public void initialize() {
        boolean add$iv$iv;
        int priority$iv$iv;
        xyz.meowing.knit.api.events.EventBus this_$iv$iv;
        Feature $this$iv;
        HUDManager.INSTANCE.register(NAME, "\u00a7bFire freeze: \u00a7c4.3s");
        Feature feature = this;
        Function1 cb$iv = initialize.1.INSTANCE;
        int priority$iv = 0;
        boolean $i$f$register = false;
        xyz.meowing.knit.api.events.EventBus eventBus = EventBus.INSTANCE;
        int n = priority$iv;
        boolean bl = false;
        Function1 callback$iv$iv = cb$iv;
        boolean $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(ChatEvent.Receive.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
        $this$iv = this;
        cb$iv = initialize.2.INSTANCE;
        priority$iv = 0;
        $i$f$register = false;
        this_$iv$iv = EventBus.INSTANCE;
        priority$iv$iv = priority$iv;
        add$iv$iv = false;
        callback$iv$iv = cb$iv;
        $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(GuiEvent.Render.HUD.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
        $this$iv = this;
        cb$iv = initialize.3.INSTANCE;
        priority$iv = 0;
        $i$f$register = false;
        this_$iv$iv = EventBus.INSTANCE;
        priority$iv$iv = priority$iv;
        add$iv$iv = false;
        callback$iv$iv = cb$iv;
        $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(LocationEvent.WorldChange.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
    }

    @Override
    public void onRegister() {
        ticks = 0;
        super.onRegister();
    }

    @Override
    public void onUnregister() {
        ticks = 0;
        super.onUnregister();
    }

    private final void renderHUD(class_332 context) {
        if (!HUDManager.INSTANCE.isEnabled(NAME) || ticks <= 0) {
            return;
        }
        String string = "%.1f";
        Object[] objectArray = new Object[]{(double)ticks / 20.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String text = "\u00a7bFire freeze: \u00a7c" + string2 + "s";
        float x = HUDManager.INSTANCE.getX(NAME);
        float y = HUDManager.INSTANCE.getY(NAME);
        float scale = HUDManager.INSTANCE.getScale(NAME);
        Render2D.renderString$default(Render2D.INSTANCE, context, text, x, y, scale, 0, null, 96, null);
    }

    public static final /* synthetic */ void access$renderHUD(FireFreezeTimer $this, class_332 context) {
        $this.renderHUD(context);
    }
}

