/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.api.websocket;

import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.scheduler.TimeScheduler;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.annotations.Module;
import xyz.meowing.zen.api.websocket.ZenAPI;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lxyz/meowing/zen/api/websocket/ZenAPI;", "", "<init>", "()V", "", "scheduleReconnect", "connectToWebsocket", "", "getZenJarName", "()Ljava/lang/String;", "Ljava/net/http/WebSocket;", "ws", "Ljava/net/http/WebSocket;", "", "reconnectAttempts", "I", "MAX_RECONNECT_ATTEMPTS", "", "BASE_RECONNECT_DELAY", "J", "Zen"})
@SourceDebugExtension(value={"SMAP\nZenAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZenAPI.kt\nxyz/meowing/zen/api/websocket/ZenAPI\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,102:1\n11228#2:103\n11563#2,3:104\n*S KotlinDebug\n*F\n+ 1 ZenAPI.kt\nxyz/meowing/zen/api/websocket/ZenAPI\n*L\n99#1:103\n99#1:104,3\n*E\n"})
public final class ZenAPI {
    @NotNull
    public static final ZenAPI INSTANCE = new ZenAPI();
    @Nullable
    private static WebSocket ws;
    private static int reconnectAttempts;
    private static final int MAX_RECONNECT_ATTEMPTS = 5;
    private static final long BASE_RECONNECT_DELAY = 10000L;

    private ZenAPI() {
    }

    private final void scheduleReconnect() {
        if (reconnectAttempts >= 5) {
            Zen.LOGGER.warn("Max reconnection attempts (5) reached. Stopping reconnection.");
            return;
        }
        long delayMillis = (long)((double)10000L * Math.pow(2.0, reconnectAttempts));
        int n = reconnectAttempts;
        reconnectAttempts = n + 1;
        Zen.LOGGER.info("Reconnecting in " + delayMillis / (long)1000 + " seconds...");
        TimeScheduler.INSTANCE.schedule(delayMillis, (Function0)scheduleReconnect.1.INSTANCE);
    }

    public final void connectToWebsocket() {
        Zen.LOGGER.info("Attempting to connect to WebSocket...");
        Object object = KnitClient.getClient().method_1548().method_44717();
        if (object == null) {
            object = KnitClient.getClient().method_1548().method_1676();
        }
        Pair[] uuid2 = object.toString();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        Pair[] pairArray = uuid2;
        byte[] byArray = pairArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        String hashedUUID2 = ArraysKt.joinToString$default((byte[])byArray2, (CharSequence)"", null, null, (int)0, null, (Function1)connectToWebsocket.hashedUUID.1.INSTANCE, (int)30, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)Zen.getModInfo().getVersion()), TuplesKt.to((Object)"gameVersion", (Object)Zen.getModInfo().getMcVersion()), TuplesKt.to((Object)"hashedUUID", (Object)hashedUUID2), TuplesKt.to((Object)"jarName", (Object)this.getZenJarName())};
        Map debug = MapsKt.mapOf((Pair[])pairArray);
        String debugOptions2 = CollectionsKt.joinToString$default((Iterable)debug.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)connectToWebsocket.debugOptions.1.INSTANCE, (int)30, null);
        URI uri = URI.create("ws://zen.mrfast-developer.com:1515/ws?" + debugOptions2);
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        CompletableFuture<WebSocket> connectionAttempt2 = client.newWebSocketBuilder().buildAsync(uri, new WebSocket.Listener(){

            public void onOpen(WebSocket webSocket) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Zen.LOGGER.info("WebSocket connected!");
                ZenAPI.access$setWs$p(webSocket);
                ZenAPI.access$setReconnectAttempts$p(0);
                webSocket.request(1L);
            }

            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                webSocket.request(1L);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }

            public void onError(WebSocket webSocket, Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Zen.LOGGER.error("WebSocket error: " + error);
            }

            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                String string = reason;
                if (string == null) {
                    string = "";
                }
                Zen.LOGGER.info("WebSocket closed: " + statusCode + " " + string);
                ZenAPI.access$scheduleReconnect(ZenAPI.INSTANCE);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
        });
        connectionAttempt2.exceptionally(ZenAPI::connectToWebsocket$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private final String getZenJarName() {
        Object names;
        Object object;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                File modsDir = FabricLoader.getInstance().getGameDir().resolve("mods").toFile();
                object = modsDir.listFiles(ZenAPI::getZenJarName$lambda$1);
                if (object == null) break block3;
                File[] $this$map$iv = object;
                boolean $i$f$map = false;
                File[] fileArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                object = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return !((Collection)(names = object)).isEmpty() ? CollectionsKt.joinToString$default((Iterable)((Iterable)names), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "Zen-DevAuthClient.jar";
    }

    private static final WebSocket connectToWebsocket$lambda$0(Throwable error) {
        Zen.LOGGER.error("WebSocket connection failed: " + error);
        INSTANCE.scheduleReconnect();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getZenJarName$lambda$1(File f) {
        if (!f.isFile()) return false;
        String string = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) return false;
        String string2 = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.contains((CharSequence)string2, (CharSequence)"zen", (boolean)true)) return false;
        return true;
    }

    public static final /* synthetic */ void access$setWs$p(WebSocket webSocket) {
        ws = webSocket;
    }

    public static final /* synthetic */ void access$setReconnectAttempts$p(int n) {
        reconnectAttempts = n;
    }

    public static final /* synthetic */ void access$scheduleReconnect(ZenAPI $this) {
        $this.scheduleReconnect();
    }

    static {
        INSTANCE.connectToWebsocket();
    }
}

