/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.features.general.chatCleaner;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.input.KnitKeys;
import xyz.meowing.zen.Zen;
import xyz.meowing.zen.annotations.Module;
import xyz.meowing.zen.api.data.StoredFile;
import xyz.meowing.zen.config.Handler;
import xyz.meowing.zen.config.ui.elements.base.ElementType;
import xyz.meowing.zen.events.EventBus;
import xyz.meowing.zen.events.core.ChatEvent;
import xyz.meowing.zen.events.core.GuiEvent;
import xyz.meowing.zen.events.core.KeyEvent;
import xyz.meowing.zen.features.Feature;
import xyz.meowing.zen.features.general.chatCleaner.ChatCleaner;
import xyz.meowing.zen.features.general.chatCleaner.ChatFilterType;
import xyz.meowing.zen.features.general.chatCleaner.ChatPattern;
import xyz.meowing.zen.hud.HUDManager;
import xyz.meowing.zen.managers.config.ConfigElement;
import xyz.meowing.zen.managers.config.ConfigManager;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J%\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0003J-\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001e\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\"\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001b\u001a\u0004\b \u0010!R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R7\u00101\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00062"}, d2={"Lxyz/meowing/zen/features/general/chatCleaner/ChatCleaner;", "Lxyz/meowing/zen/features/Feature;", "<init>", "()V", "", "addConfig", "initialize", "loadDefault", "", "pattern", "Lxyz/meowing/zen/features/general/chatCleaner/ChatFilterType;", "filterType", "", "sendToGui", "addPattern", "(Ljava/lang/String;Lxyz/meowing/zen/features/general/chatCleaner/ChatFilterType;Z)Z", "", "index", "removePattern", "(I)Z", "clearAllPatterns", "newPattern", "updatePattern", "(ILjava/lang/String;Lxyz/meowing/zen/features/general/chatCleaner/ChatFilterType;Z)Z", "NAME", "Ljava/lang/String;", "chatCleanerKey$delegate", "Lxyz/meowing/zen/config/Handler;", "getChatCleanerKey", "()I", "chatCleanerKey", "chatCleanerFilter$delegate", "getChatCleanerFilter", "()Z", "chatCleanerFilter", "Lxyz/meowing/zen/api/data/StoredFile;", "patternData", "Lxyz/meowing/zen/api/data/StoredFile;", "getPatternData", "()Lxyz/meowing/zen/api/data/StoredFile;", "", "Lxyz/meowing/zen/features/general/chatCleaner/ChatPattern;", "<set-?>", "patterns$delegate", "Lxyz/meowing/zen/api/data/StoredFile$Value;", "getPatterns", "()Ljava/util/List;", "setPatterns", "(Ljava/util/List;)V", "patterns", "Zen"})
@SourceDebugExtension(value={"SMAP\nChatCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCleaner.kt\nxyz/meowing/zen/features/general/chatCleaner/ChatCleaner\n+ 2 Feature.kt\nxyz/meowing/zen/features/Feature\n+ 3 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ConfigDelegate.kt\nxyz/meowing/zen/config/ConfigDelegateKt\n*L\n1#1,168:1\n107#2,2:169\n109#2:172\n107#2,2:173\n109#2:176\n107#2,2:177\n109#2:180\n19#3:171\n19#3:175\n19#3:179\n11228#4:181\n11563#4,3:182\n1761#5,3:185\n785#5:188\n796#5:189\n1878#5,2:190\n797#5,2:192\n1880#5:194\n799#5:195\n1573#5:196\n1604#5,4:197\n8#6:201\n*S KotlinDebug\n*F\n+ 1 ChatCleaner.kt\nxyz/meowing/zen/features/general/chatCleaner/ChatCleaner\n*L\n84#1:169,2\n84#1:172\n88#1:173,2\n88#1:176\n101#1:177,2\n101#1:180\n84#1:171\n88#1:175\n101#1:179\n126#1:181\n126#1:182,3\n136#1:185,3\n148#1:188\n148#1:189\n148#1:190,2\n148#1:192,2\n148#1:194\n148#1:195\n160#1:196\n160#1:197,4\n-1#1:201\n*E\n"})
public final class ChatCleaner
extends Feature {
    @NotNull
    public static final ChatCleaner INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String NAME = "Chat Cleaner";
    @NotNull
    private static final Handler chatCleanerKey$delegate;
    @NotNull
    private static final Handler chatCleanerFilter$delegate;
    @NotNull
    private static final StoredFile patternData;
    @NotNull
    private static final StoredFile.Value patterns$delegate;

    private ChatCleaner() {
        super("chatCleaner", false, null, null, null, 30, null);
    }

    private final int getChatCleanerKey() {
        return ((Number)chatCleanerKey$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    private final boolean getChatCleanerFilter() {
        return (Boolean)chatCleanerFilter$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @NotNull
    public final StoredFile getPatternData() {
        return patternData;
    }

    @NotNull
    public final List<ChatPattern> getPatterns() {
        Object t = patterns$delegate.getValue(this, $$delegatedProperties[2]);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
        return (List)t;
    }

    public final void setPatterns(@NotNull List<ChatPattern> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        patterns$delegate.setValue(this, $$delegatedProperties[2], list);
    }

    @Override
    public void addConfig() {
        ConfigManager.INSTANCE.addFeature("Chat cleaner", "Filter out unwanted chat messages using custom patterns", "General", new ConfigElement("chatCleaner", new ElementType.Switch(false), null, null, 12, null)).addFeatureOption("Add through keybind", new ConfigElement("chatCleaner.keybindToggle", new ElementType.Switch(false), null, null, 12, null)).addFeatureOption("Keybind to add message to filter", new ConfigElement("chatCleaner.keybind", new ElementType.Keybind(KnitKeys.INSTANCE.getKEY_H().getCode()), null, null, 12, null)).addFeatureOption("Chat cleaner filter GUI", new ConfigElement("chatCleaner.guiButton", new ElementType.Button("Open Filter GUI", (Function0<Unit>)((Function0)addConfig.1.INSTANCE)), null, null, 12, null));
    }

    @Override
    public void initialize() {
        boolean add$iv$iv;
        int priority$iv$iv;
        xyz.meowing.knit.api.events.EventBus this_$iv$iv;
        Feature $this$iv;
        HUDManager.INSTANCE.register(NAME, "Your Implosion hit 5 enemies for 1,661,807.6 damage.", "chatCleaner");
        Feature feature = this;
        Function1 cb$iv = initialize.1.INSTANCE;
        int priority$iv = 0;
        boolean $i$f$register = false;
        xyz.meowing.knit.api.events.EventBus eventBus = EventBus.INSTANCE;
        int n = priority$iv;
        boolean bl = false;
        Function1 callback$iv$iv = cb$iv;
        boolean $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(GuiEvent.Render.HUD.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
        $this$iv = this;
        cb$iv = initialize.2.INSTANCE;
        priority$iv = 0;
        $i$f$register = false;
        this_$iv$iv = EventBus.INSTANCE;
        priority$iv$iv = priority$iv;
        add$iv$iv = false;
        callback$iv$iv = cb$iv;
        $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(ChatEvent.Receive.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
        $this$iv = this;
        cb$iv = initialize.3.INSTANCE;
        priority$iv = 0;
        $i$f$register = false;
        this_$iv$iv = EventBus.INSTANCE;
        priority$iv$iv = priority$iv;
        add$iv$iv = false;
        callback$iv$iv = cb$iv;
        $i$f$register2 = false;
        $this$iv.getEvents().add(this_$iv$iv.registerInternal(KeyEvent.Press.class, priority$iv$iv, add$iv$iv, callback$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadDefault() {
        block9: {
            if (this.getPatterns().isEmpty()) {
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream("/assets/zen/chatfilter.json");
                    if (inputStream == null) break block9;
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String[] stream = (String[])closeable;
                        boolean bl = false;
                        String[] stringArray = stream;
                        Charset charset = Charsets.UTF_8;
                        Reader reader = new InputStreamReader((InputStream)stringArray, charset);
                        int n = 8192;
                        String[] defaultPatterns = (String[])new Gson().fromJson(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), String[].class);
                        Intrinsics.checkNotNull((Object)defaultPatterns);
                        stringArray = defaultPatterns;
                        ChatCleaner chatCleaner = INSTANCE;
                        boolean $i$f$map = false;
                        reader = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n2 = ((void)$this$mapTo$iv$iv).length;
                        for (int i = 0; i < n2; ++i) {
                            void it;
                            void item$iv$iv;
                            void var15_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(new ChatPattern((String)it, ChatFilterType.REGEX, false));
                        }
                        chatCleaner.setPatterns((List)destination$iv$iv);
                        patternData.forceSave();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    Zen.LOGGER.warn("Caught error while trying to load defaults in ChatCleaner: " + e);
                }
            }
        }
    }

    public final boolean addPattern(@NotNull String pattern, @NotNull ChatFilterType filterType, boolean sendToGui) {
        boolean bl;
        block12: {
            block11: {
                boolean bl2;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                    Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"filterType");
                    if (StringsKt.isBlank((CharSequence)pattern)) break block11;
                    Iterable $this$any$iv = this.getPatterns();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ChatPattern it = (ChatPattern)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)it.getPattern(), (Object)pattern) && it.getFilterType() == filterType)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break block12;
            }
            return false;
        }
        try {
            if (filterType == ChatFilterType.REGEX) {
                Pattern.compile(pattern);
            }
            this.setPatterns(CollectionsKt.plus((Collection)this.getPatterns(), (Object)new ChatPattern(pattern, filterType, sendToGui)));
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removePattern(int index) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        if (index < 0 || index >= this.getPatterns().size()) {
            return false;
        }
        Iterable iterable = this.getPatterns();
        ChatCleaner chatCleaner = this;
        boolean $i$f$filterIndexed = false;
        void var4_5 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            ChatPattern cfr_ignored_0 = (ChatPattern)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if (!(i != index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        chatCleaner.setPatterns((List)destination$iv$iv);
        return true;
    }

    public final void clearAllPatterns() {
        this.setPatterns(CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean updatePattern(int index, @NotNull String newPattern, @NotNull ChatFilterType filterType, boolean sendToGui) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newPattern, (String)"newPattern");
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"filterType");
        if (index < 0 || index >= this.getPatterns().size() || StringsKt.isBlank((CharSequence)newPattern)) {
            return false;
        }
        try {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            if (filterType == ChatFilterType.REGEX) {
                Pattern.compile(newPattern);
            }
            Iterable iterable = this.getPatterns();
            ChatCleaner chatCleaner = this;
            boolean $i$f$mapIndexed = false;
            void var7_10 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void pattern;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ChatPattern chatPattern = (ChatPattern)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(i == index ? new ChatPattern(newPattern, filterType, sendToGui) : pattern);
            }
            chatCleaner.setPatterns((List)destination$iv$iv);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$getChatCleanerFilter(ChatCleaner $this) {
        return $this.getChatCleanerFilter();
    }

    public static final /* synthetic */ int access$getChatCleanerKey(ChatCleaner $this) {
        return $this.getChatCleanerKey();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ChatCleaner.class, "chatCleanerKey", "getChatCleanerKey()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ChatCleaner.class, "chatCleanerFilter", "getChatCleanerFilter()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ChatCleaner.class, "patterns", "getPatterns()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ChatCleaner();
        String key$iv = "chatCleaner.keybind";
        boolean $i$f$ConfigDelegate = false;
        chatCleanerKey$delegate = new Handler<Integer>(key$iv, Integer.class);
        key$iv = "chatCleaner.keybindToggle";
        $i$f$ConfigDelegate = false;
        chatCleanerFilter$delegate = new Handler<Boolean>(key$iv, Boolean.class);
        patternData = new StoredFile("features/ChatCleaner");
        patterns$delegate = StoredFile.list$default(patternData, "patterns", ChatPattern.Companion.getCODEC(), null, 4, null);
        INSTANCE.loadDefault();
    }
}

