/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class Installer
extends JFrame {
    private static final Color BACKGROUND = new Color(23, 25, 31);
    private static final Color CARD_BACKGROUND = new Color(32, 35, 42);
    private static final Color ACCENT = new Color(88, 166, 255);
    private static final Color TEXT_PRIMARY = new Color(255, 255, 255);
    private static final Color TEXT_SECONDARY = new Color(156, 163, 175);
    private static final Color BUTTON_HOVER = new Color(67, 56, 202);

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Installer().setVisible(true);
        });
    }

    public Installer() {
        this.setTitle("Zen Mod");
        this.setDefaultCloseOperation(3);
        this.setSize(600, 450);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, 600.0, 450.0, 20.0, 20.0));
        final Point[] mouseDownCompCoords = new Point[]{null};
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                mouseDownCompCoords[0] = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                Installer.this.setLocation(currCoords.x - mouseDownCompCoords[0].x, currCoords.y - mouseDownCompCoords[0].y);
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBackground(BACKGROUND);
        mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        mainPanel.add((Component)this.createHeaderPanel(), "North");
        mainPanel.add((Component)this.createContentPanel(), "Center");
        mainPanel.add((Component)this.createFooterPanel(), "South");
        this.add(mainPanel);
    }

    private JPanel createHeaderPanel() {
        JPanel headerContainer = new JPanel(new BorderLayout());
        headerContainer.setBackground(BACKGROUND);
        JPanel header = new JPanel(new BorderLayout());
        header.setBackground(BACKGROUND);
        header.setBorder(new EmptyBorder(20, 20, 15, 20));
        JLabel titleLabel = new JLabel("\u26a1 Zen Mod");
        titleLabel.setFont(new Font("Segoe UI", 1, 24));
        titleLabel.setForeground(TEXT_PRIMARY);
        header.add((Component)titleLabel, "West");
        header.add((Component)this.createCloseButton(), "East");
        JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(new Dimension(0, 1));
        separator.setForeground(new Color(75, 85, 99));
        separator.setBackground(new Color(75, 85, 99));
        separator.setOpaque(true);
        headerContainer.add((Component)header, "Center");
        headerContainer.add((Component)separator, "South");
        return headerContainer;
    }

    private JButton createCloseButton() {
        JButton closeButton2 = new JButton("\u00d7"){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isPressed()) {
                    g2.setColor(new Color(248, 113, 113));
                } else if (this.getModel().isRollover()) {
                    g2.setColor(new Color(239, 68, 68));
                } else {
                    g2.setColor(TEXT_SECONDARY);
                }
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
                g2.dispose();
                super.paintComponent(g);
            }
        };
        closeButton2.setFont(new Font("Segoe UI", 1, 18));
        closeButton2.setForeground(Color.WHITE);
        closeButton2.setPreferredSize(new Dimension(32, 32));
        closeButton2.setFocusPainted(false);
        closeButton2.setBorderPainted(false);
        closeButton2.setBorder(BorderFactory.createLineBorder(new Color(75, 85, 99), 1));
        closeButton2.setContentAreaFilled(false);
        closeButton2.setCursor(new Cursor(12));
        closeButton2.addActionListener(e -> System.exit(0));
        return closeButton2;
    }

    private JPanel createContentPanel() {
        String[] steps;
        JPanel content = new JPanel(new BorderLayout());
        content.setBackground(BACKGROUND);
        content.setBorder(new EmptyBorder(20, 30, 20, 30));
        JLabel warningLabel = new JLabel("This mod cannot be run directly!");
        warningLabel.setFont(new Font("Segoe UI", 1, 20));
        warningLabel.setForeground(new Color(248, 113, 113));
        warningLabel.setHorizontalAlignment(0);
        warningLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        JPanel stepsPanel = new JPanel();
        stepsPanel.setLayout(new BoxLayout(stepsPanel, 1));
        stepsPanel.setBackground(BACKGROUND);
        for (String step : steps = new String[]{"1. Install Minecraft Forge 1.8.9-11.15.1.2318", "", "2. Place this JAR in your mods folder:", "    \u2022 Windows: %appdata%/.minecraft/mods/", "    \u2022 macOS: ~/Library/Application Support/minecraft/mods/", "    \u2022 Linux: ~/.minecraft/mods/", "", "3. Launch Minecraft with Forge profile"}) {
            JLabel stepLabel = Installer.createStepLabel(step);
            stepsPanel.add(stepLabel);
        }
        content.add((Component)warningLabel, "North");
        content.add((Component)stepsPanel, "Center");
        return content;
    }

    @NotNull
    private static JLabel createStepLabel(String step) {
        JLabel stepLabel = new JLabel(step.isEmpty() ? " " : step);
        stepLabel.setFont(new Font("Segoe UI", 0, 14));
        stepLabel.setForeground(step.startsWith("    \u2022") ? TEXT_SECONDARY : TEXT_PRIMARY);
        stepLabel.setAlignmentX(0.0f);
        stepLabel.setBorder(new EmptyBorder(1, 0, 1, 0));
        return stepLabel;
    }

    private JPanel createFooterPanel() {
        JPanel footerContainer = new JPanel(new BorderLayout());
        footerContainer.setBackground(BACKGROUND);
        JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(new Dimension(0, 1));
        separator.setForeground(new Color(75, 85, 99));
        separator.setBackground(new Color(75, 85, 99));
        separator.setOpaque(true);
        JPanel footer = new JPanel(new GridBagLayout());
        footer.setBackground(BACKGROUND);
        footer.setBorder(new EmptyBorder(20, 40, 25, 40));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 0, 8);
        gbc.gridy = 0;
        JButton installButton = this.createModernButton("Install", "\ud83d\udcc1");
        JButton discordButton = this.createModernButton("Discord", "\ud83d\udcac");
        JButton githubButton = this.createModernButton("GitHub", "\ud83d\udd17");
        installButton.addActionListener(e -> this.autoInstallMod());
        discordButton.addActionListener(e -> Installer.openURL("https://discord.gg/KPmHQUC97G"));
        githubButton.addActionListener(e -> Installer.openURL("https://github.com/kiwidotzip/zen"));
        gbc.gridx = 0;
        footer.add((Component)installButton, gbc);
        gbc.gridx = 1;
        footer.add((Component)discordButton, gbc);
        gbc.gridx = 2;
        footer.add((Component)githubButton, gbc);
        footerContainer.add((Component)separator, "North");
        footerContainer.add((Component)footer, "Center");
        return footerContainer;
    }

    private JButton createModernButton(String text, String icon) {
        JButton button = new JButton(icon + " " + text){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isPressed()) {
                    g2.setColor(BUTTON_HOVER.darker());
                } else if (this.getModel().isRollover()) {
                    g2.setColor(BUTTON_HOVER);
                } else {
                    g2.setColor(ACCENT);
                }
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
                g2.dispose();
                super.paintComponent(g);
            }
        };
        button.setFont(new Font("Segoe UI", 1, 13));
        button.setForeground(Color.WHITE);
        button.setPreferredSize(new Dimension(110, 45));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setCursor(new Cursor(12));
        return button;
    }

    private void showThemedDialog(String message, String title, int messageType) {
        JDialog dialog = new JDialog(this, title, true);
        dialog.setSize(400, 150);
        dialog.setLocationRelativeTo(this);
        dialog.setUndecorated(true);
        dialog.setShape(new RoundRectangle2D.Double(0.0, 0.0, 400.0, 150.0, 15.0, 15.0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(CARD_BACKGROUND);
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JLabel messageLabel = new JLabel("<html><center>" + message.replace("\n", "<br>") + "</center></html>");
        messageLabel.setFont(new Font("Segoe UI", 0, 14));
        messageLabel.setForeground(TEXT_PRIMARY);
        messageLabel.setHorizontalAlignment(0);
        JButton okButton = new JButton("OK");
        okButton.setFont(new Font("Segoe UI", 1, 12));
        okButton.setForeground(Color.WHITE);
        okButton.setBackground(ACCENT);
        okButton.setPreferredSize(new Dimension(80, 35));
        okButton.setFocusPainted(false);
        okButton.setBorderPainted(false);
        okButton.setCursor(new Cursor(12));
        okButton.addActionListener(e -> dialog.dispose());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setBackground(CARD_BACKGROUND);
        buttonPanel.add(okButton);
        panel.add((Component)messageLabel, "Center");
        panel.add((Component)buttonPanel, "South");
        dialog.add(panel);
        dialog.setVisible(true);
    }

    private boolean showThemedConfirmDialog() {
        JDialog dialog = new JDialog(this, "File Exists", true);
        dialog.setSize(450, 180);
        dialog.setLocationRelativeTo(this);
        dialog.setUndecorated(true);
        dialog.setShape(new RoundRectangle2D.Double(0.0, 0.0, 450.0, 180.0, 15.0, 15.0));
        boolean[] result = new boolean[]{false};
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(CARD_BACKGROUND);
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JLabel messageLabel = new JLabel("<html><center>A mod with this name already exists.<br>Replace it?</center></html>");
        messageLabel.setFont(new Font("Segoe UI", 0, 14));
        messageLabel.setForeground(TEXT_PRIMARY);
        messageLabel.setHorizontalAlignment(0);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setBackground(CARD_BACKGROUND);
        JButton yesButton = this.createConfirmButton("Yes", result, dialog, true);
        JButton noButton = this.createConfirmButton("No", result, dialog, false);
        buttonPanel.add(yesButton);
        buttonPanel.add(noButton);
        panel.add((Component)messageLabel, "Center");
        panel.add((Component)buttonPanel, "South");
        dialog.add(panel);
        dialog.setVisible(true);
        return result[0];
    }

    private JButton createConfirmButton(String text, boolean[] result, JDialog dialog, boolean setValue) {
        JButton button = new JButton(text);
        button.setFont(new Font("Segoe UI", 1, 12));
        button.setForeground(Color.WHITE);
        button.setBackground(setValue ? ACCENT : new Color(107, 114, 128));
        button.setPreferredSize(new Dimension(80, 35));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setCursor(new Cursor(12));
        button.addActionListener(e -> {
            if (setValue) {
                result[0] = true;
            }
            dialog.dispose();
        });
        return button;
    }

    private void autoInstallMod() {
        try {
            String jarPath = Installer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (jarPath.startsWith("file:")) {
                jarPath = jarPath.substring(5);
            }
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
            String os = System.getProperty("os.name").toLowerCase();
            String modsFolder = os.contains("win") ? System.getenv("APPDATA") + "\\.minecraft\\mods\\" : (os.contains("mac") ? System.getProperty("user.home") + "/Library/Application Support/minecraft/mods/" : System.getProperty("user.home") + "/.minecraft/mods/");
            File modsDir = new File(modsFolder);
            if (!modsDir.exists()) {
                modsDir.mkdirs();
            }
            File sourceFile = new File(jarPath);
            File targetFile = new File(modsFolder + sourceFile.getName());
            if (targetFile.exists() && !this.showThemedConfirmDialog()) {
                return;
            }
            Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.showThemedDialog("Mod installed successfully to:\n" + modsFolder, "Installation Complete", 1);
        }
        catch (Exception e) {
            this.showThemedDialog("Failed to install mod:\n" + e.getMessage(), "Installation Error", 0);
        }
    }

    private static void openURL(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(URI.create(url));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not open browser. Please visit: " + url, "Error", 0);
        }
    }
}

